// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxshttp.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

HTTP client/server constants and data structures shared between
HTTP client and server applications.
*/
// ----------------------------------------------------------- // 
#include "gxshttp.h"

// HTTP connection methods
const char *gxsHTTP_METHOD[gxsMAX_HTTP_METHODS] = {
  "UNKNOWN",    // String used for internal processing
  "GET",        // Retrieve whatever data is identified by the URI.
  "HEAD",       // Returns only HTTP headers and no document body. 
  "PUT",        // Store the data under the supplied URL.
  "DELETE",     // Delete the information corresponding to the given URL.
  "POST",       // Creates a new object linked to the specified object. 
  "LINK",       // Links an existing object to the specified object. 
  "UNLINK"      // Removes link (or other meta-) information from an object. 
};

// HTTP status messages
const char *gxsHTTP_STATUS_CODES[gxsMAX_HTTP_STATUS_CODES] = {
  "HTTP status: Encountered an HTTP error condition",   // Default message
  "200 HTTP status: Document OK",                       // OK
  "201 HTTP status: Document created",                  // CREATED
  "202 HTTP status: Document accepted",                 // ACCEPTED
  "204 HTTP status: Document has no content",           // NOCONTENT
  "300 HTTP status: Multiple choices",                  // MULTIPLE_CHOICES
  "301 HTTP status: Document has moved permanently",    // MOVED_PERMANENTLY
  "302 HTTP status: Document has moved temporarily",    // MOVED_TEMPORARILY
  "304 HTTP status: Document has not been modified",    // NOT_MODIFIED
  "400 HTTP client error: Bad client request",          // BAD_REQUEST
  "401 HTTP client error: Unauthorized client request", // UNAUTHORIZED
  "403 HTTP client error: Forbidden client request",    // FORBIDDEN
  "404 HTTP client error: Document not found",          // NOT_FOUND
  "500 HTTP server error: Internal server error",       // INTERNAL
  "501 HTTP server error: Service not implemented",     // NOT_IMPLEMENTED
  "502 HTTP server error: Bad gateway or proxy",        // BAD_GATEWAY
  "503 HTTP server error: Status unavailable"           // UNAVAILABLE
};

const char *gxsHTTPMethodMessage(int method)
{
  if(method > gxsMAX_HTTP_METHODS) method = gxHTTP_UNKNOWN;
  return gxsHTTP_METHOD[method];
}

const char *gxsHTTPStatusCodeMessage(int status)
{
  switch(status) {
    
    case gxsHTTP_STATUS_OK:                 // 200
      return gxsHTTP_STATUS_CODES[1];
      
    case gxsHTTP_STATUS_CREATED :           // 201
      return gxsHTTP_STATUS_CODES[2];
      
    case gxsHTTP_STATUS_ACCEPTED :          // 202
      return gxsHTTP_STATUS_CODES[3];
      
    case gxsHTTP_STATUS_NO_CONTENT :        // 204
      return gxsHTTP_STATUS_CODES[4];
      
    case gxsHTTP_STATUS_MULTIPLE_CHOICES :  // 300
      return gxsHTTP_STATUS_CODES[5];
      
    case gxsHTTP_STATUS_MOVED_PERMANENTLY : // 301
      return gxsHTTP_STATUS_CODES[6];
      
    case gxsHTTP_STATUS_MOVED_TEMPORARILY : // 302
      return gxsHTTP_STATUS_CODES[7];
      
    case gxsHTTP_STATUS_NOT_MODIFIED :      // 304
      return gxsHTTP_STATUS_CODES[8];
      
    case gxsHTTP_STATUS_BAD_REQUEST :       // 400
      return gxsHTTP_STATUS_CODES[9];
      
    case gxsHTTP_STATUS_UNAUTHORIZED :      // 401
      return gxsHTTP_STATUS_CODES[10];
      
    case gxsHTTP_STATUS_FORBIDDEN :         // 403
      return gxsHTTP_STATUS_CODES[11];
      
    case gxsHTTP_STATUS_NOT_FOUND :         // 404
      return gxsHTTP_STATUS_CODES[12];
      
    case gxsHTTP_STATUS_INTERNAL :          // 500
      return gxsHTTP_STATUS_CODES[13];
      
    case gxsHTTP_STATUS_NOT_IMPLEMENTED :   // 501
      return gxsHTTP_STATUS_CODES[14];
      
    case gxsHTTP_STATUS_BAD_GATEWAY :       // 502
      return gxsHTTP_STATUS_CODES[15];
      
    case gxsHTTP_STATUS_UNAVAILABLE :       // 503
      return gxsHTTP_STATUS_CODES[16];
      
    default:
      break;
  }
  return gxsHTTP_STATUS_CODES[0];
}

gxsNetscapeCookie::gxsNetscapeCookie()
{
  host = name = value = expires = domain = path = "\0";
  secure = 0;
}

gxsNetscapeCookie::~gxsNetscapeCookie()
{

}

void gxsNetscapeCookie::Copy(const gxsNetscapeCookie &ob)
{
  expires = ob.expires;
  domain = ob.domain;
  path = ob.path;
  host = ob.host;
  name = ob.name;
  value = ob.value;
  secure = ob.secure;
}

int operator==(const gxsNetscapeCookie &a, const gxsNetscapeCookie &b)
// Overloaded == operator added to work with gxs linked list class.
{
  if(a.expires != b.expires) return 0;
  if(a.domain != b.domain) return 0;
  if(a.path != b.path) return 0;
  if(a.host != b.host) return 0;
  if(a.name != b.name) return 0;
  if(a.value != b.value) return 0;
  if(a.secure != b.secure) return 0;
  return 1;
}

gxsHTTPHeader::gxsHTTPHeader() {
  http_header = authentication_scheme = realm = auth_cookie = \
    current_server = location = http_last_modified =  date = \
    http_expires = file_extension = content_type = mime_type = \
    etag = content_encoding = pragma = cache_control = "\0";
  
  // Default settings
  http_version = 1.0F;
  http_status = gxsHTTP_STATUS_OK;
  authentication_needed = 0;
  not_found = 0;
  keep_alive = 0;
  timeout = -1;   // -1 indicates that this value has not been set
  max_conns = -1; // -1 indicates that this value has not been set
  length = -1;    // -1 indicates that this value has not been set
  no_cache = 0;
  accept_ranges = 0;
  use_cookies = 1;
}

gxsHTTPHeader::~gxsHTTPHeader()
{

}

void gxsHTTPHeader::Copy(const gxsHTTPHeader &ob)
{
  http_header = ob.http_header;
  authentication_scheme = ob.authentication_scheme;
  realm = ob.realm;
  current_server = ob.current_server;
  location = ob.location;
  http_last_modified = ob.http_last_modified;
  date = ob.date;
  http_expires = ob.http_expires;
  file_extension = ob.file_extension;
  content_type = ob.content_type;
  mime_type = ob.mime_type;
  etag = ob.etag;
  pragma = ob.pragma;
  cache_control = ob.cache_control;
  content_encoding = ob.content_encoding;
  http_version = ob.http_version;
  http_status = ob.http_status;
  authentication_needed = ob.authentication_needed;
  not_found = ob.not_found;
  keep_alive = ob.keep_alive;
  timeout = ob.timeout;
  max_conns = ob.max_conns;
  length = ob.length;
  no_cache = ob.no_cache;
  accept_ranges = ob.accept_ranges;
  auth_cookie = ob.auth_cookie;
  use_cookies = ob.use_cookies;

  // Copy the list
  gxListNode<gxsNetscapeCookie> *ptr = ob.netscape_cookies.GetHead();
  netscape_cookies.ClearList();
  while(ptr) {
    netscape_cookies.Add(ptr->data);
    ptr = ptr->next;
  }
}

int operator==(const gxsHTTPHeader &a, const gxsHTTPHeader &b)
{
  if(a.http_header != b.http_header) return 0;
  return 1;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
