// fts.cpp : Implementation of Cfts
#include "stdafx.h"
#include "Sqltools.h"
#include "fts.h"

/////////////////////////////////////////////////////////////////////////////
// Cfts

/******************************************************************************
Method		: get_SearchString
Description : Transform the string passed to a "FTS safe" string for being used
				in a search with "CONTAINS"
Author		: Rudi Bruchez (rudi@babaluga.com)
Creation	: 2001-03-10
-------------------------------------------------------------------------------
Params :
   BSTR *SearchString	- string to be passed for transformation
   BSTR *bstrVal		- return parameter
Return value : S_OK anyway
******************************************************************************/
STDMETHODIMP Cfts::get_SearchString(BSTR *SearchString, BSTR *bstrVal)
{
	/* declarations */
	CBstr strFrom(*SearchString, true);  

	if (strFrom.Length() == 0)
	{
		*bstrVal = strFrom.copy();
		return S_OK;
	}

	/* standardize the case */
	strFrom.MakeUpper();  

	/* put off quotes */
	strFrom.Replace("\\\"", ""); //special case : \"
	strFrom.Replace("\"", "");
	
    /* double single quotes */
    strFrom.Replace("'", "''");
    
	/* add quotes around each word */
	strFrom.Replace(" ", "\" \"");

	/* Put quotes around */
	strFrom = CBstr("\"") + strFrom + CBstr("\"");

	/* replace "AND" and "OR" by a version without quotes */
	strFrom.Replace("\"AND\"","AND");
	strFrom.Replace("\"OR\"","OR");

    // erase every empty words
	BSTR seps   = ::SysAllocString(L" ,\t\n");
	CComBSTR token = ::SysAllocString(L"");

	USES_CONVERSION;

	/* 
		separate each word in tokens, and verifiy they are in the EmptyWords
		string. If they are, delete them 
	*/
	CBstr strTo = "";
	token = wcstok(strFrom.copy(), seps );
	while( token != NULL ) // While there are tokens in "string"
	{
		if (!(token == "AND")) // || token == "OR")
		{
			if (token == "OR") 
			{
				token.Append(" ");
				strTo += (BSTR)token;				
			} 
			else if (strEmptyWords.Find((const char *)OLE2T(token)) < 0)
			{
				if (token.Length() > 3) // we forget about one character long words
										// (1 char + 2 quotes = 3) (eg punctuation)
				{
					token.Append(" AND ");
					strTo += (BSTR)token;
				}
			}
		}

		// Get next token:
		token = wcstok( NULL, seps );
	}

	/* delete duplicate AND, OR */
	while (strTo.Replace("AND AND","AND") > 0);
	while (strTo.Replace("OR OR","OR") > 0);
	while (strTo.Replace("AND OR","OR") > 0);
	while (strTo.Replace("OR AND","OR") > 0);

	/* delete AND, OR, at the beggining/end of the string */
	/* we have to make a trim before ! */
	strTo.TrimLeft();

	/* remove strating AND/OR */
	while (strTo.Left(3) == "AND") 
		strTo = strTo.Right(strTo.Length()-3);
	while (strTo.Left(2) == "OR") 
		strTo = strTo.Right(strTo.Length()-2);

	strTo.TrimLeft();

	strTo.TrimRight();

	/* remove trailing AND/OR */
	while (strTo.Right(3) == "AND")
		strTo = strTo.Left(strTo.Length()-3);
	while (strTo.Right(2) == "OR") 
		strTo = strTo.Left(strTo.Length()-2);

	strTo.TrimRight();

	*bstrVal = strTo.copy();

	return S_OK;
}

/******************************************************************************
Function	: GetEmptyWords
Description : Opens the FTS noise words file and store its content in the 
				global CBstr variable strEmptyWords
Author		: Rudi Bruchez (rudi@babaluga.com)
Creation	: 2001-03-10
******************************************************************************/
void Cfts::GetEmptyWords()
{
	FILE *stream;
	int i = 0;
	char ch;
	long lsize;
	char szmychar[] = "a";
	LPSTR szTemp;
	HANDLE hFile;
	char strNoiseFilename[MAX_PATH];

	GetNoiseFilename(strNoiseFilename);
	if (strlen(strNoiseFilename) == 0)
	{
		Error("SQLTools : Noise words file not found");
		strEmptyWords = "";
		return;
	}

	/* -- we take the size of the file -- */
	hFile = CreateFile(strNoiseFilename, 
		GENERIC_READ,0,NULL,
		OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL,NULL);
	lsize = GetFileSize(hFile, NULL);
	szTemp = new char[lsize];
	memset(szTemp, 0, lsize);
	CloseHandle(hFile);
	
	if( (stream  = fopen(strNoiseFilename, "r" )) != NULL )
	{
		while (!feof(stream)) 
		{
			ch = (char)fgetc(stream);
			switch (ch) 
			{
				case 13: break;
				case 10: 
					szTemp[i++] = ' ';
					break;
				default:
					szTemp[i++] = ch;
			}
		}
		fclose(stream);
	} else {
		Error("Noise words file not found");
	}
    
	strEmptyWords = _T(szTemp);
	strEmptyWords.MakeUpper();

	// we want to keep these words
	strEmptyWords.Replace(cKeywAND, "");
	strEmptyWords.Replace(cKeywOR, "");

    // replace spaces by quotes + spaces
	strEmptyWords.Replace(" ", "\" \"");
}

/******************************************************************************
Method		: GetNoiseFilename
Description : Get the path and name of the FTS noise words file by querying the
				registry - where we wrote this info
Author		: Rudi Bruchez (rudi@babaluga.com)
Creation	: 2001-03-10
-------------------------------------------------------------------------------
Params :
   LPTSTR pstrNoiseFileName	- string to be passed for transformation
******************************************************************************/
void Cfts::GetNoiseFilename(LPTSTR pstrNoiseFileName)
{
	char *pszBuffer;
	LONG lRes;
	DWORD dwBytes;
	HKEY hKeyNoiseFile;
	LPCTSTR lpszValueName = "NoiseFile";

	lRes = RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE\\Babaluga\\sqltools", 
						0, KEY_READ, &hKeyNoiseFile); 
	if (lRes==ERROR_SUCCESS) 
	{
		dwBytes = 0;
		RegQueryValueEx(hKeyNoiseFile, lpszValueName, NULL, 
						NULL, NULL, &dwBytes);

		/* no reg entry... */
		if (dwBytes == 0)
		{
			Error("No registry entry for noise words file");
			*pstrNoiseFileName = 0;
			return;
		}

		pszBuffer = new char[dwBytes];
		RegQueryValueEx(hKeyNoiseFile, lpszValueName, NULL, 
						NULL, (unsigned char*)pszBuffer, &dwBytes);
		RegCloseKey(hKeyNoiseFile);
		lstrcpy(pstrNoiseFileName, pszBuffer);
		delete[] pszBuffer;
	} else {
		Error("No entry is found in Registry for SQLTools component noise file.");
		*pstrNoiseFileName = 0;
	}
}

/* -------------------------------------------------------
	Rudi Bruchez 2001-03-15
	Does the interface support error objects ?
	let's use the short version, implying that we'll support
	only one interface.
   ------------------------------------------------------- */
STDMETHODIMP Cfts::InterfaceSupportsErrorInfo(REFIID riid)
{
	if (InlineIsEqualGUID(IID_Ifts, riid))
		return S_OK;
	return S_FALSE;
}