unit DemoLoad;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, quickrpt, QrExtra, ExtCtrls, Qrctrls, Db, dbtables, ArtLoader;

type
  TForm1 = class(TForm)
    Button1: TButton;
    LookInDataMod: TCheckBox;
    Button2: TButton;
    List: TListBox;
    Label1: TLabel;
    Kind: TRadioGroup;
    Button3: TButton;
    ArtLoader1: TArtLoader;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses ArtLoad;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  with TOpenDialog.Create(Application) do
    begin
      try
        Filter := 'Artist report|*.ARP;*.ATX';
        DefaultExt := 'ATX';
        if Execute then
          begin
            with TfrmArtLoader.Create(Application) do
              begin
                try
                  if LoadReport(Filename) and
                     assigned(Report) then
                    begin
                      ArtPrepareExpressions; { Initialize the Expressions for bands }
                      ShowParamDialog; { ask for parameters if there are }
                      OpenTables;
                      Report.Preview;
                      CloseTables;
                      ArtUnPrepareExpressions; { Unprepare the Expressions for bands }
                    end;
                finally
                  Free;
                end;
              end;
          end;
      finally
        Free;
      end;
    end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var aList : TList;
var Ok : boolean;
var I : integer;
begin
  with TOpenDialog.Create(Application) do
    begin
      try
        Filter := 'Artist report|*.ARP;*.ATX';
        DefaultExt := 'ATX';
        if Execute then
          begin
            with TfrmArtLoader.Create(Application) do
              begin
                try
                  if LoadReport(Filename) and
                     assigned(Report) then
                    begin
                      aList := TList.Create;
                      try
                        List.Items.Clear;
                        case Kind.ItemIndex of
                          00 : Ok := GetCompList(TQrPrintable  ,aList,LookInDataMod.Checked);
                          01 : Ok := GetCompList(TQrDbText     ,aList,LookInDataMod.Checked);
                          02 : Ok := GetCompList(TQrLabel      ,aList,LookInDataMod.Checked);
                          03 : Ok := GetCompList(TTable        ,aList,LookInDataMod.Checked);
                          04 : Ok := GetCompList(TQuery        ,aList,LookInDataMod.Checked);
                          05 : Ok := GetCompList(TDataSet      ,aList,LookInDataMod.Checked);
                          06 : Ok := GetCompList(TQrCustomBand ,aList,LookInDataMod.Checked);
                          else Exit;
                        end;
                        if Ok then
                          for I := 0 to aList.Count -1 do
                            begin
                              if TComponent(aList[I]).Owner <> Report.Owner then
                                List.Items.Add(TComponent(aList[I]).Owner.Name + '.' +
                                            TComponent(aList[I]).Name)
                              else
                                List.Items.Add(TComponent(aList[I]).Name);
                            end;
                      finally
                        aList.Free;
                      end;
                    end;
                finally
                  Free;
                end;
              end;
          end;
      finally
        Free;
      end;
    end;

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  ArtLoader1.Preview;
end;


end.
