unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, CoolGrid, StdCtrls;

type
  TfrmMain = class(TForm)
    CoolGrid: TCoolGrid;
    Memo1: TMemo;
    procedure CoolGridGetEditStyle(Sender: TObject; ACol, ARow: Integer;
      var Value: TEditStyle; var ReadOnly: Boolean);
    procedure CoolGridEditButtonClick(Sender: TObject);
    procedure CoolGridGetDropDownList(Sender: TObject; ACol,
      ARow: Integer; Value: TStrings);
    procedure CoolGridGetFormatKind(Sender: TObject; ACol, ARow: Integer;
      var Value: TFormatKind);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
 with CoolGrid do
  begin
   Cells[0, 0] := 'esSimple';
   Cells[1, 0] := 'esEllipsis';
   Cells[2, 0] := 'esPickList';
   Cells[3, 0] := 'fkDate';
   Cells[4, 0] := 'fkInteger';
   Cells[5, 0] := 'fkFloat';
   Cells[6, 0] := 'fkCurrency';
  end;
end;

procedure TfrmMain.CoolGridGetEditStyle(Sender: TObject; ACol,
  ARow: Integer; var Value: TEditStyle; var ReadOnly: Boolean);
begin
 case ACol of
  1:
   begin
    Value := esEllipsis;
    ReadOnly := True;
   end;
  2:
   begin
    Value := esPickList;
    ReadOnly := True;
   end;
   else Value := esSimple;
  end;
end;

procedure TfrmMain.CoolGridEditButtonClick(Sender: TObject);
begin
 with CoolGrid do
 if MessageDlg('Push Ok Or Cancel Button!', mtInformation, [mbOK, mbCancel], 0) = mrOK then
  Cells[Col, Row] := 'OK' else Cells[Col, Row] := 'Cancel';
end;

procedure TfrmMain.CoolGridGetDropDownList(Sender: TObject; ACol,
  ARow: Integer; Value: TStrings);
var
 i: Integer;
begin
 if ACol = 2 then
  for i := Low(LongMonthNames) to High(LongMonthNames) do
   Value.Add(LongMonthNames[i]);
end;

procedure TfrmMain.CoolGridGetFormatKind(Sender: TObject; ACol,
  ARow: Integer; var Value: TFormatKind);
begin
 case ACol of
  3: Value := fkDate;
  4: Value := fkInteger;
  5: Value := fkFloat;
  6: Value := fkCurrency;
 end;
end;


end.
