{$INCLUDE ..\cDefines.inc}
unit cThreads;

interface

uses
  // Delphi
  Classes;



{                                                                              }
{ TThreadEx                                                                    }
{                                                                              }
type
  TThreadEx = class (TThread)
    public
    // Make TThread's Synchronize method public
    Procedure Synchronize (Method : TThreadMethod);

    // Make TThread's Terminate method virtual
    Procedure Terminate; virtual;

    // Make Terminated property public
    Property  Terminated;
  end;



implementation



{                                                                              }
{ TThreadEx                                                                    }
{                                                                              }
Procedure TThreadEx.Synchronize (Method : TThreadMethod);
  Begin
    inherited Synchronize (Method);
  End;

Procedure TThreadEx.Terminate;
  Begin
    inherited Terminate;
  End;



end.

