unit Frmmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Param2D, StdCtrls, ExtCtrls, Grids, Buttons;

const
  crPan = 1; crZoom = 2;

type
  TMainFrm = class(TForm)
    gbInstruct: TGroupBox;
    meInstruct: TMemo;
    LinesModel: TParModel;
    RectsModel: TParModel;
    dlgOpen: TOpenDialog;
    dlgSave: TSaveDialog;
    paBot: TPanel;
    gbVars: TGroupBox;
    grVars: TStringGrid;
    paLeft: TPanel;
    gbSelSet: TGroupBox;
    lbSelSet: TListBox;
    gbView: TGroupBox;
    ParView1: TParView;
    paStatus: TPanel;
    gbModels: TGroupBox;
    coModel: TComboBox;
    paSpeed: TPanel;
    btnSelSin: TSpeedButton;
    btnSelCrs: TSpeedButton;
    btnSelWin: TSpeedButton;
    btnPan: TSpeedButton;
    btnZoom: TSpeedButton;
    btnZoomAll: TSpeedButton;
    btnUpdate: TButton;
    btnLoad: TButton;
    btnSave: TButton;
    paBot2: TPanel;
    gbErrors: TGroupBox;
    lbErrors: TListBox;
    gbDesc: TGroupBox;
    meDesc: TMemo;
    DimsModel: TParModel;
    CurvesModel: TParModel;
    PolyModel: TParModel;
    procedure FormCreate(Sender: TObject);
    procedure coModelClick(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure ParView1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnSaveClick(Sender: TObject);
    procedure ParView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ParView1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OnBtnsClick(Sender: TObject);
    procedure btnZoomAllClick(Sender: TObject);
  private
    LBDown: boolean;
    FSelRect: TRect;
    FModel: TParModel;
    procedure OnModelError(Sender: TObject);
    procedure GetModelVars;
  public
    { Public declarations }
  end;

var
  MainFrm: TMainFrm;

implementation

{$R *.DFM}

procedure TMainFrm.FormCreate(Sender: TObject);
var i: integer; Model: TParModel; h: THandle;
begin
  if FileExists('Instruct.txt')
  then meInstruct.Lines.LoadFromFile('Instruct.txt')
  else meInstruct.Lines.Add('Missing demo instructions file Instruct.txt');

  h := LoadCursor(HInstance, 'CURSOR_PAN');
  Screen.Cursors[crPan] := h;
  h := LoadCursor(HInstance, 'CURSOR_ZOOM');
  Screen.Cursors[crZoom] := h;

  coModel.Items.Clear;
  for i := 0 to ComponentCount-1 do begin
    if Components[i] is TParModel then begin
      Model := Components[i] as TParModel;
      Model.OnError := OnModelError;
      coModel.Items.AddObject(Model.Name, Model);
    end;
  end;
  coModel.ItemIndex := 0;
  coModelClick(coModel);
end;

procedure TMainFrm.OnModelError(Sender: TObject);
var Model: TParModel;
begin
  Model := Sender as TParModel;
  if Model <> nil then lbErrors.Items := Model.Errors;
end;

procedure TMainFrm.coModelClick(Sender: TObject);
begin
  FModel := coModel.Items.Objects[coModel.ItemIndex] as TParModel;
  lbErrors.Items.Clear;
  ParView1.Model := FModel;
  meDesc.Lines := FModel.Desc;
  lbSelSet.Items := FModel.Selection;
  GetModelVars;
  meDesc.SelStart := 0;
end;

procedure TMainFrm.GetModelVars;
var i: integer; nam: string;
begin
  if FModel <> nil then begin
    grVars.RowCount := FModel.Vars.Count;
    with grVars do begin
      Cells[0,0] := '';
      Cells[1,0] := '';
      for i := 0 to FModel.Vars.Count-1 do begin
        nam := FModel.Vars.Strings[i];
        nam := copy(nam, 1, pos('=', nam)-1);
        Cells[0,i] := nam;
        Cells[1,i] := FModel.Vars.Values[nam];
      end;
    end;
  end;
end;

procedure TMainFrm.btnUpdateClick(Sender: TObject);
var i: integer; nam: string;
begin
  if FModel <> nil then begin
    with grVars do begin
      for i := 0 to RowCount-1 do begin
        nam := Cells[0,i];
        FModel.Vars.Values[nam] := Cells[1,i];
      end;
    end;
    FModel.Desc:= meDesc.Lines;
    lbErrors.Items := FModel.Errors;
    lbSelSet.Items := FModel.Selection;
    ParView1.Paint;
  end;
end;

procedure TMainFrm.btnLoadClick(Sender: TObject);
begin
  dlgOpen.Title := 'Load Parametric Model';
  dlgOpen.FileName := '';
  if dlgOpen.Execute  and (FModel <> nil) then
    FModel.LoadFromFile(dlgOpen.FileName);
  coModelClick(coModel);
end;

procedure TMainFrm.btnSaveClick(Sender: TObject);
begin
  dlgSave.Title := 'Save Parametric Model';
  dlgSave.FileName := '';
  if dlgSave.Execute  and (FModel <> nil) then
    FModel.SaveToFile(dlgSave.FileName);
end;

procedure TMainFrm.ParView1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var st: string; dx, dy: double; p: TPoint;
begin
  if LBDown and (btnSelCrs.Down or btnSelWin.Down)
  then with ParView1.Canvas do begin
    Pen.Mode := pmNot; Pen.Width := 1;
    Pen.Style := psSolid;
    Brush.Style := bsClear;
    with FSelRect do begin
      Rectangle(Left, Top, Right, Bottom);
      Right := X; Bottom := Y;
      Rectangle(Left, Top, Right, Bottom);
    end;
  end else
  if LBDown and btnPan.Down then with ParView1 do begin
    dx := (X - FSelRect.Right) / Zoom;
    dy := (FSelRect.Bottom  - Y) / Zoom;
    SetOrg(OrgX - dx, OrgY - dy);
    FSelRect.Right := X; FSelRect.Bottom := Y;
  end else
  if LBDown and btnZoom.Down then with ParView1 do begin
    if Y > 0 then dy := FSelRect.Bottom  / Y
    else dy := 1;
    Zoom := Zoom * dy;
    FSelRect.Right := X; FSelRect.Bottom := Y;
  end;

  p.X := X; p.Y := Y;
  with ParView1 do begin
    dx := GetPaperX(X);
    dy := GetPaperY(Y);
    st := SelSingle(p);
    if st <> ''
    then st := Format('%s [%f, %f] Zoom: %f', [st, dx, dy, Zoom])
    else st := Format('[%f, %f] Zoom: %f', [dx, dy, Zoom]);
  end;
  paStatus.Caption := st;
end;

procedure TMainFrm.ParView1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var p: TPoint; idx: integer; st: string;
begin
  p.X := X; p.Y := Y;
  if (Button = mbLeft) then begin
    LBDown := true;
    FSelRect.Left := X; FSelRect.Top := Y;
    FSelRect.Right := X; FSelRect.Bottom := Y;
  end;

  if btnSelSin.Down and (Button = mbLeft) then begin
    ParView1.SelPoint(p);
    ParView1.Paint;
  end else
  if btnSelSin.Down and (Button = mbRight) then begin
    st := ParView1.SelSingle(p);
    if (st <> '') and (FModel <> nil) then begin
      idx := FModel.Selection.IndexOf(st);
      if (idx <> -1) then FModel.Selection.Delete(idx);
        ParView1.Paint;
    end;
  end else
  if (not btnSelSin.Down) and (Button = mbRight) then begin
    if btnPan.Down then btnPan.Down := false;
    if btnZoom.Down then btnZoom.Down := false;
    if btnSelCrs.Down then btnSelCrs.Down := false;
    if btnSelWin.Down then btnSelWin.Down := false;
    OnBtnsClick(Self);
  end;
  if FModel <> nil then lbSelSet.Items := FModel.Selection;
end;

procedure TMainFrm.ParView1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) then begin
    LBDown := false;
    if (X > FSelRect.Left)
    then FSelRect.Right := X
    else begin
      FSelRect.Right := FSelRect.Left;
      FSelRect.Left := X;
    end;
    if (Y > FSelRect.Top)
    then FSelRect.Bottom := Y
    else begin
      FSelRect.Bottom := FSelRect.Top;
      FSelRect.Top := Y;
    end;
  end;
  if btnSelCrs.Down then begin
    ParView1.SelCross(FSelRect);
    ParView1.Paint;
  end else
  if btnSelWin.Down then begin
    ParView1.SelWindow(FSelRect);
    ParView1.Paint;
  end;
  if FModel <> nil then lbSelSet.Items := FModel.Selection;
end;

procedure TMainFrm.OnBtnsClick(Sender: TObject);
begin
  ParView1.Cursor := crDefault;
  if btnPan.Down  then ParView1.Cursor := crPan;
  if btnZoom.Down then ParView1.Cursor := crZoom;
  if btnSelCrs.Down then ParView1.Cursor := crCross;
end;

procedure TMainFrm.btnZoomAllClick(Sender: TObject);
begin
  ParView1.ZoomAll;
end;

end.
