unit Edge;

{  ******
   *
   * Module:    Edge
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    This module defines an edge.  Edges, along with vertices, define the
   *    shape of a visible object.  An edge is defined as a connection between
   *    two vertices.
   *
   ****** }

interface
uses Vertex, WinTypes, Graphics;

type TEdge = class(TObject)
    public
        m_vtxOne, m_vtxTwo: TVertex;     { Vertices connected by this edge. }
        m_iShapeID: Integer;             { Value identifing which shape the edge belongs to. }
        m_clrEdge: TColor;               { Default color of the edge. }
        m_bVisible: Boolean;             { TRUE if the edge is currently visible. }
        m_bIncludeInCollisions: Boolean; { TRUE edge defines part of object's collision boundary. }
end;

implementation

end.
