unit GameEnv;

{  ******
   *
   * Module:    GameEnv
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    The TGameEnvironment class keeps track of the current environment,
   *    such as the current video, audio, and input objects.  
   *
   ****** }

interface
uses AppEnv, SoundDev, VideoDev, InputDev;

type TGameEnvironment = class(TAppEnvironment)
    public
        { Public constructor and destructor. }
        constructor Create(szINIFilename: String;
                           devSound: TSoundDevice;
                           devVideo: TVideoDevice;
                           devInput: TInputDevice);
        destructor Destroy;

        { Methods to set th input and output devices. }
        procedure SetSoundDevice(devSound: TSoundDevice);
        procedure SetVideoDevice(devVideo: TVideoDevice);
        procedure SetInputDevice(devInput: TInputDevice);

        { Methods to retrieve input and output devices. }
        function devGetSoundDevice: TSoundDevice;
        function devGetVideoDevice: TVideoDevice;
        function devGetInputDevice: TInputDevice;

    private
        m_devSound: TSoundDevice;
        m_devVideo: TVideoDevice;
        m_devInput: TInputDevice;
end;

implementation

constructor TGameEnvironment.Create(szINIFilename: String;
                                    devSound: TSoundDevice;
                                    devVideo: TVideoDevice;
                                    devInput: TInputDevice);
begin
    { Perform the default processing. }
    inherited Create(szINIFilename);

    { Stash references to video, audio, and input devices. }
    m_devSound := devSound;
    m_devVideo := devVideo;
    m_devInput := devInput;
end;

destructor TGameEnvironment.Destroy;
begin
    inherited Destroy;
end;

procedure TGameEnvironment.SetSoundDevice(devSound: TSoundDevice);
begin
    m_devSound := devSound;
end;

procedure TGameEnvironment.SetVideoDevice(devVideo: TVideoDevice);
begin
    m_devVideo := devVideo;
end;

procedure TGameEnvironment.SetInputDevice(devInput: TInputDevice);
begin
    m_devInput := devInput;
end;

function TGameEnvironment.devGetSoundDevice: TSoundDevice;
begin
    Result := m_devSound;
end;

function TGameEnvironment.devGetVideoDevice: TVideoDevice;
begin
    Result := m_devVideo;
end;

function TGameEnvironment.devGetInputDevice: TInputDevice;
begin
    Result := m_devInput;
end;

end.

