unit PDF417Demo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls,PDF417;

type
  TPDFDemo = class(TForm)
    Image1: TImage;
    btnRefresh: TButton;
    btnPrint: TButton;
    btnExit: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    txtCode: TEdit;
    Label3: TLabel;
    cCompaction: TComboBox;
    lblMode: TLabel;
    cMode: TComboBox;
    Label4: TLabel;
    txtColumns: TEdit;
    lblSymbol: TLabel;
    txtRows: TEdit;
    Label5: TLabel;
    txtFileSize: TEdit;
    Label6: TLabel;
    txtAddresse: TEdit;
    Label7: TLabel;
    txtTimestamp: TEdit;
    Label8: TLabel;
    txtSender: TEdit;
    Label9: TLabel;
    txtFileId: TEdit;
    Label10: TLabel;
    txtFileName: TEdit;
    Label11: TLabel;
    txtSegment: TEdit;
    Label2: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    txtHeight: TEdit;
    txtWidth: TEdit;
    Label15: TLabel;
    txtPrinterHeight: TEdit;
    Label16: TLabel;
    txtPrinterWidth: TEdit;
    Button1: TButton;
    chkCompact: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    pdf417:TPDF417;
  public
    { Public declarations }
  end;

var
  PDFDemo: TPDFDemo;

implementation
uses printers;

{$R *.DFM}

procedure TPDFDemo.FormCreate(Sender: TObject);
begin
 pdf417:=TPDF417.create(nil);
 cMode.itemIndex:=2;
 cCompaction.itemIndex:=0;
 btnRefreshClick(nil);
 
end;

procedure TPDFDemo.btnExitClick(Sender: TObject);
begin
hide();
end;

procedure TPDFDemo.btnRefreshClick(Sender: TObject);
var
value:integer;
dummy:integer;
segment:integer;
begin
 pdf417.code:=txtCode.text;
 if (cMode.itemIndex>=0) then pdf417.PDFECLevel:=cMode.itemIndex
 else     pdf417.PDFECLevel:=0;

 if (cCompaction.itemIndex>=0)   then pdf417.PDFMode:=TEncoding(cCompaction.itemIndex)
 else pdf417.PDFMode:=PDF_BINARY;

 if (chkCompact.state=cbChecked) then pdf417.PDFtruncated:=true
 else pdf417.PDFtruncated:=false;

 val(txtRows.text,value,dummy);
 pdf417.PDFRows:=value;

 val(txtColumns.text,value,dummy);
 pdf417.PDFColumns:=value  ;

 val(txtSegment.text,value,dummy);
 pdf417.PDFMacroSegment:=value ;

 val(txtWidth.text,value,dummy);
 pdf417.BarWidthPixels:=value ;

 val(txtHeight.text,value,dummy);
 pdf417.BarHeightPixels:=value  ;


{val(txtSegmentCount.text,value,dummy);
 pdf417.PDFMacroSegmentCount:=value}


 pdf417.PDFMacroAddresse:=txtAddresse.text;
 pdf417.PDFMacroSender:=txtSender.text;
 pdf417.PDFMacroTimestamp:=txtTimestamp.text;
 val(txtFileSize.text,value,dummy);
 pdf417.PDFMacroFileSize:=value;
 pdf417.PDFMacroFilename:=txtFilename.text;
 pdf417.PDFMacroFileId:=txtFileId.text;

{  MACRO PDF example
 pdf417.code:='This is a test of the barcode PDF417This is a test of the barcode PDF417';
 pdf417.PDFMacroFileId:='c.zip';
 pdf417.PDFMacroFilename:='a.zip';
 pdf417.PDFMaxRows:=5;
 pdf417.PDFColumns:=10;
 pdf417.PDFECLevel:=1;
 pdf417.PDFMacroTimestamp:='000';
 pdf417.PDFMacroSegment:=1;
pdf417.PDFMacroAddresse:='ISO CH';
pdf417.PDFMacroSender:='CEN BE';

 pdf417.PDFMacroFileSize:=10000;    }


 pdf417.resetMacroPDF();
 if (pdf417.PDFMacroSegment>-1) then   begin
     segment:=pdf417.PDFMacroSegment;
     {calculate number of segment needed}
     pdf417.prepareMacroPDF();

     pdf417.PDFMacroSegment:=segment ;

 end;

 pdf417.paintBarcode(Image1.Canvas);

end;

procedure TPDFDemo.btnPrintClick(Sender: TObject);
var
value:integer;
dummy:integer;
begin
     with printer do
     begin
		BeginDoc;

                val(txtPrinterWidth.text,value,dummy);
                pdf417.BarWidthPixels:=value ;

                val(txtPrinterHeight.text,value,dummy);
                pdf417.BarHeightPixels:=value  ;

                pdf417.topmargin:=printer.PageHeight div 10;
                pdf417.leftmargin:=printer.PageWidth div 10;
		pdf417.paintBarcode(Canvas);

		EndDoc;
     end;
end;

procedure TPDFDemo.Button1Click(Sender: TObject);
var
bmp:TBitmap;
begin
     bmp:=TBitmap.create();
     bmp.height:=200;
     bmp.width:=200;
     pdf417.paintBarcode(bmp.Canvas);
     bmp.SaveToFile('pdf417.bmp');

     MessageDlg('Image saved to pdf417.bmp.', mtInformation,      [mbOk], 0);


end;

end.

