unit TEMainFrm;

{------------------------------------------------------------------------------}
{
  Very simple template editor for "mail merging"
  It loads and saves a template in TEMPLATE.RVF.

  See mail merging application in the same directory - MAILMERGE.

  Main settings:
  - since field names are stored in tags (see the help topic about tags)
    as strings, rvoTagsArePChars is included in Options of rve.
  - this demo uses a predefined set of styles (right click richviews,
    choose "Settings" from the context menu, choose "Use a predefined
    set of styles"). That means - only two text styles (see below) will be used.
  - rve.Style has two styles:
    0th style - normal text,
    1st - field code (bold, with background, protected)
}
{------------------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, RVStyle, RVScroll, RichView, RVEdit, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    rve: TRichViewEdit;
    RVStyle1: TRVStyle;
    Button4: TButton;
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  rve.LoadRVF(ExtractFilePath(Application.ExeName)+'template.rvf');
  rve.Format;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  rve.SaveRVF(ExtractFilePath(Application.ExeName)+'template.rvf', False);
end;

{------------------------------------------------------------------------------}
{
  Inserting a field "code". Text of this item does not matter, but tag
  is important and equal to "code".
  Since rvprDoNotAutoSwitch is in Protection of the 1st text style,
  a current style will be switched back to previous value after insertion.
}
{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
begin
  rve.CurTextStyleNo := 1;
  rve.InsertStringTag('Code', Integer(StrNew('code')));
  rve.SetFocus;  
end;
{------------------------------------------------------------------------------}
{
  Inserting a field "name".
}
{------------------------------------------------------------------------------}
procedure TForm1.Button2Click(Sender: TObject);
begin
  rve.CurTextStyleNo := 1;
  rve.InsertStringTag('Name', Integer(StrNew('name')));
  rve.SetFocus;
end;

end.
