unit Unit1;

interface

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, RVScroll, RichView, RVEdit, ComCtrls, RVStyle, PreviewFrm,
  PtblRV, StdCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    RichViewEdit1: TRichViewEdit;
    RichViewEdit2: TRichViewEdit;
    RichViewEdit3: TRichViewEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Print1: TMenuItem;
    Exit1: TMenuItem;
    RVStyle1: TRVStyle;
    RVStyle2: TRVStyle;
    RVStyle3: TRVStyle;
    RVPrint1: TRVPrint;
    N1: TMenuItem;
    N2: TMenuItem;
    PrintPreview1: TMenuItem;
    OpenDialog1: TOpenDialog;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    txtLeft: TEdit;
    Label2: TLabel;
    txtRight: TEdit;
    Label3: TLabel;
    txtTop: TEdit;
    Label4: TLabel;
    txtBottom: TEdit;
    GroupBox2: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    txtHeader: TEdit;
    txtFooter: TEdit;
    New1: TMenuItem;
    PrinterSetupDialog1: TPrinterSetupDialog;
    procedure PrintPreview1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
    function IsEmpty(rve: TCustomRichViewEdit): Boolean;
    procedure PreparePrinting;
    procedure OpenFile(const FileName: String);    
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

function TForm1.IsEmpty(rve: TCustomRichViewEdit): Boolean;
begin
  Result := (rve.ItemCount=0) or ((rve.ItemCount=1) and (rve.GetItemStyle(0)>=0) and
    (rve.GetItemText(0)=''));
end;

procedure TForm1.PreparePrinting;
begin
  RVPrint1.AssignSource(RichViewEdit1);
  if not IsEmpty(RichViewEdit2) then begin
    if StrToIntDef(txtHeader.Text,-1)<0 then
      txtHeader.Text := '10';
    RVPrint1.SetHeader(RichViewEdit2.RVData);
    end
  else
    RVPrint1.SetHeader(nil);
  if not IsEmpty(RichViewEdit3) then begin
    if StrToIntDef(txtFooter.Text,-1)<0 then
      txtFooter.Text := '10';
    RVPrint1.SetFooter(RichViewEdit3.RVData)
    end
  else
    RVPrint1.SetFooter(nil);
  RVPrint1.LeftMarginMM   := StrToIntDef(txtLeft.Text,0);
  RVPrint1.RightMarginMM  := StrToIntDef(txtRight.Text,0);
  RVPrint1.TopMarginMM    := StrToIntDef(txtTop.Text,0);
  RVPrint1.BottomMarginMM := StrToIntDef(txtBottom.Text,0);
  RVPrint1.HeaderYMM      := StrToIntDef(txtHeader.Text,0);
  RVPrint1.FooterYMM      := StrToIntDef(txtFooter.Text,0);
  RVPrint1.FormatPages(rvdoALL);
end;

procedure TForm1.New1Click(Sender: TObject);
begin
  RichViewEdit1.Clear;
  RichViewEdit2.Clear;
  RichViewEdit3.Clear;
  RichViewEdit1.DeleteUnusedStyles(True,True,True);
  RichViewEdit2.DeleteUnusedStyles(True,True,True);
  RichViewEdit3.DeleteUnusedStyles(True,True,True);
  RichViewEdit1.Format;
  RichViewEdit2.Format;
  RichViewEdit3.Format;
end;

procedure TForm1.OpenFile(const FileName: String);
begin
  RichViewEdit1.Clear;
  RichViewEdit2.Clear;
  RichViewEdit3.Clear;
  RichViewEdit1.DeleteUnusedStyles(True,True,True);
  RichViewEdit2.DeleteUnusedStyles(True,True,True);
  RichViewEdit3.DeleteUnusedStyles(True,True,True);
  RichViewEdit1.RTFReadProperties.SetHeader(RichViewEdit2.RVData);
  RichViewEdit1.RTFReadProperties.SetFooter(RichViewEdit3.RVData);
  RichViewEdit1.LoadRTF(FileName);
  RichViewEdit1.Format;
  RichViewEdit2.Format;
  RichViewEdit3.Format;
  txtHeader.Text := IntToStr(RichViewEdit1.RTFReadProperties.HeaderYMM);
  txtFooter.Text := IntToStr(RichViewEdit1.RTFReadProperties.FooterYMM);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenFile(ExtractFilePath(Application.ExeName)+'doc.rtf');
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    OpenFile(OpenDialog1.FileName);
end;

procedure TForm1.PrintPreview1Click(Sender: TObject);
var frm: TfrmPreview;
begin
  PreparePrinting;
  frm := TfrmPreview.Create(Application);
  frm.rvpp.RVPrint := RVPrint1;
  frm.Button1Click(nil);
  frm.ShowModal;
  frm.Free;
end;

procedure TForm1.Print1Click(Sender: TObject);
var PrintIt: Boolean;
begin
  {$IFDEF RICHVIEWDEF3}
  PrintIt := PrinterSetupDialog1.Execute;
  {$ELSE}
  PrintIt := True;
  {$ENDIF}
  if PrintIt then begin
    RVPrint1.AssignSource(RichViewEdit1);
    RVPrint1.FormatPages(rvdoALL);
    if RVPrint1.PagesCount>0 then
      RVPrint1.Print('RichView Edit Demo',1,False);
  end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
