// CopyProt.cpp : Defines the entry point for the DLL application.
//

#include <windows.h>
#include "stdafx.h"
#include "General.h"
#include "resource.h"

DLLFUNC *DllThunk32;

HMODULE hLib=NULL;
HANDLE hMod;
BOOL APIENTRY CopyProtect(void);
BOOL CALLBACK CopyProtDlgProc(HWND, UINT, WPARAM, LPARAM);
UINT WINAPI GetOSVersion(void);

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch(ul_reason_for_call){
	case DLL_PROCESS_ATTACH:
		if(hLib != NULL)
			break;
		hMod = hModule;
		if(GetVersion() > 0x80000000){
			hLib = LoadLibrary("Disk32.DLL");
			if(hLib == NULL){
				MessageBox(NULL, "Disk32.DLL not found", "DLL Error", MB_OK);
				return FALSE;
			}
			DllThunk32 = (DLLFUNC *) GetProcAddress(hLib, "ReadDisk32");
			if(DllThunk32 == NULL){
				MessageBox(NULL, "ReadDisk32 Function not accessible!", "DLL Error", MB_OK);
				return FALSE;
			}
		}
	case DLL_PROCESS_DETACH:
		break;
	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
		break;
	}
	return TRUE;
}

BOOL APIENTRY CopyProtect(void)
{
	DWORD Drive, Tmp;
	TRACKHEADSECT Ths[4];
	HANDLE hFloppy=0;
	Drive = ::DialogBox((HINSTANCE) hMod, "CopyProt", NULL, CopyProtDlgProc);
	HLOCAL hMem = LocalAlloc(LMEM_MOVEABLE|LMEM_DISCARDABLE, 1000);
	LPBYTE pMem = (LPBYTE) LocalLock(hMem);
	if(GetVersion() > 0x80000000){
		if(!(DllThunk32)(Drive, 0, 0, 1, 1, pMem)){
			MessageBox(NULL, "Boot Sector not accessible!", "ERROR", MB_OK);
			return FALSE;
		}
	}
	else{
		char TmpStr[10];
		wsprintf(TmpStr, "\\\\.\\%c:", ((BYTE) Drive)+'A');
		hFloppy = CreateFile(TmpStr, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_NO_BUFFERING, NULL);
		ReadFile(hFloppy, pMem, 512, &Tmp, NULL);
		if((pMem[0] == 0xF6) && (pMem[1] == 0xF6) && (pMem[2] == 0xF6) && (pMem[509] == 0xF6) && (pMem[510] == 0xF6) && (pMem[511] == 0xF6)){
			MessageBox(NULL, "Boot Sector not accessible!", "ERROR", MB_OK);
			return FALSE;
		}
	}
	DWORD SectorsPerTrack = ((BOOT *) pMem)->SectorsPerTrack;
	DWORD NumHeads = ((BOOT *) pMem)->NumHeads;
	if((pMem[0] != 0xEB)  || (pMem[1] != 0xFE) || (pMem[508] != 'V') || (pMem[509] != 'C'))
		return FALSE;
	for(int i=0; i<4; i++){
		Ths[i].Track = pMem[496+i*3];
		Ths[i].Head = pMem[497+i*3];
		Ths[i].Sector = pMem[498+i*3];
	}
	for(i=0; i<4; i++){
		if(GetVersion() > 0x80000000){
			if((DllThunk32)(Drive, Ths[i].Track, Ths[i].Head, Ths[i].Sector, 1, pMem))
				return FALSE;
		}
		else{
			char TmpStr[10];
			wsprintf(TmpStr, "\\\\.\\%c:", ((BYTE) Drive)+'A');
			SetFilePointer(hFloppy, ((Ths[i].Track*NumHeads+Ths[i].Head)*SectorsPerTrack+Ths[i].Sector)*512, 0, FILE_BEGIN);
			ReadFile(hFloppy, pMem, 512, &Tmp, NULL);
			if((pMem[0] != 0xF6) || (pMem[1] != 0xF6) || (pMem[2] != 0xF6) || (pMem[509] != 0xF6) || (pMem[510] != 0xF6) || (pMem[511] != 0xF6)){
				return FALSE;
			}
		}
	}
	if(hFloppy)
		CloseHandle(hFloppy);
	return TRUE;
}

BOOL CALLBACK CopyProtDlgProc(HWND hWndDlg, UINT msg,
						WPARAM wParam, LPARAM lParam)
{
	BOOL DrivePresent=FALSE;
	char TmpStr[]="A:\\";
	DWORD Drive;

	switch ( msg )
	{
	case WM_COMMAND:
		if(LOWORD(wParam) == IDOK){
			Drive = SendMessage(GetDlgItem(hWndDlg, IDC_FLOPPYDRIVE), CB_GETCURSEL, 0, 0);
			EndDialog(hWndDlg, Drive);
			return TRUE;
		}
		break;
	case WM_INITDIALOG:
		for(int i=0; i<26; i++){
			if(GetDriveType(TmpStr)==DRIVE_REMOVABLE){
				SendMessage(GetDlgItem(hWndDlg, IDC_FLOPPYDRIVE), CB_ADDSTRING, 0, (LPARAM) TmpStr);
				DrivePresent = TRUE;
			}
			TmpStr[0]++;
		}
		if(!DrivePresent){
			MessageBox(hWndDlg, "No Floppy drives in the system!", "FATAL", MB_OK);
			EndDialog(hWndDlg, -1);
			return FALSE;
		}
		SendMessage(GetDlgItem(hWndDlg, IDC_FLOPPYDRIVE), CB_SETCURSEL, 0, 0);
		break;
	}
	return FALSE;
}
