// Options.cpp : implements the Options tabbed dialog box
//

// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#include "stdafx.h"
#include "HexEdit.h"
#include "HexEditView.h"
#include "Dialog.h"             // For Macro Save dialog etc
#include "DirDialog.h"          // For directory selection dialog
#include "resource.hm"          // For control help IDs

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptSheet

IMPLEMENT_DYNAMIC(COptSheet, CPropertySheet)

COptSheet::COptSheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
        :CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
}

COptSheet::COptSheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
        :CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
}

COptSheet::~COptSheet()
{
}


BEGIN_MESSAGE_MAP(COptSheet, CPropertySheet)
        //{{AFX_MSG_MAP(COptSheet)
        ON_WM_NCCREATE()
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptSheet message handlers

BOOL COptSheet::OnNcCreate(LPCREATESTRUCT lpCreateStruct) 
{
        if (!CPropertySheet::OnNcCreate(lpCreateStruct))
                return FALSE;
        
        ModifyStyleEx(0, WS_EX_CONTEXTHELP);
        
        return TRUE;
}

//===========================================================================
/////////////////////////////////////////////////////////////////////////////
// CGeneralPage property page

IMPLEMENT_DYNCREATE(CGeneralPage, CPropertyPage)

CGeneralPage::CGeneralPage() // /* Don't Construct yet*/ : CPropertyPage(CGeneralPage::IDD)
{
        //{{AFX_DATA_INIT(CGeneralPage)
        backup_ = FALSE;
        save_exit_ = FALSE;
	one_only_ = FALSE;
	shell_open_ = FALSE;
	bg_search_ = FALSE;
	//}}AFX_DATA_INIT
}

CGeneralPage::~CGeneralPage()
{
}

void CGeneralPage::DoDataExchange(CDataExchange* pDX)
{
        CPropertyPage::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CGeneralPage)
        DDX_Check(pDX, IDC_BACKUP, backup_);
        DDX_Check(pDX, IDC_SAVE_EXIT, save_exit_);
        DDX_Check(pDX, IDC_ONE_ONLY, one_only_);
        DDX_Check(pDX, IDC_SHELLOPEN, shell_open_);
        DDX_Check(pDX, IDC_BG_SEARCH, bg_search_);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGeneralPage, CPropertyPage)
        //{{AFX_MSG_MAP(CGeneralPage)
        ON_BN_CLICKED(IDC_SAVE_NOW, OnSaveNow)
        ON_BN_CLICKED(IDC_BACKUP, OnChange)
        ON_WM_HELPINFO()
        ON_BN_CLICKED(IDC_SAVE_EXIT, OnChange)
        ON_BN_CLICKED(IDC_ONE_ONLY, OnChange)
        ON_BN_CLICKED(IDC_BG_SEARCH, OnChange)
        ON_BN_CLICKED(IDC_SHELLOPEN, OnShellopen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGeneralPage message handlers

void CGeneralPage::OnOK() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    aa->set_general();
        
    CPropertyPage::OnOK();
}

BOOL CGeneralPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
//      return CPropertyPage::OnHelpInfo(pHelpInfo);
    static DWORD id_pairs[] = { 
        IDC_SHELLOPEN, HIDC_SHELLOPEN,
        IDC_ONE_ONLY, HIDC_ONE_ONLY,
        IDC_BG_SEARCH, HIDC_BG_SEARCH,
        IDC_SAVE_EXIT, HIDC_SAVE_EXIT,
        IDC_SAVE_NOW, HIDC_SAVE_NOW,
        IDC_BACKUP, HIDC_BACKUP,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}

void CGeneralPage::OnChange() 
{
    SetModified(TRUE);
}

void CGeneralPage::OnShellopen() 
{
    UpdateData();
    if (shell_open_)
    {
        if (AfxMessageBox("This option affects all users of the system and\n"
                          "can cause problems with some program launchers.\n"
                          "Do you want to enable this option anyway?",
                          MB_YESNO) != IDYES)
        {
            shell_open_ = FALSE;
            UpdateData(FALSE);
        }
    }
    SetModified(TRUE);
}

void CGeneralPage::OnSaveNow() 
{
    CPropertySheet *oo = dynamic_cast<CPropertySheet *>(GetParent());

    // BUG: PressButton() always returns zero - so ignore return value
    (void)oo->PressButton(PSBTN_APPLYNOW);
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    aa->SaveOptions();
}

/////////////////////////////////////////////////////////////////////////////
// CSysDisplayPage property page

IMPLEMENT_DYNCREATE(CSysDisplayPage, CPropertyPage)

CSysDisplayPage::CSysDisplayPage() // /* Don't Construct yet*/ : CPropertyPage(CSysDisplayPage::IDD)
{
	//{{AFX_DATA_INIT(CSysDisplayPage)
	large_cursor_ = FALSE;
	hex_ucase_ = FALSE;
	nice_addr_ = FALSE;
	open_restore_ = FALSE;
	//}}AFX_DATA_INIT
}

CSysDisplayPage::~CSysDisplayPage()
{
}

void CSysDisplayPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSysDisplayPage)
	DDX_Check(pDX, IDC_LARGE_CURSOR, large_cursor_);
	DDX_Check(pDX, IDC_HEX_UCASE, hex_ucase_);
	DDX_Check(pDX, IDC_NICE_ADDR, nice_addr_);
	DDX_Check(pDX, IDC_RESTORE, open_restore_);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSysDisplayPage, CPropertyPage)
	//{{AFX_MSG_MAP(CSysDisplayPage)
	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_HEX_UCASE, OnChange)
	ON_BN_CLICKED(IDC_NICE_ADDR, OnChange)
	ON_BN_CLICKED(IDC_RESTORE, OnChange)
	ON_BN_CLICKED(IDC_LARGE_CURSOR, OnChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSysDisplayPage message handlers

void CSysDisplayPage::OnChange() 
{
    SetModified(TRUE);
}

void CSysDisplayPage::OnOK() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    aa->set_sysdisplay();
        
    CPropertyPage::OnOK();
}

BOOL CSysDisplayPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
    static DWORD id_pairs[] = { 
        IDC_RESTORE, HIDC_RESTORE,
        IDC_HEX_UCASE, HIDC_HEX_UCASE,
        IDC_NICE_ADDR, HIDC_NICE_ADDR,
        IDC_LARGE_CURSOR, HIDC_LARGE_CURSOR,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}

//===========================================================================
/////////////////////////////////////////////////////////////////////////////
// CMacroPage property page

IMPLEMENT_DYNCREATE(CMacroPage, CPropertyPage)

CMacroPage::CMacroPage() // : CPropertyPage(CMacroPage::IDD)
{
        //{{AFX_DATA_INIT(CMacroPage)
        num_keys_ = 0;
        num_plays_ = 0;
        num_secs_ = 0;
        refresh_ = -1;
        refresh_bars_ = FALSE;
        refresh_props_ = FALSE;
        halt_level_ = -1;
        //}}AFX_DATA_INIT
}

CMacroPage::~CMacroPage()
{
}

void CMacroPage::DoDataExchange(CDataExchange* pDX)
{
        CPropertyPage::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CMacroPage)
        DDX_Text(pDX, IDC_NUM_KEYS, num_keys_);
        DDV_MinMaxLong(pDX, num_keys_, 1, 999);
        DDX_Text(pDX, IDC_NUM_PLAYS, num_plays_);
        DDV_MinMaxLong(pDX, num_plays_, 1, 999);
        DDX_Text(pDX, IDC_NUM_SECS, num_secs_);
        DDV_MinMaxLong(pDX, num_secs_, 1, 999);
        DDX_Radio(pDX, IDC_REFRESH_NEVER, refresh_);
        DDX_Check(pDX, IDC_REFRESH_BARS, refresh_bars_);
        DDX_Check(pDX, IDC_REFRESH_PROPS, refresh_props_);
        DDX_Radio(pDX, IDC_HALT0, halt_level_);
        //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMacroPage, CPropertyPage)
        //{{AFX_MSG_MAP(CMacroPage)
        ON_WM_HELPINFO()
        ON_BN_CLICKED(IDC_HALT0, OnChange)
        ON_BN_CLICKED(IDC_REFRESH_NEVER, OnRefreshNever)
        ON_BN_CLICKED(IDC_REFRESH_PLAYS, OnRefreshPlays)
        ON_BN_CLICKED(IDC_REFRESH_SECS, OnRefreshSecs)
        ON_BN_CLICKED(IDC_REFRESH_KEYS, OnRefreshKeys)
        ON_BN_CLICKED(IDC_HALT1, OnChange)
        ON_BN_CLICKED(IDC_HALT2, OnChange)
        ON_EN_CHANGE(IDC_NUM_KEYS, OnChange)
        ON_EN_CHANGE(IDC_NUM_PLAYS, OnChange)
        ON_EN_CHANGE(IDC_NUM_SECS, OnChange)
        ON_BN_CLICKED(IDC_REFRESH_BARS, OnChange)
        ON_BN_CLICKED(IDC_REFRESH_PROPS, OnChange)
	ON_BN_CLICKED(IDC_SAVEMACRO, OnSavemacro)
	ON_BN_CLICKED(IDC_LOADMACRO, OnLoadmacro)
	ON_BN_CLICKED(IDC_MACRODIR, OnMacrodir)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMacroPage message handlers

BOOL CMacroPage::OnInitDialog() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    CPropertyPage::OnInitDialog();

    ASSERT(GetDlgItem(IDC_SPIN_SECS) != NULL);
    ((CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_SECS))->SetRange(1, 999);
    ASSERT(GetDlgItem(IDC_SPIN_KEYS) != NULL);
    ((CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_KEYS))->SetRange(1, 999);
    ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
    ((CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_PLAYS))->SetRange(1, 999);

    // Set edit box, spin control, static text for all 3 refresh options
    ASSERT(GetDlgItem(IDC_NUM_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_SECS) != NULL);
    GetDlgItem(IDC_NUM_SECS)->EnableWindow(refresh_ == 1);
    GetDlgItem(IDC_SPIN_SECS)->EnableWindow(refresh_ == 1);
    GetDlgItem(IDC_DESC_SECS)->EnableWindow(refresh_ == 1);

    ASSERT(GetDlgItem(IDC_NUM_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_KEYS) != NULL);
    GetDlgItem(IDC_NUM_KEYS)->EnableWindow(refresh_ == 2);
    GetDlgItem(IDC_SPIN_KEYS)->EnableWindow(refresh_ == 2);
    GetDlgItem(IDC_DESC_KEYS)->EnableWindow(refresh_ == 2);

    ASSERT(GetDlgItem(IDC_NUM_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_PLAYS) != NULL);
    GetDlgItem(IDC_NUM_PLAYS)->EnableWindow(refresh_ == 3);
    GetDlgItem(IDC_SPIN_PLAYS)->EnableWindow(refresh_ == 3);
    GetDlgItem(IDC_DESC_PLAYS)->EnableWindow(refresh_ == 3);

    ASSERT(GetDlgItem(IDC_SAVEMACRO) != NULL);
    GetDlgItem(IDC_SAVEMACRO)->EnableWindow(!aa->recording_ && aa->mac_.size() > 0);
    return TRUE;
}

void CMacroPage::OnChange() 
{
    SetModified(TRUE);
}

void CMacroPage::OnOK() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    aa->set_macro();

    CPropertyPage::OnOK();
}

BOOL CMacroPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
//      return CPropertyPage::OnHelpInfo(pHelpInfo);
    static DWORD id_pairs[] = { 
        IDC_REFRESH_NEVER, HIDC_REFRESH_NEVER,
        IDC_REFRESH_SECS, HIDC_REFRESH_SECS,
        IDC_REFRESH_KEYS, HIDC_REFRESH_KEYS,
        IDC_REFRESH_PLAYS, HIDC_REFRESH_PLAYS,
        IDC_NUM_SECS, HIDC_NUM_SECS,
        IDC_SPIN_SECS, HIDC_NUM_SECS,
        IDC_DESC_SECS, HIDC_NUM_SECS,
        IDC_NUM_KEYS, HIDC_NUM_KEYS,
        IDC_SPIN_KEYS, HIDC_NUM_KEYS,
        IDC_DESC_KEYS, HIDC_NUM_KEYS,
        IDC_NUM_PLAYS, HIDC_NUM_PLAYS,
        IDC_SPIN_PLAYS, HIDC_NUM_PLAYS,
        IDC_DESC_PLAYS, HIDC_NUM_PLAYS,
        IDC_REFRESH_BARS, HIDC_REFRESH_BARS,
        IDC_REFRESH_PROPS, HIDC_REFRESH_PROPS,
        IDC_HALT0, HIDC_HALT0,
        IDC_HALT1, HIDC_HALT1,
        IDC_HALT2, HIDC_HALT2,
        IDC_SAVEMACRO, HIDC_SAVEMACRO,
        IDC_LOADMACRO, HIDC_LOADMACRO,
        IDC_MACRODIR, HIDC_MACRODIR,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}

void CMacroPage::OnRefreshNever() 
{
    // Disable edit box, spin control, static text for all 3 refresh options
    ASSERT(GetDlgItem(IDC_NUM_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_SECS) != NULL);
    GetDlgItem(IDC_NUM_SECS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_SECS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_SECS)->EnableWindow(FALSE);

    ASSERT(GetDlgItem(IDC_NUM_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_PLAYS) != NULL);
    GetDlgItem(IDC_NUM_PLAYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_PLAYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_PLAYS)->EnableWindow(FALSE);

    ASSERT(GetDlgItem(IDC_NUM_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_KEYS) != NULL);
    GetDlgItem(IDC_NUM_KEYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_KEYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_KEYS)->EnableWindow(FALSE);

    SetModified(TRUE);
}

void CMacroPage::OnRefreshPlays() 
{
    // Disable edit box, spin control, static text KEYS and SECS
    // Enable them for PLAYS
    ASSERT(GetDlgItem(IDC_NUM_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_SECS) != NULL);
    GetDlgItem(IDC_NUM_SECS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_SECS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_SECS)->EnableWindow(FALSE);

    ASSERT(GetDlgItem(IDC_NUM_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_PLAYS) != NULL);
    GetDlgItem(IDC_NUM_PLAYS)->EnableWindow(TRUE);
    GetDlgItem(IDC_SPIN_PLAYS)->EnableWindow(TRUE);
    GetDlgItem(IDC_DESC_PLAYS)->EnableWindow(TRUE);

    ASSERT(GetDlgItem(IDC_NUM_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_KEYS) != NULL);
    GetDlgItem(IDC_NUM_KEYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_KEYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_KEYS)->EnableWindow(FALSE);

    SetModified(TRUE);
}

void CMacroPage::OnRefreshSecs() 
{
    // Disable edit box, spin control, static text KEYS and PLAYS
    // Enable them for SECS
    ASSERT(GetDlgItem(IDC_NUM_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_SECS) != NULL);
    GetDlgItem(IDC_NUM_SECS)->EnableWindow(TRUE);
    GetDlgItem(IDC_SPIN_SECS)->EnableWindow(TRUE);
    GetDlgItem(IDC_DESC_SECS)->EnableWindow(TRUE);

    ASSERT(GetDlgItem(IDC_NUM_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_PLAYS) != NULL);
    GetDlgItem(IDC_NUM_PLAYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_PLAYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_PLAYS)->EnableWindow(FALSE);

    ASSERT(GetDlgItem(IDC_NUM_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_KEYS) != NULL);
    GetDlgItem(IDC_NUM_KEYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_KEYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_KEYS)->EnableWindow(FALSE);

    SetModified(TRUE);
}

void CMacroPage::OnRefreshKeys() 
{
    // Disable edit box, spin control, static text PLAYS and SECS
    // Enable them for KEYS
    ASSERT(GetDlgItem(IDC_NUM_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_SECS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_SECS) != NULL);
    GetDlgItem(IDC_NUM_SECS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_SECS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_SECS)->EnableWindow(FALSE);

    ASSERT(GetDlgItem(IDC_NUM_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_PLAYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_PLAYS) != NULL);
    GetDlgItem(IDC_NUM_PLAYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_SPIN_PLAYS)->EnableWindow(FALSE);
    GetDlgItem(IDC_DESC_PLAYS)->EnableWindow(FALSE);

    ASSERT(GetDlgItem(IDC_NUM_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_SPIN_KEYS) != NULL);
    ASSERT(GetDlgItem(IDC_DESC_KEYS) != NULL);
    GetDlgItem(IDC_NUM_KEYS)->EnableWindow(TRUE);
    GetDlgItem(IDC_SPIN_KEYS)->EnableWindow(TRUE);
    GetDlgItem(IDC_DESC_KEYS)->EnableWindow(TRUE);

    SetModified(TRUE);
}

void CMacroPage::OnSavemacro() 
{
    if (!UpdateData(TRUE))
        return;                         // DDV failed

    CSaveMacro dlg;
    dlg.halt_level_ = halt_level_;

    dlg.DoModal();
}

void CMacroPage::OnLoadmacro() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    ASSERT_VALID(aa);

    ASSERT(aa->mac_dir_.Right(1) == "\\");
    CFileDialog dlg(TRUE, "hem", NULL, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST | OFN_SHOWHELP,
                    "Macro Files (*.hem)|*.hem|All Files (*.*)|*.*||", this);
	dlg.m_ofn.lpstrTitle = "Select Macro File";
    dlg.m_ofn.lpstrInitialDir = aa->mac_dir_;

    if (dlg.DoModal() == IDOK)
	{
        std::vector<key_macro> tmp;     // Load macro into temp so that if something goes wrong we don't lose the current macro
        CString comment;
        int halt_lev;
        long plays;

        if (aa->macro_load(dlg.GetPathName(), &tmp,
                           comment, halt_lev, plays))
        {
            aa->mac_ = tmp;             // Store the temp macro to current HexEdit macro
            aa->mac_filename_ = dlg.GetFileTitle();
            aa->mac_comment_ = comment;
            aa->plays_ = plays;
            halt_level_ = halt_lev;     // Set halt level requested by saved macro in this dialog
            UpdateData(FALSE);

            // Now enable save button since we now have a macro loaded
            ASSERT(GetDlgItem(IDC_SAVEMACRO) != NULL);
            GetDlgItem(IDC_SAVEMACRO)->EnableWindow(TRUE);

            // Display the comment for this macro
            if (!comment.IsEmpty())
                ::HMessageBox(comment);
        }
	}
}

void CMacroPage::OnMacrodir() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    ASSERT_VALID(aa);

    ASSERT(aa->mac_dir_.Right(1) == "\\");
    CDirDialog dlg(aa->mac_dir_, "Macro Files (*.hem)|*.hem|All Files (*.*)|*.*||", this);
    dlg.m_ofn.lpstrTitle = "Select Folder for HexEdit Macros";

    if (dlg.DoModal() == IDOK)
        aa->mac_dir_ = dlg.GetPath();
    ASSERT(aa->mac_dir_.Right(1) == "\\");
}

//===========================================================================
/////////////////////////////////////////////////////////////////////////////
// CDisplayPage property page

IMPLEMENT_DYNCREATE(CDisplayPage, CPropertyPage)

CDisplayPage::CDisplayPage() // : CPropertyPage(CDisplayPage::IDD)
{
        update_ok_ = false;

        //{{AFX_DATA_INIT(CDisplayPage)
        autofit_ = FALSE;
        char_ = FALSE;
        cols_ = 0;
        grouping_ = 0;
        offset_ = 0;
        //}}AFX_DATA_INIT
}

CDisplayPage::~CDisplayPage()
{
}

void CDisplayPage::DoDataExchange(CDataExchange* pDX)
{
        CPropertyPage::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CDisplayPage)
        DDX_Check(pDX, IDC_AUTOFIT, autofit_);
        DDX_Check(pDX, IDC_CHAR, char_);
        DDX_Text(pDX, IDC_COLS, cols_);
        DDX_Text(pDX, IDC_GROUPING, grouping_);
        DDX_Text(pDX, IDC_OFFSET, offset_);
        //}}AFX_DATA_MAP

        if (!pDX->m_bSaveAndValidate)
        {
            // Display the name of the window in the group box
            CWnd *pwnd = GetDlgItem(IDC_BOX);
            if (pwnd != NULL)
                pwnd->SetWindowText(window_name_);
        }
}


BEGIN_MESSAGE_MAP(CDisplayPage, CPropertyPage)
        //{{AFX_MSG_MAP(CDisplayPage)
        ON_BN_CLICKED(IDC_AUTOFIT, OnAutoFit)
        ON_BN_CLICKED(IDC_CHAR, OnChange)
        ON_WM_HELPINFO()
        ON_EN_CHANGE(IDC_COLS, OnChangeCols)
        ON_EN_CHANGE(IDC_GROUPING, OnChange)
        ON_EN_CHANGE(IDC_OFFSET, OnChange)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDisplayPage message handlers

BOOL CDisplayPage::OnInitDialog() 
{
    CPropertyPage::OnInitDialog();

    int state = 1;                      // Current enabled state of control
    CButton *bb;                        // Pointer to auto fit button control
    CWnd *ww;                           // Pointer to affected controls

    // Set spin control ranges (default to 0-100)
    CSpinButtonCtrl *pspin;
    pspin = (CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_COLS);
    ASSERT(pspin != NULL);
    pspin->SetRange(4, CHexEditView::max_buf);

    pspin = (CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_OFFSET);
    ASSERT(pspin != NULL);
//    pspin->SetRange(0, CHexEditView::max_buf-1);
    pspin->SetRange(0, cols_-1);

    pspin = (CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_GROUPING);
    ASSERT(pspin != NULL);
    pspin->SetRange(2, CHexEditView::max_buf);

    // See if Autofit control is checked
    bb = (CButton *)GetDlgItem(IDC_AUTOFIT);
    ASSERT(bb != NULL);
    if (bb != NULL)
        state = bb->GetCheck();

    // Disable column entry controls if checked
    ww = GetDlgItem(IDC_COLS_DESC);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);
    ww = GetDlgItem(IDC_COLS);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);
    pspin = (CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_COLS);
    ASSERT(pspin != NULL);
    if (pspin != NULL) pspin->EnableWindow(state == 0);

    return TRUE;
}

void CDisplayPage::OnChange() 
{
    SetModified(TRUE);
}

void CDisplayPage::OnChangeCols() 
{
    if (!update_ok_)
        return;
    update_ok_ = false;

    // Get cols_ value from dialog controls
    if (UpdateData(TRUE))
    {
        // Change the offset spin control range
        CSpinButtonCtrl *pspin;
        pspin = (CSpinButtonCtrl *)GetDlgItem(IDC_SPIN_OFFSET);
        ASSERT(pspin != NULL);
        pspin->SetRange(0, cols_-1);
    }

    SetModified(TRUE);
    update_ok_ = true;
}

void CDisplayPage::OnOK() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    ASSERT_VALID(aa);
    (void)aa->set_display();

    CPropertyPage::OnOK();
}

BOOL CDisplayPage::OnSetActive() 
{
    BOOL retval = CPropertyPage::OnSetActive();
    update_ok_ = true;          // Its now OK to allow changes to cols field to be processed
    return retval;
}

BOOL CDisplayPage::OnKillActive() 
{
    BOOL retval = CPropertyPage::OnKillActive();

    if (retval)
    {
        // Special validation that's too tricky for DDV, or gives nicer error messages
        if (cols_ < 4)
        {
            ::HMessageBox("You must have at least 4 columns");
            GetDlgItem(IDC_COLS)->SetFocus();
            return 0;
        }
        if (cols_ > CHexEditView::max_buf)
        {
            ::HMessageBox("Too many columns");
            GetDlgItem(IDC_COLS)->SetFocus();
            return 0;
        }
        if (offset_ >= cols_)
        {
            ::HMessageBox("Offset must be less than the number of columns");
            GetDlgItem(IDC_OFFSET)->SetFocus();
            return 0;
        }
        if (grouping_ < 2)
        {
            ::HMessageBox("There must be at least 2 columns per group");
            GetDlgItem(IDC_GROUPING)->SetFocus();
            return 0;
        }

        // All validation is OK so we will be deactivated
        update_ok_ = false;
    }

    return retval;
}

void CDisplayPage::OnCancel() 
{
    update_ok_ = false;
        
    CPropertyPage::OnCancel();
}

BOOL CDisplayPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
//      return CPropertyPage::OnHelpInfo(pHelpInfo);
    static DWORD id_pairs[] = { 
        IDC_CHAR, HIDC_CHAR,
        IDC_AUTOFIT, HIDC_AUTOFIT,
        IDC_COLS, HIDC_COLS,
        IDC_COLS_DESC, HIDC_COLS,
        IDC_SPIN_COLS, HIDC_COLS,
        IDC_OFFSET, HIDC_OFFSET,
        IDC_SPIN_OFFSET, HIDC_OFFSET,
        IDC_GROUPING, HIDC_GROUPING,
        IDC_SPIN_GROUPING, HIDC_GROUPING,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}


void CDisplayPage::OnAutoFit() 
{
    int state = 1;                      // Current enabled state of control
    CButton *bb;                        // Pointer to auto fit button control
    CWnd *ww;                           // Pointer to affected controls

    // See if control is checked
    bb = (CButton *)GetDlgItem(IDC_AUTOFIT);
    ASSERT(bb != NULL);
    if (bb != NULL)
        state = bb->GetCheck();

    // Disable other controls if checked
    ww = GetDlgItem(IDC_COLS_DESC);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);
    ww = GetDlgItem(IDC_COLS);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);
    ww = GetDlgItem(IDC_SPIN_COLS);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);

    OnChange();
}

//===========================================================================
/////////////////////////////////////////////////////////////////////////////
// CDefaultsPage property page

IMPLEMENT_DYNCREATE(CDefaultsPage, CPropertyPage)

CDefaultsPage::CDefaultsPage() // : CPropertyPage(CDefaultsPage::IDD)
{
        //{{AFX_DATA_INIT(CDefaultsPage)
        open_autofit_ = FALSE;
        open_display_char_ = FALSE;
        open_control_ = FALSE;
        open_ebcdic_ = FALSE;
        open_graphic_ = FALSE;
        open_dec_addr_ = FALSE;
        open_insert_ = -1;
        open_allow_mods_ = -1;
        open_max_ = FALSE;
        open_oem_ = FALSE;
        //}}AFX_DATA_INIT
        open_plf_ = open_oem_plf_ = NULL;
}

CDefaultsPage::~CDefaultsPage()
{
}

void CDefaultsPage::DoDataExchange(CDataExchange* pDX)
{
        CPropertyPage::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CDefaultsPage)
        DDX_Check(pDX, IDC_OPEN_AUTOFIT, open_autofit_);
        DDX_Check(pDX, IDC_OPEN_DISPLAY_CHAR, open_display_char_);
        DDX_Check(pDX, IDC_OPEN_CONTROL, open_control_);
        DDX_Check(pDX, IDC_OPEN_EBCDIC, open_ebcdic_);
        DDX_Check(pDX, IDC_OPEN_GRAPHIC, open_graphic_);
        DDX_Check(pDX, IDC_OPEN_ADDR_DEC, open_dec_addr_);
        DDX_Radio(pDX, IDC_OPEN_OVERTYPE, open_insert_);
        DDX_Radio(pDX, IDC_OPEN_READONLY, open_allow_mods_);
        DDX_Check(pDX, IDC_OPEN_MAX, open_max_);
        DDX_Check(pDX, IDC_OPEN_OEM, open_oem_);
        //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDefaultsPage, CPropertyPage)
        //{{AFX_MSG_MAP(CDefaultsPage)
        ON_BN_CLICKED(IDC_OPEN_AUTOFIT, OnChange)
        ON_BN_CLICKED(IDC_OPEN_DISPLAY_CHAR, OnChangedDisplayChar)
        ON_BN_CLICKED(IDC_OPEN_EBCDIC, OnChangeEbcdic)
        ON_WM_HELPINFO()
        ON_BN_CLICKED(IDC_OPEN_CONTROL, OnChange)
        ON_BN_CLICKED(IDC_OPEN_ADDR_DEC, OnChange)
        ON_BN_CLICKED(IDC_OPEN_ALLOW_MODS, OnChange)
        ON_BN_CLICKED(IDC_OPEN_INSERT, OnChange)
        ON_BN_CLICKED(IDC_OPEN_OVERTYPE, OnChange)
        ON_BN_CLICKED(IDC_OPEN_READONLY, OnChange)
        ON_BN_CLICKED(IDC_OPEN_MAX, OnChange)
        ON_BN_CLICKED(IDC_OPEN_OEM, OnChange)
        ON_BN_CLICKED(IDC_OPEN_FONT, OnOpenFont)
        ON_BN_CLICKED(IDC_OPEN_GRAPHIC, OnChangeGraphic)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDefaultsPage message handlers

BOOL CDefaultsPage::OnInitDialog() 
{
    CPropertyPage::OnInitDialog();

    int state = 1;                      // Current enabled state of control
    CButton *bb;                        // Pointer to button control
    CWnd *ww;                           // Pointer to affected controls

    // See if control is checked
    bb = (CButton *)GetDlgItem(IDC_OPEN_DISPLAY_CHAR);
    ASSERT(bb != NULL);
    if (bb != NULL)
        state = bb->GetCheck();

    // Disable other controls if not displaying char area
    ww = GetDlgItem(IDC_OPEN_EBCDIC);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);
    ww = GetDlgItem(IDC_OPEN_CONTROL);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);
    ww = GetDlgItem(IDC_OPEN_GRAPHIC);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);
    ww = GetDlgItem(IDC_OPEN_OEM);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);

    if (state != 0)
    {
        // Displaying char area so do more checks
        bb = (CButton *)GetDlgItem(IDC_OPEN_EBCDIC);
        ASSERT(bb != NULL);
        if (bb != NULL)
            state = bb->GetCheck();

        // Disable other controls if EBCDIC checked
        ww = GetDlgItem(IDC_OPEN_CONTROL);
        ASSERT(ww != NULL);
        if (ww != NULL) ww->EnableWindow(state == 0);
        ww = GetDlgItem(IDC_OPEN_GRAPHIC);
        ASSERT(ww != NULL);
        if (ww != NULL) ww->EnableWindow(state == 0);
        ww = GetDlgItem(IDC_OPEN_OEM);
        ASSERT(ww != NULL);
        if (ww != NULL) ww->EnableWindow(state == 0);

        if (state == 0)
        {
            // Not displaying EBCDIC so do more checks
            bb = (CButton *)GetDlgItem(IDC_OPEN_GRAPHIC);
            ASSERT(bb != NULL);
            if (bb != NULL)
                state = bb->GetCheck();

            ww = GetDlgItem(IDC_OPEN_OEM);
            ASSERT(ww != NULL);
            if (ww != NULL) ww->EnableWindow(state != 0);
        }
    }

    return TRUE;
}

void CDefaultsPage::OnOK() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    ASSERT_VALID(aa);
    aa->set_defaults();

    CPropertyPage::OnOK();
}

BOOL CDefaultsPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
//      return CPropertyPage::OnHelpInfo(pHelpInfo);
    static DWORD id_pairs[] = { 
        IDC_OPEN_MAX, HIDC_OPEN_MAX,
        IDC_OPEN_AUTOFIT, HIDC_OPEN_AUTOFIT,
        IDC_OPEN_ADDR_DEC, HIDC_OPEN_ADDR_DEC,
        IDC_OPEN_DISPLAY_CHAR, HIDC_OPEN_DISPLAY_CHAR,
        IDC_OPEN_EBCDIC, HIDC_OPEN_EBCDIC,
        IDC_OPEN_CONTROL, HIDC_OPEN_CONTROL,
        IDC_OPEN_GRAPHIC, HIDC_OPEN_GRAPHIC,
        IDC_OPEN_OEM, HIDC_OPEN_OEM,

        IDC_OPEN_READONLY, HIDC_OPEN_READONLY,
        IDC_OPEN_ALLOW_MODS, HIDC_OPEN_ALLOW_MODS,
        IDC_OPEN_OVERTYPE, HIDC_OPEN_OVERTYPE,
        IDC_OPEN_INSERT, HIDC_OPEN_INSERT,
        IDC_OPEN_FONT, HIDC_OPEN_FONT,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}

void CDefaultsPage::OnOpenFont() 
{
    UpdateData();

    LOGFONT logfont;
    if (open_display_char_ && !open_ebcdic_ && open_graphic_ && open_oem_)
    {
        if (open_oem_plf_ == NULL)
        {
            open_oem_plf_ = new LOGFONT;
            memset((void *)open_oem_plf_, '\0', sizeof(*open_oem_plf_));
            _tcscpy(open_oem_plf_->lfFaceName, _T("Terminal"));
            open_oem_plf_->lfCharSet = OEM_CHARSET;         // Only allow OEM/IBM character set fonts
            open_oem_plf_->lfHeight = 18;
        }
        logfont = *open_oem_plf_;
    }
    else
    {
        if (open_plf_ == NULL)
        {
            open_plf_ = new LOGFONT;
            memset((void *)open_plf_, '\0', sizeof(*open_plf_));
            _tcscpy(open_plf_->lfFaceName, _T("Courier"));
            open_plf_->lfHeight = 16;
            open_plf_->lfCharSet = ANSI_CHARSET;           // Only allow ANSI character set fonts
        }
        logfont = *open_plf_;
    }
    CFontDialog dlg;
//    dlg.SetWindowText(open_display_char_ && !open_ebcdic_ && open_graphic_ && open_oem_ ?
//                      "Default OEM/IBM window font" : "Default font");
    dlg.m_cf.lpLogFont = &logfont;
    dlg.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT |  CF_SELECTSCRIPT | CF_SHOWHELP;
    dlg.m_cf.Flags &= ~(CF_EFFECTS);              // Disable selection of strikethrough, colours etc
    if (dlg.DoModal() == IDOK)
    {
        dlg.GetCurrentFont(&logfont);

        if (open_display_char_ && !open_ebcdic_ && open_graphic_ && open_oem_)
            *open_oem_plf_ = logfont;
        else
            *open_plf_ = logfont;
    }
	
    SetModified(TRUE);
}

void CDefaultsPage::OnChange() 
{
    SetModified(TRUE);
}

void CDefaultsPage::OnChangedDisplayChar() 
{
    int state = 1;                      // Current enabled state of control
    CButton *bb;                        // Pointer to button control
    CWnd *ww;                           // Pointer to affected controls

    // See if control is checked
    bb = (CButton *)GetDlgItem(IDC_OPEN_DISPLAY_CHAR);
    ASSERT(bb != NULL);
    if (bb != NULL)
        state = bb->GetCheck();

    // Disable other controls if not checked
    ww = GetDlgItem(IDC_OPEN_EBCDIC);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);
    ww = GetDlgItem(IDC_OPEN_CONTROL);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);
    ww = GetDlgItem(IDC_OPEN_GRAPHIC);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);
    ww = GetDlgItem(IDC_OPEN_OEM);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);

    if (state != 0)
    {
        bb = (CButton *)GetDlgItem(IDC_OPEN_EBCDIC);
        ASSERT(bb != NULL);
        if (bb != NULL)
            state = bb->GetCheck();

        // Disable other controls if not checked
        ww = GetDlgItem(IDC_OPEN_CONTROL);
        ASSERT(ww != NULL);
        if (ww != NULL) ww->EnableWindow(state == 0);
        ww = GetDlgItem(IDC_OPEN_GRAPHIC);
        ASSERT(ww != NULL);
        if (ww != NULL) ww->EnableWindow(state == 0);
        ww = GetDlgItem(IDC_OPEN_OEM);
        ASSERT(ww != NULL);
        if (ww != NULL) ww->EnableWindow(state == 0);

        if (state == 0)
        {
            // Not displaying EBCDIC so do more checks
            bb = (CButton *)GetDlgItem(IDC_OPEN_GRAPHIC);
            ASSERT(bb != NULL);
            if (bb != NULL)
                state = bb->GetCheck();

            ww = GetDlgItem(IDC_OPEN_OEM);
            ASSERT(ww != NULL);
            if (ww != NULL) ww->EnableWindow(state != 0);
        }
    }

    SetModified(TRUE);
}

void CDefaultsPage::OnChangeEbcdic() 
{
    int state = 1;                      // Current enabled state of control
    CButton *bb;                        // Pointer to button control
    CWnd *ww;                           // Pointer to affected controls

    // See if control is checked
    bb = (CButton *)GetDlgItem(IDC_OPEN_EBCDIC);
    ASSERT(bb != NULL);
    if (bb != NULL)
        state = bb->GetCheck();

    // Disable other controls if not checked
    ww = GetDlgItem(IDC_OPEN_CONTROL);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);
    ww = GetDlgItem(IDC_OPEN_GRAPHIC);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);
    ww = GetDlgItem(IDC_OPEN_OEM);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state == 0);

    if (state == 0)
    {
        // Not displaying EBCDIC so do more checks
        bb = (CButton *)GetDlgItem(IDC_OPEN_GRAPHIC);
        ASSERT(bb != NULL);
        if (bb != NULL)
            state = bb->GetCheck();

        ww = GetDlgItem(IDC_OPEN_OEM);
        ASSERT(ww != NULL);
        if (ww != NULL) ww->EnableWindow(state != 0);
    }

    SetModified(TRUE);
}

void CDefaultsPage::OnChangeGraphic() 
{
    int state = 1;                      // Current enabled state of control
    CButton *bb;                        // Pointer to button control
    CWnd *ww;                           // Pointer to affected controls
	
    bb = (CButton *)GetDlgItem(IDC_OPEN_GRAPHIC);
    ASSERT(bb != NULL);
    if (bb != NULL)
        state = bb->GetCheck();

    ww = GetDlgItem(IDC_OPEN_OEM);
    ASSERT(ww != NULL);
    if (ww != NULL) ww->EnableWindow(state != 0);

    SetModified(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// CColourList - allow selection of a colour from a drop list combobox

CColourList::CColourList()
{
}

CColourList::~CColourList()
{
}


BEGIN_MESSAGE_MAP(CColourList, CComboBox)
        //{{AFX_MSG_MAP(CColourList)
                // NOTE - the ClassWizard will add and remove mapping macros here.
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColourList message handlers
void CColourList::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
    CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
    COLORREF colour = (COLORREF)lpDrawItemStruct->itemData;

    if (lpDrawItemStruct->itemAction & ODA_DRAWENTIRE)
    {
        CBrush brush(colour);
        pDC->FillRect(&lpDrawItemStruct->rcItem, &brush);
    }
    
    if ((lpDrawItemStruct->itemState & ODS_SELECTED) &&
        (lpDrawItemStruct->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
    {
        // Draw selected item
        COLORREF sel;           // Some sort of contrasting colour
//        sel = 0xFFFFFF - colour;
        // Just use black or white depending on the intensity of colour
        if (GetRValue(colour) + GetGValue(colour) + GetBValue(colour) > 384)
            sel = 0;            // black
        else
            sel = 0xFFFFFF;     // white

        CBrush brush(sel);
        pDC->FrameRect(&lpDrawItemStruct->rcItem, &brush);
    }
    else if (!(lpDrawItemStruct->itemState & ODS_SELECTED) &&
             (lpDrawItemStruct->itemAction & ODA_SELECT))
    {
        // Draw item that was deselected
        CBrush brush(colour);
        pDC->FrameRect(&lpDrawItemStruct->rcItem, &brush);
    }
}

// Compare 2 combo box elements for sorting (returns -1, 0 or 1)
int CColourList::CompareItem(LPCOMPAREITEMSTRUCT lpCompareItemStruct) 
{
    COLORREF col1 = (COLORREF)lpCompareItemStruct->itemData1;
    COLORREF col2 = (COLORREF)lpCompareItemStruct->itemData2;
    
    // Sort by intensity
    int intensity1 = GetRValue(col1) + GetGValue(col1) + GetBValue(col1);
    int intensity2 = GetRValue(col2) + GetGValue(col2) + GetBValue(col2);
    if (intensity1 < intensity2)
        return -1;
    else if (intensity1 > intensity2)
        return 1;
    
    // .. then by colour for equal intensities
    return (GetBValue(col1) > GetBValue(col2) ||
            GetGValue(col1) > GetGValue(col2) ||
            GetRValue(col1) > GetRValue(col2)) ? -1 : 1;
}

void CColourList::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct) 
{
    lpMeasureItemStruct->itemHeight = 14;
}
/////////////////////////////////////////////////////////////////////////////
// CPartitionsPage property page

IMPLEMENT_DYNCREATE(CPartitionsPage, CPropertyPage)

CPartitionsPage::CPartitionsPage() // : CPropertyPage(CPartitionsPage::IDD)
{
        //{{AFX_DATA_INIT(CPartitionsPage)
                // NOTE: the ClassWizard will add member initialization here
        //}}AFX_DATA_INIT
}

CPartitionsPage::~CPartitionsPage()
{
}

void CPartitionsPage::DoDataExchange(CDataExchange* pDX)
{
        CPropertyPage::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CPartitionsPage)
                // NOTE: the ClassWizard will add DDX and DDV calls here
        //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPartitionsPage, CPropertyPage)
        //{{AFX_MSG_MAP(CPartitionsPage)
        ON_BN_CLICKED(IDC_ADD, OnAdd)
        ON_BN_CLICKED(IDC_REMOVE, OnRemove)
        ON_BN_CLICKED(IDC_RESET, OnReset)
        ON_EN_CHANGE(IDC_CURRENT, OnChangeCurrent)
        ON_LBN_SELCHANGE(IDC_NAMES, OnSelchangeNames)
        ON_EN_CHANGE(IDC_RANGES, OnChangeRanges)
        ON_CBN_SELENDOK(IDC_COLOUR, OnSelendokColour)
        ON_BN_CLICKED(IDC_DEFAULT, OnSaveAsDefault)
        ON_BN_CLICKED(IDC_DOWN, OnDown)
        ON_BN_CLICKED(IDC_UP, OnUp)
        ON_WM_HELPINFO()
	ON_BN_DOUBLECLICKED(IDC_UP, OnUp)
	ON_BN_DOUBLECLICKED(IDC_DOWN, OnDown)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPartitionsPage message handlers

BOOL CPartitionsPage::OnInitDialog() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    change_range_ = true;

    CPropertyPage::OnInitDialog();

    if (aa->is_us_)
    {
        ASSERT(GetDlgItem(IDC_DESC_COLOUR) != NULL);
#ifdef _DEBUG
        CString ss;
        GetDlgItem(IDC_DESC_COLOUR)->GetWindowText(ss);
        ASSERT(ss == "Colour:");
#endif
        GetDlgItem(IDC_DESC_COLOUR)->SetWindowText("Color:");
    }

    // Subclass drop list control so we can draw the colours in its items
    if (!list_colours_.SubclassDlgItem(IDC_COLOUR, this))
    {
        TRACE0("Failed to get colours combo box\n");
        ASSERT(0);
        return TRUE;
    }

    // Add the range names to IDC_NAMES
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    plist->ResetContent();
    for (std::vector<partn>::iterator pp = partitions_.begin(); pp != partitions_.end(); ++pp)
    {
        plist->AddString((*pp).name);
    }

    // Init the bitmap buttons
    if (!bb_up_.SubclassDlgItem(IDC_UP, this) ||
        !bb_down_.SubclassDlgItem(IDC_DOWN, this))
    {
        TRACE0("Failed to get up/down bitmap buttons\n");
        ASSERT(0);
        return TRUE;
    }
    bb_up_.LoadBitmaps(IDB_UPU, IDB_UPD, 0, IDB_UPX);
    bb_down_.LoadBitmaps(IDB_DOWNU, IDB_DOWND, 0, IDB_DOWNX);

    // Add some colours to IDC_COLOUR
    list_colours_.ResetContent();
    for (int red = 0; red <= 255; red += (red == 128) ? 127 : 128)
        for (int green = 0; green <= 255; green += (green == 128) ? 127 : 128)
            for (int blue = 0; blue <= 255; blue += (blue == 128) ? 127 : 128)
                if (red + green + blue < 384)     // Don't add light colours
                    list_colours_.AddString((LPCTSTR) RGB(red, green, blue));

    return TRUE;
}

void CPartitionsPage::OnOK() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    (void)aa->set_partitions();

    CPropertyPage::OnOK();
}

BOOL CPartitionsPage::OnHelpInfo(HELPINFO* pHelpInfo) 
{
//      return CPropertyPage::OnHelpInfo(pHelpInfo);
    static DWORD id_pairs[] = { 
        IDC_CURRENT, HIDC_CURRENT,
        IDC_NAMES, HIDC_NAMES,
        IDC_DESC_COLOUR, HIDC_COLOUR,
        IDC_COLOUR, HIDC_COLOUR,
        IDC_RANGES, HIDC_RANGES,
        IDC_UP, HIDC_UP,
        IDC_DOWN, HIDC_DOWN,
        IDC_ADD, HIDC_ADD,
        IDC_REMOVE, HIDC_REMOVE,
        IDC_RESET, HIDC_RESET,
        IDC_DEFAULT, HIDC_DEFAULT,
        0,0 
    }; 
 
    CWinApp* pApp = AfxGetApp();
    ASSERT_VALID(pApp);
    ASSERT(pApp->m_pszHelpFilePath != NULL);

    CWaitCursor wait;

    if (!::WinHelp((HWND)pHelpInfo->hItemHandle, pApp->m_pszHelpFilePath, HELP_WM_HELP, (DWORD) (LPSTR) id_pairs))
        ::HMessageBox(AFX_IDP_FAILED_TO_LAUNCH_HELP);
    return TRUE;
}

void CPartitionsPage::OnUp() 
{
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    int current = plist->GetCurSel();
    ASSERT(current > 0 && current < partitions_.size());

    // Move the entry in the partitions_ vector up one position
    partn v = partitions_[current];                            // Save it
    partitions_.erase(partitions_.begin() + current);             // Delete it
    partitions_.insert(partitions_.begin() + current - 1, v);     // Add at new posn

    // Move the corresponding entry in the IDC_NAMES list
    plist->DeleteString(current);
    plist->InsertString(current - 1, v.name);
    plist->SetCurSel(current - 1);      // Set selection on same elt at new posn

    check_buttons();
}

void CPartitionsPage::OnDown() 
{
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    int current = plist->GetCurSel();
    ASSERT(current >= 0 && current < partitions_.size() - 1);

    // Move the entry in the partitions_ vector down one position
    partn v = partitions_[current];                            // Save it
    partitions_.erase(partitions_.begin() + current);             // Delete it
    partitions_.insert(partitions_.begin() + current + 1, v);     // Add at new posn

    // Move the corresponding entry in the IDC_NAMES list
    plist->DeleteString(current);
    plist->InsertString(current + 1, v.name);
    plist->SetCurSel(current + 1);      // Set selection on same elt at new posn

    check_buttons();
}

void CPartitionsPage::OnAdd() 
{
    // Get the name from the control
    CString ss;
    CEdit *pedit = (CEdit *)GetDlgItem(IDC_CURRENT);
    ASSERT(pedit != NULL);
    pedit->GetWindowText(ss);

    // Add new one to the beginning of the vector
    partitions_.insert(partitions_.begin(), partn(ss, 0));
    SetModified(TRUE);

    // Add to the start of names list and select it
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    plist->InsertString(0, ss);
    plist->SetCurSel(0);

    // Get the currently selected colour and add to vector
    int index = list_colours_.GetCurSel();
    if (index != CB_ERR)
    {
        COLORREF colour = (COLORREF)list_colours_.GetItemData(index);

        if (colour != CB_ERR)
            partitions_[0].col = colour;
    }
    else
    {
        // No colour currently selected: select the default (black)
        list_colours_.SetCurSel(0);
    }

    // Convert the current range string and add to vector
    pedit = (CEdit *)GetDlgItem(IDC_RANGES);
    ASSERT(pedit != NULL);
    pedit->GetWindowText(ss);
    std::istringstream strstr((const char *)ss);
    strstr >> partitions_[0].range;

    // Enable Remove/Up/Down buttons but disable Add button
    check_buttons();
    CButton *pbutton = (CButton *)GetDlgItem(IDC_ADD);
    ASSERT(pbutton != NULL);
    pbutton->EnableWindow(FALSE);
}

void CPartitionsPage::OnRemove() 
{
    // Get the current selection
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    int current = plist->GetCurSel();

    if (current != LB_ERR)
    {
        // Remove the item from the list box and corresponding vector element
        ASSERT(current >= 0 && current < partitions_.size());
        plist->DeleteString(current);
        partitions_.erase(partitions_.begin() + current);
        SetModified(TRUE);
    }

    // Disable the Remove button and enable the Add button
    CButton *pbutton = (CButton *)GetDlgItem(IDC_REMOVE);
    ASSERT(pbutton != NULL);
    pbutton->EnableWindow(FALSE);
    pbutton = (CButton *)GetDlgItem(IDC_ADD);
    ASSERT(pbutton != NULL);
    pbutton->EnableWindow(TRUE);

    // Disable the up and down buttons
    bb_up_.EnableWindow(FALSE);
    bb_down_.EnableWindow(FALSE);
}

void CPartitionsPage::OnReset() 
{
    // xxx why is this called after hitting Cancel??? (No effect since nothing saved)

    // Set up the default colours in the vector
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());
    partitions_ = aa->default_partitions_;
    SetModified(TRUE);

    // Add the names for the default ranges to the names list
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    plist->ResetContent();
    for (std::vector<partn>::iterator pp = partitions_.begin(); pp != partitions_.end(); ++pp)
        plist->AddString((*pp).name);

    // Disable the Remove button
    CButton *pbutton = (CButton *)GetDlgItem(IDC_REMOVE);
    ASSERT(pbutton != NULL);
    pbutton->EnableWindow(FALSE);

    // Disable the up and down buttons
    bb_up_.EnableWindow(FALSE);
    bb_down_.EnableWindow(FALSE);

    // Deselect any selection in the names list
    plist->SetCurSel(-1);

    // Blank the name in IDC_CURRENT
    CEdit *pedit = (CEdit *)GetDlgItem(IDC_CURRENT);
    ASSERT(pedit != NULL);
    pedit->SetWindowText("");
    pedit->SetFocus();

    // Deselect any colour and disable the drop list
    list_colours_.SetCurSel(-1);
    list_colours_.EnableWindow(FALSE);

    // Blank the range string and disable it
    pedit = (CEdit *)GetDlgItem(IDC_RANGES);
    ASSERT(pedit != NULL);
    change_range_ = true;
    pedit->SetWindowText("");
    change_range_ = false;
    pedit->EnableWindow(FALSE);
}

void CPartitionsPage::OnSaveAsDefault() 
{
    CHexEditApp *aa = dynamic_cast<CHexEditApp *>(AfxGetApp());

    // Save to registry/INI file
    int ii = 1;
    for (std::vector<partn>::iterator pp = partitions_.begin(); pp != partitions_.end(); ++pp, ++ii)
    {
        CString f1, f2, f3;
        f1.Format("Name%d", ii);
        f2.Format("Colour%d", ii);
        f3.Format("Range%d", ii);
        aa->SetColours("DefaultColours", f1, f2, f3, (*pp));
    }

    // Make these the in memory default colours
    aa->open_partitions_ = partitions_;
}

void CPartitionsPage::OnChangeCurrent() 
{
    bool disable = false;               // Disable adding to list
    CString ss;
    CEdit *pedit = (CEdit *)GetDlgItem(IDC_CURRENT);
    ASSERT(pedit != NULL);
    pedit->GetWindowText(ss);

    // Check if we need to disable adding
    if (ss.IsEmpty())
        disable = true;                     // Disbale for empty current name
    else
    {
        // But also disable if current name is already in the names list
        for (std::vector<partn>::iterator pp = partitions_.begin(); pp != partitions_.end(); ++pp)
            if (ss.CompareNoCase((*pp).name) == 0)
                disable = true;
    }

    // Disable colour/range control if no name here and no selection in list
    // since we can't set these for an existing range or one to be added
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    CEdit *prange = (CEdit *)GetDlgItem(IDC_RANGES);
    ASSERT(prange != NULL);
    prange->EnableWindow(TRUE);
    list_colours_.EnableWindow(TRUE);
    if (disable && plist->GetCurSel() == LB_ERR)
    {
//        change_range_ = true;
//        prange->SetWindowText("");
//        change_range_ = false;
        prange->EnableWindow(FALSE);
//        list_colours_.SetCurSel(-1);
        list_colours_.EnableWindow(FALSE);
    }
    else if (!disable)
    {
        // Changes are for the name to be added so remove any selection in
        // the names list so that we don't change an existing range as well
        plist->SetCurSel(-1);

        // Since there is no exitsing name now selected: disable the
        // Remove, Up and Down buttons
        CButton *pbutton = (CButton *)GetDlgItem(IDC_REMOVE);
        ASSERT(pbutton != NULL);
        pbutton->EnableWindow(FALSE);
        bb_up_.EnableWindow(FALSE);
        bb_down_.EnableWindow(FALSE);
    }

    // Disable the "Add" button if there is no current name
    CButton *pbutton = (CButton *)GetDlgItem(IDC_ADD);
    ASSERT(pbutton != NULL);
    pbutton->EnableWindow(!disable);
}

void CPartitionsPage::OnSelchangeNames() 
{
    // Enable Remove/Up/Down buttons
    check_buttons();

    // Get the colour and find it in the colour drop list
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    int current = plist->GetCurSel();
    ASSERT(current >= 0 && current < partitions_.size());

    list_colours_.EnableWindow(TRUE);
    int last = list_colours_.GetCount();
    for (int ii = 0; ii < last; ++ii)
    {
        if ((COLORREF)list_colours_.GetItemData(ii) == partitions_[current].col)
            break;  // found
    }

    if (ii == last)
    {
        // Colour not found in the list so add it
        list_colours_.AddString((LPCTSTR)partitions_[current].col);
        ++last;

        // Re-search list since it is automatically sorted
        for (ii = 0; ii < last; ++ii)
        {
            if ((COLORREF)list_colours_.GetItemData(ii) == partitions_[current].col)
                break;  // found
        }
        ASSERT(ii < last); // It must be there now!
    }

    // Select this colour
    list_colours_.SetCurSel(ii);

    // Get the range as a string and display in IDC_RANGES
    std::ostringstream strstr;
    strstr << partitions_[current].range;

    // Convert std::stringstream to std::string to C string to MFC CString
    const CString ss = (const char *)strstr.str().c_str();

    CEdit *pedit = (CEdit *)GetDlgItem(IDC_RANGES);
    ASSERT(pedit != NULL);
    pedit->EnableWindow(TRUE);
    change_range_ = true;
    pedit->SetWindowText(ss);
    change_range_ = false;

    // Display the name in IDC_CURRENT
    pedit = (CEdit *)GetDlgItem(IDC_CURRENT);
    ASSERT(pedit != NULL);
    pedit->SetWindowText(partitions_[current].name);
}

// Check which buttons have to be enabled or disabled
void CPartitionsPage::check_buttons()
{
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);

    // Disable the up/down buttons at/bottom of list
    bb_up_.EnableWindow(plist->GetCurSel() > 0);
    bb_down_.EnableWindow(plist->GetCurSel() < plist->GetCount()-1);

    // Enable the Remove button if there is a selection
    CButton *pbutton;
    pbutton = (CButton *)GetDlgItem(IDC_REMOVE);
    ASSERT(pbutton != NULL);
    int current = plist->GetCurSel();
    pbutton->EnableWindow(current != LB_ERR);
}

void CPartitionsPage::OnSelendokColour() 
{
    int index = list_colours_.GetCurSel();
    if (index != CB_ERR)
    {
        COLORREF colour = (COLORREF)list_colours_.GetItemData(index);

        if (colour != CB_ERR)
        {
            // Get the current names selection
            CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
            ASSERT(plist != NULL);
            int current = plist->GetCurSel();

            if (current != LB_ERR)
            {
                // Set the colour for this element
                ASSERT(current < partitions_.size());
                partitions_[current].col = colour;
                SetModified(TRUE);
            }
        }
    }
}

void CPartitionsPage::OnChangeRanges() 
{
    // Get the new range string
    CString ss;
    CEdit *pedit = (CEdit *)GetDlgItem(IDC_RANGES);
    ASSERT(pedit != NULL);
    pedit->GetWindowText(ss);

    // Get the current names selection
    CListBox *plist = (CListBox *)GetDlgItem(IDC_NAMES);
    ASSERT(plist != NULL);
    int current = plist->GetCurSel();

    // If the user change the range string and there is a name selected
    if (!change_range_ && current != LB_ERR)
    {
        // Set the range for this element
        ASSERT(current < partitions_.size());
        std::istringstream strstr((const char *)ss);
        strstr >> partitions_[current].range;
        SetModified(TRUE);
    }
}


