#define STRICT
#define NOTREEVIEW
#define NOIMAGEAPIS
#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include <commctrl.h>
#define MAX_STRING_LEN 33

UINT CALLBACK        FRHookProc1(HWND, UINT, WPARAM, LPARAM);
UINT CALLBACK        FRHookProc2(HWND, UINT, WPARAM, LPARAM);
UINT CALLBACK        Edt1SubclassProc(HWND, UINT, WPARAM, LPARAM);
void                 SetXCaret (void);
void                 ScrollandCaretPos(void);

WNDPROC              wpOrigEdt1Proc;
HWND                 hwndEdt1;
char                 szFind[MAX_STRING_LEN], szGoTo[MAX_STRING_LEN],
                     szAsciiLo[MAX_STRING_LEN], szAsciiUp[MAX_STRING_LEN];
extern HWND          hDlgModeless, hwndChild;
extern unsigned char *c;
extern int           iFileLength, iVscrollPos, cyClient, cxClient, cyChar, cxChar, xCaret, yCaret;
extern char          szHelpFile[_MAX_PATH+_MAX_FNAME+_MAX_EXT];
FINDREPLACE          fr;
int                  iOffset, iFindPos, offset, t1=-1, t2;
BOOL                 bFind=FALSE;
HINSTANCE            hexiwin;
LPHELPINFO           lphi;

HWND HexFindDlg (HWND hwnd)
     {
     fr.lStructSize      = sizeof (fr);
     fr.hwndOwner        = hwnd;
     fr.hInstance        = hexiwin;
     fr.Flags            = FR_ENABLEHOOK | FR_ENABLETEMPLATE;
     fr.lpstrFindWhat    = szFind;
     fr.lpstrReplaceWith = NULL;
     fr.wFindWhatLen     = sizeof (szFind);
     fr.wReplaceWithLen  = 0;
     fr.lCustData        = 0;
     fr.lpfnHook         = FRHookProc1;
     fr.lpTemplateName   = "FIND";
     
     return FindText (&fr);
     }

HWND HexGoToDlg (HWND hwnd)
     {
     fr.lStructSize      = sizeof (fr);
     fr.hwndOwner        = hwnd;
     fr.hInstance        = hexiwin;
     fr.Flags            = FR_ENABLEHOOK | FR_ENABLETEMPLATE;
     fr.lpstrFindWhat    = szGoTo;
     fr.lpstrReplaceWith = NULL;
     fr.wFindWhatLen     = sizeof (szGoTo);
     fr.wReplaceWithLen  = 0;
     fr.lCustData        = 0;
     fr.lpfnHook         = FRHookProc2;
     fr.lpTemplateName   = "GOTO";

     return FindText (&fr);
     }

UINT CALLBACK FRHookProc1(HWND hDlgModeless, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message)
   {
   case WM_INITDIALOG:
        SendDlgItemMessage(hDlgModeless, 1152, EM_SETSEL, 0, -1);
        SendDlgItemMessage(hDlgModeless, 1152, EM_SETLIMITTEXT, 32, 0L);
        CheckRadioButton(hDlgModeless, 1056, 1057, 1057);
        CheckRadioButton(hDlgModeless, 1018, 1019, 1018);
     //   SendDlgItemMessage(hDlgModeless, 1152, WM_SETTEXT, 0, 0);
        ShowWindow(GetDlgItem(hDlgModeless, 1041), SW_HIDE);
        hwndEdt1 = GetDlgItem(hDlgModeless, edt1);
        wpOrigEdt1Proc = (WNDPROC) SetWindowLong(hwndEdt1,
        GWL_WNDPROC, (LONG) Edt1SubclassProc);
        break;
   case WM_HELP:
        lphi = (LPHELPINFO) lParam;
        if (lphi->iCtrlId == 1017 || lphi->iCtrlId == 1018 || lphi->iCtrlId == 1019) {
            WinHelp(hDlgModeless, szHelpFile, HELP_CONTEXTPOPUP, 1);
        }
        if (lphi->iCtrlId == 1152 || lphi->iCtrlId == 1151) {
            WinHelp(hDlgModeless, szHelpFile, HELP_CONTEXTPOPUP, 2);
        }
       if (lphi->iCtrlId == IDOK) {
            WinHelp(hDlgModeless, szHelpFile, HELP_CONTEXTPOPUP, 3);
        }
        if (lphi->iCtrlId == 1041) {
            WinHelp(hDlgModeless, szHelpFile, HELP_CONTEXTPOPUP, 7);
        }
        break;
   case WM_COMMAND:
        switch (HIWORD (wParam))
        {
        case BN_SETFOCUS:
             if (LOWORD (wParam) == 1018 && IsDlgButtonChecked(hDlgModeless, 1018) == BST_UNCHECKED){
               SendDlgItemMessage(hDlgModeless, 1152, EM_SETLIMITTEXT, 32, 0L);
               ShowWindow(GetDlgItem(hDlgModeless, 1041), SW_HIDE);
               SendDlgItemMessage(hDlgModeless, 1152, WM_SETTEXT, 0, 0);
             }
             if (LOWORD (wParam) == 1019 && IsDlgButtonChecked(hDlgModeless, 1019) == BST_UNCHECKED) {
               SendDlgItemMessage(hDlgModeless, 1152, EM_SETLIMITTEXT, 20, 0L);
               ShowWindow(GetDlgItem(hDlgModeless, 1041), SW_SHOW);
               SendDlgItemMessage(hDlgModeless, 1152, WM_SETTEXT, 0, 0);
             }
        break;
        case BN_CLICKED:
             if (LOWORD (wParam) == 1) { InvalidateRect(hDlgModeless, NULL, FALSE); }
        break;
        }
   break;
   }
return 0;
}

UINT CALLBACK FRHookProc2(HWND hDlgModeless, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message)
   {
   case WM_INITDIALOG:
        SendDlgItemMessage(hDlgModeless, 1152, EM_SETSEL, 0, -1);
        SendDlgItemMessage(hDlgModeless, 1152, EM_SETLIMITTEXT, 8, 0L);
        CheckRadioButton(hDlgModeless, 1021, 1022, 1021);
     //   SendDlgItemMessage(hDlgModeless, 1152, WM_SETTEXT, 0, 0);
        hwndEdt1 = GetDlgItem(hDlgModeless, edt1);
        wpOrigEdt1Proc = (WNDPROC) SetWindowLong(hwndEdt1,
        GWL_WNDPROC, (LONG) Edt1SubclassProc);
        break;

   case WM_HELP:
        lphi = (LPHELPINFO) lParam;
        if (lphi->iCtrlId == 1020 || lphi->iCtrlId == 1021 || lphi->iCtrlId == 1022) {
            WinHelp(hDlgModeless, szHelpFile, HELP_CONTEXTPOPUP, 4);
        }
        if (lphi->iCtrlId == 1152 || lphi->iCtrlId == 1151){
            WinHelp(hDlgModeless, szHelpFile, HELP_CONTEXTPOPUP, 5);
        }
        if (lphi->iCtrlId == IDOK){
            WinHelp(hDlgModeless, szHelpFile, HELP_CONTEXTPOPUP, 6);
        }
        break;

   case WM_COMMAND:
        switch (HIWORD (wParam))
        {
        case BN_SETFOCUS:
             if (LOWORD (wParam) == 1021 && IsDlgButtonChecked(hDlgModeless, 1021) == BST_UNCHECKED){
               SendDlgItemMessage(hDlgModeless, 1152, EM_SETLIMITTEXT, 8, 0L);
               SendDlgItemMessage(hDlgModeless, 1152, WM_SETTEXT, 0, 0);
             }
             if (LOWORD (wParam) == 1022 && IsDlgButtonChecked(hDlgModeless, 1022) == BST_UNCHECKED) {
               SendDlgItemMessage(hDlgModeless, 1152, EM_SETLIMITTEXT, 10, 0L);
               SendDlgItemMessage(hDlgModeless, 1152, WM_SETTEXT, 0, 0);
             }
        break;
        case BN_CLICKED:
             if (LOWORD (wParam) == 1) { InvalidateRect(hDlgModeless, NULL, FALSE); }
        break;
        }
   }
return FALSE;
}
UINT CALLBACK Edt1SubclassProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{

if (IsDlgButtonChecked(hDlgModeless, 1018) == BST_CHECKED ||
    IsDlgButtonChecked(hDlgModeless, 1021) == BST_CHECKED) {
   if (message == WM_GETDLGCODE) { return DLGC_WANTCHARS | DLGC_WANTARROWS; }
   switch (message)
   {
   case WM_CHAR:
        if (!((wParam >= 'a' && wParam <= 'f') || (wParam >= '0' && wParam <= '9')
         	|| (wParam >= 'A' && wParam <= 'F') || (wParam == VK_BACK))) {
        MessageBeep(0);
        return 0;
        }
        break;
   }
}

if (IsDlgButtonChecked(hDlgModeless, 1019) == BST_CHECKED) {
	if (message == WM_GETDLGCODE) { return DLGC_WANTCHARS | DLGC_WANTARROWS; }
   switch (message)
   {
   case WM_CHAR:
   break;
   }
}

if (IsDlgButtonChecked(hDlgModeless, 1022) == BST_CHECKED) {
	if (message == WM_GETDLGCODE) { return DLGC_WANTCHARS | DLGC_WANTARROWS; }
   switch (message)
   {
   case WM_CHAR:
        if (!((wParam >= '0' && wParam <= '9') || (wParam == VK_BACK))) {
        MessageBeep(0);
        return 0;
        }
   break;
   }
}
return CallWindowProc((WNDPROC) wpOrigEdt1Proc, hwnd, message, wParam, lParam);
} 

BOOL FindHexValue (HWND hwnd, LPFINDREPLACE lpfr)
{
int         a[16], b=0, b2=0, d, iSize;
extern char szAppName[];
char        szConvertHexString[3], *endptr;

   for (d=0;d<=lstrlen(szFind);d+=2) {
       szConvertHexString[b2]=szFind[d];
       szConvertHexString[b2+1]=szFind[d+1];
       a[b] = strtol(szConvertHexString, &endptr, 16);
       b++;
   }

   if (lstrlen(szFind)%2 != 0) {
       MessageBox (NULL, "Hexidecimal value must be even number of digits!",
       szAppName, MB_OK | MB_ICONEXCLAMATION | MB_TASKMODAL);
   return TRUE;
   }

   if (IsDlgButtonChecked(hDlgModeless, 1057) == BST_CHECKED) { t2=1; }
   if (IsDlgButtonChecked(hDlgModeless, 1056) == BST_CHECKED) { t2=-1; }
   iOffset=lstrlen(szFind)/2;
   iSize=lstrlen(szFind);

   for ( ; ; ) {
       t1+=t2;
     if (t1 < 0 || t1 > iFileLength-iOffset) { t1=iFindPos; return FALSE; }
     if (c[t1] == a[0]) {
       if (iSize == 2) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+1] == a[1]) {
       if (iSize == 4) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+2] == a[2]) {
       if (iSize == 6) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+3] == a[3]) {
       if (iSize == 8) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+4] == a[4]) {
       if (iSize == 10) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+5] == a[5]) {
       if (iSize == 12) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+6] == a[6]) {
       if (iSize == 14) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+7] == a[7]) {
       if (iSize == 16) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+8] == a[8]) {
       if (iSize == 18) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+9] == a[9]) {
       if (iSize == 20) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+10] == a[10]) {
       if (iSize == 22) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+11] == a[11]) {
       if (iSize == 24) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+12] == a[12]) {
       if (iSize == 26) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+13] == a[13]) {
       if (iSize == 28) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+14] == a[14]) {
       if (iSize == 30) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+15] == a[15]) {
       if (iSize == 32) { ScrollandCaretPos(); return TRUE; }
     } } } } } } } } } } } } } } } }
   }
}

void ScrollandCaretPos(void)
{
extern char lpszSbIoffset[17];
extern int  xCaretCount;
extern HWND hStatusWindow;

  bFind=TRUE;
  if ((t1/16) > iVscrollPos + (cyClient/cyChar)) {
    if (t1/16 > (iFileLength/16)-(cyClient/cyChar)) {
      if (iFileLength%16 != 0) { iVscrollPos=(iFileLength/16)-((cyClient/cyChar)-2); }
      if (iFileLength%16 == 0) { iVscrollPos=(iFileLength/16)-((cyClient/cyChar)-1); }
      yCaret=(t1/16)-iVscrollPos;
      InvalidateRect(hwndChild, NULL, TRUE);
    } else { iVscrollPos=t1/16; yCaret=(t1/16)-iVscrollPos; }
  } else { yCaret=(t1/16)-iVscrollPos; }
  if (iVscrollPos > t1/16) { iVscrollPos=t1/16; yCaret=(t1/16)-iVscrollPos; }
      SetXCaret();
      SetCaretPos (xCaret * cxChar, yCaret * cyChar);
      iFindPos=t1;
      wsprintf(lpszSbIoffset, "Offset: %08X", (xCaretCount-1)+
      (yCaret*16)+(iVscrollPos*16));
      SendMessage (hStatusWindow, SB_SETTEXT, 1 | 0, (LPARAM) lpszSbIoffset);
      InvalidateRect(hwndChild, NULL, FALSE);
      UpdateWindow(hwndChild);
      SendMessage (hwndChild, WM_SIZE, 0, 0);
      return;
}

void SetXCaret (void)
{

extern int xCaretCount;

   if (IsDlgButtonChecked(hDlgModeless, 1018) == BST_CHECKED ||
       IsDlgButtonChecked(hDlgModeless, 1021) == BST_CHECKED ||
       IsDlgButtonChecked(hDlgModeless, 1022) == BST_CHECKED) {
       
     xCaretCount=(t1%16)+1;
     if (t1%16 == 0) { xCaret=10; }
     if (t1%16 == 1) { xCaret=12; }
     if (t1%16 == 2) { xCaret=15; }
     if (t1%16 == 3) { xCaret=17; }
     if (t1%16 == 4) { xCaret=20; }
     if (t1%16 == 5) { xCaret=22; }
     if (t1%16 == 6) { xCaret=25; }
     if (t1%16 == 7) { xCaret=27; }
     if (t1%16 == 8) { xCaret=30; }
     if (t1%16 == 9) { xCaret=32; }
     if (t1%16 == 10) { xCaret=35; }
     if (t1%16 == 11) { xCaret=37; }
     if (t1%16 == 12) { xCaret=40; }
     if (t1%16 == 13) { xCaret=42; }
     if (t1%16 == 14) { xCaret=45; }
     if (t1%16 == 15) { xCaret=47; }
   }

   if (IsDlgButtonChecked(hDlgModeless, 1019) == BST_CHECKED) {
      xCaret=(t1%16)+50;
      xCaretCount=(t1%16)+1;
   }
return;
}

BOOL FindAsciiValue (HWND hwnd, LPFINDREPLACE lpfr)
{

   if (IsDlgButtonChecked(hDlgModeless, 1057) == BST_CHECKED) { t2=1; }
   if (IsDlgButtonChecked(hDlgModeless, 1056) == BST_CHECKED) { t2=-1; }
   iOffset=lstrlen(szFind);
   lstrcpy(szAsciiLo, szFind);
   lstrcpy(szAsciiUp, szFind);
   if (IsDlgButtonChecked(hDlgModeless, 1041) == BST_UNCHECKED) {
       CharUpper(szAsciiUp);
       CharLower(szAsciiLo);
   }

   for ( ; ; ) {
       t1+=t2;

     if (t1 < 0 || t1 > iFileLength-iOffset) { t1=iFindPos; return FALSE; }
     if (c[t1] == szAsciiLo[0] || c[t1] == szAsciiUp[0]) {
       if (iOffset == 1) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+1] == szAsciiLo[1] || c[t1+1] == szAsciiUp[1]) {
       if (iOffset == 2) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+2] == szAsciiLo[2] || c[t1+2] == szAsciiUp[2]) {
       if (iOffset == 3) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+3] == szAsciiLo[3] || c[t1+3] == szAsciiUp[3]) {
       if (iOffset == 4) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+4] == szAsciiLo[4] || c[t1+4] == szAsciiUp[4]) {
       if (iOffset == 5) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+5] == szAsciiLo[5] || c[t1+5] == szAsciiUp[5]) {
       if (iOffset == 6) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+6] == szAsciiLo[6] || c[t1+6] == szAsciiUp[6]) {
       if (iOffset == 7) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+7] == szAsciiLo[7] || c[t1+7] == szAsciiUp[7]) {
       if (iOffset == 8) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+8] == szAsciiLo[8] || c[t1+8] == szAsciiUp[8]) {
       if (iOffset == 9) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+9] == szAsciiLo[9] || c[t1+9] == szAsciiUp[9]) {
       if (iOffset == 10) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+10] == szAsciiLo[10] || c[t1+10] == szAsciiUp[10]) {
       if (iOffset == 11) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+11] == szAsciiLo[11] || c[t1+11] == szAsciiUp[11]) {
       if (iOffset == 12) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+12] == szAsciiLo[12] || c[t1+12] == szAsciiUp[12]) {
       if (iOffset == 13) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+13] == szAsciiLo[13] || c[t1+13] == szAsciiUp[13]) {
       if (iOffset == 14) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+14] == szAsciiLo[14] || c[t1+14] == szAsciiUp[14]) {
       if (iOffset == 15) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+15] == szAsciiLo[15] || c[t1+15] == szAsciiUp[15]) {
       if (iOffset == 16) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+16] == szAsciiLo[16] || c[t1+16] == szAsciiUp[16]) {
       if (iOffset == 17) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+17] == szAsciiLo[17] || c[t1+17] == szAsciiUp[17]) {
       if (iOffset == 18) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+18] == szAsciiLo[18] || c[t1+18] == szAsciiUp[18]) {
       if (iOffset == 19) { ScrollandCaretPos(); return TRUE; }
     if (c[t1+19] == szAsciiLo[19] || c[t1+19] == szAsciiUp[19]) {
       if (iOffset == 20) { ScrollandCaretPos(); return TRUE; }
     } } } } } } } } } } } } } } } } } } } }
   }
}

BOOL GotoOffset (HWND hwnd, LPFINDREPLACE lpfr)
{
int         a=0;
extern char szAppName[];
char        *endptr;

  if (IsDlgButtonChecked(hDlgModeless, 1021) == BST_CHECKED) {
      a = strtol(szGoTo, &endptr, 16);
  }
  if (IsDlgButtonChecked(hDlgModeless, 1022) == BST_CHECKED) {
      a = strtol(szGoTo, &endptr, 10);
  }
  if (a < iFileLength) { t1 = a; iFindPos=a; iOffset=1; ScrollandCaretPos(); return TRUE; }

return FALSE;
}
