'
'   Goto next line which different between current and next file
'   Start compare beyond current line positions
'   Mark the line that is different in the first file
'
Function GotoDiff

  nr1   = pe32.Lines                    ' Get lines and current line in File1
  row1  = pe32.Row

  pe32.Command "e"                      ' File2

  nr2   = pe32.Lines                    ' Get lines and current line in File12
  row2  = pe32.Row

  pe32.Command "e -"                    ' File1

  nrmin = nr1 - row1                    ' Get shortest remaining length
  If nr2 - row2 < nrmin Then
    nrmin = nr2 - row2
  End If

  pe32.Command "[unmark]"               ' Clear last mark

  '   Search current line up to first end of file
  For i=1 To nrmin

    str1=pe32.GetLine(i + row1)

    pe32.Command "e"                    ' File2

    str2=pe32.GetLine(i + row2)

    pe32.Command "e -"                  ' File1

    If str1 <> str2 Then
      Call Set_Row(i + row1)            ' Move File1

      pe32.Command "e"                  ' File2

      Call Set_Row(i + row2)            ' Move File2

      pe32.Command "e -"                ' File1

      pe32.Command "[mark line]"        ' Mark File1 and exit
      Exit For
    End If

  Next

End Function


'
'   Visual flash 2 files
'   (Wait switch back to prior file, wait)
'
'   First argument is amount to wait, second is number of times to flash
'
Function Flash (Wait_Time, Num_Flash)

  If Wait_Time <= 0 Then
    Wait_Time = 100000                    ' Default wait counter
  End If

  If Num_Flash <= 0 Then
    Num_Flash = 1                         ' Set > 1 for multiple flash
  End If

  For k=1 To Num_Flash-1

'   pe32.Command "[wait &Wait_Time&]"
    For i=1 To Wait_Time
      j=j+1
    Next

    pe32.Command "e -"

'   pe32.Command "[wait &Wait_Time&]"
    For i=1 To Wait_Time
      j=j+1
    Next

    pe32.Command "e"

  Next

' pe32.Command "[wait &Wait_Time&]"
  For i=1 To Wait_Time
    j=j+1
  Next

  pe32.Command "e -"

' pe32.Command "[wait &Wait_Time&]"
  For i=1 To Wait_Time
    j=j+1
  Next

End Function


'
'   Visual flash compare 2 files
'
'   Cursor movement keys scroll both files
'      PgUp, PgDn, Home, End, Left, Right
'
'   Esc exits compare
'
'   + goes to next difference
'
'   Ins scrolls first file up   (it has less lines)
'   Del scrolls first file down (it has more lines)
'
'   Shift cursor keys just move File1       (NOT implemented)
'   Ctrl  cursor keys just move File2       (NOT implemented)
'   Alt   cursor keys scroll in both files  (NOT implemented)
'
Function Compare

' wait_time=250                         ' Milleseconds to wait
  wait_time=50000                       ' Burn counter:  adjust for your
                                        '     computers speed
  num_flash=5

  exitloop=0
  Do

    key=pe32.Key                        ' Get command

    Select Case key
      Case 27                           ' Esc
        exitloop=1

      Case &H2200                       ' PgDn
        pe32.Command "[page down]"
        pe32.Command "e"
        pe32.Command "[page down]"
        Call Flash(wait_time, num_flash)

      Case &H2100                       ' PgUp
        pe32.Command "[page up]"
        pe32.Command "e"
        pe32.Command "[page up]"
        Call Flash(wait_time, num_flash)

      Case &H2600                       ' Up
        pe32.Command "[scrolldown]"
        pe32.Command "e"
        pe32.Command "[scrolldown]"
        Call Flash(wait_time, num_flash)

      Case &H2800                       ' Dn
        pe32.Command "[scrollup]"
        pe32.Command "e"
        pe32.Command "[scrollup]"
        Call Flash(wait_time, num_flash)

      Case &H2500                       ' Left
        pe32.Command "[left]"
        pe32.Command "e"
        pe32.Command "[left]"
        Call Flash(wait_time, num_flash)

      Case &H2700                       ' Right
        pe32.Command "[right]"
        pe32.Command "e"
        pe32.Command "[right]"
        Call Flash(wait_time, num_flash)

      Case &H2300                       ' End  Bottom of files
        pe32.Command "[bottom]"
        pe32.Command "[begin line]"
        pe32.Command "e"
        pe32.Command "[bottom]"
        pe32.Command "[begin line]"
        Call Flash(wait_time, num_flash)

      Case &H2D00                       ' Ins  First file has less lines
        pe32.Command "[scrollup]"
        pe32.Command "e"
        Call Flash(wait_time, num_flash)

      Case &H2E00                       ' Del  First file has more lines
        pe32.Command "[scrolldown]"
        pe32.Command "e"
        Call Flash(wait_time, num_flash)

      Case &H2400                       ' Home Top of files
        pe32.Command "[top]"
        pe32.Command "[begin line]"
        pe32.Command "e"
        pe32.Command "[top]"
        pe32.Command "[begin line]"
        Call Flash(wait_time, num_flash)

      Case &H6B00,43                    ' +
        pe32.Command "[ve GotoDiff][unmark]"

      Case Else
        pe32.Command "e"                ' Flash toggle files
        Call Flash(wait_time, num_flash)

    End Select

  Loop Until exitloop=1                 ' Repeat loop

End Function


'
'   Capture key code for next keystroke as text (preceded by a blank).
'   Will overwrite current cursor position (or insert at current position
'       if in insert mode).
'
Function KeyCode

  key         = pe32.Key                ' Get next keystroke
  pe32.Insert = " "&key&""              ' Insert as text

End Function


'
'   Parse C error line
'   Pick off filename (and line number if it exists)
'      and open that file (at that line number).
'
Function GotoErr

  Dim regEx, Matches, Match
  Set regEx = New RegExp                ' Use regular expression
  regEx.IgnoreCase = True
  regEx.Global = False

  str=pe32.Line                         ' Line with Filename(line) etc. on it

  '   Find start of line number
  regEx.Pattern = "\("                  ' Set pattern
  Set Matches = regEx.Execute(str)      ' Execute search

  If Matches.count > 0 Then
    For each Match in Matches
      Exit For
    Next

    file = Left(str, Match.FirstIndex)  ' Extract Filename
    pos = Match.FirstIndex+2

    '   Find end of line number
    regEx.Pattern = "\)"
    Set Matches = regEx.Execute(str)

    row = "1"
    If Matches.count > 0 Then
      For each Match in Matches
        Exit For
      Next
      row = Mid(str, pos, Match.FirstIndex) ' Extract line number
    End If
  Else
    file = str                          ' No line number assume just Filename
    row = "1"                           '   at top of file
  End If

  pe32.Command "e " & Chr(34) & file & Chr(34) ' Edit filename
  pe32.Command "line "+row              '   at line number

End Function


'
'   Comment out (with block comments) a single word
'
Function RemWord

  pe32.Word = "/* "+pe32.Word+" */"

End Function


'
'   Comment out (add // rem to start of line) all of file
'   Do not double comment lines
'
Function RemAll

  For i=1 To pe32.Lines

    str=pe32.GetLine(i)

    If Left( str, 7 ) <> "// rem " Then
      str="// rem "+str
      pe32.SetLine str, i               ' Add comment
    End If

  Next

End Function


'
'   Comment out (add // rem to start of line) marked lines
'   Do not double comment lines
'
Function RemMark

  For i=1 To pe32.MarkedLines

    str=pe32.GetMarkedLine(i)

    If Left( str, 7 ) <> "// rem " Then
      str="// rem "+str
      pe32.SetMarkedLine str, i
    End If

  Next

End Function


'
'   From current position until matching C block depth
'      comment out (add // rem to start of line) all source lines.
'
'   Note:  Will comment all leading lines before first block mark ({).
'
Function RemFun

  Dim regEx, Matches
  Set regEx = New RegExp                ' Use regular expression
  regEx.IgnoreCase = True               ' Set ignore case
  regEx.Global = True                   ' Set global search

  brace=0
  exitloop=0

  '  Loop over block (or until EOF)
  Do                                    ' Loop until end

    str=pe32.Line                       ' Get pe32 current line

    '   Increment count for blocks opened
    regEx.Pattern = "{"                 ' Set pattern
    Set Matches = regEx.Execute(str)    ' Execute search
    brace=brace+Matches.count           ' Count braces

    ' Decrement count for blocks closed
    regEx.Pattern = "}"                 ' Set pattern
    Set Matches = regEx.Execute(str)    ' Execute search
    brace=brace-Matches.count           ' Count braces

    ' Comment the line
    str="// rem "+str                   ' Add a C remark
    pe32.Line=str                       ' Set current pe32 line
    newrow=pe32.Row+1                   ' Increment row

    ' Exit if EOF
    If newrow>pe32.Lines Then           ' If eof exit
      exitloop=1
    End If

    ' Exit at matching depth
    If brace=0 and Matches.count>0 Then ' If End Function exit
      exitloop=1
    End If

    Call Set_Row(newrow)                ' Set new row

  Loop Until exitloop=1                 ' Repeat loop

End Function


'
'   Search for all occurrences of current word and try to align them
'      Note:  will use cursor position to align (even if not at start of word)
'
Function Align_Word


  Dim regEx, Matches
  Set regEx = New RegExp                ' Use regular expressions
  regEx.IgnoreCase = False
  regEx.Global = False


  ' Get state
  str1  = pe32.Word                     ' Get current word
  row1  = pe32.Row                      '  and position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  For i=1 To lines1                     ' Loop over rest of lines in file

    pe32.Row = pe32.Row + 1             ' Get next line
    str      = pe32.Line

    ' Find match
    regEx.Pattern = str1                ' Set pattern
    Set Matches   = regEx.Execute(str)  ' Execute search

    If Matches.count > 0 Then           ' If found

      For each Match in Matches         ' Load match information
        Exit For
      Next

      find1    = Match.FirstIndex+1     ' Goto that column
      Call Set_Col(find1)

      If find1 < col1 Then              ' Before alignment word?

        ' Add blanks
        For j=1 To col1-find1

          pe32.Insert = " "             ' Align word

        Next

      ElseIf find1 > col1 Then          ' After alignment word?


        ' Count deletable blanks
        For j=find1-1 To col1 step -1

          char = Mid(str, j, 1)         ' Extract j'th character

          If char <> " " Then
           Exit For
          End If

        Next

        ' Remove deletable blanks
        pe32.Line = Left(str, j) & Mid(str, find1)

      End If

    End If

  Next                                  ' Repeat loop

  ' Restore state
  Call Set_Row_Col(row1, col1)          ' Restore position
  pe32.InsertMode = mode1               '  and mode

End Function


'
'   For jagged columns:  align blank / non-blank transition at cursor (columns
'      past column being aligned are shifted in unison).
'
'   Align column to cursor:  if over text add blanks Else remove blanks
'
'   Apply to rest of file if no marked lines Else apply to rest of mark
'
Function Align_Col


  ' Get state
  row1  = pe32.Row                      ' Position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  ' Restrict loop to marked lines
  If pe32.MarkedLines > 0 Then

    pe32.Command "[begin mark]"         ' Goto start of mark
    row2 = pe32.Row

    If (row2 < row1) Then row2 = row1   ' Use lower of row1 and row2

    pe32.Command "[end mark]"           ' Goto end of mark
    lines1 = pe32.Row - row2            ' Shorten loop to end of mark

    Call Set_Row(row2)                  ' Restore start position

  End If

  ' Loop over current and rest of lines
  For i=1 To lines1+1                   ' Loop over rest of lines in file

    str = pe32.Line

    char = Mid(str, col1-1, 1)          ' Extract align character

    If char = " " Then

      ' Count deletable blanks
      For j=col1 To Len(str)

        char = Mid(str, j, 1)           ' Extract j'th character

        If char <> " " Then
          Exit For
        End If

      Next

      ' Remove deletable blanks
      pe32.Line = Left(str, col1-1) & Mid(str, j)
    Else

      ' Count blanks to insert
      For j=col1-1 To 1 step -1

        char = Mid(str, j, 1)           ' Extract j'th character

        If char = " " Then
          Exit For
        End If

      Next

      ' Add blanks
      Call Set_Col(j)

      For k=1 To col1-j-1

        pe32.Insert = " "               ' Align word

      Next

    End If

    pe32.Row = pe32.Row + 1             ' Get next line
  Next                                  ' Repeat loop

  ' Restore state
  Call Set_Row_Col(row1, col1)          ' Restore position
  pe32.InsertMode = mode1               '  and mode

End Function


'
'   Place cursor a left edge of field to be left justified.
'   Blanks under the cursor will be moved beyond the following word.
'
'   Apply to rest of file if no marked lines Else apply to rest of mark
'
Function Left_Justify


  ' Get state
  row1  = pe32.Row                      ' Position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  ' Restrict loop to marked lines
  If pe32.MarkedLines > 0 Then

    pe32.Command "[begin mark]"         ' Goto start of mark
    row2 = pe32.Row

    If (row2 < row1) Then row2 = row1   ' Use lower of row1 and row2

    pe32.Command "[end mark]"           ' Goto end of mark
    lines1 = pe32.Row - row2            ' Shorten loop to end of mark

    Call Set_Row(row2)                  ' Restore start position

  End If

  ' Loop over current and rest of lines
  For i=1 To lines1+1                   ' Loop over rest of lines in file

    str = pe32.Line

    char = Mid(str, col1-1, 1)          ' Extract align character

    If char = " " Then

      ' Count moveable blanks
      For j=col1 To Len(str)

        char = Mid(str, j, 1)           ' Extract j'th character

        If char <> " " Then
          Exit For
        End If

      Next

      ' Find end of next word
      For k=j+1 To Len(str)

        char = Mid(str, k, 1)           ' Extract k'th character

        If char = " " Then
          Exit For
        End If

      Next

      ' Move blanks
      '            Before column       next word          blanks moved
      pe32.Line = Left(str,col1-1) + Mid(str,j,k-j) + Mid(str,col1,j-col1) + _
                  Mid(str,k)            ' rest
    End If

    pe32.Row = pe32.Row + 1             ' Get next line
  Next                                  ' Repeat loop

  ' Restore state
  Call Set_Row_Col(row1, col1)          ' Restore position
  pe32.InsertMode = mode1               '  and mode

End Function


'
'   Place cursor a right edge of field to be right justified.
'   Blanks under the cursor will be moved before the preceding word.
'
'   Apply to rest of file if no marked lines Else apply to rest of mark
'
Function Right_Justify


  ' Get state
  row1  = pe32.Row                      ' Position
  col1  = pe32.Col
  mode1 = pe32.InsertMode               '  and mode

  pe32.InsertMode = 1                   ' Set to insert

  lines1 = pe32.Lines - row1            ' Get lines and current line in File1

  ' Restrict loop to marked lines
  If pe32.MarkedLines > 0 Then

    pe32.Command "[begin mark]"         ' Goto start of mark
    row2 = pe32.Row

    If (row2 < row1) Then row2 = row1   ' Use lower of row1 and row2

    pe32.Command "[end mark]"           ' Goto end of mark
    lines1 = pe32.Row - row2            ' Shorten loop to end of mark

    Call Set_Row(row2)                  ' Restore start position

  End If

  ' Loop over current and rest of lines
  For i=1 To lines1+1                   ' Loop over rest of lines in file

    str = pe32.Line

    If col1 > Len(str) Then

      ' Count moveable blanks
      For j=Len(str) To 1 Step -1

        char = Mid(str, j, 1)           ' Extract j'th character

        If char <> " " Then
          Exit For
        End If

      Next

      ' Find end of next word
      For k=j-1 To 1 step -1

        char = Mid(str, k, 1)           ' Extract k'th character

        If char = " " Then
          Exit For
        End If

      Next

      ' Insert blanks
      Call Set_Col(k-1)

      For l=1 To col1-j

        pe32.Insert = " "               ' Align word

      Next
    Else
      char = Mid(str, col1+1, 1)        ' Extract align character

      If char = " " Then

        ' Count moveable blanks
        For j=col1 To 1 Step -1

          char = Mid(str, j, 1)         ' Extract j'th character

          If char <> " " Then
            Exit For
          End If

        Next

        ' Find end of next word
        For k=j-1 To 1 Step -1

          char = Mid(str, k, 1)         ' Extract k'th character

          If char = " " Then
            Exit For
          End If

        Next

        ' Move blanks
        '           Before word      blanks moved          prior word
        pe32.Line = Left(str,k) + Mid(str,j+1,col1-j) + Mid(str,k+1,j-k) + _
                    Mid(str,col1+1)     ' rest
      End If
    End If

    pe32.Row = pe32.Row + 1             ' Get next line
  Next                                  ' Repeat loop

  ' Restore state
  Call Set_Row_Col(row1, col1)          ' Restore position
  pe32.InsertMode = mode1               '  and mode

End Function


'
'   Execute a FILE of PE32 and/or VBS commands
'   Each line is a sequence of commands
'
'   Unless a line starts with $ it is assumed to be a set of PE32 commands
'
'   Special commands that start with $:
'       $VBScript VBS-command(s)
'       $ExitIf   VBS-expression
'
'   Special commands that start with $ that control execution of following line:
'       $While    VBS-expression
'       $If       VBS-expression
'       $IfNot    VBS-expression
'       $Repeat   VBS-expression
'
'       This allows one line blocks (multiple commands on a line) and avoids
'          all complications with block marks and nesting.
'
'   Special commands that start with $ that set flags for all PE32 lines:
'       $Global                         ' Repeat each line on all files
'       $EndGlobal
'       $Demo     VBS-expression        ' Zero implies wait for keystroke <>
'                                       '     escape
'                                       ' Else wait time in seconds
'       $EndDemo                        ' Same as $Demo negative
'
'   Line continuation ("\") is supported on PE32 lines.
'
'   This allows unlimited length command sequences with complete documentation
'       and limited control flow.
'
'   Example:
'   [ve Ex_Commands("EditTask.cmd")]
'
Function Ex_Commands (FileSpec)

Dim FSO, TextStream, Command, FullCommand, Special, Rest
Dim LCSpecial, WhileText, StartFile, ThisFile, FileCount

Set FSO = CreateObject("Scripting.FileSystemObject") ' Setup to read

' If empty filename is passed Then use Default.cmd
If FileSpec = "" Then
  FileSpec = "Default.cmd"
End If

' Verify that passed file exists
If (FSO.FileExists(FileSpec)) Then

  ' Open passed filename
  Set TextStream = FSO.OpenTextFile(FileSpec, 1) ' Open filename to read

  IsGlobal    = FALSE                            ' Off
  DemoSpeed   = -1                               ' Off
  RepeatCount = 1                                ' Off
  WhileText   = ""                               ' Off

  Do While Not TextStream.AtEndOfStream
    Command = TextStream.ReadLine                ' Get next command

    '
    ' Process the line form the passed file
    '
    If Left(Command, 1) = "$" Then

      ' Remove keyword
      For j=2 To Len(Command)

        If Mid(Command, j, 1) = " " Then         ' Check j'th character
          Exit For
        End If
      Next

      Special = Mid (Command, 2, j-2)            ' Extract special command
      Rest    = Mid (Command, j)                 ' Extract any argument

      LCSpecial = LCase (Special)
      '
      ' Parse special control extensions
      '
      Select Case LCSpecial
        Case "vbscript"
          ExecuteGlobal (Rest)                   ' Execute rest (assume VBScript)

        Case "exitif"
          If Eval(Rest) Then Exit Function

        Case "while"
          WhileText   = Rest                     ' Save condition
          RepeatCount = 1                        ' Only one of While and Repeat

        Case "if"
          If Not Eval(Rest) Then
            If TextStream.AtEndOfStream Then Exit Function
            Command = TextStream.ReadLine        ' Toss next line
          End If

        Case "ifnot"
          If Eval(Rest) Then
            If TextStream.AtEndOfStream Then Exit Function
            Command = TextStream.ReadLine        ' Toss next line
          End If

        Case "repeat"
          RepeatCount = Eval(Rest)
          WhileText   = ""                       ' Only one of While and Repeat

        Case "global"
          IsGlobal = TRUE

        Case "endglobal"
          IsGlobal = FALSE

        Case "demo"
           DemoSpeed = Eval (Rest)               ' Save time

           If DemoSpeed > 10 Then                ' Not too big
             DemoSpeed = 10
           End If

        Case "enddemo"
           DemoSpeed = -1                        ' Off

        Case Else
          Answer = MsgBox ("Unknown command: $"+Special+Rest, vbOKCancel)
          If Answer=2 Then Exit Function

      End Select
    Else
      '
      ' Support line continuation
      '
      FullCommand = ""

      Do While Right (Command, 1) = "\" and Not TextStream.AtEndOfStream

        '
        ' Strip lines that start with comment and end with continuation
        ' pe32.Command can not process imbedded comments without error message
        '
        If Left (Command, 2) <> "[*" Then
            FullCommand = FullCommand & Left (Command, Len(Command)-1)
        End If

        Command = TextStream.ReadLine            ' Continue to next line

      Loop

      FullCommand = FullCommand & Command        ' Add part of line without
                                                 '     continuation
      '
      ' Handle any debug requests
      '
      If DemoSpeed = 0 Then
        If FullCommand <> "" And Left(FullCommand, 1) <> "*" Then ' Not dummy
          Answer = MsgBox ("Step "&RepeatCount&": "+FullCommand, vbOKCancel)
          If Answer=2 Then Exit Function
        End If
      End If

      '
      ' If requested, slow it down (badly)
      '
      If DemoSpeed > 0 Then
        If FullCommand <> "" And Left(FullCommand, 1) <> "*" Then ' Not dummy
          StartTime = Timer
          Do
            Elapsed = Timer - StartTime
          Loop Until Elapsed > DemoSpeed
        End If
      End If

      '
      ' Remember on which file we started (and start with next one)
      '
      If IsGlobal Then
         StartFile    = pe32.Filename            ' For global
         pe32.Command "e"                        ' Start with second file
         FileCount    = 0
      End If

      Do_loop = IsGlobal                         ' Save looping status

      '
      ' Loop over files
      '
      Do
        ThisFile = pe32.Filename                 ' Copy current filename
                                                 '     (incase released)
        If WhileText <> "" Then
          '
          ' Handle While condition
          '
          Do While Eval (WhileText)
            pe32.Command FullCommand             ' Execute the PE32 command(s)
          Loop
        Else
          '
          ' Handle repeat looping
          '
          If RepeatCount <= 0 Then               ' Validate step counter
            RepeatCount = 1
          End If

          For Ex_Loop = 1 To RepeatCount         ' Support repeat
            pe32.Command FullCommand             ' Execute the PE32 command(s)
          Next
        End If

        '
        ' Handle Global looping and termination
        '
        If IsGlobal Then
          '
          ' Warning:  Due to current PE32 ring ordering this is not failsafe
          '           A new file can be opened and closed resulting in a new
          '           current file and a possible infinite loop.
          '           Also if more files are opened than closed we may never
          '           get back to the first file.
          '
          If StartFile = ThisFile Then           ' Back to original file?
            Do_loop = FALSE                      ' If yes Then stop
          Else
            pe32.Command "e"                     ' Next global file
            FileCount    = FileCount+1           ' Failsafe
          End If
        End If

      ' Exit when processed first file
      Loop Until Do_loop = FALSE Or FileCount > 500

      RepeatCount = 1                            ' Clear count for next command
    End If
  Loop

  TextStream.Close

Else
  MsgBox FileSpec+" does not exist"
End If

End Function


'
'   Save all files where cursor is not at upper left corner
'
'   Designed to save changed files by using side effect that change command
'   moves the cursor.
'
Function Save_Changed

Dim FirstFile

  FirstFile = pe32.Filename                 ' Loop control
  '
  ' Loop over files
  '
  Do
    If pe32.Row+pe32.Col <> 2 Then          ' At top left corner?
      pe32.Command "save"                   ' Save the file
    End If

  pe32.Command "e"                        ' Next file

Loop Until pe32.Filename = FirstFile      ' Exit when back to first file

End Function


'
'   Move cursor to beginning of line on all files
'
Function Home_All

    Call Prompt_Global( "[bl]" )

End Function


'
'   Move cursor to end of line on all files
'
Function End_All

    Call Prompt_Global( "[el]" )

End Function


'
'   Save all files
'
Function Save_All

    Call Prompt_Global( "save" )

End Function

'
'   Prompt for a string of PE32 commands and Then execute it on all open files
'
'   Examples: [ve Prompt_Global] "save" is equivalent to [ve Save_All]
'             [ve Prompt_Global] "[bl]" is equivalent to [ve Home_All]
'             [ve Prompt_Global] "[el]" is equivalent to [ve End_All]
'             [ve Prompt_Global] "[bl][top]" sets up Save_All to work properly
'                                            until true file status is available
'
Function Prompt_Global (Commands)

Dim FirstFile
Dim CommandString

  FirstFile = pe32.Filename                 ' Loop control

  '
  '   Get input from operator
  '
  '   ** Can %@input be used through pe32.Command ??? how?    **
  '   ** Can %@set be used to make it forget its prior value  **
  '   ** Can   so that the macro will work twice?             **
  '
  If Commands = "" Then
      CommandString = Inputbox ("Enter Global Command String", "PE32", "")

      '
      ' ** The following does not work as hoped                              **
      ' ** How can I get focus back to DOS window ???                        **
      ' ** In Win98 user must hit enter or manually task switch back to PE32 **
      '
      pe32.Command "[redraw]"                   ' Force screen back
  Else
      CommandString = Commands
  End If

  If CommandString <> "" Then
      '
      ' Loop over files
      '
      Do
        pe32.Command CommandString          ' Do specified operation
        pe32.Command "e"                    ' Next file

      Loop Until pe32.Filename = FirstFile  ' Exit when back to first file
  End If

End Function

'
' Open current file in read only mode ... try to position near current position
'
Function Read_Only

  ' Get state
  row1 = pe32.Row                           ' Position
  col1 = pe32.Col

  pe32.Command "view " & Chr(34) & pe32.Filename & Chr(34) ' View current file

  ' Position in same place in read only version
  Call Set_Row_Col(row1, col1)          ' Restore position

End Function

'
'   Compute Kwd file index
'
Function Kwd (Extension)

  lcExt = LCase (Extension)

  Select Case lcExt

    Case "cxx","cpp","c","inl","hxx","hpp","h","tlh","tli"
      Kwd = 0

    Case "htm","html"
      Kwd = 1

    Case "asm","equ"
      Kwd = 2

    Case "bat","btm","cmd"
      Kwd = 3

    Case "pro"
      Kwd = 4

    Case "vbs"
      Kwd = 5

    Case Else
      Kwd = 255                           ' Undefined

  End Select

' MsgBox "Kdw of " & Extension & " is " & Kwd

End Function

'
'   Switch file specific settings if necessary
'
'   Set Current file to "" if no previous filename
'
Function New_File (CurrentFile)

Dim CurrentExt
Dim NewExt
Dim NewFile
Dim regEx, Matches, Match

  '
  ' Setup to find extension
  '
  Set regEx = New RegExp                      ' Use regular expression
  regEx.IgnoreCase = True
  regEx.Global = True                         ' Allow more than 1 match

  NewFile = pe32.Filename                     ' Get new name

  regEx.Pattern = "\."                        ' Set pattern: the character .
                                              '   not . any character

  ' Look for extension on current file
  Set Matches = regEx.Execute(CurrentFile)    ' Execute search

' MsgBox "Current file=" & CurrentFile & " Matches.count " & Matches.count

  ' If found save extension on current file
  If Matches.count > 0 Then
    ' Get last match
    For each Match in Matches
      LastIndex = Match.FirstIndex            ' Save match position
    Next

    ' Extract extension
    CurrentExt = Right(CurrentFile, Len(CurrentFile)-LastIndex-1)
'   MsgBox "LastIndex " & LastIndex & " CurrentExt=" & CurrentExt
  Else
    CurrentExt = ""
  End If

  If CurrentFile = "" Or CurrentFile = NewFile Then
    CurrentIndex=256
  Else
    CurrentIndex = Kwd ( CurrentExt )
  End If

  ' Look for extension on new file
  Set Matches = regEx.Execute(NewFile)        ' Execute search

' MsgBox "NewFile=" & NewFile & " Matches.count " & Matches.count

  ' If found save extension on new file
  If Matches.count > 0 Then
    ' Get last match
    For each Match in Matches
      LastIndex = Match.FirstIndex            ' Save match position
    Next

    NewExt = Right(NewFile, Len(NewFile)-LastIndex-1) ' Extract extension
'   MsgBox "LastIndex " & LastIndex & " NewExt=" & NewExt
  Else
    NewExt=""
  End If

  NewIndex = Kwd ( NewExt )

  '
  ' CurrentIndex and NewIndex are set ... see if there is any work to do
  '
  CurrentIndex = 256                      ' Force different

  If CurrentIndex <> NewIndex Then

'   MsgBox "CurrentIndex=" & CurrentIndex & " NewIndex=" & NewIndex

    Select Case NewIndex

      Case 0              ' "cxx","cpp","c","inl","hxx","hpp","h","tlh","tli"
        pe32.Command "set tabs 5 4"
        pe32.Command "set delimiters \t\n\r [](),'+-*=/\\" & chr(34)

      Case 1              ' "htm","html"
        pe32.Command "set tabs 9 8"
        pe32.Command "set delimiters \t\n\r "

      Case 2              ' "asm","equ"
        pe32.Command "set tabs 1 17 25 43"
        pe32.Command "set delimiters \t\n\r [](){}<>,;:.!?'+-*=/\\" & chr(34)

      Case 3              ' "bat","btm","cmd"
        pe32.Command "set tabs 9 8"
        pe32.Command "set delimiters \t\n\r "

      Case 4              ' "pro"
        pe32.Command "set tabs 9 8"
        pe32.Command "set delimiters \t\n\r [](){}<>,;:.!?'+-*=/\\" & chr(34)

      Case 5              ' "vbs"
        pe32.Command "set tabs 3 2"
        pe32.Command "set delimiters \t\n\r ()<>,.'+-*=/\\" & chr(34)

      Case Else           ' Others
        pe32.Command "set tabs 9 8"
        pe32.Command "set delimiters \t\n\r "

    End Select

  End If

End Function

'
'   Open next file switching file specific setting if necessary
'
Function Next_File

Dim CurrentFile

  CurrentFile = pe32.Filename        ' Get current name
                pe32.Command  "e"    ' Next file

  New_File( CurrentFile )

End Function

'
'   Open last file switching file specific setting if necessary
'
Function Last_File

Dim CurrentFile

  CurrentFile = pe32.Filename        ' Get current name
                pe32.Command "e -"   ' Last file

  New_File( CurrentFile )

End Function

'
'   Set margins to edges of block mark
'
'   Note:  will also do corners (not edges) of character mark ...
'          probably not useful.  Rejects line mark (and some character marks)
'          by rejecting marks one or less characters "wide"
'
Function Set_Margins

  Set_Margins = 0                         ' Set failure

  If pe32.MarkedLines > 0 Then
    CommandT = pe32.CommandMode           ' Save command mode

    row1  = pe32.Row                      ' Save position
    col1  = pe32.Col

    pe32.Command "[begin mark]"           ' Go to top left of block mark

    col2  = pe32.Col                      ' Get left edge of mark

    pe32.Command "[end mark]"             ' Go to lower right of block mark

    col3  = pe32.Col                      ' Get right edge of mark

    Call Set_Row_Col(row1, col1)          ' Restore position

    If col3 - col2 > 1 Then
      '
      ' Set margins left right left       ' No first line indent
      '
      pe32.Command "set margins " & col2 & " " & col3 & " " & col2

      Set_Margins = col3-col2+1           ' Set success (return width >= 2)

      pe32.CommandMode = CommandT         ' Restore command mode
    Else
      MsgBox "Bad margins selected:  " & col2 & " " & col3
    End If

  Else
    MsgBox "Select block mark before Set_Margins"
  End If

End Function

'
' Returns true if String consists of all blanks
'
Function Is_Blanks(String)

  Is_Blanks = True
  '
  ' Loop over characters in String looking for a non-blank one
  '
  For i = 1 to len(String)
    If Mid(String, i, 1) <> " " Then
      Is_Blanks = False                   ' Not all blank
      Exit Function
    End If
  Next

End Function

'
'Fetch line of screen that has cursor (1 = top edge)
'
Function Get_Screen_Line

  CommandT = pe32.CommandMode             ' Save command mode

  pe32.Command "[cursor data]"            ' Goto data

  row1  = pe32.Row                        ' Save position
  col1  = pe32.Col

  pe32.Command "[top edge]"               ' Top of screen

  Get_Screen_Line = row1 - pe32.Row + 1   ' Compute screen line

  Call Set_Row_Col(row1, col1)            ' Restore position

  pe32.CommandMode = CommandT             ' Restore command mode

End Function

'
'Restore cursor to passed line of screen (1 = top edge)
'
Function Set_Screen_Line(Line)

  If (Line >= 1) Then
    CommandT = pe32.CommandMode           ' Save command mode

    pe32.Command "[cursor data]"          ' Goto data

    row1  = pe32.Row                      ' Save position
    col1  = pe32.Col

    pe32.Command "[bottom edge]"          ' Bottom of screen

    row3  = pe32.Row                      ' Save position

    pe32.Command "[top edge]"             ' Top of screen

    row2  = pe32.Row                      ' Save position

    If Line <= row3 - row2 + 1 Then       ' If fits on screen
      Line1 = row1 - row2 + 1             ' Compute screen line

      Call Set_Row_Col(row2 + Line - 1, col1) ' Restore cursor

      If Line1 > Line Then
        pe32.Command "[scrolldown " & Line1-Line & "]" ' Reposition
      End If

      If Line > Line1 Then
        pe32.Command "[scrollup " & Line-Line1 & "]"   ' Reposition
      End If
    Else
      Call Set_Row_Col(row1, col1)        ' Restore position
    End If

    pe32.CommandMode = CommandT           ' Restore command mode
  End If

End Function

'
'   Tab right marked lines by passed number of columns
'   Insist cursor is in mark as a safety measure
'   If no mark or character mark then no action is taken
'
'   If Columns is zero then use length between first two tabs
'
Function Tab_N_Right(Columns)

  Tab_N_Right = 0                         ' Not done

  MType = Mark_Type                       ' Get status of this mark
  CommandT = pe32.CommandMode             ' Save command mode

  If MType > 1 And CommandT = 0 Then      ' If line or block mark in this file
                                          '     and cursor in data
    SLine = Get_Screen_Line               ' Save scroll position

    pe32.Command "[cursor data]"          ' Goto data

    row1  = pe32.Row                      ' Save position
    col1  = pe32.Col

    If Columns = 0 Then
      pe32.Command "[begin line] [tab]"   ' Find first tab column
      col2  = pe32.Col                    ' Get that column

      pe32.Command "[tab]"                ' Find next tab column
      col3  = pe32.Col                    ' Get second tab column

      Columns = col3 - col2               ' Length between columns
    End If

    pe32.Command "[begin mark]"           ' Go to top left of block mark

    row2  = pe32.Row                      ' Get top edge of mark
    col2  = pe32.Col

    pe32.Command "[end mark]"             ' Go to lower right of block mark

    row3  = pe32.Row                      ' Get bottom edge of mark
    col3  = pe32.Col

    ' If Cursor is in the mark
    If row1 >= row2 And row1 <= row3 Then

      If MType = 3 Then
        ' Convert block mark to line mark
        pe32.Command "[unmark] [mark line]" ' Mark the bottom
        Call Set_Row(row2)
        pe32.Command "[mark line]"          ' Mark the top

        ' See if each line can be shortened
        For i=1 To pe32.MarkedLines

          str=pe32.GetMarkedLine(i)

          ' Block mark ... removing from right edge (verify blanks are there)
          str1 = Mid(str, col3 + 1, Columns)

          If Not Is_Blanks(str1) Then
            Tab_N_Right = 2                 ' Not doable
            Exit For
          End If

          pe32.SetMarkedLine str, i
        Next
      End If

      ' Build a string to pad lines with
      Blanks = ""
      For i=1 To Columns
        Blanks = " "+Blanks
      Next

      If Tab_N_Right = 0 Then               ' If doable
        ' Lengthen each line
        For i=1 To pe32.MarkedLines

          str=pe32.GetMarkedLine(i)

          If MType = 2 Then
            ' Was a line mark ... add to beginning of line
            str = Blanks & str
          Else
            ' Was a block mark ... add before left edge
            If Len(str) >= col2 Then
              If Len(str) >= col3 + Columns Then
                str = Left(str, col2-1) & Blanks & _
                      Mid(str, col2, col3 - col2 + 1) & _
                      Right(str, Len(str) - col3 - Columns)
              Else
                str = Left(str, col2-1) & Blanks & _
                      Mid(str, col2, col3 - col2 + 1)
              End If
            End If
          End If

          pe32.SetMarkedLine str, i
        Next
      Else
        Columns    = 0
      End If

      If MType = 3 Then
        ' Convert line mark back to block mark
        Call Set_Row_Col(row3, col3 + Columns)
        pe32.Command "[unmark] [mark block]" ' Mark the bottom

        Call Set_Row_Col(row2, col2 + Columns)
        pe32.Command "[mark block]"          ' Mark the top
      End If

      Tab_N_Right = 1                        ' Done

      ' Replace cursor
      Call Set_Row_Col(row1, col1 + Columns)

      Call Set_Screen_Line(Sline)            ' Restore scroll position
    Else
      Call Set_Row_Col(row1, col1)           ' Restore position
      Call Set_Screen_Line(Sline)            ' Restore scroll position

      pe32.Command "[tab]"
    End If
  Else
    pe32.Command "[tab]"                     ' WHY does this not work when
                                             '     cursor is on command line?
  End If

End Function

'
'   Tab left marked lines by passed number of columns
'   Insist cursor is in mark as a safety measure
'   If no mark or character mark then no action is taken
'
'   If Columns is zero then use length between first two tabs
'
Function Tab_N_Left(Columns)

  Tab_N_Left = 0                          ' Not done

  MType = Mark_Type                       ' Get status of this mark
  CommandT = pe32.CommandMode             ' Save command mode

  If MType > 1 And CommandT = 0 Then      ' If line or block mark in this
                                          '     file and cursor in data
    SLine = Get_Screen_Line               ' Save scroll position

    pe32.Command "[cursor data]"          ' Goto data

    row1  = pe32.Row                      ' Save position
    col1  = pe32.Col

    If Columns = 0 Then
      pe32.Command "[begin line] [tab]"   ' Find first tab column
      col2  = pe32.Col                    ' Get that column

      pe32.Command "[tab]"                ' Find next tab column
      col3  = pe32.Col                    ' Get second tab column

      Columns = col3 - col2               ' Length between columns
    End If

    pe32.Command "[begin mark]"           ' Go to top left of block mark

    row2  = pe32.Row                      ' Get top edge of mark
    col2  = pe32.Col

    pe32.Command "[end mark]"             ' Go to lower right of block mark

    row3  = pe32.Row                      ' Get bottom edge of mark
    col3  = pe32.Col

    ' If Cursor is in the mark
    If row1 >= row2 And row1 <= row3 Then

      If MType = 3 Then
        ' Convert block mark to line mark
        pe32.Command "[unmark] [mark line]" ' Mark the bottom
        Call Set_Row(row2)
        pe32.Command "[mark line]"          ' Mark the top
      End If

      ' See if each line can be shortened
      For i=1 To pe32.MarkedLines

        str=pe32.GetMarkedLine(i)

        If MType = 2 Then
          ' Line mark ... removing from left (verify blanks are there)
          str1 = Left(str, Columns)
        Else
          If col2 <= Columns Then
            Tab_N_Left = 2                  ' Not doable
            Exit For
          End If

          ' Block mark ... removing from left edge (verify blanks are there)
          str1 = Mid(str, col2-Columns, Columns)
        End If

        If Not Is_Blanks(str1) Then
          Tab_N_Left = 2                    ' Not doable
          Exit For
        End If

        pe32.SetMarkedLine str, i
      Next

      If Tab_N_Left = 0 Then                ' If doable
        If MType = 3 Then
          ' Build a string to pad lines with
          Blanks = ""
          For i=1 To Columns
            Blanks = " "+Blanks
          Next
        End If

        ' Shorthen each line
        For i=1 To pe32.MarkedLines

          str=pe32.GetMarkedLine(i)

          If MType = 2 Then
            ' Was a line mark ... remove from left
            If Len(str) >= Columns Then
              str = Right(str, Len(str)-Columns)
            End If
          Else
            ' Was a block mark ... remove from left edge
            If Len(str) >= col2 Then
              If Len(str) >= col3 Then
                str = Left(str, col2 - Columns - 1) & _
                      Mid(str, col2, col3 - col2 + 1) & Blanks & _
                      Right(str, Len(str) - col3)
              Else
                str = Left(str, col2 - Columns - 1) & _
                      Mid(str, col2, col3 - col2 + 1) & Blanks
              End If
            End If
          End If

          pe32.SetMarkedLine str, i
        Next

        Tab_N_Left = 1                     ' Done
      Else
        Columns    = 0
      End If

      If MType = 3 Then
        ' Convert line mark back to block mark
        Call Set_Row_Col(row3, col3 - Columns)
        pe32.Command "[unmark] [mark block]" ' Mark the bottom

        Call Set_Row_Col(row2, col2 - Columns)
        pe32.Command "[mark block]"          ' Mark the top
      End If

      ' Replace cursor
      pe32.Row = row1
      If col1 > Columns Then
        Call Set_Col(col1 - Columns)
      Else
        Call Set_Col(1)
      End If
      Call Set_Screen_Line(Sline)            ' Restore scroll position
    Else
      Call Set_Row_Col(row1, col1)           ' Restore position
      Call Set_Screen_Line(Sline)            ' Restore scroll position

      pe32.Command "[backtab]"
    End If

  Else
    pe32.Command "[backtab]"                 ' WHY does not work when
                                             '     cursor is on command line?
  End If

End Function

'
'   Reflow the area covered by a mark.
'
'   If the area has multiple paragraphs then reflow each separately.
'
'   If Guess_Para is 0 then assumes paragraphs are separated by blank lines
'
'   If Guess_Para is 1 then assumes any line that ends in a "." is also a
'     paragraph (note that this may guess wrong).
'
'   If Guess_Para is 2 then assumes any line that ends in a "." is also a
'     paragraph and adds the missing blank line.
'
Function Reflow_Mult(Guess_Para)

  Reflow_Mult = 0                         ' Set failure

  If pe32.MarkedLines > 0 Then
    CommandT = pe32.CommandMode           ' Save command mode

    row1  = pe32.Row                      ' Save position
    col1  = pe32.Col

    pe32.Command "[begin mark]"           ' Go to top left of block mark

    row2  = pe32.Row                      ' Get top edge of mark

    pe32.Command "[end mark]"             ' Go to lower right of block mark

    row3  = pe32.Row                      ' Get bottom edge of mark

    ' Loop over possible paragraphs
    Do
      pe32.Command "[unmark] [mark line]" ' Mark possible end of paragraph

      flag=2                              ' No end found

      For i=row3 To row2 Step -1
        str=pe32.GetLine(i)               ' Get line

        If str = "" Then
          flag=0                          ' Found separator between paragraphs
          Exit For
        End If

        If Guess_Para > 0 And i < row3 And Right(str,1) = "." Then
          If Guess_Para = 2 Then
            Call Set_Row(i)
            pe32.Command "[il]"           ' Separate paragraphs

            i = i+1
          End If

          flag=1                          ' Found bottom of prior paragraph
          Exit For
        End If

      Next

      ' Found a paragraph
      If flag > 0 Or i < row3 Then        ' If paragraph not just a blank line
        Call Set_Row(i + 1)
        pe32.Command "[mark line] [reflow]" ' Mark start of paragraph
      End If

'     Answer = MsgBox ("Did a paragraph: " & i+1 & " to " & row3 & _
'                      " flag: " & flag, vbOKCancel)
'     If Answer=2 Then Exit Function

      ' Position above paragraph
      If flag = 0 Then
        row3 = i-1
      Else
        row3 = i
      End If

      pe32.Row = row3                     ' Move to bottom of paragraph
    Loop Until flag = 2 Or i <= row2

    pe32.Command "[unmark]"               ' Clear marks

    Call Set_Row_Col(row1, col1)          ' Restore position

    Reflow_Mult = 1                       ' Set success
  End If

End Function

'
'   Check current file for mark type
'
'   Return mark type
'         Return 0 if no mark
'         Return 1 if char  mark
'         Return 2 if line mark
'         Return 3 if block mark
'
'   Add 4 if mark is on command line (not implemented yet)
'
Function Mark_Type

  Mark_Type = 0                           ' Assume no mark

  If pe32.MarkedLines > 0 Then
    CommandT = pe32.CommandMode           ' Save command mode
    SLine    = Get_Screen_Line            ' Save scroll position

    pe32.Command "[cursor data]"          ' Goto data

    row1  = pe32.Row                      ' Save position
    col1  = pe32.Col
    '
    ' Find corners of mark
    '
    pe32.Command "[begin mark]"           ' Go to top left of block mark
                                          '   - forces command data
    row2  = pe32.Row                      ' Get top of mark
    col2  = pe32.Col                      ' Get left edge of mark

    pe32.Command "[end mark]"             ' Go to lower right of block mark

    row3  = pe32.Row                      ' Get bottom of mark
    col3  = pe32.Col                      ' Get right edge of mark

    If col3 < col2 Then
      '
      ' Must be a character mark to have end to left of start
      '
      Mark_Type = 1                       ' Character mark

      Call Set_Row_Col(row1, col1)        ' Restore position

      Call Set_Screen_Line(Sline)         ' Restore scroll position
      pe32.CommandMode = CommandT         ' Restore command mode
      Exit Function
    End If

    pe32.Command "[right] [end mark]"     ' Move off end of mark and try to
                                          '     return to it
    col4  = pe32.Col                      ' Get right edge of mark

    If col3 <> col4 Then
      '
      ' Must be a line mark to have cursor not return to end
      '
      Mark_Type = 2                       ' Line mark

      Call Set_Row_Col(row1, col1)        ' Restore position

      Call Set_Screen_Line(Sline)         ' Restore scroll position
      pe32.CommandMode = CommandT         ' Restore command mode
      Exit Function
    End If

    ' Get marked portion of last marked line
    ' Note that freespace is trimed from end of mark
    str=pe32.GetMarkedLine(pe32.MarkedLines)

    OldLen = Len(str)

    pe32.Command "[end line]"             ' Go to start of freespace

    col5  = pe32.Col                      ' Get end of line to test for freespace

'   MsgBox "Length: " & OldLen & " column: " & col5
    '
    ' If length of mark is equal all of non-freespace and top not at left
    ' and multi-line mark then must be character mark
    '
    If row3 > row2 And OldLen = col5-1 And col1 > 1 Then
      Mark_Type = 1                       ' Character mark

      Call Set_Row_Col(row1, col1)        ' Restore position

      Call Set_Screen_Line(Sline)         ' Restore scroll position
      pe32.CommandMode = CommandT         ' Restore command mode
      Exit Function
    End If
    '
    ' Still have two cases:  1) Multi-line left edge block/character mark
    '                        2) Single line block/character mark
    '

    ' *** Undo has changed its behavior and the following no longer works ***
    ' *** so just assume block mark and exit until fixed ***

    If 0 Then                               ' Change to If 0 to test undo
      Mark_Type = 3                         ' Block mark

      Call Set_Row_Col(row1, col1)          ' Restore position

      Call Set_Screen_Line(Sline)           ' Restore scroll position
      pe32.CommandMode = CommandT           ' Restore command mode
      Exit Function
    End If
    '
    ' See if changing last character changes end location
    ' *** Needs Bug #2 Test case #2 to be fixed ***
    '
    Call Set_Col(col3)                    ' Restore end of mark position
    '
    ' The following change command needs a character at the last position,
    '   so if it is not there then add it.
    '
    If OldLen < col3-col1 Then
       pe32.Command "' ' [left]"          ' Place blank at end of mark
    End If

    pe32.Command "c/?/&&/*xm"             ' Lengthen mark if it is a character
                                          '     block
    pe32.Command "[end mark]"             ' Discover new end of mark

    col4  = pe32.Col                      ' Get right edge of mark

    pe32.Command "[undo]"                 ' Restore text to macro start

    ' See if end of block changed
    If col4 <> col3 Then
      Mark_Type = 1                       ' Character mark
      '
      ' Since [undo] does not restore highlighting we need to do it here
      '
      Call Set_Row_Col(row3, col3)        ' Restore end mark

      pe32.Command "[unmark] [mark char]" ' Restart char mark

      Call Set_Row_Col(row2, col2)        ' Restore start mark
      pe32.Command "[mark char]"          ' Finish char mark restore

'     If col4 <> col3+1 Then
'       MsgBox "Bad column after change: " & col4 & " Should be " & col3+1
'     End If
    Else
      Mark_Type = 3                       ' Block mark
    End If

    Call Set_Row_Col(row1, col1)          ' Restore position

    Call Set_Screen_Line(Sline)           ' Restore scroll position
    pe32.CommandMode = CommandT           ' Restore command mode
  End If

End Function

'
'   Return mark type
'         Return bit 1,0 = 00 if no   mark, 01 if char  mark
'         Return bit 1,0 = 10 if line mark, 11 if block mark
'         Return bit 2 NZ iff mark is on the command line
'         Return bit 3 NZ iff mark is in another file
'
'   Note:  When mark is in the current file and not completely visible then the
'          screen may scroll up or down as a side effect of this function.
'
Function Glb_Mark_Type

Dim FirstFile

  Glb_Mark_Type = 0                       ' Assume no mark

  If pe32.MarkedLines > 0 Then

    Glb_Mark_Type = Mark_Type             ' Get status of this mark

  Else

    FirstFile = pe32.Filename             ' Loop control
    '
    ' Loop over files
    '
    Do
      pe32.Command "e"                    ' Next file

    ' Exit when mark found or back to first file
    Loop Until pe32.MarkedLines > 0 Or pe32.Filename = FirstFile

    If pe32.MarkedLines > 0 Then

      Glb_Mark_Type = Mark_Type + 8        ' Get status of this mark

      pe32.Command "e " & Chr(34) & FirstFile & Chr(34) ' Return to first file
    Else
      '
      ' Need to detect if mark is on the command line
      '
      CommandT = pe32.CommandMode         ' Save command mode
      SLine    = Get_Screen_Line          ' Save scroll position

      If 1 Then                           ' Change to If 1 to test undo
        lines1 = pe32.Lines                 ' Get number of lines in file
        pe32.Command "[cursor data] [il] [copy mark]"

        lines2 = pe32.Lines               ' Get number of lines in file

        If lines1 <> lines2-1 Then
          Glb_Mark_Type = 6               ' Line mark on command line
        Else
          row1= pe32.Row                  ' Save position
          str = pe32.GetLine(row1)        ' Get blank inserted line

          If Len(str) > 0 Then
            ' Something moved onto line ... assume block mark for now
            Glb_Mark_Type = 7             ' Block mark on command line
          End If
        End If

        pe32.Command "[undo]"             ' Restore state
      End If

      If Glb_Mark_Type > 0 Then
        pe32.Command "[begin mark]"       ' Go to top left of block mark

        If FirstFile <> pe32.Filename Then
          Glb_Mark_Type = Glb_Mark_Type + 8 ' Not in same file

          pe32.Command "e " & Chr(34) & FirstFile & Chr(34) ' Return to first file
        End If
      End If

      Call Set_Screen_Line(Sline)         ' Restore scroll position
      pe32.CommandMode = CommandT         ' Restore command mode
    End If
  End If

End Function
'
'   Print and return mark type
'         Return bit 1,0 = 00 if no   mark, 01 if char  mark
'         Return bit 1,0 = 10 if line mark, 11 if block mark
'         Return bit 2 NZ iff mark is on the command line
'
'   Note:  When mark is in the current file and not completely visible then the
'          screen may scroll up or down as a side effect of this function.
'
Function Prt_Mark_Type

  Prt_Mark_Type = Mark_Type               ' Get status of mark

  If Prt_Mark_Type = 0 Then
    MsgBox "There is no mark"
  Else
    str = "A "
    Select Case Prt_Mark_Type And 3
      Case 1                              ' Character mark
        str = str + "character"
      Case 2                              ' Line mark
        str = str + "line"
      Case 3                              ' Block mark
        str = str + "block"
    End Select

    str = str + " mark"

    If Prt_Mark_Type And 4 Then
        str = str + " on the command line"
    End If

    str = str + " (" & Prt_Mark_Type & ")"
    MsgBox str
  End If

End Function

'
'   Print and return mark type
'         Return bit 1,0 = 00 if no   mark, 01 if char  mark
'         Return bit 1,0 = 10 if line mark, 11 if block mark
'         Return bit 2 NZ iff mark is on the command line
'         Return bit 3 NZ iff mark is in another file
'
'   Note:  When mark is in the current file and not completely visible then the
'          screen may scroll up or down as a side effect of this function.
'
Function Prt_Glb_Mark_Type

  Prt_Glb_Mark_Type = Glb_Mark_Type       ' Get status of mark

  If Prt_Glb_Mark_Type = 0 Then
    MsgBox "There is no mark"
  Else
    str = "A "
    Select Case Prt_Glb_Mark_Type And 3
      Case 1                              ' Character mark
        str = str + "character"
      Case 2                              ' Line mark
        str = str + "line"
      Case 3                              ' Block mark
        str = str + "block"
    End Select

    str = str + " mark"

    If Prt_Glb_Mark_Type And 8 Then
        str = str + " in another file"
    End If

    If Prt_Glb_Mark_Type And 4 Then
        str = str + " on the command line"
    End If

    str = str + " (" & Prt_Glb_Mark_Type & ")"
    MsgBox str
  End If

End Function

'
' Copy mark to cursor position AND move highlighting to new position
'
Function Copy_Mark

Dim FirstFile

  MType1 = Glb_Mark_Type                  ' Get mark type

  If MType1 = 0 Then Exit Function        ' Done if no mark anywhere

  MType2 = MType1 And 3                   ' Get mark type without
                                          '     command/global flags

  FirstFile = pe32.Filename               ' File control
  CommandT  = pe32.CommandMode            ' Save command mode
  SLine     = Get_Screen_Line             ' Save scroll position

  row1  = pe32.Row                        ' Save position
  col1  = pe32.Col
  '
  ' Find corners of mark
  '
  pe32.Command "[begin mark]"             ' Go to top left of block mark

  '
  ' If mark is on command line then we will (probably incorrectly) think that
  '   it is one character long (since there is no pe32.CommandCol yet)
  '
  row2  = pe32.Row                        ' Get top of mark
  col2  = pe32.Col                        ' Get left edge of mark
' col2c = pe32.CommandCol                 ' Get left edge of mark

  pe32.Command "[end mark]"               ' Go to lower right of block mark

  row3  = pe32.Row                        ' Get bottom of mark
  col3  = pe32.Col                        ' Get right edge of mark
' col3c = pe32.CommandCol                 ' Get right edge of mark

  If CommandT > 0 Then                    ' On command line?
    row2 = 1                              ' Command line has only 1 row
    row3 = 1

'   col2 = col2c                          ' Use command line columns
'   col3 = col3c
  End If

' MsgBox   "Cursor:  (" & col1 & "," & row1 & _
'        ")  Begin:  (" & col2 & "," & row2 & _
'          ")  End:  (" & col3 & "," & row3 & ")"

  If MType1 And 8 Then
    pe32.Command "e " & Chr(34) & FirstFile & Chr(34) ' Return to first file
  End If

  pe32.CommandMode = CommandT             ' Restore command mode

  If CommandT = 0 Then                    ' On command line?
    Call Set_Row_Col(row1, col1)          ' Restore position if no
  End If


  ' Can get length info of command line mark by change in length of line
  ' *** More Code ***

  pe32.Command "[copy mark] [unmark]"     ' Copy the mark

  Select Case MType2
    Case 1                                ' Character mark
      pe32.Command "[mark char]"          ' Start the highlighting
      Call Set_Row(row1 + row3 - row2)
      If row3 = row2 Then
        Call Set_Col(col1 + col3 - col2)  ' If one line block
      Else
        Call Set_Col(col3)                ' If multi-line block
      End If
      pe32.Command "[mark char]"          ' Finish the highlighting

    Case 2                                ' Line mark
      pe32.Command "[down] [mark line]"   ' Start the highlighting
      Call Set_Row(row1 + row3 - row2 + 1)
      pe32.Command "[mark line]"          ' Finish the highlighting

    Case 3                                ' Block mark
      pe32.Command "[mark block]"         ' Start the highlighting
      Call Set_Row_Col(row1 + row3 - row2, col1 + col3 - col2)
      pe32.Command "[mark block]"         ' Finish the highlighting
  End Select

  Call Set_Row_Col(row1, col1)            ' Restore position
  Call Set_Screen_Line(Sline)             ' Restore scroll position
  pe32.CommandMode = CommandT             ' Restore command mode

End Function

'
' Set row
'
Function Set_Row(New_Row)

  pe32.Row = New_Row

End Function

'
' Set col
'
Function Set_Col(New_Col)

  pe32.Col = New_Col

End Function

'
' Set row and col
'
Function Set_Row_Col(New_Row, New_Col)

' MsgBox   "Cursor:  (" & pe32.Col & "," & pe32.row & _
'          ")  Was:  (" & New_Col  & "," & New_Row  & ")"

  pe32.Row = New_Row
  pe32.Col = New_Col

End Function

'
' Move mark to cursor position AND move highlighting to new position
'
Function Move_Mark

Dim FirstFile

  MType1 = Glb_Mark_Type                  ' Get mark type

  If MType1 = 0 Then Exit Function        ' Done if no mark anywhere

  MType2 = MType1 And 3                   ' Get mark type without
                                          '     command/global flags

  FirstFile = pe32.Filename               ' File control
  CommandT  = pe32.CommandMode            ' Save command mode
  SLine     = Get_Screen_Line             ' Save scroll position

  row1  = pe32.Row                        ' Save position
  col1  = pe32.Col
  '
  ' Find corners of mark
  '
  pe32.Command "[begin mark]"             ' Go to top left of block mark

  '
  ' If mark is on command line then we will (probably incorrectly) think that
  '   it is one character long (since there is no pe32.CommandCol yet)
  '
  row2  = pe32.Row                        ' Get top of mark
  col2  = pe32.Col                        ' Get left edge of mark
' col3c = pe32.CommandCol                 ' Get right edge of mark

  pe32.Command "[end mark]"               ' Go to lower right of block mark

  row3  = pe32.Row                        ' Get bottom of mark
  col3  = pe32.Col                        ' Get right edge of mark
' col3c = pe32.CommandCol                 ' Get right edge of mark

  If CommandT > 0 Then                    ' On command line?
    row2 = 1                              ' Command line has only 1 row
    row3 = 1

'   col2 = col2c                          ' Use command line columns
'   col3 = col3c
  End If

  If MType1 And 8 Then
    pe32.Command "e " & Chr(34) & FirstFile & Chr(34) ' Return to first file
  End If

  pe32.CommandMode = CommandT             ' Restore command mode

  If CommandT = 0 Then                    ' On command line?
    Call Set_Row_Col(row1, col1)          ' Restore position if no
  End If


  ' Can get length info of command line mark by change in length of line
  ' *** More Code ***

  pe32.Command "[move mark]"              ' Move the mark

  row1  = pe32.Row                        ' Save position (if some of mark is
                                          '   above cursor then cursor moves)

  Select Case MType2
    Case 1                                ' Character mark
      '
      ' Detect deletion of data to left of cursor
      '
      If row1 = row3 And row1 = row2 And col1 >= col2 Then
        If col1 <= col3 Then
          col1 = col2
        Else
          col1 = col1 - (col3 - col2 + 1)
        End If
        Call Set_Col(col1)
      End If

      pe32.Command "[mark char]"          ' Start the highlighting
      Call Set_Row(row1 + row3 - row2)

      If row3 = row2 Then
        Call Set_Col(col1 + col3 - col2)  ' If one line block
      Else
        Call Set_Col(col3)                ' If multi-line block
      End If

      pe32.Command "[mark char]"          ' Finish the highlighting

    Case 2                                ' Line mark
      pe32.Command "[down] [mark line]"   ' Start the highlighting
      Call Set_Row(row1 + row3 - row2 + 1)
      pe32.Command "[mark line]"          ' Finish the highlighting

    Case 3                                ' Block mark
      '
      ' Detect deletion of data to left of cursor
      '
      If row1 >= row2 And row1 <= row3 And col1 >= col2 Then
        If col1 <= col3 Then
          col1 = col2
        Else
          col1 = col1 - (col3 - col2 + 1)
        End If

        Call Set_Col(col1)
      End If

      pe32.Command "[mark block]"         ' Start the highlighting
      Call Set_Row_Col(row1 + row3 - row2, col1 + col3 - col2)
      pe32.Command "[mark block]"         ' Finish the highlighting
  End Select

  Call Set_Row_Col(row1, col1)            ' Restore position
  Call Set_Screen_Line(Sline)             ' Restore scroll position
  pe32.CommandMode = CommandT             ' Restore command mode

End Function
