/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class GRProblem
extends GProblem {
    private GSolidWndList rawSolidWndList;
    private static GSolidWndList currSolidWndList;
    private static GNPRecordList currRecordList;
    protected static GLogDialog logDialog;
    protected static GTextCanvas hypothesisView;

    public GRProblem(GFrame gFrame, GProblem gProblem, GMenuBar gMenuBar, GCalculator gCalculator, GNotepad gNotepad) {
        super(gFrame, gMenuBar, gCalculator, gNotepad);
        this.newSolidCount = gProblem.newSolidCount;
        this.solidWndList = gProblem.solidWndList;
        if (gProblem instanceof GRProblem) {
            this.rawSolidWndList = ((GRProblem)gProblem).rawSolidWndList;
        }
        this.hypothesis = gProblem.hypothesis;
        this.comments = gProblem.comments;
        this.year = gProblem.year;
        this.author = gProblem.author;
        this.authorEmail = gProblem.authorEmail;
        this.authorWeb = gProblem.authorWeb;
        this.answer = gProblem.answer;
        this.randomized = gProblem.randomized;
        this.lineAvail = gProblem.lineAvail;
        this.perpAvail = gProblem.perpAvail;
        this.midpointAvail = gProblem.midpointAvail;
        this.bisectorAvail = gProblem.bisectorAvail;
        this.layDistAvail = gProblem.layDistAvail;
        this.layAngleAvail = gProblem.layAngleAvail;
        this.cutAvail = gProblem.cutAvail;
    }

    public void init(boolean bl) {
        this.unfoldSolidWnds(true);
        GProblem.saved = !bl;
        GProblem.modified = false;
        this.initRawSolidWndList(bl);
        if (this.log == null) {
            this.log = new GLog();
        }
    }

    public boolean onSolidWindowClose(GSolidWindow gSolidWindow) {
        String string = gSolidWindow.getTitle();
        if (this.answer.needsSolidName(string)) {
            new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA", "Cannot remove " + string + ": targeted by answer");
            return false;
        }
        return true;
    }

    public boolean onClose() {
        if (this.log == null || !GProblem.modified) {
            return true;
        }
        GYNCPromptDialog gYNCPromptDialog = new GYNCPromptDialog(GProblem.frame, "Save resolution " + GProblem.name + "?");
        if (gYNCPromptDialog.result == 2) {
            if (GProblem.saved) {
                return this.save();
            }
            return this.saveAs();
        }
        return gYNCPromptDialog.result == 3;
    }

    public boolean onSave() {
        return true;
    }

    protected boolean save() {
        try {
            File file = new File(GProblem.frame.resDir, GProblem.name);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            GProblem.saved = true;
            GProblem.modified = false;
            return true;
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            return false;
        }
    }

    protected boolean saveAs() {
        GFileDialog gFileDialog = new GFileDialog(GProblem.frame, "Save Resolution As", GProblem.frame.resDir, 1);
        String string = gFileDialog.getDirectory();
        String string2 = gFileDialog.getFile();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            try {
                File file = new File(string, string2);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.flush();
                GProblem.frame.resDir = string;
                GProblem.name = string2;
                GProblem.frame.setTitle("GEOMETRIA Resolver: " + GProblem.name);
                GProblem.saved = true;
                GProblem.modified = false;
                return true;
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
            }
        }
        return false;
    }

    protected void initRawSolidWndList(boolean bl) {
        if (bl) {
            this.rawSolidWndList = new GSolidWndList();
            GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
            while (gSolidWndNode != null) {
                GSolid gSolid = gSolidWndNode.getSolid();
                this.rawSolidWndList.addToTail(gSolid.copy(gSolid.getLabel()));
                gSolidWndNode = gSolidWndNode.getNext();
            }
            return;
        }
        GSolidWndNode gSolidWndNode = this.rawSolidWndList.getHead();
        while (gSolidWndNode != null) {
            GSolid gSolid = gSolidWndNode.getSolid();
            gSolid.enforce();
            gSolidWndNode = gSolidWndNode.getNext();
        }
    }

    protected void answer() {
        if (this.logAlert("answer problem")) {
            return;
        }
        GRAnswerDialog gRAnswerDialog = new GRAnswerDialog(GProblem.frame, this, this.notepad, this.answer);
        if (gRAnswerDialog.good) {
            GProblem.modified = true;
            this.log.add("Correct answer", gRAnswerDialog.getFields(), null);
        }
    }

    protected void setCurrSolidWndList() {
        currSolidWndList = new GSolidWndList();
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        while (gSolidWndNode != null) {
            GSolid gSolid = gSolidWndNode.getSolid();
            currSolidWndList.addToTail(gSolid.copy(gSolid.getLabel()));
            gSolidWndNode = gSolidWndNode.getNext();
        }
    }

    protected void setCurrRecordList() {
        currRecordList = new GNPRecordList();
        GNPRecordNode gNPRecordNode = this.notepad.recordList.getHead();
        while (gNPRecordNode != null) {
            currRecordList.addToTail(gNPRecordNode.getRecord());
            gNPRecordNode = gNPRecordNode.getNext();
        }
    }

    public void review() {
        if (logDialog != null) {
            logDialog.toFront();
            return;
        }
        this.setCurrSolidWndList();
        this.setCurrRecordList();
        logDialog = new GLogDialog(GProblem.frame, this, this.log);
        this.rewind();
        logDialog.show();
    }

    public void oneStep(int n) {
        GSolidWindow gSolidWindow;
        GLogRecord gLogRecord = this.log.recordList.seek(n);
        GSolidWindow gSolidWindow2 = gSolidWindow = gLogRecord.getSolidName() != null ? this.setTopSolidWnd(gLogRecord.getSolidName()) : null;
        if (gLogRecord.getGenerator().equals("Measure distance")) {
            this.distance(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Measure angle")) {
            this.angle(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Draw line")) {
            this.drawLine(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Draw midpoint")) {
            this.drawMidpoint(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Draw bisector")) {
            this.drawBisector(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Draw intersection")) {
            this.drawIntersection(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Draw perp")) {
            this.drawPerpendicular(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Lay distance")) {
            this.layDistance(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Lay angle")) {
            this.layAngle(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Cut")) {
            this.cut(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Erase")) {
            this.erase(gSolidWindow, 2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Erase all drawings")) {
            this.eraseAll(gSolidWindow, 2);
            return;
        }
        if (gLogRecord.getGenerator().equals("Calculator")) {
            Object[] objectArray = gLogRecord.getFields();
            this.notepad.add((GVariable)objectArray[0], (GExpression)objectArray[1], GProblem.calculator, 2);
            return;
        }
        if (gLogRecord.getGenerator().equals("Notepad: Delete")) {
            this.notepad.deleteRecords(2, gLogRecord.getFields());
            return;
        }
        if (gLogRecord.getGenerator().equals("Close window")) {
            this.closeSolidWindow(this.solidWndList.seek(gLogRecord.getSolidName()));
        }
    }

    public void closeSolidWindow(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        this.solidWndList.remove(gSolidWindow);
        gSolidWindow.dispose();
        GProblem.menuBar.removeWindowMenuItem(gSolidWindow.getTitle());
        this.notepad.removeSolid(gSolid, false);
        GSolidWndNode gSolidWndNode = this.solidWndList.getTop();
        if (gSolidWndNode != null) {
            gSolidWindow = gSolidWndNode.getWindow();
            GProblem.menuBar.selectWindowMenuItem(gSolidWindow.getTitle());
            gSolidWindow.toFront();
            gSolidWindow.getCanvas().requestFocus();
        } else {
            GProblem.menuBar.update(this, null);
        }
        this.updateLabelBag();
    }

    public void rewind() {
        this.solidWndList.flush();
        this.notepad.recordList.flush();
        this.notepad.redraw();
        GSolidWndNode gSolidWndNode = this.rawSolidWndList.getHead();
        while (gSolidWndNode != null) {
            GSolid gSolid = gSolidWndNode.getSolid();
            this.solidWndList.addToTail(gSolid.copy(gSolid.getLabel()));
            gSolidWndNode = gSolidWndNode.getNext();
        }
        GProblem.menuBar.initWindowMenu();
        this.unfoldSolidWnds(false);
    }

    public void clearLog(int n) {
        this.log.clearDown(n);
        this.setCurrSolidWndList();
        this.setCurrRecordList();
        this.updateLabelBag();
        GProblem.modified = true;
    }

    public void restore() {
        this.solidWndList.flush();
        this.solidWndList = currSolidWndList;
        this.notepad.recordList = currRecordList;
        this.notepad.redraw();
        GProblem.menuBar.initWindowMenu();
        this.unfoldSolidWnds(false);
    }

    public void logDialogClosed() {
        logDialog = null;
    }

    public void aboutProblem() {
        if (this.author.length() > 0 || this.comments.length() > 0) {
            new GAboutProblemDialog(GProblem.frame, GProblem.name, this.year, this.author, this.authorEmail, this.authorWeb, this.comments);
            return;
        }
        new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA Warning", "No info on " + GProblem.name + " available");
    }

    public boolean logAlert(String string) {
        if (logDialog != null) {
            new GAlertDialog(GProblem.frame, "warn.gif", "GEOMETRIA Warning", "Cannot " + string + " while resolution log is viewed");
            logDialog.toFront();
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        GRMenuBar gRMenuBar = (GRMenuBar)GProblem.menuBar;
        GMenuItem gMenuItem = (GMenuItem)actionEvent.getSource();
        GMenu gMenu = (GMenu)gMenuItem.getParent();
        if (gMenu == gRMenuBar.fileMenu) {
            if (gMenuItem == gRMenuBar.reviewMenuItem) {
                this.review();
                return;
            }
            if (gMenuItem == gRMenuBar.answerMenuItem) {
                this.answer();
                return;
            }
            if (gMenuItem == gRMenuBar.aboutProblemMenuItem) {
                this.aboutProblem();
            }
        }
    }
}

