/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GRectangle
implements Serializable {
    public double left;
    public double right;
    public double top;
    public double bottom;

    public GRectangle() {
        this.bottom = Double.POSITIVE_INFINITY;
        this.left = Double.POSITIVE_INFINITY;
        this.top = Double.NEGATIVE_INFINITY;
        this.right = Double.NEGATIVE_INFINITY;
    }

    public GRectangle(double d, double d2, double d3, double d4) {
        this.left = d;
        this.bottom = d3;
        this.right = d2;
        this.top = d4;
    }

    public void print() {
        System.out.println("left = " + this.left);
        System.out.println("right = " + this.right);
        System.out.println("top = " + this.top);
        System.out.println("bottom = " + this.bottom);
    }

    public void add(double d, double d2) {
        this.left = Math.min(this.left, d);
        this.right = Math.max(this.right, d);
        this.bottom = Math.min(this.bottom, d2);
        this.top = Math.max(this.top, d2);
    }

    public GRectangle add(GRectangle gRectangle) {
        double d = Math.min(this.left, gRectangle.left);
        double d2 = Math.max(this.right, gRectangle.right);
        double d3 = Math.min(this.bottom, gRectangle.bottom);
        double d4 = Math.max(this.top, gRectangle.top);
        return new GRectangle(d, d2, d3, d4);
    }

    public void enlarge(double d) {
        double d2 = this.left;
        this.left = (1.0 + d) * d2 - d * this.right;
        this.right = (1.0 + d) * this.right - d * d2;
        d2 = this.bottom;
        this.bottom = (1.0 + d) * d2 - d * this.top;
        this.top = (1.0 + d) * this.top - d * d2;
    }

    public double square() {
        double d = Math.max(this.right - this.left, this.top - this.bottom);
        double d2 = this.left + this.right;
        this.left = (d2 - d) / 2.0;
        this.right = (d2 + d) / 2.0;
        d2 = this.bottom + this.top;
        this.bottom = (d2 - d) / 2.0;
        this.top = (d2 + d) / 2.0;
        return d;
    }

    public void grow(double d) {
        this.left -= d;
        this.right += d;
        this.bottom -= d;
        this.top += d;
    }

    public int[] standartize(double d) {
        int[] nArray = new int[]{(int)((this.right - this.left) / d), (int)((this.top - this.bottom) / d)};
        this.left = d * Math.ceil(this.left / d);
        this.right = this.left + (double)nArray[0] * d;
        this.bottom = d * Math.ceil(this.bottom / d);
        this.top = this.bottom + (double)nArray[1] * d;
        return nArray;
    }
}

