/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;

    private Method() {
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class[] getParameterTypes() {
        return Method.copy(this.parameterTypes);
    }

    public Class[] getExceptionTypes() {
        return Method.copy(this.exceptionTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Class[] classArray;
            Class[] classArray2;
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName().equals(method.getName()) && (classArray2 = this.parameterTypes).length == (classArray = method.parameterTypes).length) {
                int n = 0;
                while (n < classArray2.length) {
                    if (classArray2[n] != classArray[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuffer.append(this.getName() + "(");
            Class[] classArray = this.parameterTypes;
            int n2 = 0;
            while (n2 < classArray.length) {
                stringBuffer.append(Field.getTypeName(classArray[n2]));
                if (n2 < classArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                int n3 = 0;
                while (n3 < classArray2.length) {
                    stringBuffer.append(classArray2[n3].getName());
                    if (n3 < classArray2.length - 1) {
                        stringBuffer.append(",");
                    }
                    ++n3;
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    static Class[] copy(Class[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray2[n2] = classArray[n2];
            ++n2;
        }
        return classArray2;
    }
}

