/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;

class BumpBuffer {
    static Frame frame;
    static Component component;
    static final int IMAGE_SIZE = 64;
    static Dimension imageSize;
    transient Image image;
    Color topColor;
    Color shadowColor;
    Color backColor;

    public BumpBuffer(Color color, Color color2, Color color3) {
        this.createComponent();
        this.image = this.getComponent().createImage(64, 64);
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
        this.fillBumpBuffer();
    }

    public boolean hasSameColors(Color color, Color color2, Color color3) {
        return this.topColor.equals(color) && this.shadowColor.equals(color2) && this.backColor.equals(color3);
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = this.getComponent().createImage(64, 64);
            this.fillBumpBuffer();
        }
        return this.image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    protected void fillBumpBuffer() {
        int n;
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(this.topColor);
        int n2 = 0;
        while (n2 < 64) {
            n = 0;
            while (n < 64) {
                graphics.drawLine(n2, n, n2, n);
                graphics.drawLine(n2 + 2, n + 2, n2 + 2, n + 2);
                n += 4;
            }
            n2 += 4;
        }
        graphics.setColor(this.shadowColor);
        n = 0;
        while (n < 64) {
            int n3 = 0;
            while (n3 < 64) {
                graphics.drawLine(n + 1, n3 + 1, n + 1, n3 + 1);
                graphics.drawLine(n + 3, n3 + 3, n + 3, n3 + 3);
                n3 += 4;
            }
            n += 4;
        }
        graphics.dispose();
    }

    protected Component getComponent() {
        return component;
    }

    protected void createComponent() {
        if (frame == null) {
            frame = new Frame("bufferCreator");
        }
        if (component == null) {
            component = new Canvas();
            frame.add(component, "Center");
        }
        frame.addNotify();
    }

    static {
        imageSize = new Dimension(64, 64);
    }
}

