/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;

public class TabStop
implements Serializable {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_DECIMAL = 4;
    public static final int ALIGN_BAR = 5;
    public static final int LEAD_NONE = 0;
    public static final int LEAD_DOTS = 1;
    public static final int LEAD_HYPHENS = 2;
    public static final int LEAD_UNDERLINE = 3;
    public static final int LEAD_THICKLINE = 4;
    public static final int LEAD_EQUALS = 5;
    private int alignment;
    private float position;
    private int leader;

    public TabStop(float f) {
        this(f, 0, 0);
    }

    public TabStop(float f, int n, int n2) {
        this.alignment = n;
        this.leader = n2;
        this.position = f;
    }

    public float getPosition() {
        return this.position;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getLeader() {
        return this.leader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TabStop) {
            TabStop tabStop = (TabStop)object;
            return this.alignment == tabStop.alignment && this.leader == tabStop.leader && this.position == tabStop.position;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        String string;
        switch (this.alignment) {
            default: {
                string = "";
                break;
            }
            case 1: {
                string = "right ";
                break;
            }
            case 2: {
                string = "center ";
                break;
            }
            case 4: {
                string = "decimal ";
                break;
            }
            case 5: {
                string = "bar ";
            }
        }
        string = string + "tab @" + String.valueOf(this.position);
        if (this.leader != 0) {
            string = string + " (w/leaders)";
        }
        return string;
    }
}

