/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;

public class OffScreenImageSource
implements ImageProducer {
    BufferedImage image;
    int width;
    int height;
    private ImageConsumer theConsumer;

    public OffScreenImageSource(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.theConsumer = imageConsumer;
        this.produce();
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.theConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void sendPixels() {
        int n;
        Object object;
        ColorModel colorModel = this.image.getColorModel();
        WritableRaster writableRaster = this.image.getRaster();
        int n2 = writableRaster.getNumDataElements();
        int n3 = writableRaster.getDataBuffer().getDataType();
        int[] nArray = new int[this.width * n2];
        boolean bl = true;
        if (colorModel instanceof IndexColorModel) {
            object = new byte[this.width];
            this.theConsumer.setColorModel(colorModel);
            if (writableRaster instanceof ByteComponentRaster) {
                bl = false;
                int n4 = 0;
                while (n4 < this.height) {
                    writableRaster.getDataElements(0, n4, this.width, 1, object);
                    this.theConsumer.setPixels(0, n4, this.width, 1, colorModel, (byte[])object, 0, this.width);
                    ++n4;
                }
            } else if (writableRaster instanceof BytePackedRaster) {
                bl = false;
                int n5 = 0;
                while (n5 < this.height) {
                    writableRaster.getPixels(0, n5, this.width, 1, nArray);
                    n = 0;
                    while (n < this.width) {
                        object[n] = (byte)nArray[n];
                        ++n;
                    }
                    this.theConsumer.setPixels(0, n5, this.width, 1, colorModel, (byte[])object, 0, this.width);
                    ++n5;
                }
            } else if (n3 == 2 || n3 == 3) {
                bl = false;
                int n6 = 0;
                while (n6 < this.height) {
                    writableRaster.getPixels(0, n6, this.width, 1, nArray);
                    this.theConsumer.setPixels(0, n6, this.width, 1, colorModel, nArray, 0, this.width);
                    ++n6;
                }
            }
        } else if (colorModel instanceof DirectColorModel) {
            this.theConsumer.setColorModel(colorModel);
            bl = false;
            switch (n3) {
                case 3: {
                    int n7 = 0;
                    while (n7 < this.height) {
                        writableRaster.getDataElements(0, n7, this.width, 1, nArray);
                        this.theConsumer.setPixels(0, n7, this.width, 1, colorModel, nArray, 0, this.width);
                        ++n7;
                    }
                    break;
                }
                case 0: {
                    byte[] byArray = new byte[this.width];
                    n = 0;
                    while (n < this.height) {
                        writableRaster.getDataElements(0, n, this.width, 1, byArray);
                        int n8 = 0;
                        while (n8 < this.width) {
                            nArray[n8] = byArray[n8] & 0xFF;
                            ++n8;
                        }
                        this.theConsumer.setPixels(0, n, this.width, 1, colorModel, nArray, 0, this.width);
                        ++n;
                    }
                    break;
                }
                case 1: {
                    short[] sArray = new short[this.width];
                    int n9 = 0;
                    while (n9 < this.height) {
                        writableRaster.getDataElements(0, n9, this.width, 1, sArray);
                        int n10 = 0;
                        while (n10 < this.width) {
                            nArray[n10] = sArray[n10] & 0xFFFF;
                            ++n10;
                        }
                        this.theConsumer.setPixels(0, n9, this.width, 1, colorModel, nArray, 0, this.width);
                        ++n9;
                    }
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            object = ColorModel.getRGBdefault();
            this.theConsumer.setColorModel((ColorModel)object);
            int n11 = 0;
            while (n11 < this.height) {
                n = 0;
                while (n < this.width) {
                    nArray[n] = this.image.getRGB(n, n11);
                    ++n;
                }
                this.theConsumer.setPixels(0, n11, this.width, 1, (ColorModel)object, nArray, 0, this.width);
                ++n11;
            }
        }
    }

    private void produce() {
        if (this.theConsumer != null) {
            this.theConsumer.setDimensions(this.image.getWidth(), this.image.getHeight());
        }
        if (this.theConsumer != null) {
            this.theConsumer.setProperties(new Hashtable());
        }
        this.sendPixels();
        if (this.theConsumer != null) {
            this.theConsumer.imageComplete(2);
        }
    }
}

