/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;

public class CertificatePanel
extends ActivatorSubPanel
implements ActionListener {
    private JLabel certText;
    private JList certList;
    private JButton removeButton;
    private MessageHandler mh = new MessageHandler("cert");

    public CertificatePanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("netscape_object_signing")));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.certText = new JLabel(this.mh.getMessage("description"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        jPanel4.add(this.certText);
        jPanel3.add((Component)jPanel4, "North");
        this.certList = new JList();
        this.certList.setSelectionMode(0);
        jPanel3.add((Component)this.certList, "Center");
        this.removeButton = new JButton(this.mh.getMessage("remove_button"));
        this.removeButton.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        jPanel5.add(this.removeButton);
        jPanel3.add((Component)jPanel5, "South");
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        this.reset();
        this.add(jPanel2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.removeButton) {
            int n = this.certList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            this.model.changeCertificatesToInactive(n);
            this.reset();
        }
    }

    public void reset() {
        X509Certificate[] x509CertificateArray = this.model.getActiveCertificatesSet();
        if (x509CertificateArray == null) {
            this.certList.setListData(new String[0]);
        } else {
            String[] stringArray = new String[x509CertificateArray.length];
            int n = 0;
            while (n < x509CertificateArray.length) {
                try {
                    Principal principal = x509CertificateArray[n].getSubjectDN();
                    String string = principal.getName();
                    int n2 = string.indexOf("CN=");
                    int n3 = 0;
                    stringArray[n] = n2 < 0 ? "Unknown subject" : ((n3 = string.charAt(n2 += 3) == '\"' ? string.indexOf(34, ++n2) : string.indexOf(44, n2)) < 0 ? string.substring(n2) : string.substring(n2, n3));
                }
                catch (Exception exception) {
                    stringArray[n] = "Unknown subject";
                }
                ++n;
            }
            this.certList.setListData(stringArray);
        }
        boolean bl = x509CertificateArray != null && x509CertificateArray.length > 0;
        this.setEnabled(this.certText, bl);
        this.setEnabled(this.certList, bl);
        this.setEnabled(this.removeButton, bl);
        if (bl) {
            this.certList.setSelectedIndex(0);
        }
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }
}

