/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class AndTerm
extends SearchTerm {
    protected SearchTerm[] terms;

    public AndTerm(SearchTerm searchTerm, SearchTerm searchTerm2) {
        this.terms = new SearchTerm[2];
        this.terms[0] = searchTerm;
        this.terms[1] = searchTerm2;
    }

    public AndTerm(SearchTerm[] searchTermArray) {
        this.terms = new SearchTerm[searchTermArray.length];
        int n = 0;
        while (n < searchTermArray.length) {
            this.terms[n] = searchTermArray[n];
            ++n;
        }
    }

    public SearchTerm[] getTerms() {
        return (SearchTerm[])this.terms.clone();
    }

    public boolean match(Message message) {
        int n = 0;
        while (n < this.terms.length) {
            if (!this.terms[n].match(message)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

