/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Effect;
import common.ListItem;
import common.OS;
import common.Style;
import common.Tool;
import common.VectorString;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class DListBox
extends Panel
implements ItemSelectable,
KeyListener,
MouseListener,
AdjustmentListener {
    public static final int EVT_IMAGE_SELECT = 16388;
    public static final int BORDER_REGULAR = 0;
    public static final int BORDER_NONE = 1;
    public static final int IMAGE_WIDTH = 20;
    private static final boolean ABSOLUTE = true;
    public Image image = null;
    public String[] arrayModel;
    boolean listChanged;
    int popx;
    int popy;
    int countTagged;
    int lastTagged;
    protected int nTopRow = 0;
    protected int lWidth = 0;
    protected int cellHt = 0;
    protected int yAdj = 0;
    protected int borderWidth = 4;
    protected int halfBorderWidth = 2;
    ActionListener actionListener = null;
    ItemListener itemListener = null;
    protected final int LINE_SLOP = 4;
    protected String ilbLabel;
    protected Scrollbar VBar = null;
    protected Scrollbar HBar = null;
    protected Vector items;
    protected Font font;
    protected transient FontMetrics fm = null;
    protected transient boolean bAllDirty = true;
    protected boolean bMultipleSelections = false;
    protected boolean bBlockPaint = false;
    protected boolean bVBarVisible = false;
    protected boolean bHBarVisible = false;
    protected transient boolean bInternalBlockPaint = false;
    protected int rowsToShow = -1;
    protected int colsToShow = 10;
    protected transient int visibleRows = 0;
    protected transient int visibleCols = -1;
    protected transient int fontHeight;
    protected transient int fontDescent;
    protected transient int lastDownModifiers = -1;
    protected transient int lastSelected = -1;
    protected transient int lastIndex = -1;
    protected transient int lastTempIndex = -1;
    protected transient int countSelected = 0;
    protected int borderType = 0;
    protected int longestLineValue = 0;
    protected transient int barSize;
    protected int xCoord;
    protected transient long prevSelectTime;
    protected transient long prevSelectRow;
    protected boolean bAllowShowVBar;
    protected boolean bAllowShowHBar;
    protected boolean bComboMode;
    protected boolean bCellBorders;
    protected Color borderLighterColor;
    protected Color borderDarkerColor;
    protected Color borderLightColor;
    protected Color borderDarkColor;
    protected Color cachedBackground;
    protected Color textHighlight;
    protected Color textHighlightText;
    protected Color enabledColor;
    protected Color disabledColor;
    protected int fastDownCount;
    protected boolean bMouseDrawHandled;
    private MouseMotion mouseMotion;
    protected Color PanelColor;
    protected Focus focus;
    public transient boolean hasFocus;

    public DListBox() {
        this(-1, false);
    }

    public DListBox(boolean bl) {
        this(-1, bl);
    }

    public DListBox(int n, boolean bl) {
        this.barSize = new Scrollbar((int)1).getSize().width;
        this.xCoord = 0;
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
        this.bAllowShowVBar = true;
        this.bAllowShowHBar = true;
        this.bComboMode = false;
        this.bCellBorders = false;
        this.borderLighterColor = null;
        this.borderDarkerColor = null;
        this.borderLightColor = null;
        this.borderDarkColor = null;
        this.cachedBackground = null;
        this.textHighlight = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
        this.textHighlightText = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
        this.enabledColor = OS.isMacintosh() ? Color.black : SystemColor.textText;
        this.disabledColor = OS.isMacintosh() ? Color.gray : SystemColor.textInactiveText;
        this.fastDownCount = 0;
        this.bMouseDrawHandled = false;
        this.mouseMotion = null;
        this.PanelColor = Color.gray;
        this.focus = null;
        this.hasFocus = false;
        this.items = new Vector();
        this.rowsToShow = n;
        this.bMultipleSelections = bl;
        this.setLayout(null);
        this.VBar = new Scrollbar();
        this.VBar.setBackground(SystemColor.control);
        this.VBar.setVisible(false);
        this.add(this.VBar);
        this.HBar = new Scrollbar(0);
        this.HBar.setBackground(SystemColor.control);
        this.HBar.setVisible(false);
        this.add(this.HBar);
        this.cachedBackground = this.getBackground();
        if (OS.isWindows()) {
            this.barSize = 17;
        }
        this.listChanged = false;
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public boolean isFocusable() {
        return true;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setModel(String[] stringArray) {
        this.arrayModel = stringArray;
    }

    public void setShowVerticalScroll(boolean bl) {
        if (this.bAllowShowVBar != bl) {
            this.bAllowShowVBar = bl;
            this.invalidate();
        }
    }

    public boolean isShowVerticalScroll() {
        return this.bAllowShowVBar;
    }

    public void setShowHorizontalScroll(boolean bl) {
        if (this.bAllowShowHBar != bl) {
            this.bAllowShowHBar = bl;
            this.invalidate();
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.bAllowShowHBar;
    }

    public void setComboMode(boolean bl) {
        if (this.bComboMode != bl) {
            this.bComboMode = bl;
            this.yAdj = 0;
            if (OS.isWindows()) {
                this.yAdj = 6;
            }
            this.invalidate();
        }
    }

    public boolean isComboMode() {
        return this.bComboMode;
    }

    public void setRowsToShow(int n) {
        if (this.rowsToShow != n) {
            this.rowsToShow = n;
            this.invalidate();
        }
    }

    public int getRowsToShow() {
        return this.rowsToShow;
    }

    public void setBorderType(int n) {
        if (this.borderType != n) {
            this.borderType = n;
            if (n == 0) {
                this.borderWidth = 4;
                this.halfBorderWidth = 2;
            } else {
                this.borderWidth = 0;
                this.halfBorderWidth = 0;
            }
            this.invalidate();
        }
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setCellBorder(int n, boolean bl) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            if (listItem.bCellBorder != bl) {
                listItem.bCellBorder = bl;
                listItem.bDirty = true;
                this.invalidate();
            }
        }
    }

    public void setCellBorders(boolean bl) {
        if (this.bCellBorders != bl) {
            this.bCellBorders = bl;
            int n = this.items.size();
            ListItem listItem = null;
            for (int i = 0; i < n; ++i) {
                listItem = (ListItem)this.items.elementAt(i);
                listItem.bCellBorder = bl;
            }
            this.bAllDirty = true;
            this.invalidate();
        }
    }

    public boolean isCellBorders() {
        return this.bCellBorders;
    }

    public void setEnabledTextColor(int n, Color color) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.color = color;
        }
    }

    public void crossOut(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.deleted = true;
            listItem.bDirty = true;
        }
    }

    public void crossOut(int n, boolean bl) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.deleted = bl;
            listItem.bDirty = true;
        }
    }

    public boolean isCrossedOff(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.deleted;
        }
        return false;
    }

    public int getCrossedOffIndex() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.deleted) continue;
            return i;
        }
        return -1;
    }

    public boolean isCrossedOff() {
        return this.getCrossedOffIndex() != -1;
    }

    public Color getEnabledTextColor(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.color;
        }
        return null;
    }

    public synchronized void setMultiColumnMode(boolean bl) {
        if (this.isCellBorders() != bl) {
            this.setComboMode(false);
            this.setBorderType(1);
            this.setCellBorders(bl);
            this.yAdj = 2;
        }
    }

    public void setListItems(String[] stringArray) {
        this.clear(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addItem(stringArray[i]);
        }
    }

    public String[] getListItems() {
        int n = this.countItems();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getText(i);
        }
        return stringArray;
    }

    public void setEdited(int n, boolean bl) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.bEdited = bl;
        }
    }

    public boolean isEdited(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.bEdited;
        }
        return false;
    }

    public void setMultipleSelections(boolean bl) {
        if (this.bMultipleSelections != bl) {
            if (!bl) {
                this.deselectAll();
            }
            this.bMultipleSelections = bl;
        }
    }

    public boolean isMultipleSelections() {
        return this.bMultipleSelections;
    }

    public void setEnabled(int n, boolean bl) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            if (listItem.bEnabled != bl) {
                listItem.bEnabled = bl;
                if (!bl) {
                    this.deselect(n);
                }
                listItem.bDirty = true;
                if (!this.bInternalBlockPaint) {
                    this.repaint();
                }
            }
        }
    }

    public boolean isEnabled(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.bEnabled;
        }
        return false;
    }

    public void setText(int n, String string) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.sText = string;
            listItem.bDirty = true;
            listItem.updateWidth(this.fm);
            this.updateWidth(listItem);
        }
    }

    public String getText(int n) {
        if (this.validIndex(n)) {
            return ((ListItem)this.items.elementAt((int)n)).sText;
        }
        return null;
    }

    public void setImageURL(int n, URL uRL) throws MalformedURLException {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            Image image = this.getToolkit().getImage(uRL);
            if (image != null) {
                this.setImage(n, image);
            }
            listItem.url = uRL;
        }
    }

    public URL getImageURL(int n) {
        if (this.validIndex(n)) {
            return ((ListItem)this.items.elementAt((int)n)).url;
        }
        return null;
    }

    public void setImage(int n, Image image) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.image = image;
            listItem.bDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public Image getImage(int n) {
        if (this.validIndex(n)) {
            return ((ListItem)this.items.elementAt((int)n)).image;
        }
        return null;
    }

    public synchronized void setSelectedItem(String string, boolean bl) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.sText.equalsIgnoreCase(string) || !listItem.bEnabled) continue;
            this.setSelectedIndex(i, bl);
            return;
        }
    }

    public synchronized String getSelectedItem() {
        return this.lastSelected < 0 ? null : this.getText(this.lastSelected);
    }

    public void setLastSelected(int n) {
        this.lastSelected = n;
    }

    public synchronized void setSelectedIndex(int n, boolean bl) {
        ListItem listItem = null;
        if (this.bMultipleSelections) {
            listItem = (ListItem)this.items.elementAt(n);
            this.clearSelected();
            listItem.bSelected = bl;
            listItem.bDirty = true;
            if (bl) {
                ++this.countSelected;
            }
        } else {
            int n2 = this.items.size();
            if (n < n2 && n > -1) {
                listItem = (ListItem)this.items.elementAt(n);
                boolean bl2 = listItem.bSelected;
                if (bl) {
                    this.clearSelected();
                    listItem.bSelected = true;
                    if (bl2) {
                        listItem.bDirty = false;
                    }
                    this.countSelected = 1;
                } else {
                    listItem.bSelected = false;
                    listItem.tagged = false;
                    if (bl2) {
                        listItem.bDirty = true;
                        --this.countSelected;
                    }
                }
            }
        }
        this.lastSelected = n;
        this.lastIndex = n;
        this.setVisibleIndex(n);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void setDeselected(int n) {
        if (!this.validIndex(n)) {
            return;
        }
        ListItem listItem = (ListItem)this.items.elementAt(n);
        if (listItem.bSelected) {
            listItem.bSelected = false;
            listItem.bDirty = true;
            --this.countSelected;
        }
        this.lastSelected = -1;
    }

    public synchronized void setDeselected() {
        this.setDeselected(this.lastIndex);
        this.repaint();
    }

    public synchronized int getSelectedIndex() {
        return this.lastSelected;
    }

    public synchronized int[] getSelectedIndexes() {
        int[] nArray = new int[this.countSelected];
        if (this.countSelected == 1) {
            nArray[0] = this.lastSelected;
        } else if (this.countSelected > 1) {
            int n = 0;
            int n2 = this.items.size();
            for (int i = 0; i < n2; ++i) {
                ListItem listItem = (ListItem)this.items.elementAt(i);
                if (!listItem.bSelected && !listItem.tagged) continue;
                nArray[n++] = i;
                if (n == this.countSelected) break;
            }
        }
        return nArray;
    }

    public synchronized String[] getSelectedItems() {
        String[] stringArray = new String[this.countSelected];
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem listItem = (ListItem)this.items.elementAt(this.lastSelected);
                stringArray[0] = listItem.sText;
            }
        } else if (this.countSelected > 0) {
            int n = 0;
            int n2 = this.items.size();
            for (int i = 0; i < n2; ++i) {
                ListItem listItem = (ListItem)this.items.elementAt(i);
                if (!listItem.bSelected && !listItem.tagged) continue;
                stringArray[n] = listItem.sText;
                if (++n == this.countSelected) break;
            }
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public synchronized boolean isSelected(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.bSelected || listItem.deleted;
        }
        return false;
    }

    public synchronized void setLabel(String string) {
        this.ilbLabel = string;
    }

    public synchronized String getLabel() {
        return new String(this.ilbLabel);
    }

    public synchronized void setVisibleIndex(int n) {
        if (n < this.nTopRow) {
            this.scrollVertical(n, true);
            return;
        }
        if (n < this.nTopRow + this.visibleRows) {
            return;
        }
        this.scrollVertical(n - this.visibleRows + 1, true);
    }

    public void setTopRow(int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.items.size();
        if (n2 < this.visibleRows) {
            n = 0;
        } else if (n > n2 - this.visibleRows) {
            n = n2 - this.visibleRows;
        }
        if (this.nTopRow != n) {
            this.nTopRow = n;
            this.bAllDirty = true;
            this.invalidate();
        }
    }

    public synchronized int getTopRow() {
        return this.nTopRow;
    }

    public synchronized void setColumns(int n) {
        if (this.colsToShow != n) {
            this.colsToShow = n;
            this.invalidate();
        }
    }

    public synchronized int getColumns() {
        return this.colsToShow;
    }

    public int getRows() {
        return this.visibleRows;
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.updateWidths(this.fm);
        this.xCoord = 0;
        this.bAllDirty = true;
        this.invalidate();
    }

    public synchronized void setDirty(boolean bl) {
        this.bAllDirty = bl;
    }

    public synchronized boolean isDirty() {
        return this.bAllDirty;
    }

    public boolean isAllSelected() {
        return this.countSelected == this.items.size();
    }

    protected void addItem(ListItem listItem) {
        if (listItem != null) {
            this.items.addElement(listItem);
            this.updateWidth(listItem);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void addItem(int n) {
        this.addItem(new ListItem(this.image, this.arrayModel[n], true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, int n) {
        this.addItem(new ListItem(image, this.arrayModel[n], true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(String string) {
        this.addItem(new ListItem(null, string, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(String string, boolean bl) {
        this.addItem(new ListItem(null, string, bl, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String string) {
        this.addItem(new ListItem(image, string, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String string, boolean bl) {
        this.addItem(new ListItem(image, string, bl, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String string, boolean bl, Color color) {
        ListItem listItem = new ListItem(image, string, bl, this.fm, this.bCellBorders);
        listItem.color = color;
        this.addItem(listItem);
    }

    public synchronized void insertItem(int n, Image image, String string, boolean bl) {
        ListItem listItem = null;
        if (this.validIndex(n)) {
            listItem = new ListItem(image, string, bl, this.fm, this.bCellBorders);
            this.items.insertElementAt(listItem, n);
            this.bAllDirty = true;
            if (this.lastSelected >= n) {
                ++this.lastSelected;
            }
        } else {
            listItem = new ListItem(image, string, bl, this.fm, this.bCellBorders);
            this.items.addElement(listItem);
        }
        this.updateWidth(listItem);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void insertItems(int n, Vector vector, Image image, boolean bl) {
        int n2 = vector.size();
        int n3 = 0;
        if (this.validIndex(n)) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.items.insertElementAt(new ListItem(image, (String)vector.elementAt(n3), bl, this.fm, this.bCellBorders), n++);
            }
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                this.items.addElement(new ListItem(image, (String)vector.elementAt(n3), bl, this.fm, this.bCellBorders));
            }
        }
        this.deselectAll();
        this.bAllDirty = true;
        this.updateWidths(this.fm);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public int countItems() {
        return this.items.size();
    }

    public synchronized void clear() {
        this.clear(16);
    }

    public synchronized void clear(int n) {
        this.items = new Vector(n, 16);
        this.nTopRow = 0;
        this.lastDownModifiers = -1;
        this.lastSelected = -1;
        this.lastIndex = -1;
        this.lastTempIndex = -1;
        this.countSelected = 0;
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
        this.VBar.setValues(1, 1, 0, 2);
        this.VBar.setVisible(false);
        this.bVBarVisible = false;
        this.HBar.setValues(1, 1, 0, 2);
        this.HBar.setVisible(false);
        this.bHBarVisible = false;
        this.bAllDirty = true;
        this.bInternalBlockPaint = false;
        this.bBlockPaint = false;
        this.longestLineValue = 0;
        this.xCoord = 0;
    }

    public synchronized void delItem(int n) {
        if (this.validIndex(n)) {
            this.items.removeElementAt(n);
            this.bAllDirty = true;
            this.scrollVertical(this.nTopRow, true);
            this.updateWidths(null);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void delItems(int n, int n2) {
        int n3 = this.items.size();
        if (n3 > 0) {
            if (n2 >= n3) {
                n2 = n3 - 1;
            }
            if (n < 0) {
                n = 0;
            }
            if (n <= n2) {
                this.bInternalBlockPaint = true;
                for (int i = n2; i >= n; --i) {
                    this.items.removeElementAt(i);
                }
                this.bInternalBlockPaint = false;
                this.bAllDirty = true;
                this.scrollVertical(this.nTopRow, true);
                this.updateWidths(null);
                this.repaint();
            }
        }
    }

    public synchronized void delSelectedItems() {
        int n = this.items.size();
        this.bInternalBlockPaint = true;
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem = (ListItem)this.items.elementAt(n2);
            if (listItem.bSelected) {
                this.delItem(n2);
                --n;
                continue;
            }
            ++n2;
        }
        this.bAllDirty = true;
        this.scrollVertical(this.nTopRow, true);
        this.updateWidths(null);
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public synchronized void selectMultiple(int n, boolean bl, boolean bl2) {
        if (!this.bMultipleSelections) {
            bl = false;
            bl2 = false;
        }
        if (bl) {
            this.shiftSelect(n, bl2);
        } else if (bl2) {
            this.ctrlSelect(n);
        } else {
            this.setSelectedIndex(n, true);
        }
    }

    public synchronized void selectAll() {
        if (!this.bMultipleSelections) {
            return;
        }
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.bEnabled) continue;
            listItem.bSelected = true;
        }
        this.countSelected = n;
        this.lastSelected = n - 1;
        this.repaint();
    }

    public synchronized void deselect(int n) {
        if (this.validIndex(n)) {
            this.setSelectedIndex(n, false);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void deselectAll() {
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem listItem = (ListItem)this.items.elementAt(this.lastSelected);
                listItem.bSelected = false;
                listItem.bDirty = true;
                listItem.deleted = false;
                listItem.tagged = false;
            }
        } else {
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                ListItem listItem = (ListItem)this.items.elementAt(i);
                listItem.bSelected = false;
                listItem.bDirty = true;
                listItem.deleted = false;
                listItem.tagged = false;
            }
        }
        this.lastSelected = -1;
        this.countSelected = 0;
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void uncrossAll() {
        int n;
        for (int i = n = this.items.size(); i >= 0; --i) {
            this.crossOut(i, false);
        }
    }

    public synchronized void clearSelected() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.bSelected && !listItem.tagged) continue;
            listItem.bSelected = false;
            listItem.tagged = false;
            listItem.bDirty = true;
        }
        this.lastSelected = -1;
        this.countSelected = 0;
    }

    public Dimension getPreferredSize(int n) {
        Dimension dimension = this.getMinimumSize(n);
        Dimension dimension2 = this.getSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getPreferredSize() {
        if (this.rowsToShow > 0) {
            return this.getPreferredSize(this.rowsToShow);
        }
        return this.getPreferredSize(this.items.size());
    }

    public Dimension getMinimumSize(int n) {
        this.font = this.getFont();
        if (this.font != null) {
            this.fm = this.getFontMetrics(this.font);
            if (this.fm != null) {
                this.fontHeight = this.fm.getHeight();
                this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
                return new Dimension(this.fm.stringWidth("WN") * this.colsToShow / 2 + 4, n * this.cellHt + this.borderWidth + this.yAdj);
            }
        }
        return new Dimension(this.borderWidth + 4, this.borderWidth + this.yAdj);
    }

    public Dimension getMinimumSize() {
        if (this.rowsToShow > 0) {
            return this.getMinimumSize(this.rowsToShow);
        }
        return this.getMinimumSize(this.items.size());
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMotion();
            this.addMouseMotionListener(this.mouseMotion);
        }
        this.VBar.addAdjustmentListener(this);
        this.HBar.addAdjustmentListener(this);
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
        this.font = this.getFont();
        this.fm = this.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.updateWidths(this.fm);
    }

    public synchronized void removeNotify() {
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        this.removeKeyListener(this);
        this.VBar.removeAdjustmentListener(this);
        this.HBar.removeAdjustmentListener(this);
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public synchronized void blockPaint(boolean bl) {
        this.bBlockPaint = bl;
        if (!this.bBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void enablePainting(boolean bl) {
        this.bInternalBlockPaint = !bl;
    }

    public synchronized void scrollVertical(int n, boolean bl) {
        int n2 = this.nTopRow;
        if (this.visibleRows == 0) {
            n2 = 0;
        } else {
            if (bl) {
                n2 = n;
            } else {
                switch (n) {
                    case 3: {
                        n2 -= this.visibleRows;
                        break;
                    }
                    case 4: {
                        n2 += this.visibleRows;
                        break;
                    }
                    case 2: {
                        --n2;
                        break;
                    }
                    case 1: {
                        ++n2;
                    }
                }
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.items.size() - this.visibleRows && (n2 = this.items.size() - this.visibleRows) < 0) {
                n2 = 0;
            }
        }
        if (this.nTopRow != n2) {
            this.nTopRow = n2;
            this.VBar.setValue(n2);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void scrollHorizontal(int n, boolean bl) {
        int n2 = this.xCoord;
        if (bl) {
            n2 = -n;
        } else {
            switch (n) {
                case 3: {
                    n2 += this.lWidth;
                    break;
                }
                case 4: {
                    n2 -= this.lWidth;
                    break;
                }
                case 2: {
                    ++n2;
                    break;
                }
                case 1: {
                    --n2;
                }
            }
        }
        if (n2 > 0) {
            n2 = 0;
        } else if (-n2 > this.HBar.getMaximum() - this.lWidth) {
            n2 = -(this.HBar.getMaximum() - this.lWidth);
        }
        if (this.xCoord != n2) {
            this.xCoord = n2;
            this.HBar.setValue(-n2);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void update(Graphics graphics) {
        if (!this.bBlockPaint && !this.bInternalBlockPaint) {
            this.paint(graphics);
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Color color = this.getBackground();
        if (!Tool.objectsEqual(color, this.cachedBackground)) {
            this.cachedBackground = color;
            this.calculateBorderColors(this.PanelColor);
        }
        Rectangle rectangle = this.getBounds();
        this.font = graphics.getFont();
        this.fm = graphics.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.fontDescent = this.fm.getDescent();
        int n6 = this.items.size();
        this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
        if (n6 == 0) {
            this.nTopRow = 0;
            this.visibleRows = 0;
            bl2 = false;
            bl = false;
            this.xCoord = 0;
        } else {
            if (this.bAllowShowHBar && this.longestLineValue > rectangle.width - this.borderWidth) {
                bl2 = true;
                n2 = this.barSize;
            } else {
                bl2 = false;
                n2 = 0;
                this.xCoord = 0;
            }
            int n7 = (rectangle.height - n2 - this.borderWidth - this.yAdj) / this.cellHt;
            if (this.bAllowShowVBar && n6 > n7) {
                bl = true;
                n = this.barSize;
                if (!bl2 && this.bAllowShowHBar && this.longestLineValue > rectangle.width - this.borderWidth - n) {
                    bl2 = true;
                    n2 = this.barSize;
                    n7 = (rectangle.height - n2 - this.borderWidth - this.yAdj) / this.cellHt;
                }
            } else {
                bl = false;
                n = 0;
            }
            if (this.visibleRows != n7) {
                this.visibleRows = n7;
                this.bAllDirty = true;
            }
            if (bl) {
                this.VBar.setBounds(rectangle.width - this.barSize - this.halfBorderWidth, this.halfBorderWidth, this.barSize, rectangle.height - this.borderWidth - n2);
                this.VBar.setValues(this.nTopRow, this.visibleRows, 0, n6);
                this.VBar.setBlockIncrement(this.visibleRows);
                this.lWidth = rectangle.width - n - this.borderWidth;
                if (!this.bVBarVisible) {
                    this.bVBarVisible = true;
                    this.VBar.setVisible(true);
                }
            } else {
                this.lWidth = rectangle.width - this.borderWidth;
                if (this.bVBarVisible) {
                    this.bVBarVisible = false;
                    this.VBar.setVisible(false);
                }
            }
            if (bl2) {
                this.HBar.setBounds(this.halfBorderWidth, rectangle.height - this.barSize - this.halfBorderWidth, rectangle.width - this.borderWidth - n, this.barSize);
                this.HBar.setValues(-this.xCoord, this.lWidth, 0, this.longestLineValue);
                this.HBar.setBlockIncrement(this.lWidth);
                if (!this.bHBarVisible) {
                    this.bHBarVisible = true;
                    this.HBar.setVisible(true);
                }
            } else if (this.bHBarVisible) {
                this.bHBarVisible = false;
                this.HBar.setVisible(false);
            }
        }
        if (n6 == 0 || this.bAllDirty) {
            graphics.clearRect(this.halfBorderWidth, this.halfBorderWidth, rectangle.width - this.borderWidth - 1, rectangle.height - this.borderWidth - 1);
        }
        if (this.borderType == 0) {
            graphics.setColor(this.borderDarkerColor);
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(0, 0, 0, rectangle.height - 1);
            graphics.setColor(this.borderDarkColor);
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            graphics.setColor(this.borderLightColor);
            graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
            graphics.setColor(this.borderLighterColor);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.clipRect(this.halfBorderWidth, this.halfBorderWidth, this.lWidth, rectangle.height - this.borderWidth);
        if (this.nTopRow >= n6) {
            this.nTopRow -= this.visibleRows + 1;
        }
        int n8 = this.nTopRow;
        int n9 = Math.min(this.nTopRow + this.visibleRows, n6);
        int n10 = 0;
        while (n8 < n9) {
            n4 = n10 * this.cellHt + this.yAdj + this.halfBorderWidth;
            n5 = (n10 + 1) * this.cellHt + this.yAdj + this.halfBorderWidth;
            ListItem listItem = (ListItem)this.items.elementAt(n8);
            if (listItem.bDirty || this.bAllDirty) {
                listItem.bDirty = false;
                graphics.clearRect(this.halfBorderWidth, n4, this.lWidth, this.cellHt);
            }
            int n11 = listItem.image != null ? this.halfBorderWidth + 20 + 2 : this.halfBorderWidth;
            n3 = listItem.bCellBorder ? 2 : 0;
            int n12 = this.lWidth - this.xCoord - 20 - 2;
            if (listItem.bSelected) {
                graphics.setColor(this.textHighlight);
                graphics.fillRect(this.xCoord + n11 + n3, n4, n12, this.cellHt);
                graphics.setColor(this.textHighlightText);
            } else if (listItem.bEnabled) {
                if (listItem.color == null) {
                    graphics.setColor(this.enabledColor);
                } else {
                    graphics.setColor(listItem.color);
                }
            } else {
                graphics.setColor(this.disabledColor);
            }
            graphics.drawString(listItem.sText, this.xCoord + n11 + n3 + 2, n5 - this.fontDescent);
            if (listItem.image != null) {
                graphics.drawImage(listItem.image, this.xCoord + this.halfBorderWidth + n3 + 2, n4 + 2, 20, this.cellHt - 3, this);
            }
            if (listItem.deleted) {
                graphics.setColor(Color.red);
                int n13 = n4 + this.cellHt / 2;
                graphics.drawLine(this.xCoord + this.halfBorderWidth + n3 + 2, n13, this.lWidth, n13);
            }
            if (listItem.bCellBorder) {
                graphics.setColor(listItem.cellBorderColor);
                graphics.drawRect(this.halfBorderWidth, n4, this.lWidth, this.cellHt);
            }
            if (listItem.tagged) {
                graphics.setColor(this.textHighlight);
                graphics.drawRect(this.xCoord + n11 + n3, n4 + 1, n12, this.cellHt - 2);
            }
            ++n8;
            ++n10;
        }
        this.extraPaint(graphics, rectangle);
        this.bAllDirty = false;
        this.listChanged = false;
    }

    public void extraPaint(Graphics graphics, Rectangle rectangle) {
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        this.bAllDirty = true;
        super.setBounds(n, n2, n3, n4);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        if (mouseEvent.isPopupTrigger()) {
            this.popx = mouseEvent.getX();
            this.popy = mouseEvent.getY();
            this.sendActionEvent("Popup");
            return;
        }
        ++this.fastDownCount;
        this.bMouseDrawHandled = false;
        if (n > -1 && n < this.lWidth) {
            n3 = this.mouseCalcIndex(n2);
            if (n3 == -1) {
                return;
            }
            if (this.bMultipleSelections) {
                if (mouseEvent.isShiftDown() && mouseEvent.isControlDown()) {
                    this.bMouseDrawHandled = true;
                    this.shiftSelect(n3, true);
                } else if (mouseEvent.isShiftDown()) {
                    this.bMouseDrawHandled = true;
                    this.shiftSelect(n3, false);
                } else if (mouseEvent.isControlDown()) {
                    this.bMouseDrawHandled = true;
                    this.ctrlSelect(n3);
                } else {
                    this.setSelectedIndex(n3, true);
                }
            } else {
                this.lastTempIndex = n3;
                this.setSelectedIndex(n3, true);
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        if (mouseEvent.isPopupTrigger()) {
            this.popx = mouseEvent.getX();
            this.popy = mouseEvent.getY();
            this.sendActionEvent("Popup");
            this.requestFocus();
            return;
        }
        --this.fastDownCount;
        if (this.bMouseDrawHandled) {
            this.notifyHelper(-1, n2, -1, false);
            return;
        }
        n3 = this.mouseCalcIndex(n2);
        if (n3 == -1 || n < 0 || n >= this.lWidth) {
            this.fastDownCount = 0;
            n3 = this.lastTempIndex;
            if (n3 == -1) {
                return;
            }
        }
        if (this.bComboMode) {
            this.fastDownCount = 0;
            bl = false;
        } else if (this.fastDownCount > 0) {
            this.fastDownCount = 0;
            bl = true;
            this.prevSelectTime = -1L;
            this.prevSelectRow = -1L;
        } else {
            long l = System.currentTimeMillis();
            if (this.prevSelectTime != (long)-1 && this.prevSelectRow == (long)n3 && this.prevSelectTime + (long)250 > l) {
                bl = true;
                this.prevSelectTime = -1L;
                this.prevSelectRow = -1L;
            } else {
                bl = false;
                this.prevSelectTime = l;
                this.prevSelectRow = n3;
            }
        }
        if (this.lastSelected != n3) {
            this.setSelectedIndex(n3, true);
            this.repaint();
        }
        if (this.bMultipleSelections) {
            this.notifyHelper(n, n2, this.lastSelected, bl);
            this.lastIndex = this.lastSelected;
        } else {
            this.notifyHelper(n, n2, n3, bl);
            this.lastIndex = n3;
        }
        this.lastTempIndex = -1;
        this.lastDownModifiers = -1;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.bMultipleSelections && this.bComboMode) {
            this.lastIndex = -1;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!this.isVisible()) {
            return;
        }
        if (keyEvent.isMetaDown() || keyEvent.isAltDown()) {
            return;
        }
        int n2 = -1;
        if (keyEvent.isControlDown()) {
            switch (n) {
                case 38: {
                    n2 = this.keyCalcIndex(-1, false);
                    break;
                }
                case 40: {
                    n2 = this.keyCalcIndex(1, false);
                }
            }
            if (n2 == -1) {
                return;
            }
            if (this.bMultipleSelections) {
                this.setVisibleIndex(n2);
                this.ctrlSelect(n2);
                this.repaint();
                this.notifyHelper(-1, -1, n2, false);
                this.prevSelectTime = -1L;
                this.prevSelectRow = -1L;
            }
            return;
        }
        switch (n) {
            case 10: {
                this.sendActionEvent("Enter");
                this.requestFocus();
                break;
            }
            case 127: {
                this.sendActionEvent("Delete");
                this.requestFocus();
                break;
            }
            case 27: {
                this.sendActionEvent("Esc");
                break;
            }
            case 37: {
                this.sendActionEvent("Up");
                this.requestFocus();
                break;
            }
            case 36: {
                n2 = this.keyCalcIndex(0, true);
                break;
            }
            case 35: {
                n2 = this.keyCalcIndex(this.items.size() - 1, true);
                break;
            }
            case 33: {
                n2 = this.keyCalcIndex(-this.visibleRows, false);
                break;
            }
            case 34: {
                n2 = this.keyCalcIndex(this.visibleRows, false);
                break;
            }
            case 38: {
                n2 = this.keyCalcIndex(-1, false);
                break;
            }
            case 32: {
                n2 = this.keyCalcIndex(1, false);
                if (n2 == -1) {
                    return;
                }
                if (this.bMultipleSelections) {
                    this.setVisibleIndex(n2);
                    this.ctrlSelect(n2);
                    this.repaint();
                    this.notifyHelper(-1, -1, n2, false);
                    this.prevSelectTime = -1L;
                    this.prevSelectRow = -1L;
                }
                return;
            }
            case 40: {
                n2 = this.keyCalcIndex(1, false);
                break;
            }
            default: {
                int n3;
                if (n < 65 || n > 90) break;
                int n4 = this.lastIndex;
                if (n4 < 0 || n4 >= this.items.size()) {
                    n4 = -1;
                }
                if ((n3 = this.moveCursor(n, ++n4)) <= -1) break;
                n2 = this.keyCalcIndex(n3, true);
            }
        }
        if (n2 == -1) {
            return;
        }
        if (this.bMultipleSelections && keyEvent.isShiftDown()) {
            this.setVisibleIndex(n2);
            this.shiftSelect(n2, false);
            return;
        }
        this.setSelectedIndex(n2, true);
        this.repaint();
        this.notifyHelper(-1, -1, n2, false);
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.VBar) {
            if (adjustmentEvent.getAdjustmentType() == 5) {
                this.scrollVertical(adjustmentEvent.getValue(), true);
            } else {
                this.scrollVertical(adjustmentEvent.getAdjustmentType(), false);
            }
        } else if (adjustmentEvent.getSource() == this.HBar) {
            if (adjustmentEvent.getAdjustmentType() == 5) {
                this.scrollHorizontal(adjustmentEvent.getValue(), true);
            } else {
                this.scrollHorizontal(adjustmentEvent.getAdjustmentType(), false);
            }
        }
    }

    protected void sourceItemEvent() {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, 1));
        }
    }

    protected boolean validIndex(int n) {
        return n >= 0 && n < this.items.size();
    }

    protected boolean isVisibleIndex(int n) {
        return n >= this.nTopRow && n < this.nTopRow + this.visibleRows;
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.paramString()))).append(", selected=").append(this.getSelectedItem())));
    }

    protected void shiftSelect(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        if (this.lastSelected == -1) {
            this.setSelectedIndex(n, true);
        } else if (this.lastSelected == n) {
            if (!bl) {
                this.bInternalBlockPaint = true;
                this.setSelectedIndex(n, true);
                this.bInternalBlockPaint = false;
            }
        } else if (this.lastSelected < n) {
            if (!this.isEnabled(n)) {
                return;
            }
            if (bl) {
                n2 = this.lastSelected + 1;
                n3 = Math.min(this.items.size(), n + 1);
            } else {
                n2 = 0;
                n3 = this.items.size();
            }
            while (n2 < n3) {
                ListItem listItem = (ListItem)this.items.elementAt(n2);
                if (n2 < this.lastSelected || n2 > n) {
                    if (listItem.bSelected) {
                        listItem.bDirty = true;
                        listItem.bSelected = false;
                        --this.countSelected;
                    }
                } else if (!listItem.bSelected) {
                    listItem.bDirty = true;
                    listItem.bSelected = true;
                    ++this.countSelected;
                }
                ++n2;
            }
        } else if (this.lastSelected > n) {
            if (!this.isEnabled(n)) {
                return;
            }
            if (bl) {
                n2 = n;
                n3 = Math.min(this.items.size(), this.lastSelected);
            } else {
                n2 = 0;
                n3 = this.items.size();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                ListItem listItem = (ListItem)this.items.elementAt(n2);
                if (n2 < n || n2 > this.lastSelected) {
                    if (!listItem.bSelected) continue;
                    listItem.bDirty = true;
                    listItem.bSelected = false;
                    --this.countSelected;
                    continue;
                }
                if (listItem.bSelected) continue;
                listItem.bDirty = true;
                listItem.bSelected = true;
                ++this.countSelected;
            }
        }
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected void ctrlSelect(int n) {
        ListItem listItem = (ListItem)this.items.elementAt(n);
        if (!listItem.bEnabled) {
            return;
        }
        if (listItem.bSelected) {
            listItem.bSelected = false;
            --this.countSelected;
            this.lastSelected = -1;
        } else {
            listItem.bSelected = true;
            ++this.countSelected;
            this.lastSelected = n;
        }
        listItem.bDirty = true;
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected int mouseCalcIndex(int n) {
        int n2 = n < this.yAdj ? this.nTopRow - 1 : (n - this.yAdj) / this.cellHt + this.nTopRow;
        if (n2 >= this.items.size()) {
            n2 = -1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    protected void updateWidth(ListItem listItem) {
        int n = listItem.lineWidth + 4;
        if (listItem.image != null) {
            n += 20;
        }
        if (n > this.longestLineValue) {
            this.longestLineValue = n;
        }
        this.listChanged = true;
    }

    protected void updateWidths(FontMetrics fontMetrics) {
        int n = this.items.size();
        this.longestLineValue = 0;
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            listItem.updateWidth(fontMetrics);
            int n2 = listItem.lineWidth + 4;
            if (listItem.image != null) {
                n2 += 20;
            }
            if (n2 <= this.longestLineValue) continue;
            this.longestLineValue = n2;
        }
        this.listChanged = true;
    }

    protected void notifyHelper(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.sendActionEvent("DoubleClicked");
        } else {
            if (n >= 0 && n - this.xCoord < 20) {
                ListItem listItem = (ListItem)this.items.elementAt(n3);
                if (listItem.image != null) {
                    this.sendActionEvent("ImageSelected");
                }
            }
            this.sourceItemEvent();
        }
    }

    protected void calculateBorderColors(Color color) {
        this.borderLighterColor = Effect.hilight(color);
        this.borderDarkerColor = Effect.shadow(color);
        this.borderLightColor = Effect.darken(this.borderLighterColor, 0.2);
        this.borderDarkColor = Effect.darken(this.borderDarkerColor, 0.2);
    }

    protected int keyCalcIndex(int n, boolean bl) {
        this.lastIndex = bl ? n : (this.lastIndex += n);
        if (this.lastIndex >= this.items.size()) {
            this.lastIndex = this.items.size() - 1;
        } else if (this.lastIndex < 0) {
            this.lastIndex = 0;
        }
        return this.lastIndex;
    }

    public int moveCursor(int n, int n2) {
        int n3 = this.items.size();
        n = Character.toLowerCase((char)n);
        for (int i = n2; i < n3; ++i) {
            char c = Character.toLowerCase(this.getText(i).charAt(0));
            if (c != n) continue;
            return i;
        }
        return -1;
    }

    public void setPanelColor(Color color) {
        this.PanelColor = color;
    }

    public void setStyle(Style style) {
        this.setBackground(style.background);
        this.setForeground(style.foreground);
        this.setFont(style.font);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.VBar.setBackground(color);
        this.HBar.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (OS.isMacintosh()) {
            return;
        }
        this.textHighlightText = Color.white;
        this.enabledColor = color;
        this.disabledColor = Color.gray;
    }

    public synchronized void update(boolean bl) {
        if (bl) {
            this.bAllDirty = true;
        }
        this.paint(this.getGraphics());
    }

    public void setPainting(boolean bl) {
        this.bInternalBlockPaint = !bl;
    }

    protected void sendActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, new String(string)));
        }
    }

    public int getIndex(String string) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.sText.equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public void showIt(int n) {
        if (this.validIndex(n)) {
            n = this.keyCalcIndex(n, true);
            this.bInternalBlockPaint = false;
            this.setSelectedIndex(n, true);
            this.requestFocus();
        }
    }

    public void showIt(String string) {
        this.showIt(this.getIndex(string));
    }

    public synchronized void setTagged(int n, boolean bl) {
        ListItem listItem = (ListItem)this.items.elementAt(n);
        listItem.tagged = bl;
        listItem.bDirty = true;
        this.countTagged = bl ? ++this.countTagged : --this.countTagged;
        this.lastTagged = n;
    }

    public boolean isTagged(int n) {
        if (this.validIndex(n)) {
            return ((ListItem)this.items.elementAt((int)n)).tagged;
        }
        return false;
    }

    public boolean isTagged() {
        return this.getTaggedIndex() != -1;
    }

    public int getTaggedIndex() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            if (!((ListItem)this.items.elementAt((int)i)).tagged) continue;
            return i;
        }
        return -1;
    }

    public String getTaggedItem() {
        return this.getText(this.getTaggedIndex());
    }

    public String[] getTaggedItems() {
        VectorString vectorString = new VectorString();
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.bSelected && !listItem.tagged) continue;
            vectorString.addElement(((ListItem)this.items.elementAt((int)i)).sText);
        }
        return vectorString.toArray();
    }

    public boolean isSelected() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (listItem.bSelected) {
                return true;
            }
            if (!listItem.deleted) continue;
            return true;
        }
        return false;
    }

    public void hideSelection() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.bSelected) continue;
            listItem.bSelected = false;
            listItem.bDirty = true;
            listItem.tagged = true;
        }
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public void showSelection() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.tagged) continue;
            listItem.bSelected = true;
            listItem.tagged = false;
            listItem.bDirty = true;
        }
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public void clean() {
        this.bInternalBlockPaint = false;
        this.bAllDirty = true;
        this.deselectAll();
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        Focus() {
        }

        public void focusGained(FocusEvent focusEvent) {
            DListBox.this.hasFocus = true;
            DListBox.this.showSelection();
        }

        public void focusLost(FocusEvent focusEvent) {
            DListBox.this.hasFocus = false;
            DListBox.this.hideSelection();
        }
    }

    class MouseMotion
    implements MouseMotionListener,
    Serializable {
        MouseMotion() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!DListBox.this.bMultipleSelections) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = -1;
                if (n > -1 && n < DListBox.this.lWidth && DListBox.this.bComboMode) {
                    n3 = DListBox.this.mouseCalcIndex(n2);
                    if (n3 == -1 || n3 == DListBox.this.lastIndex) {
                        return;
                    }
                    DListBox.this.lastIndex = n3;
                    DListBox.this.setSelectedIndex(n3, true);
                    DListBox.this.repaint();
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = -1;
            if (n > -1 && n < DListBox.this.lWidth) {
                if (DListBox.this.bComboMode) {
                    n3 = DListBox.this.mouseCalcIndex(n2);
                    if (n3 == -1 || n3 == DListBox.this.lastIndex) {
                        return;
                    }
                    DListBox.this.lastIndex = n3;
                    DListBox.this.setSelectedIndex(n3, true);
                    DListBox.this.repaint();
                } else {
                    n3 = DListBox.this.mouseCalcIndex(n2);
                    if (n3 != -1 && n3 != DListBox.this.lastIndex) {
                        if (DListBox.this.bMultipleSelections) {
                            if (mouseEvent.getModifiers() != 0) {
                                return;
                            }
                            DListBox.this.bInternalBlockPaint = true;
                            DListBox.this.setVisibleIndex(n3);
                            DListBox.this.bInternalBlockPaint = false;
                            DListBox.this.shiftSelect(n3, false);
                        } else {
                            DListBox.this.setSelectedIndex(n3, true);
                        }
                        DListBox.this.lastIndex = n3;
                    }
                }
            }
        }
    }
}

