/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class ColorUtils {
    public static Color darken(int n, int n2, int n3, double d) {
        Tool.checkValidPercent(d);
        return new Color(Math.max((int)((double)n * (1.0 - d)), 0), Math.max((int)((double)n2 * (1.0 - d)), 0), Math.max((int)((double)n3 * (1.0 - d)), 0));
    }

    public static Color darken(Color color, double d) {
        Tool.checkValidPercent(d);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return ColorUtils.darken(n, n2, n3, d);
    }

    public static Color lighten(int n, int n2, int n3, double d) {
        Tool.checkValidPercent(d);
        int n4 = n + (int)((double)(255 - n) * d);
        int n5 = n2 + (int)((double)(255 - n2) * d);
        int n6 = n3 + (int)((double)(255 - n3) * d);
        return new Color(n4, n5, n6);
    }

    public static Color lighten(Color color, double d) {
        Tool.checkValidPercent(d);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return ColorUtils.lighten(n, n2, n3, d);
    }

    public static Color fade(Color color, Color color2, double d) {
        Tool.checkValidPercent(d);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getRed();
        int n5 = color2.getGreen();
        int n6 = color2.getBlue();
        int n7 = n > n4 ? n4 + (int)((double)(n - n4) * (1.0 - d)) : n4 - (int)((double)(n4 - n) * (1.0 - d));
        int n8 = n2 > n4 ? n5 + (int)((double)(n2 - n5) * (1.0 - d)) : n5 - (int)((double)(n5 - n2) * (1.0 - d));
        int n9 = n3 > n6 ? n6 + (int)((double)(n3 - n6) * (1.0 - d)) : n6 - (int)((double)(n6 - n3) * (1.0 - d));
        return new Color(n7, n8, n9);
    }

    public static double lightness(Color color) {
        if (color == null) {
            return 0.0;
        }
        double d = color.getRed();
        double d2 = color.getGreen();
        double d3 = color.getBlue();
        double d4 = Math.max(d, Math.max(d2, d3)) / (double)255 / (double)2;
        double d5 = Math.min(d, Math.min(d2, d3)) / (double)255 / (double)2;
        return d4 + d5;
    }

    public static Color calculateHilightColor(Color color) {
        if (color == null) {
            return null;
        }
        double d = ColorUtils.lightness(color);
        if (d >= 0.9) {
            return ColorUtils.darken(color, 0.1);
        }
        if (d <= 0.2) {
            return ColorUtils.lighten(color, 0.6);
        }
        return ColorUtils.lighten(color, 0.6);
    }

    public static Color calculateShadowColor(Color color) {
        if (color == null) {
            return null;
        }
        double d = ColorUtils.lightness(color);
        if (d >= 0.9) {
            return ColorUtils.darken(color, 0.25);
        }
        if (d <= 0.2) {
            return ColorUtils.lighten(color, 0.2);
        }
        return ColorUtils.darken(color, 0.25);
    }

    public static Color shadow(Color color) {
        return ColorUtils.calculateShadowColor(color);
    }
}

