/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.distribution.simple;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Date;
import org.apache.log4j.BasicConfigurator;
import org.nakedobjects.object.distribution.UpdateMessage;
import org.nakedobjects.utility.ConfigurationParameters;

public class NotifierSniffer {
    public NotifierSniffer() {
        try {
            String string = ConfigurationParameters.getInstance().getString("nakedobjects.udp-updates.group", "225.5.2.2");
            InetAddress inetAddress = InetAddress.getByName(string);
            int n = ConfigurationParameters.getInstance().getInteger("nakedobjects.udp-updates.port", 6561);
            int n2 = ConfigurationParameters.getInstance().getInteger("nakedobjects.udp-updates.size", 8192);
            System.out.println("Listening on " + inetAddress + "/" + n);
            MulticastSocket multicastSocket = new MulticastSocket(n);
            byte[] byArray = new byte[n2];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            multicastSocket.joinGroup(inetAddress);
            int n3 = 1;
            while (true) {
                System.out.print(n3++ + "... ");
                datagramPacket.setLength(n2);
                multicastSocket.receive(datagramPacket);
                System.out.print(new Date() + "/" + datagramPacket.getAddress().getHostName() + "/" + datagramPacket.getLength() + " bytes - ");
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    UpdateMessage updateMessage = (UpdateMessage)objectInputStream.readObject();
                    System.out.print(updateMessage + " " + updateMessage.getOid());
                }
                catch (Exception exception) {
                    System.out.print(" failed to extract message " + exception);
                }
                System.out.println();
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        String string = stringArray.length == 1 ? stringArray[0] : "./naked-objects.cfg";
        if (new File(string).exists()) {
            ConfigurationParameters.getInstance().load(string);
        } else {
            System.out.println("No configuration file found or loaded.");
        }
        new NotifierSniffer();
    }
}

