/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.PersistenceType;
import org.nakedobjects.object.UpdateNotifier;
import org.nakedobjects.utility.Log;
import org.nakedobjects.utility.NullLog;

public abstract class AbstractObjectStore
implements NakedObjectStore {
    private Hashtable cache = new Hashtable();
    private Log log = new NullLog();
    private UpdateNotifier notifier;

    protected AbstractObjectStore() {
    }

    public boolean areObjectsDistributed() {
        return false;
    }

    public boolean areObjectsProxied() {
        return false;
    }

    protected void broadcastAddUpdate(NakedCollection nakedCollection, NakedObject nakedObject) {
        this.notifier.broadcastAdd(nakedCollection, nakedObject);
    }

    protected void broadcastObjectUpdate(NakedObject nakedObject) {
        this.notifier.broadcastObject(nakedObject);
    }

    protected void broadcastRemoveUpdate(NakedCollection nakedCollection, NakedObject nakedObject) {
        this.notifier.broadcastRemove(nakedCollection, nakedObject);
    }

    public Enumeration cache() {
        return this.cache.elements();
    }

    public void cache(NakedObject nakedObject) {
        if (nakedObject.getOid() == null) {
            throw new IllegalArgumentException("Objects OID must be set before it can be cached");
        }
        this.cache.put(nakedObject.getOid(), nakedObject);
    }

    public Enumeration classes() throws ObjectStoreException {
        Vector vector = this.getNextInstances(NakedClass.FINDER, null, 100);
        return vector.elements();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void clearCache(NakedObject nakedObject) {
        this.cache.remove(nakedObject.getOid());
    }

    protected NakedObject getCachedObject(Object object) {
        return (NakedObject)this.cache.get(object);
    }

    protected Log getLog() {
        return this.log;
    }

    public void init() {
    }

    public boolean isObjectCached(Object object) {
        return this.cache.containsKey(object);
    }

    protected void log() {
        this.log("");
    }

    protected void log(String string) {
        if (this.log != null) {
            this.log.log(string);
        }
    }

    public PersistenceType persistenceType() {
        return PersistenceType.AUTHORITATIVE;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setUpdateNotifier(UpdateNotifier updateNotifier) {
        this.notifier = updateNotifier;
    }

    public void shutdown() {
    }

    public NakedObject createInstance(NakedClass nakedClass) throws ObjectStoreException {
        NakedObject nakedObject = nakedClass.acquireInstance();
        this.makePersistent(nakedObject);
        nakedObject.created();
        nakedObject.objectChanged();
        return nakedObject;
    }

    public abstract void startTransaction() throws ObjectStoreException;

    public abstract long serialNumber(String var1) throws ObjectStoreException;

    public abstract void save(NakedObject var1) throws ObjectStoreException;

    public abstract void resolve(NakedObject var1) throws ObjectStoreException;

    public abstract void removeElement(NakedCollection var1, NakedObject var2) throws ObjectStoreException;

    public abstract int numberOfInstances(NakedObject var1) throws ObjectStoreException;

    public abstract int numberOfElements(NakedCollection var1) throws ObjectStoreException;

    public abstract String name();

    public abstract void makePersistent(NakedObject var1) throws ObjectStoreException;

    public abstract boolean hasInstances(NakedClass var1) throws ObjectStoreException;

    public abstract void endTransaction() throws ObjectStoreException;

    public abstract void destroyObject(NakedObject var1) throws ObjectStoreException;

    public abstract boolean containsElement(NakedCollection var1, NakedObject var2) throws ObjectStoreException;

    public abstract void addElement(NakedCollection var1, NakedObject var2) throws ObjectStoreException;

    public abstract Vector getPreviousInstances(NakedObject var1, NakedObject var2, int var3) throws ObjectStoreException;

    public abstract Vector getPreviousElements(NakedCollection var1, NakedObject var2, int var3) throws ObjectStoreException;

    public abstract NakedObject getObject(Object var1) throws ObjectNotFoundException, ObjectStoreException;

    public abstract Vector getNextInstances(NakedObject var1, NakedObject var2, int var3) throws ObjectStoreException;

    public abstract Vector getNextElements(NakedCollection var1, NakedObject var2, int var3) throws ObjectStoreException;

    public abstract boolean isLastInstance(NakedObject var1, NakedObject var2) throws ObjectStoreException;

    public abstract boolean isLastElement(NakedCollection var1, NakedObject var2) throws ObjectStoreException;

    public abstract boolean isFirstInstance(NakedObject var1, NakedObject var2) throws ObjectStoreException;

    public abstract boolean isFirstElement(NakedCollection var1, NakedObject var2) throws ObjectStoreException;
}

