/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class TooHotCrosswordApplet
extends Applet {
    static final int UPWARDS = 1;
    static final int DOWNWARDS = 2;
    static final int C = 4;
    static final int A = 8;
    static final int EN = 16;
    static final int EE = 32;
    static final int ES = 64;
    static final int SW = 128;
    static final int SS = 256;
    static final int SE = 512;
    static final int AR = 4096;
    static final int H = 8192;
    static final int V = 16384;
    static final int BV = 32768;
    static final int EV = 65536;
    static final int BH = 131072;
    static final int EH = 262144;
    static final int CURPOS = 1024;
    static final int CURWORD = 2048;
    private int curX;
    private int curY;
    private int cellsX;
    private int cellsY;
    private int curDir;
    private int curQuestionPos;
    private String curQuestion;
    private String curAnswer;
    private int curAnswerX;
    private int curAnswerY;
    private Vector questions;
    private Image bImg;
    private Element[][] field;
    private int wc;
    private URL dataFileURL;
    private URL baseURL;
    private URL toohotURL;
    private boolean fontInitialized;
    private Color bgColor;
    private Color frameColor;
    private Color lineColor;
    private Color qbgColor;
    private Color abgColor;
    private Color abgcwColor;
    private Color abgccColor;
    private Color wbgColor;
    private Color qfColor;
    private Color afColor;
    private Font aFont;
    private Font qfFont;
    private Font qsFont;
    private Font qlFont;
    private FontMetrics aFontM;
    private FontMetrics qfFontM;
    private FontMetrics qsFontM;
    private FontMetrics qlFontM;
    private int drawWidth;
    private int drawHeight;
    private int qAreaHeight;
    private int qPadding;
    private int padY;
    private Toolkit toolkit;
    private Cursor handCursor;
    private Cursor defaultCursor;
    private Cursor currentCursor;
    private String[][] fielAnswer;

    public void init() {
        this.toolkit = this.getToolkit();
        this.fontInitialized = false;
        this.wc = 30;
        this.bgColor = Color.white;
        this.frameColor = Color.black;
        this.lineColor = Color.black;
        this.qbgColor = Color.darkGray;
        this.abgColor = Color.white;
        this.wbgColor = Color.black;
        this.qfColor = Color.white;
        this.afColor = Color.black;
        this.abgccColor = Color.orange;
        this.abgcwColor = Color.lightGray;
        this.curDir = 8192;
        this.curAnswer = null;
        this.bImg = null;
        this.dataFileURL = null;
        this.baseURL = this.getDocumentBase();
        String string = this.getParameter("WIDTHCELL");
        if (string != null) {
            try {
                this.wc = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.qfFont = new Font("SansSerif", 0, (int)((double)this.wc / 5.0));
        this.aFont = new Font("SansSerif", 0, (int)((double)this.wc * 0.6));
        this.qlFont = new Font("SansSerif", 0, 14);
        this.qsFont = new Font("SansSerif", 0, 10);
        this.drawHeight = this.getSize().height;
        this.drawWidth = this.getSize().width;
        this.qAreaHeight = 20;
        this.qPadding = 15;
        this.padY = this.qAreaHeight + this.qPadding;
        this.handCursor = new Cursor(12);
        this.currentCursor = this.defaultCursor = new Cursor(0);
        string = this.getParameter("DATAURL");
        if (string != null) {
            try {
                this.dataFileURL = string.indexOf(":") < 0 ? new URL(this.baseURL, string) : new URL(string);
                this.toohotURL = new URL("http://www.tea.ch/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            this.loadCrossword(this.dataFileURL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setActivePos(0, 0);
        this.requestFocus();
    }

    public void paint(Graphics graphics) {
        this.render(graphics);
        super.paint(graphics);
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.bImg == null) {
            this.bImg = this.createImage(rectangle.width, rectangle.height);
        }
        this.render(this.bImg.getGraphics());
        if (this.bImg != null) {
            graphics.drawImage(this.bImg, rectangle.x, rectangle.y, (ImageObserver)this);
            this.toolkit.sync();
        }
    }

    public void render(Graphics graphics) {
        int n2;
        if (!this.fontInitialized) {
            this.qfFontM = graphics.getFontMetrics(this.qfFont);
            this.aFontM = graphics.getFontMetrics(this.aFont);
            this.qlFontM = graphics.getFontMetrics(this.qlFont);
            this.qsFontM = graphics.getFontMetrics(this.qsFont);
            this.fontInitialized = true;
        }
        graphics.setColor(this.bgColor);
        graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
        graphics.setColor(this.qbgColor);
        graphics.fillRect(0, 0, this.drawWidth, this.qAreaHeight);
        graphics.setColor(this.frameColor);
        graphics.drawRect(0, 0, this.drawWidth - 1, this.qAreaHeight - 1);
        graphics.setColor(this.abgColor);
        graphics.fillRect(1, this.padY + 1, this.cellsX * this.wc - 1, this.cellsY * this.wc - 1);
        graphics.setFont(this.qsFont);
        graphics.setColor(this.afColor);
        graphics.drawString("TooHot Crossword Java Applet \u00a9 2002 http://www.tea.ch/", 2, this.padY - 3);
        graphics.setColor(this.qfColor);
        if (this.qlFontM.stringWidth(this.curQuestion) > this.drawWidth - 4) {
            graphics.setFont(this.qsFont);
            graphics.drawString(this.curQuestion, 2, this.qAreaHeight - 6);
        } else {
            graphics.setFont(this.qlFont);
            graphics.drawString(this.curQuestion, 2, this.qAreaHeight - 5);
        }
        int n3 = 0;
        while (n3 < this.cellsX) {
            n2 = 0;
            while (n2 < this.cellsY) {
                if (this.field[n2][n3] == null) {
                    graphics.setColor(this.qbgColor);
                    graphics.fillRect(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, this.wc - 1, this.wc - 1);
                } else {
                    if ((this.field[n2][n3].t & 0x400) == 1024) {
                        graphics.setColor(this.abgccColor);
                        graphics.fillRect(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, this.wc - 1, this.wc - 1);
                    } else if ((this.field[n2][n3].t & 0x800) == 2048) {
                        graphics.setColor(this.abgcwColor);
                        graphics.fillRect(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, this.wc - 1, this.wc - 1);
                    } else if ((this.field[n2][n3].t & 4) == 4) {
                        graphics.setColor(this.qbgColor);
                        graphics.fillRect(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, this.wc - 1, this.wc - 1);
                    }
                    if (this.field[n2][n3].g != null) {
                        graphics.setColor(this.afColor);
                        graphics.setFont(this.aFont);
                        graphics.drawString(this.field[n2][n3].g, n3 * this.wc + (this.wc - this.aFontM.stringWidth(this.field[n2][n3].g)) / 2, (int)((double)this.padY + ((double)n2 + 0.9) * (double)this.wc - (double)((this.wc - this.aFontM.getAscent()) / 2)));
                    } else if ((this.field[n2][n3].t & 4) == 4) {
                        graphics.setColor(this.qfColor);
                        if (this.field[n2][n3].fclue == null) {
                            this.drawString(this.field[n2][n3].clue, n3 * this.wc, this.padY + n2 * this.wc, graphics);
                        } else {
                            this.drawStringForm(this.field[n2][n3].fclue, n3 * this.wc, this.padY + n2 * this.wc, graphics);
                        }
                    }
                    if ((this.field[n2][n3].t & 0x1000) == 4096) {
                        if ((this.field[n2][n3].a & 0x240) == 576) {
                            if ((this.field[n2][n3].a & 0x200) == 512) {
                                this.renderArrow(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, 512, graphics);
                            }
                            if ((this.field[n2][n3].a & 0x40) == 64) {
                                this.renderArrow(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, 64, graphics);
                            }
                        } else if ((this.field[n2][n3].a & 0x120) == 288) {
                            this.renderArrow(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, 256, graphics);
                            this.renderArrow(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, 32, graphics);
                        } else {
                            this.renderArrow(1 + n3 * this.wc, this.padY + n2 * this.wc + 1, this.field[n2][n3].a, graphics);
                        }
                    }
                }
                ++n2;
            }
            ++n3;
        }
        graphics.setColor(this.lineColor);
        n2 = 1;
        while (n2 < this.cellsY) {
            graphics.drawLine(1, this.padY + n2 * this.wc, this.cellsX * this.wc - 1, this.padY + n2 * this.wc);
            ++n2;
        }
        n3 = 1;
        while (n3 < this.cellsX) {
            graphics.drawLine(n3 * this.wc, this.padY + 1, n3 * this.wc, this.padY + this.cellsY * this.wc - 1);
            ++n3;
        }
        graphics.setColor(this.frameColor);
        graphics.drawRect(0, this.padY, this.cellsX * this.wc, this.cellsY * this.wc);
    }

    protected void setActivePos(int n2, int n3) {
        int n4;
        int n5;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        this.repaint();
        if (n2 < 0 || n2 > this.cellsY - 1 || n3 < 0 || n3 > this.cellsX - 1) {
            return;
        }
        if (this.field[n2][n3] == null) {
            return;
        }
        if (this.curAnswer != null) {
            n5 = this.curAnswer.length();
            this.field[this.curY][this.curX].t &= 0xFFFFFBFF;
            if (this.curDir == 16384) {
                n4 = 0;
                while (n4 < n5) {
                    this.field[this.curAnswerY + n4][this.curAnswerX].t &= 0xFFFFF7FF;
                    ++n4;
                }
            } else {
                n4 = 0;
                while (n4 < n5) {
                    this.field[this.curAnswerY][this.curAnswerX + n4].t &= 0xFFFFF7FF;
                    ++n4;
                }
            }
            if (this.curX == n3 && this.curY == n2 && (this.field[n2][n3].d & 0x6000) == 24576) {
                int n10 = this.curDir = this.curDir == 16384 ? 8192 : 16384;
            }
        }
        if ((this.field[n2][n3].d & 0x6000) != 24576) {
            this.curDir = this.field[n2][n3].d;
        }
        if ((this.field[n2][n3].t & 4) == 4) {
            n8 = n2;
            n9 = n3;
            switch (this.field[n2][n3].d) {
                case 64: {
                    n6 = n2 + 1;
                    n7 = n3;
                    this.curDir = 8192;
                    break;
                }
                case 512: {
                    n6 = n2;
                    n7 = n3 + 1;
                    this.curDir = 16384;
                    break;
                }
                case 32: {
                    n6 = n2;
                    n7 = n3 + 1;
                    this.curDir = 8192;
                    break;
                }
                case 16: {
                    n6 = n2 - 1;
                    n7 = n3;
                    this.curDir = 8192;
                    break;
                }
                case 128: {
                    n6 = n2;
                    n7 = n3 - 1;
                    this.curDir = 16384;
                    break;
                }
                case 256: {
                    n6 = n2 + 1;
                    n7 = n3;
                    this.curDir = 16384;
                }
            }
        } else if (this.curDir == 16384) {
            n6 = n2;
            n7 = n3;
            while (n6 >= 0 && (0x8000 & this.field[n6][n7].t) != 32768) {
                --n6;
            }
            if ((0x8000 & this.field[n6][n7].t) == 32768) {
                if (n6 - 1 >= 0 && this.field[n6 - 1][n7] != null && (0x100 & this.field[n6 - 1][n7].d) == 256) {
                    n8 = n6 - 1;
                    n9 = n7;
                } else if (n7 - 1 >= 0 && this.field[n6][n7 - 1] != null && (0x200 & this.field[n6][n7 - 1].d) == 512) {
                    n8 = n6;
                    n9 = n7 - 1;
                } else if (n7 + 1 < this.cellsX && this.field[n6][n7 + 1] != null && (0x80 & this.field[n6][n7 + 1].d) == 128) {
                    n8 = n6;
                    n9 = n7 + 1;
                }
            }
        } else {
            n6 = n2;
            n7 = n3;
            while (n7 >= 0 && (0x20000 & this.field[n6][n7].t) != 131072) {
                --n7;
            }
            if ((0x20000 & this.field[n6][n7].t) == 131072) {
                if (n7 - 1 >= 0 && this.field[n6][n7 - 1] != null && (0x20 & this.field[n6][n7 - 1].d) == 32) {
                    n8 = n6;
                    n9 = n7 - 1;
                } else if (n6 - 1 >= 0 && this.field[n6 - 1][n7] != null && (0x40 & this.field[n6 - 1][n7].d) == 64) {
                    n8 = n6 - 1;
                    n9 = n7;
                } else if (n6 + 1 < this.cellsY && this.field[n6 + 1][n7] != null && (0x10 & this.field[n6 + 1][n7].d) == 16) {
                    n8 = n6 + 1;
                    n9 = n7;
                }
            }
        }
        n5 = this.field[n8][n9].answer.length();
        this.curQuestion = this.field[n8][n9].clue;
        this.curAnswer = this.field[n8][n9].answer;
        this.curAnswerX = n7;
        this.curAnswerY = n6;
        if (this.curDir == 16384) {
            n4 = 0;
            while (n4 < n5) {
                this.field[n6 + n4][n7].t |= 0x800;
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n5) {
                this.field[n6][n7 + n4].t |= 0x800;
                ++n4;
            }
        }
        if (n8 == n2 && n9 == n3) {
            this.curX = n7;
            this.curY = n6;
        } else {
            this.curX = n3;
            this.curY = n2;
        }
        this.field[this.curY][this.curX].t |= 0x400;
        this.repaint();
    }

    public boolean mouseMove(Event event, int n2, int n3) {
        if (n3 > this.qAreaHeight && n3 < this.padY) {
            this.setCursor(this.handCursor);
            this.currentCursor = this.handCursor;
            this.getAppletContext().showStatus(this.toohotURL.toString());
        } else if (this.currentCursor != this.defaultCursor) {
            this.setCursor(this.defaultCursor);
            this.currentCursor = this.defaultCursor;
        }
        return true;
    }

    public boolean mouseDown(Event event, int n2, int n3) {
        int n4 = n2;
        int n5 = n3 - this.qAreaHeight - this.qPadding;
        if (n3 > this.qAreaHeight && n3 < this.padY) {
            this.getAppletContext().showDocument(this.toohotURL);
        }
        if (n4 < 0 || n5 < 0 || n4 > this.cellsX * this.wc || n5 > this.cellsY * this.wc) {
            System.out.println("Ausserhalb");
        } else {
            int n6 = (n4 - n4 % this.wc) / this.wc;
            int n7 = (n5 - n5 % this.wc) / this.wc;
            this.setActivePos(n7, n6);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean keyDown(Event var1_1, int var2_2) {
        block19: {
            block18: {
                var3_3 = this.curY;
                var4_4 = this.curX;
                var6_5 = this.curDir;
                var7_6 = 1;
                var8_7 = new char[]{(char)var2_2};
                if (var2_2 <= 256 && var2_2 >= 32) break block18;
                switch (var2_2) {
                    case 9: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 1004: {
                        var3_3 = this.curY == 0 ? this.cellsY - 1 : this.curY - 1;
                        var6_5 = 16384;
                        var7_6 = -1;
                        break;
                    }
                    case 1005: {
                        var3_3 = (this.curY + 1) % this.cellsY;
                        var6_5 = 16384;
                        break;
                    }
                    case 1006: {
                        var4_4 = this.curX == 0 ? this.cellsX - 1 : this.curX - 1;
                        var6_5 = 8192;
                        var7_6 = -1;
                        break;
                    }
                    case 1007: {
                        var4_4 = (this.curX + 1) % this.cellsX;
                        var6_5 = 8192;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                var5_8 = 0;
                if (var6_5 != 8192) ** GOTO lbl41
                while (var5_8 < this.cellsX && this.field[var3_3][var4_4] == null || var5_8 < this.cellsX && this.field[var3_3][var4_4].clue != null) {
                    var4_4 = (this.cellsX + var4_4 + var7_6) % this.cellsX;
                    ++var5_8;
                }
                break block19;
lbl-1000:
                // 1 sources

                {
                    var3_3 = (this.cellsY + var3_3 + var7_6) % this.cellsY;
                    ++var5_8;
lbl41:
                    // 2 sources

                    ** while (var5_8 < this.cellsY && this.field[var3_3][var4_4] == null || var5_8 < this.cellsY && this.field[var3_3][var4_4].clue != null)
                }
lbl42:
                // 1 sources

                break block19;
            }
            this.field[this.curY][this.curX].g = new String(var8_7).toUpperCase();
            if (this.curY + 1 == this.cellsY && this.curX + 1 == this.cellsX) {
                var3_3 = 0;
                var4_4 = 0;
            } else if (this.curDir == 16384) {
                if (this.curY + 1 == this.cellsY) {
                    var3_3 = 0;
                    var4_4 = this.curX + 1;
                } else {
                    var3_3 = this.curY + 1;
                }
            } else if (this.curX + 1 == this.cellsX) {
                var4_4 = 0;
                var3_3 = this.curY + 1;
            } else {
                var4_4 = this.curX + 1;
            }
        }
        this.setActivePos(var3_3, var4_4);
        return true;
    }

    private void renderArrow(int n2, int n3, int n4, Graphics graphics) {
        float[] fArray = new float[]{0.2f, 0.3f, 0.2f};
        float[] fArray2 = new float[]{1.4f, 1.5f, 1.6f};
        float[] fArray3 = new float[]{-0.4f, -0.5f, -0.6f};
        float[] fArray4 = new float[]{0.2f, 0.3f, 0.2f};
        boolean bl = true;
        graphics.setColor(this.frameColor);
        if ((n4 & 0x20) == 32) {
            n2 = (int)((double)n2 - 0.2 * (double)this.wc);
            n3 -= this.wc;
        } else if ((n4 & 0x40) == 64) {
            graphics.drawLine((int)((double)n2 + 0.1 * (double)this.wc), (n3 -= this.wc) + this.wc, (int)((double)n2 + 0.1 * (double)this.wc), (int)((double)n3 + 1.5 * (double)this.wc));
            graphics.drawLine((int)((double)n2 + 0.1 * (double)this.wc), (int)((double)n3 + 1.5 * (double)this.wc), (int)((double)n2 + 0.2 * (double)this.wc), (int)((double)n3 + 1.5 * (double)this.wc));
        } else if ((n4 & 0x10) == 16) {
            graphics.drawLine((int)((double)n2 + 0.1 * (double)this.wc), (n3 -= this.wc) + 2 * this.wc, (int)((double)n2 + 0.1 * (double)this.wc), (int)((double)n3 + 1.5 * (double)this.wc));
            graphics.drawLine((int)((double)n2 + 0.1 * (double)this.wc), (int)((double)n3 + 1.5 * (double)this.wc), (int)((double)n2 + 0.2 * (double)this.wc), (int)((double)n3 + 1.5 * (double)this.wc));
        } else if ((n4 & 0x100) == 256) {
            n2 += this.wc;
            n3 = (int)((double)n3 - 0.2 * (double)this.wc);
            bl = false;
        } else if ((n4 & 0x80) == 128) {
            graphics.drawLine(n2 += this.wc, (int)((double)n3 + 0.1 * (double)this.wc), (int)((double)n2 - 0.5 * (double)this.wc), (int)((double)n3 + 0.1 * (double)this.wc));
            graphics.drawLine((int)((double)n2 - 0.5 * (double)this.wc), (int)((double)n3 + 0.1 * (double)this.wc), (int)((double)n2 - 0.5 * (double)this.wc), (int)((double)n3 + 0.2 * (double)this.wc));
            bl = false;
        } else if ((n4 & 0x200) == 512) {
            graphics.drawLine((n2 += this.wc) - this.wc, (int)((double)n3 + 0.1 * (double)this.wc), (int)((double)n2 - 0.5 * (double)this.wc), (int)((double)n3 + 0.1 * (double)this.wc));
            graphics.drawLine((int)((double)n2 - 0.5 * (double)this.wc), (int)((double)n3 + 0.1 * (double)this.wc), (int)((double)n2 - 0.5 * (double)this.wc), (int)((double)n3 + 0.2 * (double)this.wc));
            bl = false;
        }
        if (!bl) {
            fArray = fArray3;
            fArray2 = fArray4;
        }
        int[] nArray = new int[fArray.length];
        int[] nArray2 = new int[fArray2.length];
        nArray[0] = (int)((float)n2 + fArray[0] * (float)this.wc);
        nArray2[0] = (int)((float)n3 + fArray2[0] * (float)this.wc);
        int n5 = 1;
        while (n5 < fArray.length) {
            nArray[n5] = (int)((float)n2 + fArray[n5] * (float)this.wc);
            nArray2[n5] = (int)((float)n3 + fArray2[n5] * (float)this.wc);
            ++n5;
        }
        graphics.fillPolygon(nArray, nArray2, nArray.length);
    }

    private void drawString(String string, int n2, int n3, Graphics graphics) {
        int n4;
        boolean bl = false;
        FontMetrics fontMetrics = null;
        graphics.setFont(this.qfFont);
        Vector<String> vector = new Vector<String>();
        int n5 = this.qfFont.getSize();
        while (!bl) {
            fontMetrics = graphics.getFontMetrics();
            if ((double)(fontMetrics.stringWidth(string) * fontMetrics.getHeight()) / (0.8 * (double)this.wc) < 0.8 * (double)this.wc || fontMetrics.getHeight() * 15 < this.wc) {
                bl = true;
                continue;
            }
            graphics.setFont(new Font(this.qfFont.getName(), this.qfFont.getStyle(), --n5));
        }
        while ((double)fontMetrics.stringWidth(string) > (double)this.wc * 0.8) {
            n4 = 1;
            String string2 = "";
            while ((double)fontMetrics.stringWidth(string2) < (double)this.wc * 0.8) {
                string2 = string.substring(0, n4++);
            }
            vector.addElement(string.substring(0, n4 - 1).trim());
            string = string.substring(n4 - 1).trim();
        }
        vector.addElement(string);
        int n6 = fontMetrics.getHeight();
        float f2 = (this.wc - n6 * vector.size()) / 2;
        graphics.setColor(this.qfColor);
        n4 = 0;
        while (n4 < vector.size()) {
            graphics.drawString((String)vector.elementAt(n4), n2 + (this.wc - fontMetrics.stringWidth((String)vector.elementAt(n4))) / 2, (int)((float)n3 + f2 + (float)(n6 * (n4 + 1)) - 2.0f));
            ++n4;
        }
    }

    private void drawStringForm(String string, int n2, int n3, Graphics graphics) {
        int n4;
        int n5 = 0;
        graphics.setFont(this.qfFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Vector<String> vector = new Vector<String>();
        while ((n4 = string.indexOf("\\n")) > 0) {
            String string2 = string.substring(0, n4);
            vector.addElement(string2);
            string = string.substring(n4 + 2);
            if (n5 >= fontMetrics.stringWidth(string2)) continue;
            n5 = fontMetrics.stringWidth(string2);
        }
        vector.addElement(string);
        if (n5 < fontMetrics.stringWidth(string)) {
            n5 = fontMetrics.stringWidth(string);
        }
        int n6 = fontMetrics.getAscent();
        float f2 = (this.wc - n6 * vector.size()) / 2;
        graphics.setColor(this.qfColor);
        n4 = 0;
        while (n4 < vector.size()) {
            graphics.drawString((String)vector.elementAt(n4), n2 + (this.wc - n5) / 2, (int)((float)n3 + f2 + (float)(n6 * (n4 + 1)) - 2.0f));
            ++n4;
        }
    }

    public void loadCrossword(URL uRL) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        String string = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        boolean bl = false;
        this.questions = new Vector();
        while (!bl && (string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            n3 = string.indexOf(44);
            if (n3 > 0) {
                this.cellsX = n4 = Integer.parseInt(string.substring(0, n3));
                this.cellsY = n5 = Integer.parseInt(string.substring(n3 + 1));
                bl = true;
                continue;
            }
            return;
        }
        this.field = new Element[n5][];
        n3 = 0;
        while (n3 < n5) {
            this.field[n3] = new Element[n4];
            n2 = 0;
            while (n2 < n4) {
                this.field[n3][n2] = null;
                ++n2;
            }
            ++n3;
        }
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            int n6;
            if (string.startsWith("#") || (n3 = string.indexOf(44)) <= 0) continue;
            int n7 = Integer.parseInt(string.substring(0, n3));
            if ((n3 = (string = string.substring(n3 + 1)).indexOf(47)) <= 0) continue;
            int n8 = Integer.parseInt(string.substring(0, n3));
            if ((n3 = (string = string.substring(n3 + 1)).indexOf(47)) <= 0) continue;
            String string3 = string.substring(0, n3);
            if ("ES".equals(string3)) {
                n6 = 64;
            } else if ("SE".equals(string3)) {
                n6 = 512;
            } else if ("EE".equals(string3)) {
                n6 = 32;
            } else if ("EN".equals(string3)) {
                n6 = 16;
            } else if ("SW".equals(string3)) {
                n6 = 128;
            } else {
                if (!"SS".equals(string3)) continue;
                n6 = 256;
            }
            string = string.substring(n3 + 1);
            n3 = string.indexOf(61);
            String string4 = null;
            if (n3 <= 0) continue;
            String string5 = string.substring(0, n3);
            n2 = string.indexOf("//");
            if (n2 != -1) {
                string2 = string.substring(n3 + 1, n2);
                if ((string = string.substring(n2 + 2)).length() > 0) {
                    string4 = string;
                }
            } else {
                string2 = string.substring(n3 + 1);
            }
            this.insertClueAnswer(string2, string5, string4, n8, n7, n6);
            this.questions.addElement(string2);
        }
    }

    protected void insertClueAnswer(String string, String string2, String string3, int n2, int n3, int n4) {
        Element element;
        int n5 = 0;
        int n6 = 0;
        int n7 = 8192;
        this.field[n2][n3] = element = new Element(this, string, string2, string3, 4);
        int n8 = string2.length();
        switch (n4) {
            case 64: {
                n5 = n2 + 1;
                n6 = n3;
                n7 = 8192;
                break;
            }
            case 512: {
                n5 = n2;
                n6 = n3 + 1;
                n7 = 16384;
                break;
            }
            case 32: {
                n5 = n2;
                n6 = n3 + 1;
                n7 = 8192;
                break;
            }
            case 16: {
                n5 = n2 - 1;
                n6 = n3;
                n7 = 8192;
                break;
            }
            case 128: {
                n5 = n2;
                n6 = n3 - 1;
                n7 = 16384;
                break;
            }
            case 256: {
                n5 = n2 + 1;
                n6 = n3;
                n7 = 16384;
            }
        }
        this.field[n2][n3].t |= n7;
        this.field[n2][n3].d = n4;
        if (n7 == 8192) {
            int n9 = 0;
            while (n9 < n8) {
                if (this.field[n5][n6 + n9] != null) {
                    this.field[n5][n6 + n9].d |= 0x2000;
                } else {
                    this.field[n5][n6 + n9] = new Element(this, null, string2.substring(n9, n9 + 1), string3, 8);
                    this.field[n5][n6 + n9].d = 8192;
                }
                ++n9;
            }
            this.field[n5][n6].t |= 0x21000;
            this.field[n5][n6 + n8 - 1].t |= 0x40000;
        } else {
            int n10 = 0;
            while (n10 < n8) {
                if (this.field[n5 + n10][n6] != null) {
                    this.field[n5 + n10][n6].d |= 0x4000;
                } else {
                    this.field[n5 + n10][n6] = new Element(this, null, string2.substring(n10, n10 + 1), string3, 8);
                    this.field[n5 + n10][n6].d = 16384;
                }
                ++n10;
            }
            this.field[n5][n6].t |= 0x9000;
            this.field[n5 + n8 - 1][n6].t |= 0x10000;
        }
        this.field[n5][n6].a |= n4;
    }
}

