/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class FontDetails {
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    CJKFont cjkFont;
    byte[] shortTag;
    HashMap longTag;
    IntHashtable cjkTag;
    int fontType;
    boolean symbolic;
    protected boolean subset = true;

    FontDetails(PdfName pdfName, PdfIndirectReference pdfIndirectReference, BaseFont baseFont) {
        this.fontName = pdfName;
        this.indirectReference = pdfIndirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    byte[] convertToBytes(String string) {
        byte[] byArray = null;
        switch (this.fontType) {
            case 0: 
            case 1: {
                byArray = this.baseFont.convertToBytes(string);
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.shortTag[byArray[n3] & 0xFF] = 1;
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = string.length();
                int n5 = 0;
                while (n5 < n4) {
                    this.cjkTag.put(this.cjkFont.getCidCode(string.charAt(n5)), 0);
                    ++n5;
                }
                byArray = this.baseFont.convertToBytes(string);
                break;
            }
            case 3: {
                try {
                    int n6;
                    int n7 = string.length();
                    int[] nArray = null;
                    char[] cArray = new char[n7];
                    int n8 = 0;
                    if (this.symbolic) {
                        byArray = PdfEncodings.convertToBytes(string, "Cp1252");
                        n7 = byArray.length;
                        n6 = 0;
                        while (n6 < n7) {
                            nArray = this.ttu.getMetricsTT(byArray[n6] & 0xFF);
                            if (nArray != null) {
                                this.longTag.put(new Integer(nArray[0]), new int[]{nArray[0], nArray[1], this.ttu.getUnicodeDifferences(byArray[n6] & 0xFF)});
                                cArray[n8++] = (char)nArray[0];
                            }
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < n7) {
                            char c2 = string.charAt(n6);
                            nArray = this.ttu.getMetricsTT(c2);
                            if (nArray != null) {
                                int n9 = nArray[0];
                                Integer n10 = new Integer(n9);
                                if (!this.longTag.containsKey(n10)) {
                                    this.longTag.put(n10, new int[]{n9, nArray[1], c2});
                                }
                                cArray[n8++] = (char)n9;
                            }
                            ++n6;
                        }
                    }
                    String string2 = new String(cArray, 0, n8);
                    byArray = string2.getBytes("UnicodeBigUnmarked");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ExceptionConverter(unsupportedEncodingException);
                }
            }
        }
        return byArray;
    }

    void writeFont(PdfWriter pdfWriter) {
        try {
            switch (this.fontType) {
                case 0: 
                case 1: {
                    int n2;
                    int n3;
                    if (this.subset) {
                        n3 = 0;
                        while (n3 < 256) {
                            if (this.shortTag[n3] != 0) break;
                            ++n3;
                        }
                        n2 = 255;
                        while (n2 >= n3) {
                            if (this.shortTag[n2] != 0) break;
                            --n2;
                        }
                        if (n3 > 255) {
                            n3 = 255;
                            n2 = 255;
                        }
                    } else {
                        int n4 = 0;
                        while (n4 < this.shortTag.length) {
                            this.shortTag[n4] = 1;
                            ++n4;
                        }
                        n3 = 0;
                        n2 = this.shortTag.length - 1;
                    }
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{new Integer(n3), new Integer(n2), this.shortTag});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{this.longTag});
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }
}

