/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PRStream
extends PdfStream {
    protected PdfReader reader;
    protected int offset;
    protected int length;

    public PRStream(PdfReader pdfReader, int n2) {
        this.reader = pdfReader;
        this.offset = n2;
    }

    public PRStream(PdfReader pdfReader, byte[] byArray) {
        this.reader = pdfReader;
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    public void setLength(int n2) {
        this.length = n2;
        this.put(PdfName.LENGTH, new PdfNumber(n2));
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getStreamLength(PdfWriter pdfWriter) {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        return this.length + this.dicBytes.length + PdfStream.SIZESTREAM;
    }

    void writeTo(OutputStream outputStream, PdfWriter pdfWriter) throws IOException {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        outputStream.write(this.dicBytes);
        outputStream.write(PdfStream.STARTSTREAM);
        if (this.length > 0) {
            PdfEncryption pdfEncryption = pdfWriter.getEncryption();
            if (this.offset < 0) {
                if (pdfEncryption == null) {
                    outputStream.write(this.bytes);
                } else {
                    pdfEncryption.prepareKey();
                    byte[] byArray = new byte[this.length];
                    System.arraycopy(this.bytes, 0, byArray, 0, this.length);
                    pdfEncryption.encryptRC4(byArray);
                    outputStream.write(byArray);
                }
            } else {
                byte[] byArray = new byte[Math.min(this.length, 4092)];
                RandomAccessFileOrArray randomAccessFileOrArray = pdfWriter.getReaderFile(this.reader);
                randomAccessFileOrArray.seek(this.offset);
                int n2 = this.length;
                if (pdfEncryption != null) {
                    pdfEncryption.prepareKey();
                }
                while (n2 > 0) {
                    int n3 = randomAccessFileOrArray.read(byArray, 0, Math.min(n2, byArray.length));
                    n2 -= n3;
                    if (pdfEncryption != null) {
                        pdfEncryption.encryptRC4(byArray, 0, n3);
                    }
                    outputStream.write(byArray, 0, n3);
                }
            }
        }
        outputStream.write(PdfStream.ENDSTREAM);
    }
}

