/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.InflaterInputStream;

public class PdfReader {
    static final PdfName[] pageInhCandidates = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    PRTokeniser tokens;
    int[] xref;
    PdfObject[] xrefObj;
    PdfDictionary trailer;
    PdfDictionary[] pages;
    ArrayList pageInh;
    int pagesCount;

    public PdfReader(String string) throws IOException {
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) throws IOException {
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected PdfReaderInstance getPdfReaderInstance(PdfWriter pdfWriter) {
        return new PdfReaderInstance(this, pdfWriter, this.xrefObj, this.pages);
    }

    public int getNumberOfPages() {
        return this.pages.length;
    }

    public int getPageRotation(int n2) {
        PdfDictionary pdfDictionary = this.pages[n2 - 1];
        PdfNumber pdfNumber = (PdfNumber)this.getPdfObject(pdfDictionary.get(PdfName.ROTATE));
        if (pdfNumber == null) {
            return 0;
        }
        return pdfNumber.intValue();
    }

    public Rectangle getPageSizeWithRotation(int n2) {
        Rectangle rectangle = this.getPageSize(n2);
        int n3 = this.getPageRotation(n2);
        while (n3 > 0) {
            rectangle = rectangle.rotate();
            n3 -= 90;
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n2) {
        PdfDictionary pdfDictionary = this.pages[n2 - 1];
        PdfArray pdfArray = (PdfArray)this.getPdfObject(pdfDictionary.get(PdfName.MEDIABOX));
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getCropBox(int n2) {
        PdfDictionary pdfDictionary = this.pages[n2 - 1];
        PdfArray pdfArray = (PdfArray)this.getPdfObject(pdfDictionary.get(PdfName.CROPBOX));
        if (pdfArray == null) {
            return this.getPageSize(n2);
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public HashMap getInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfDictionary pdfDictionary = (PdfDictionary)this.getPdfObject(this.trailer.get(PdfName.INFO));
        if (pdfDictionary == null) {
            return hashMap;
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = this.getPdfObject(pdfDictionary.get(pdfName));
            if (pdfObject == null) continue;
            String string = pdfObject.toString();
            switch (pdfObject.type()) {
                case 3: {
                    byte[] byArray = PdfEncodings.convertToBytes(string, null);
                    if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                        string = PdfEncodings.convertToString(byArray, "UnicodeBig");
                        break;
                    }
                    string = PdfEncodings.convertToString(byArray, "PDF");
                    break;
                }
                case 4: {
                    string = PdfName.decodeName(string);
                }
            }
            hashMap.put(PdfName.decodeName(pdfName.toString()), string);
        }
        return hashMap;
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        ArrayList arrayList = pdfArray.getArrayList();
        float f2 = ((PdfNumber)arrayList.get(0)).floatValue();
        float f3 = ((PdfNumber)arrayList.get(1)).floatValue();
        float f4 = ((PdfNumber)arrayList.get(2)).floatValue();
        float f5 = ((PdfNumber)arrayList.get(3)).floatValue();
        return new Rectangle(Math.min(f2, f4), Math.min(f3, f5), Math.max(f2, f4), Math.max(f3, f5));
    }

    protected void readPdf() throws IOException {
        try {
            this.tokens.checkPdfHeader();
            this.readXref();
            this.readDocObj();
            this.readPages();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.tokens.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception exception) {}
    }

    protected PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject.type() != 10) {
            return pdfObject;
        }
        int n2 = ((PRIndirectReference)pdfObject).getNumber();
        if ((pdfObject = this.xrefObj[n2]) == null) {
            return PdfNull.PDFNULL;
        }
        return pdfObject;
    }

    protected void pushPageAttributes(PdfDictionary pdfDictionary) {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (this.pageInh.size() != 0) {
            pdfDictionary2.putAll((PdfDictionary)this.pageInh.get(this.pageInh.size() - 1));
        }
        int n2 = 0;
        while (n2 < pageInhCandidates.length) {
            PdfObject pdfObject = pdfDictionary.get(pageInhCandidates[n2]);
            if (pdfObject != null) {
                pdfDictionary2.put(pageInhCandidates[n2], pdfObject);
            }
            ++n2;
        }
        this.pageInh.add(pdfDictionary2);
    }

    protected void popPageAttributes() {
        this.pageInh.remove(this.pageInh.size() - 1);
    }

    protected void iteratePages(PdfDictionary pdfDictionary) throws IOException {
        PdfName pdfName = (PdfName)this.getPdfObject(pdfDictionary.get(PdfName.TYPE));
        if (pdfName.equals(PdfName.PAGE)) {
            PdfDictionary pdfDictionary2 = (PdfDictionary)this.pageInh.get(this.pageInh.size() - 1);
            Iterator iterator = pdfDictionary2.getKeys().iterator();
            while (iterator.hasNext()) {
                PdfName pdfName2 = (PdfName)iterator.next();
                if (pdfDictionary.get(pdfName2) != null) continue;
                pdfDictionary.put(pdfName2, pdfDictionary2.get(pdfName2));
            }
            this.pages[this.pagesCount++] = pdfDictionary;
        } else {
            this.pushPageAttributes(pdfDictionary);
            PdfArray pdfArray = (PdfArray)this.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            ArrayList arrayList = pdfArray.getArrayList();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                PdfDictionary pdfDictionary3 = (PdfDictionary)this.getPdfObject((PdfObject)arrayList.get(n2));
                this.iteratePages(pdfDictionary3);
                ++n2;
            }
            this.popPageAttributes();
        }
    }

    protected void readPages() throws IOException {
        this.pageInh = new ArrayList();
        PdfDictionary pdfDictionary = (PdfDictionary)this.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary pdfDictionary2 = (PdfDictionary)this.getPdfObject(pdfDictionary.get(PdfName.PAGES));
        PdfNumber pdfNumber = (PdfNumber)this.getPdfObject(pdfDictionary2.get(PdfName.COUNT));
        this.pages = new PdfDictionary[pdfNumber.intValue()];
        this.pagesCount = 0;
        this.iteratePages(pdfDictionary2);
        this.pageInh = null;
    }

    protected void readDocObj() throws IOException {
        int n2;
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        this.xrefObj = new PdfObject[this.xref.length];
        int n3 = 1;
        while (n3 < this.xrefObj.length) {
            n2 = this.xref[n3];
            if (n2 > 0) {
                PdfObject pdfObject;
                this.tokens.seek(n2);
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid object number.");
                }
                int n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getTokenType() != 1) {
                    this.tokens.throwError("Invalid generation number.");
                }
                int n5 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (!this.tokens.getStringValue().equals("obj")) {
                    this.tokens.throwError("Token 'obj' expected.");
                }
                this.xrefObj[n3] = pdfObject = this.readPRObject();
                if (pdfObject.type() == 7) {
                    arrayList.add(pdfObject);
                }
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            PRStream pRStream = (PRStream)arrayList.get(n2);
            PdfObject pdfObject = this.getPdfObject(pRStream.get(PdfName.LENGTH));
            pRStream.setLength(((PdfNumber)pdfObject).intValue());
            ++n2;
        }
    }

    protected void readXref() throws IOException {
        PdfNumber pdfNumber;
        int n2;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new IOException("startxref not found.");
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new IOException("startxref is not followed by a number.");
        }
        int n3 = this.tokens.intValue();
        this.tokens.seek(n3);
        while ((n2 = this.tokens.read()) != -1 && n2 != 116) {
        }
        if (n2 == -1) {
            throw new IOException("Unexpected end of file.");
        }
        this.tokens.backOnePosition();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("trailer")) {
            throw new IOException("trailer not found.");
        }
        this.trailer = (PdfDictionary)this.readPRObject();
        if (this.trailer.get(PdfName.ENCRYPT) != null) {
            throw new IOException("Encrypted files are not supported.");
        }
        PdfNumber pdfNumber2 = (PdfNumber)this.trailer.get(PdfName.SIZE);
        this.xref = new int[pdfNumber2.intValue()];
        this.tokens.seek(n3);
        this.readXrefSection();
        PdfDictionary pdfDictionary = this.trailer;
        while ((pdfNumber = (PdfNumber)pdfDictionary.get(PdfName.PREV)) != null) {
            this.tokens.seek(pdfNumber.intValue());
            this.readXrefSection();
            pdfDictionary = (PdfDictionary)this.readPRObject();
        }
    }

    protected void readXrefSection() throws IOException {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError("xref subsection not found");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block0: while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Object number of the first object in this xref subsection not found");
            }
            n2 = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError("Number of entries in this xref subsection not found");
            }
            n3 = this.tokens.intValue() + n2;
            int n6 = n2;
            while (true) {
                if (n6 >= n3) continue block0;
                this.tokens.nextValidToken();
                n4 = this.tokens.intValue();
                this.tokens.nextValidToken();
                n5 = this.tokens.intValue();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n6] == 0) {
                        this.xref[n6] = n4;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n6] == 0) {
                        this.xref[n6] = -1;
                    }
                } else {
                    this.tokens.throwError("Invalid cross-reference entry in this xref subsection");
                }
                ++n6;
            }
            break;
        }
    }

    protected PdfDictionary readDictionary() throws IOException {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError("Dictionary key is not a name.");
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue());
            PdfObject pdfObject = this.readPRObject();
            int n2 = pdfObject.type();
            if (-n2 == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            if (-n2 == 6) {
                this.tokens.throwError("Unexpected ']'");
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() throws IOException {
        PdfObject pdfObject;
        int n2;
        PdfArray pdfArray = new PdfArray();
        while (-(n2 = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n2 == 8) {
                this.tokens.throwError("Unexpected '>>'");
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() throws IOException {
        this.tokens.nextValidToken();
        int n2 = this.tokens.getTokenType();
        switch (n2) {
            case 7: {
                PdfDictionary pdfDictionary = this.readDictionary();
                int n3 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                if (this.tokens.getStringValue().equals("stream")) {
                    int n4 = this.tokens.read();
                    if (n4 == 13) {
                        n4 = this.tokens.read();
                    }
                    if (n4 != 10) {
                        this.tokens.backOnePosition();
                    }
                    PRStream pRStream = new PRStream(this, this.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    return pRStream;
                }
                this.tokens.seek(n3);
                return pdfDictionary;
            }
            case 5: {
                return this.readArray();
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                return new PdfString(this.tokens.getStringValue(), null);
            }
            case 3: {
                return new PdfName(this.tokens.getStringValue());
            }
            case 9: {
                return new PRIndirectReference(this, this.tokens.getReference(), this.tokens.getGeneration());
            }
        }
        return new PdfLiteral(-n2, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] FlateDecode(byte[] byArray, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[bl ? 4092 : 1];
        try {
            int n2;
            while ((n2 = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            int n4 = byArray[n3] & 0xFF;
            if (n4 == 62) break;
            if (!PRTokeniser.isWhitespace(n4)) {
                int n5 = PRTokeniser.getHex(n4);
                if (n5 == -1) {
                    throw new RuntimeException("Illegal character in ASCIIHexDecode.");
                }
                if (bl) {
                    n2 = n5;
                } else {
                    byteArrayOutputStream.write((byte)((n2 << 4) + n5));
                }
                bl = !bl;
            }
            ++n3;
        }
        if (!bl) {
            byteArrayOutputStream.write((byte)(n2 << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int[] nArray = new int[5];
        int n4 = 0;
        while (n4 < byArray.length) {
            n2 = byArray[n4] & 0xFF;
            if (n2 == 126) break;
            if (!PRTokeniser.isWhitespace(n2)) {
                if (n2 == 122 && n3 == 0) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(0);
                } else {
                    if (n2 < 33 || n2 > 117) {
                        throw new RuntimeException("Illegal character in ASCII85Decode.");
                    }
                    nArray[n3] = n2 - 33;
                    if (++n3 == 5) {
                        n3 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < 5) {
                            n5 = n5 * 85 + nArray[n6];
                            ++n6;
                        }
                        byteArrayOutputStream.write((byte)(n5 >> 24));
                        byteArrayOutputStream.write((byte)(n5 >> 16));
                        byteArrayOutputStream.write((byte)(n5 >> 8));
                        byteArrayOutputStream.write((byte)n5);
                    }
                }
            }
            ++n4;
        }
        n2 = 0;
        if (n3 == 1) {
            throw new RuntimeException("Illegal length in ASCII85Decode.");
        }
        if (n3 == 2) {
            n2 = nArray[0] * 85 + nArray[1];
            byteArrayOutputStream.write((byte)n2);
        } else if (n3 == 3) {
            n2 = nArray[0] * 85 * 85 + nArray[1] * 85 + nArray[2];
            byteArrayOutputStream.write((byte)(n2 >> 8));
            byteArrayOutputStream.write((byte)n2);
        } else if (n3 == 4) {
            n2 = nArray[0] * 85 * 85 * 85 + nArray[1] * 85 * 85 + nArray[2] * 85 + nArray[3];
            byteArrayOutputStream.write((byte)(n2 >> 16));
            byteArrayOutputStream.write((byte)(n2 >> 8));
            byteArrayOutputStream.write((byte)n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

