/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.cgm.BeginMetafile;
import org.freehep.graphicsio.cgm.BeginPicture;
import org.freehep.graphicsio.cgm.BeginPictureBody;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMPathConstructor;
import org.freehep.graphicsio.cgm.CGMWriter;
import org.freehep.graphicsio.cgm.CharacterHeight;
import org.freehep.graphicsio.cgm.CharacterOrientation;
import org.freehep.graphicsio.cgm.ClipIndicator;
import org.freehep.graphicsio.cgm.ColorSelectionMode;
import org.freehep.graphicsio.cgm.EdgeCap;
import org.freehep.graphicsio.cgm.EdgeColor;
import org.freehep.graphicsio.cgm.EdgeJoin;
import org.freehep.graphicsio.cgm.EdgeType;
import org.freehep.graphicsio.cgm.EdgeVisibility;
import org.freehep.graphicsio.cgm.EdgeWidth;
import org.freehep.graphicsio.cgm.EdgeWidthSpecificationMode;
import org.freehep.graphicsio.cgm.EndMetafile;
import org.freehep.graphicsio.cgm.EndPicture;
import org.freehep.graphicsio.cgm.FillColor;
import org.freehep.graphicsio.cgm.FontList;
import org.freehep.graphicsio.cgm.InteriorStyle;
import org.freehep.graphicsio.cgm.LineCap;
import org.freehep.graphicsio.cgm.LineColor;
import org.freehep.graphicsio.cgm.LineJoin;
import org.freehep.graphicsio.cgm.LineType;
import org.freehep.graphicsio.cgm.LineWidth;
import org.freehep.graphicsio.cgm.LineWidthSpecificationMode;
import org.freehep.graphicsio.cgm.MetafileDescription;
import org.freehep.graphicsio.cgm.MetafileElementList;
import org.freehep.graphicsio.cgm.MetafileVersion;
import org.freehep.graphicsio.cgm.MitreLimit;
import org.freehep.graphicsio.cgm.Text;
import org.freehep.graphicsio.cgm.TextColor;
import org.freehep.graphicsio.cgm.TextFontIndex;
import org.freehep.graphicsio.cgm.VDCExtent;
import org.freehep.graphicsio.cgm.VDCType;
import org.freehep.util.UserProperties;
import org.freehep.util.io.TaggedOutput;

public class CGMGraphics2D
extends AbstractVectorGraphicsIO {
    private static final String rootKey = (class$org$freehep$graphicsio$cgm$CGMGraphics2D == null ? (class$org$freehep$graphicsio$cgm$CGMGraphics2D = CGMGraphics2D.class$("org.freehep.graphicsio.cgm.CGMGraphics2D")) : class$org$freehep$graphicsio$cgm$CGMGraphics2D).getName();
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String BINARY = rootKey + ".Binary";
    public static final String AUTHOR = rootKey + ".Author";
    public static final String TITLE = rootKey + ".Title";
    public static final String SUBJECT = rootKey + ".Subject";
    public static final String KEYWORDS = rootKey + ".Keywords";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 1.11 $";
    private static final int CGM_VERSION = 3;
    private static final double FONTSIZE_CORRECTION = 0.8;
    private static final String[] STANDARD_FONT;
    private OutputStream ros;
    private TaggedOutput os;
    static /* synthetic */ Class class$org$freehep$graphicsio$cgm$CGMGraphics2D;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public CGMGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public CGMGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public CGMGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(this.ros);
    }

    public CGMGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.ros = os;
        this.initProperties(defaultProperties);
    }

    protected CGMGraphics2D(CGMGraphics2D graphics) {
        super(graphics, false);
        this.os = graphics.os;
    }

    public void writeHeader() throws IOException {
        this.os = this.isProperty(BINARY) ? new CGMOutputStream((OutputStream)new BufferedOutputStream(this.ros), 3) : new CGMWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.ros)), 3);
        String producer = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.writeTag(new BeginMetafile("Generated by CGMGraphics2D, FreeHEP Graphics2D Driver"));
        this.os.writeTag(new MetafileVersion(3));
        this.os.writeTag(new MetafileDescription("Producer: " + producer));
        this.os.writeTag(new MetafileDescription("Creator: " + this.getCreator()));
        this.os.writeTag(new MetafileDescription("Title: " + this.getProperty(TITLE)));
        this.os.writeTag(new MetafileDescription("Author: " + this.getProperty(AUTHOR)));
        this.os.writeTag(new MetafileDescription("Subject: " + this.getProperty(SUBJECT)));
        this.os.writeTag(new MetafileDescription("Info: " + this.getProperty(KEYWORDS)));
        if (!this.isDeviceIndependent()) {
            this.os.writeTag(new MetafileDescription("CreationDate: " + new SimpleDateFormat().format(new Date())));
        }
        this.os.writeTag(new MetafileElementList(5));
        this.os.writeTag(new VDCType(1));
        this.os.writeTag(new FontList(STANDARD_FONT));
        this.os.writeTag(new ClipIndicator(true));
        this.os.writeTag(new BeginPicture("Picture"));
        this.os.writeTag(new ColorSelectionMode(1));
        this.os.writeTag(new EdgeWidthSpecificationMode(0));
        this.os.writeTag(new LineWidthSpecificationMode(0));
        Dimension size = this.getSize();
        this.os.writeTag(new VDCExtent(new Point2D.Double(0.0, size.height), new Point2D.Double(size.width, 0.0)));
        this.os.writeTag(new BeginPictureBody());
        this.os.writeTag(new EdgeVisibility(false));
        this.os.writeTag(new EdgeCap(2));
        this.os.writeTag(new LineCap(2));
        this.os.writeTag(new EdgeColor(Color.black));
        this.os.writeTag(new FillColor(Color.black));
        this.os.writeTag(new LineColor(Color.black));
        this.os.writeTag(new TextColor(Color.black));
        this.os.writeTag(new EdgeJoin(2));
        this.os.writeTag(new LineJoin(2));
        this.os.writeTag(new EdgeType(1));
        this.os.writeTag(new LineType(1));
        this.os.writeTag(new EdgeWidth(1.0));
        this.os.writeTag(new LineWidth(1.0));
        this.os.writeTag(new InteriorStyle(1));
        this.os.writeTag(new CharacterHeight(this.getFont().getSize()));
        this.os.writeTag(new TextFontIndex(CGMGraphics2D.fontIndex(this.getFont())));
        if (this.getClip() != null) {
            this.setClip(this.getClip());
        }
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
        }
        this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
    }

    public void writeTrailer() throws IOException {
        this.os.writeTag(new EndPicture());
        this.os.writeTag(new EndMetafile());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        return new CGMGraphics2D(this);
    }

    public Graphics create(double x2, double y2, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        CGMGraphics2D graphics = new CGMGraphics2D(this);
        ((VectorGraphics)graphics).translate(x2, y2);
        ((VectorGraphics)graphics).clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
    }

    public void draw(Shape s2) {
        block3: {
            try {
                if (this.getStroke() instanceof BasicStroke) {
                    this.drawPath(s2, false);
                    break block3;
                }
                this.drawPath(this.getStroke().createStrokedShape(s2), true);
            }
            catch (IOException e2) {
                this.handleException(e2);
            }
        }
    }

    public void fill(Shape s2) {
        try {
            this.drawPath(s2, true);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public void fillAndDraw(Shape s2, Color fillColor) {
        try {
            this.setNonStrokeColor(fillColor);
            this.drawPath(s2, true);
            this.setNonStrokeColor(this.getColor());
            this.drawPath(s2, false);
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    private void drawPath(Shape s2, boolean fill) throws IOException {
        CGMPathConstructor path = new CGMPathConstructor(this.os, fill, this.getTransform());
        boolean eo = path.addPath(s2);
        path.writePolyline();
        if (!eo) {
            this.writeWarning(this.getClass() + ": cannot fill using non-zero winding rule.");
        }
    }

    public void copyArea(int x2, int y2, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        this.writeWarning(this.getClass() + ": writeImage(RenderedImage, AffineTransform, Color) not implemented.");
    }

    protected void writeString(String str, double x2, double y2) throws IOException {
        Point2D.Double point = new Point2D.Double(x2, y2);
        AffineTransform currentTransform = this.getTransform();
        this.os.writeTag(new CharacterOrientation(-currentTransform.getShearX(), -currentTransform.getScaleY(), currentTransform.getScaleX(), currentTransform.getShearY()));
        this.os.writeTag(new Text(currentTransform.transform(point, point), str));
    }

    public void drawString(AttributedCharacterIterator iterator, float x2, float y2) {
        this.writeWarning(this.getClass() + ": drawString(AttributedCharacterIterator, float, float) not implemented.");
    }

    public void drawGlyphVector(GlyphVector g2, float x2, float y2) {
        this.writeWarning(this.getClass() + ": drawGlyphVector(GlyphVector, float, float) not implemented.");
    }

    protected void writeTransform(AffineTransform t2) throws IOException {
    }

    protected void writeClip(Rectangle2D r2d) throws IOException {
        AffineTransform currentTransform = this.getTransform();
        Point2D xy = currentTransform.transform(new Point2D.Double(r2d.getX(), r2d.getY()), null);
        Point2D wh = currentTransform.deltaTransform(new Point2D.Double(r2d.getWidth(), r2d.getHeight()), null);
        r2d = new Rectangle2D.Double(xy.getX(), xy.getY(), wh.getX(), wh.getY());
    }

    protected void writeClip(Shape s2) throws IOException {
        this.writeWarning(this.getClass() + ": writeClip(Shape) not implemented.");
    }

    protected void writeWidth(float width) throws IOException {
        this.os.writeTag(new EdgeWidth(width));
        this.os.writeTag(new LineWidth(width));
    }

    protected void writeCap(int cap) throws IOException {
        switch (cap) {
            case 0: {
                this.os.writeTag(new EdgeCap(2));
                this.os.writeTag(new LineCap(2));
                break;
            }
            case 1: {
                this.os.writeTag(new EdgeCap(3));
                this.os.writeTag(new LineCap(3));
                break;
            }
            case 2: {
                this.os.writeTag(new EdgeCap(4));
                this.os.writeTag(new LineCap(4));
            }
        }
    }

    protected void writeJoin(int join) throws IOException {
        switch (join) {
            default: {
                this.os.writeTag(new EdgeJoin(2));
                this.os.writeTag(new LineJoin(2));
                break;
            }
            case 1: {
                this.os.writeTag(new EdgeJoin(3));
                this.os.writeTag(new LineJoin(3));
                break;
            }
            case 2: {
                this.os.writeTag(new EdgeJoin(4));
                this.os.writeTag(new LineJoin(4));
            }
        }
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.os.writeTag(new MitreLimit(limit));
    }

    protected void writeDash(double[] dash, double phase) throws IOException {
        switch (dash.length) {
            case 0: {
                this.os.writeTag(new EdgeType(1));
                this.os.writeTag(new LineType(1));
                break;
            }
            default: {
                this.os.writeTag(new EdgeType(2));
                this.os.writeTag(new LineType(2));
                break;
            }
            case 2: {
                this.os.writeTag(new EdgeType(3));
                this.os.writeTag(new LineType(3));
                break;
            }
            case 3: {
                this.os.writeTag(new EdgeType(4));
                this.os.writeTag(new LineType(4));
                break;
            }
            case 4: {
                this.os.writeTag(new EdgeType(5));
                this.os.writeTag(new LineType(5));
            }
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c2) throws IOException {
        this.os.writeTag(new LineColor(c2));
        this.os.writeTag(new EdgeColor(c2));
        this.os.writeTag(new FillColor(c2));
        this.os.writeTag(new TextColor(c2));
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        this.setColor(PrintColor.mixColor(paint.getColor1(), paint.getColor2()));
    }

    protected void writePaint(TexturePaint p2) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(TexturePaint) not implemented.");
    }

    protected void writePaint(Paint p2) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + p2.getClass());
    }

    public void setFont(Font font) {
        super.setFont(font);
        try {
            this.os.writeTag(new TextFontIndex(CGMGraphics2D.fontIndex(font)));
            this.os.writeTag(new CharacterHeight((double)font.getSize() * 0.8));
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s2, boolean onStroke) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String comment) throws IOException {
    }

    public String toString() {
        return "CGMGraphics2D";
    }

    private static int fontIndex(Font font) {
        StringBuffer fontName = new StringBuffer(font.getName());
        if (font.isBold() || font.isItalic()) {
            fontName.append("-");
        }
        if (font.isBold()) {
            fontName.append("Bold");
        }
        if (font.isItalic()) {
            fontName.append("Italic");
        }
        String name = fontName.toString();
        int i2 = 0;
        while (i2 < STANDARD_FONT.length) {
            if (name.equals(STANDARD_FONT[i2])) {
                return i2 + 1;
            }
            ++i2;
        }
        return 5;
    }

    private void setNonStrokeColor(Color c2) throws IOException {
        this.os.writeTag(new FillColor(this.getPrintColor(c2)));
    }

    private void setStrokeColor(Color c2) throws IOException {
        this.os.writeTag(new LineColor(this.getPrintColor(c2)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(BINARY, true);
        defaultProperties.setProperty(AUTHOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(SUBJECT, "");
        defaultProperties.setProperty(KEYWORDS, "");
        STANDARD_FONT = new String[]{"Courier", "Courier-Bold", "Courier-Italic", "Courier-BoldItalic", "Helvetica", "Helvetica-Bold", "Helvetica-Italic", "Helvetica-BoldItalic", "TimesRoman", "TimesRoman-Bold", "TimesRoman-Italic", "TimesRoman-BoldItalic", "Symbol", "ZapfDingbats"};
    }
}

