/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import org.freehep.graphicsio.pdf.PDFConstants;

public class PDFUtil
implements PDFConstants {
    private static final NumberFormat fixedPrecision = NumberFormat.getNumberInstance(Locale.US);

    private PDFUtil() {
    }

    public static String escape(String string) {
        StringBuffer escape = new StringBuffer();
        int i2 = 0;
        while (i2 < string.length()) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '(': 
                case ')': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c2);
                    break;
                }
                default: {
                    escape.append(c2);
                }
            }
            ++i2;
        }
        return escape.toString();
    }

    public static String date(Calendar date) {
        String tz;
        int offset = date.get(15) + date.get(16);
        if (offset == 0) {
            tz = "Z";
        } else {
            DecimalFormat fmt = new DecimalFormat("00");
            int tzh = Math.abs(offset / 3600000);
            int tzm = Math.abs(offset % 3600000);
            tz = offset > 0 ? "+" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'" : "-" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'";
        }
        return "(D:" + PDFConstants.dateFormat.format(date.getTime()) + tz + ")";
    }

    public static String fixedPrecision(double v2) {
        return fixedPrecision.format(v2);
    }

    static {
        if (fixedPrecision instanceof DecimalFormat) {
            ((DecimalFormat)fixedPrecision).applyPattern("0.#####");
        }
    }
}

