/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class RotatedRectangleSelectionPanel
extends AbstractRegionSelectionPanel {
    private static final int STARTING_WIDTH = 25;

    public int getNumberOfControlPoints() {
        return 6;
    }

    public Cursor getControlPointCursor(int index) {
        String type;
        int k2;
        switch (index) {
            case 0: 
            case 3: {
                k2 = 4;
                type = "Resize";
                break;
            }
            case 1: 
            case 2: {
                k2 = 5;
                type = "Resize";
                break;
            }
            case 4: {
                k2 = 5;
                type = "Rotation";
                break;
            }
            case 5: {
                k2 = 4;
                type = "Rotation";
                break;
            }
            default: {
                return FreeHepImage.getCursor("RotatedRectangleCursor");
            }
        }
        return AbstractRegionSelectionPanel.compassCursor(type, this.xCtrlPts[index] - this.xCtrlPts[k2], this.yCtrlPts[index] - this.yCtrlPts[k2], 8, true);
    }

    public void initializeControlPoints(int x2, int y2) {
        this.activeCtrlPt = 5;
        Arrays.fill(this.yCtrlPts, y2);
        this.xCtrlPts[0] = x2 - 25;
        this.xCtrlPts[1] = x2 - 25;
        this.xCtrlPts[2] = x2 + 25;
        this.xCtrlPts[3] = x2 + 25;
        this.xCtrlPts[4] = x2;
        this.xCtrlPts[5] = x2;
    }

    public void updateActiveControlPoint(int x2, int y2) {
        x2 = this.forceXCoordinateWithinBounds(x2);
        y2 = this.forceYCoordinateWithinBounds(y2);
        switch (this.activeCtrlPt) {
            case 0: {
                double radius = this.getRadius(x2, y2, 4);
                double angle = this.getAngle();
                int deltax = x2 - this.xCtrlPts[4];
                int deltay = y2 - this.yCtrlPts[4];
                int dx = (int)(-Math.round(radius * Math.sin(angle)));
                int dy = (int)Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.xCtrlPts[0] = this.xCtrlPts[4] + dx;
                this.yCtrlPts[0] = this.yCtrlPts[4] + dy;
                this.xCtrlPts[3] = this.xCtrlPts[4] - dx;
                this.yCtrlPts[3] = this.yCtrlPts[4] - dy;
                this.xCtrlPts[1] = this.xCtrlPts[5] + dx;
                this.yCtrlPts[1] = this.yCtrlPts[5] + dy;
                this.xCtrlPts[2] = this.xCtrlPts[5] - dx;
                this.yCtrlPts[2] = this.yCtrlPts[5] - dy;
                break;
            }
            case 1: {
                double radius = this.getRadius(x2, y2, 5);
                double angle = this.getAngle();
                int deltax = x2 - this.xCtrlPts[5];
                int deltay = y2 - this.yCtrlPts[5];
                int dx = (int)(-Math.round(radius * Math.sin(angle)));
                int dy = (int)Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.xCtrlPts[0] = this.xCtrlPts[4] + dx;
                this.yCtrlPts[0] = this.yCtrlPts[4] + dy;
                this.xCtrlPts[3] = this.xCtrlPts[4] - dx;
                this.yCtrlPts[3] = this.yCtrlPts[4] - dy;
                this.xCtrlPts[1] = this.xCtrlPts[5] + dx;
                this.yCtrlPts[1] = this.yCtrlPts[5] + dy;
                this.xCtrlPts[2] = this.xCtrlPts[5] - dx;
                this.yCtrlPts[2] = this.yCtrlPts[5] - dy;
                break;
            }
            case 2: {
                double radius = this.getRadius(x2, y2, 5);
                double angle = this.getAngle();
                int deltax = x2 - this.xCtrlPts[5];
                int deltay = y2 - this.yCtrlPts[5];
                int dx = (int)(-Math.round(radius * Math.sin(angle)));
                int dy = (int)Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.xCtrlPts[0] = this.xCtrlPts[4] - dx;
                this.yCtrlPts[0] = this.yCtrlPts[4] - dy;
                this.xCtrlPts[3] = this.xCtrlPts[4] + dx;
                this.yCtrlPts[3] = this.yCtrlPts[4] + dy;
                this.xCtrlPts[1] = this.xCtrlPts[5] - dx;
                this.yCtrlPts[1] = this.yCtrlPts[5] - dy;
                this.xCtrlPts[2] = this.xCtrlPts[5] + dx;
                this.yCtrlPts[2] = this.yCtrlPts[5] + dy;
                break;
            }
            case 3: {
                double radius = this.getRadius(x2, y2, 4);
                double angle = this.getAngle();
                int deltax = x2 - this.xCtrlPts[4];
                int deltay = y2 - this.yCtrlPts[4];
                int dx = (int)(-Math.round(radius * Math.sin(angle)));
                int dy = (int)Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.xCtrlPts[0] = this.xCtrlPts[4] - dx;
                this.yCtrlPts[0] = this.yCtrlPts[4] - dy;
                this.xCtrlPts[3] = this.xCtrlPts[4] + dx;
                this.yCtrlPts[3] = this.yCtrlPts[4] + dy;
                this.xCtrlPts[1] = this.xCtrlPts[5] - dx;
                this.yCtrlPts[1] = this.yCtrlPts[5] - dy;
                this.xCtrlPts[2] = this.xCtrlPts[5] + dx;
                this.yCtrlPts[2] = this.yCtrlPts[5] + dy;
                break;
            }
            case 4: 
            case 5: {
                double radius = this.getRadius(this.xCtrlPts[0], this.yCtrlPts[0], 4);
                this.xCtrlPts[this.activeCtrlPt] = x2;
                this.yCtrlPts[this.activeCtrlPt] = y2;
                double angle = this.getAngle();
                int dx = (int)(-Math.round(radius * Math.sin(angle)));
                int dy = (int)Math.round(radius * Math.cos(angle));
                this.xCtrlPts[0] = this.xCtrlPts[4] + dx;
                this.yCtrlPts[0] = this.yCtrlPts[4] + dy;
                this.xCtrlPts[3] = this.xCtrlPts[4] - dx;
                this.yCtrlPts[3] = this.yCtrlPts[4] - dy;
                this.xCtrlPts[1] = this.xCtrlPts[5] + dx;
                this.yCtrlPts[1] = this.yCtrlPts[5] + dy;
                this.xCtrlPts[2] = this.xCtrlPts[5] - dx;
                this.yCtrlPts[2] = this.yCtrlPts[5] - dy;
                break;
            }
        }
        this.repaintPanel();
    }

    private double getRadius(int x2, int y2, int ctrlPt) {
        int dx = x2 - this.xCtrlPts[ctrlPt];
        int dy = y2 - this.yCtrlPts[ctrlPt];
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double getAngle() {
        double deltax = this.xCtrlPts[5] - this.xCtrlPts[4];
        double deltay = this.yCtrlPts[5] - this.yCtrlPts[4];
        if (deltax != 0.0 || deltay != 0.0) {
            return Math.atan2(deltay, deltax);
        }
        return 0.0;
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setStroke(GraphicalSelectionPanel.thickStroke);
            g2.setColor(Color.black);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g2.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            g2d.setStroke(GraphicalSelectionPanel.thinStroke);
            g2.setColor(Color.white);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g2.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            if (this.activeCtrlPt >= 0) {
                g2.setColor(Color.black);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3);
                g2.setColor(Color.white);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int first = 0;
        int savedValue = this.xCtrlPts[0] * this.xCtrlPts[0] + this.yCtrlPts[0] * this.yCtrlPts[0];
        int i2 = 1;
        while (i2 < 4) {
            int value = this.xCtrlPts[i2] * this.xCtrlPts[i2] + this.yCtrlPts[i2] * this.yCtrlPts[i2];
            if (value < savedValue) {
                savedValue = value;
                first = i2;
            }
            ++i2;
        }
        int third = (first + 2) % 4;
        int dx0 = this.xCtrlPts[third] - this.xCtrlPts[first];
        int second = (first + 1) % 4;
        int dy1 = this.yCtrlPts[second] - this.yCtrlPts[first];
        int dy0 = this.yCtrlPts[third] - this.yCtrlPts[first];
        int dx1 = this.xCtrlPts[second] - this.xCtrlPts[first];
        if (dx0 * dy1 - dy0 * dx1 > 0) {
            second = (first + 3) % 4;
        }
        int centerIndex = first == 0 || first == 3 ? 4 : 5;
        double radius = this.getRadius(this.xCtrlPts[first], this.yCtrlPts[first], centerIndex);
        double angle = this.getAngle();
        double dx = Math.abs(radius * Math.sin(angle));
        double dy = Math.abs(radius * Math.cos(angle));
        centerIndex = first == 0 || first == 3 ? 4 : 5;
        double sdx = this.xCtrlPts[first] - this.xCtrlPts[centerIndex] > 0 ? 1.0 : -1.0;
        double sdy = this.yCtrlPts[first] - this.yCtrlPts[centerIndex] > 0 ? 1.0 : -1.0;
        double x0 = (double)this.xCtrlPts[centerIndex] + sdx * dx;
        double y0 = (double)this.yCtrlPts[centerIndex] + sdy * dy;
        centerIndex = second == 0 || second == 3 ? 4 : 5;
        sdx = this.xCtrlPts[second] - this.xCtrlPts[centerIndex] > 0 ? 1.0 : -1.0;
        sdy = this.yCtrlPts[second] - this.yCtrlPts[centerIndex] > 0 ? 1.0 : -1.0;
        double x1 = (double)this.xCtrlPts[centerIndex] + sdx * dx;
        double y1 = (double)this.yCtrlPts[centerIndex] + sdy * dy;
        centerIndex = third == 0 || third == 3 ? 4 : 5;
        sdx = this.xCtrlPts[third] - this.xCtrlPts[centerIndex] > 0 ? 1.0 : -1.0;
        sdy = this.yCtrlPts[third] - this.yCtrlPts[centerIndex] > 0 ? 1.0 : -1.0;
        double x2 = (double)this.xCtrlPts[centerIndex] + sdx * dx;
        double y2 = (double)this.yCtrlPts[centerIndex] + sdy * dy;
        return this.makeTransform(x0, y0, x1, y1, x2, y2);
    }

    public boolean isValidSelection() {
        return !(!this.visible || this.xCtrlPts[4] == this.xCtrlPts[5] && this.yCtrlPts[4] == this.yCtrlPts[5] || this.xCtrlPts[0] == this.xCtrlPts[3] && this.yCtrlPts[0] == this.yCtrlPts[3]);
    }
}

