/** \file DS_Dictionary.h
    Efficient string lookup

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_DS_DICTIONARY
#define H_DS_DICTIONARY

#include <DS_Exceptions.h>
#include <DS_Containable.h>

#ifndef BASE_NODE 
  #define BASE_NODE void
#endif

/** Word Dictionary.  
    An alternative to a Hashtable of subclasses of SimpleString_Containable
    Provides translation from text word (any string) to a Containable subclass */
class Dictionary
{
public:
  /** Default Constructor */
  Dictionary();

  /** Copy Constructor */
  Dictionary(const Dictionary& D);

  /** Destructor */
  virtual ~Dictionary();

  /** Assignment operator. */
  Dictionary& operator=(const Dictionary& D);

  /** Add a new word to the dictionary. 
      len indicates the length of the word.
      Value is the data associated with the word.
      Method throws WordExists if the word is already in the dictionary.
  */
  void addWord(const char* word, const int len, const Data Value);

  /** Add a new word to the dictionary. 
      Value is the data associated with the word.
      Method throws WordExists if the word is already in the dictionary.
  */
  void addWord(const String& word, const Data Value);

  /** Retrieve an association from the Dictionary.
      Value will be set if the word is found.
      Method throws WordNotFound if the word is not in the dictionary.
  */
  int  getWord(const char* word, const int len, Data& Value);

  /** Retrieve an association from the Dictionary.
      Value will be set if the word is found.
      Method throws WordNotFound if the word is not in the dictionary.
  */
  int  getWord(const String& word, Data& Value);

  /** Returns non-zero if there are words in the dictionary. */
  int  isEmpty() const;

  // Exception thrown when a word is not found
  class WordNotFound : public ConsistencyException 
  {
  public:
    WordNotFound() : ConsistencyException("Word Not Found")
    {}
  };
  
  // Exception thrown when trying to add an existing word
  class WordExists : public ConsistencyException 
  {
  public:
    WordExists() : ConsistencyException("Word Exists")
    {}
  };

protected:
  BASE_NODE *m_Root;
};

#endif // H_DS_DICTIONARY
