//
//                oooooooooo.
//                `888'   `Y8b
//                 888     888  .ooooo.    oooooooo  .ooooo.
//                 888oooo888' d88' `88b  d'""7d8P  d88' `88b
//                 888    `88b 888   888    .d8P'   888   888
//                 888    .88P 888   888  .d8P'  .P 888   888
//                o888bood8P'  `Y8bod8P' d8888888P  `Y8bod8P'
//                           _
//                          /_\     |    _  _ | _ ._
//                         /   \  \_||_|(_|(_||(/_|
//                                       _| _|
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// Bozo TASK
//
//      This module contains the high-level tasking routines and data
//  structures.
//
//

#ifndef __BZ_TASK_H
#define __BZ_TASK_H 1

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

#ifdef __cplusplus
extern "C" {
#endif

//
//
//                                Includes
//
//

#include <ivory.h>

#include "bzartn.h"

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

// Forward reference
struct _bz_task_queue;

typedef struct _bz_task bz_task;
struct _bz_task
{
    bz_task     *next;

    void        *tls;
    void        *creation_parameters;   // Should only be passed in?

    // Forward reference
    struct _bz_task_queue   *queue;

    bz_context  context;
};


//
//
//                                  Data
//
//

// The current task
extern bz_task *Task;

//
//
//                               Prototypes
//
//

bz_task *bz_init_task (IvorySubAlloc *);
void bz_set_allocator (IvorySubAlloc *);

typedef void (*bz_task_func) (void *);
bz_task *bz_create (bz_task_func, int, void *);
bz_task *bz_spawn  (bz_task_func, int, void *);
void    bz_term    (bz_task *);

void    bz_return (void);

// A note to the compiler....
//#pragma aux bz_return aborts

//
// A few routines for a task to call for information about itself.

// During task creation, this value is set by the creating task.
void *bz_get_params (void);

// Each task has a pointer all its own.  This can be used to hold
// instance specific data in addition to the passed parameters.
void *bz_get_tls (void);
void  bz_set_tls (void *);

#ifdef __cplusplus
};
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - bztask.h 
