//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// global.hpp
//
//

#ifndef __GLOBAL_HPP
#define __GLOBAL_HPP    1

//
//
//                                Includes
//
//

// NOTE: the including file must define any Windows control defines

#include <windows.h>
#include <stdio.h>

#include "portable.h"
#include "debug.h"

#include <chronos.hpp>
#include <ivory.hpp>
#include <max.hpp>
#include <vangogh.hpp>
#include <gutenbrg.hpp>

#include "escher.hpp"

//
//
//                                Equates
//
//

#if defined (WIN32)
        #define IS_WIN32 TRUE
#else
        #define IS_WIN32 FALSE
#endif
#define IS_NT      IS_WIN32 && (BOOL)(GetVersion() < 0x80000000)
#define IS_WIN32S  IS_WIN32 && (BOOL)(!(IS_NT) && (LOBYTE(LOWORD(GetVersion()))<4))
#define IS_CHICAGO (BOOL)(!(IS_NT) && !(IS_WIN32S)) && IS_WIN32

//
//
//                               Structures
//
//

//
//
//                                Classes
//
//

class EscherTest
{
protected:
    TCHAR   szFileName[MAX_PATH];

    MaxDevices      *devs;
    MaxEventSource  *evt;           // Source of our events
    MaxEventListOneshot oneshot;    // Track events for single_events
    MaxEventListToggle  toggles;
    MaxEventList    events;         // Most current event set
    MaxEventList    single_events;  // Most current event set, momentary
    MaxEventList    toggle_events;

    void draw_extents(EschMeshDraw *ptr);

public:     // Construction/Destruction
//    enum { MAP_XSIZE = 320, MAP_YSIZE = 240 };
//    enum { MAP_XSIZE = 640, MAP_YSIZE = 480 };
    enum { MAP_XSIZE = 284, MAP_YSIZE = 256 };
//    enum { MAP_XSIZE = 144, MAP_YSIZE = 128 };
//    enum { MAP_XSIZE = 400, MAP_YSIZE = 400};

    BITMAPINFO      *bmi;
    BYTE            *gmap;
    VngoVport       *gvp;
    VngoPal         *mypal;
    HPALETTE        hpal;
    HDC             hdc;

    VngoScreenManager  *screen;
    int             map_xsize;
    int             map_ysize;

    EscherTest (MaxDevices *);
    ~EscherTest ();

    BOOL    active;

    BOOL    show_fps;
    BOOL    pick_test;
    BOOL    collide_test;
    BOOL    use_new_terrain;
    float   mbox_size;
    long    alpha;

    // key-frame animation data
    BOOL    keyframe_animation;
    float   anim_time;
    float   anim_step_time;
    float   anim_current_step;
    int     anim_current_frame;
    int     anim_chain_count;
    float   anim_max_compress;
    EschKeyframeDraw *anim_root;
    float   scale;

    // particle system data
    int     part_count;
    float   part_speed;
    float   part_life;
    int     part_linear;
    int     part_alpha;
    float   part_rotrate;
    float   part_rotrate_low;
    float   part_rotrate_high;

    EschCameraEx            *cam;
    EschLight               *light;
    EschDrawable            *draws;
    EschScene               *scene;
    EschTerrain             *terrain;
    EschParticleGenerator   *prtgen;
    EschStarfield           *starfield;
    EschPlosion             *explosion;
    EschMeshDraw            *curmesh;
    EschFireTexture         *fire;
    EschPartition           *partn;
    EschSprite              *sprite;
    EschMetabox             *metabox;
    EschPlaneDraw           *plane;
    EschMultiFrameTexture   *mtxt;
    EschTerrainTreeTop      *trees;
    int                     drawexts;
    int                     drawpartn;
    dword                   exts_color;
    float                   RotateDegrees;
    float                   ScriptRotateDegrees;

    XFBitmap                *backgrnd;

    Chronometer             fps_clock;
    long                    frames;
    long                    total_frames;
    long                    total_time;

    Chronometer             clock;
    Chronometer             anim_clock;

    BOOL SetupFireTest();
    BOOL SetupPartitionTest(const char *buff);
    BOOL SetupMultiTest(const char *name);
    BOOL SetupSprite(const char *name);

    BOOL LoadScene(char *fn, dword in_type=ESCH_SCENELD_ALL);
    BOOL LoadTreeTops(const char *buff);
    BOOL LoadTerrain(char *fn);
    BOOL SetupParticleSystem(const char *name);
    BOOL SetupStarfield(BOOL fixed, BOOL brights);
    BOOL SetupExplosion(const char *buff);
    BOOL SetupMetabox(const char *buff);
    BOOL SetupPlane(const char *buff);
    BOOL SetupAnimation(const char *buff);
    void update_keys(float interval);

    void Animate();

    void Begin();
    void End(char *buff);

            // Per-Frame Members
    virtual BOOL    PumpWindows ();
    virtual void    LoadEvents (LPCSTR lpszFile);
    virtual void    GetEvents ();
    virtual void    ProcessEvents();
    virtual void    Render();
    virtual void    Display();

    int MessageBox(LPCSTR lpText, UINT nType);
};


//
//
//                               Prototypes
//
//

//
//
//                                 Data
//
//

extern HINSTANCE   hInst;         // current instance
extern HWND        hWndClient;    // Main window handle
extern const char  szAppName[];
extern EscherTest   *game;


#endif

// End of header - global.hpp 

