/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.os.Shortcut;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class ShortcutPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final String SEPARATOR_LINE = "--------------------------------------------------------------------------------";
    private static final String TEXT_FILE_NAME = "Shortcuts.txt";
    private static final String SPEC_FILE_NAME = "shortcutSpec.xml";
    private static final String SPEC_KEY_NOT_SUPPORTED = "notSupported";
    private static final String SPEC_KEY_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_KEY_SHORTCUT = "shortcut";
    private static final String SPEC_KEY_PACKS = "createForPack";
    private static final String SPEC_ATTRIBUTE_DEFAULT_GROUP = "defaultName";
    private static final String SPEC_ATTRIBUTE_LOCATION = "location";
    private static final String SPEC_ATTRIBUTE_NAME = "name";
    private static final String SPEC_ATTRIBUTE_SUBGROUP = "subgroup";
    private static final String SPEC_ATTRIBUTE_DESCRIPTION = "description";
    private static final String SPEC_ATTRIBUTE_TARGET = "target";
    private static final String SPEC_ATTRIBUTE_COMMAND = "commandLine";
    private static final String SPEC_ATTRIBUTE_ICON = "iconFile";
    private static final String SPEC_ATTRIBUTE_ICON_INDEX = "iconIndex";
    private static final String SPEC_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    private static final String SPEC_ATTRIBUTE_INITIAL_STATE = "initialState";
    private static final String SPEC_ATTRIBUTE_DESKTOP = "desktop";
    private static final String SPEC_ATTRIBUTE_APPLICATIONS = "applications";
    private static final String SPEC_ATTRIBUTE_START_MENU = "startMenu";
    private static final String SPEC_ATTRIBUTE_STARTUP = "startup";
    private static final String SPEC_ATTRIBUTE_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_VALUE_APPLICATIONS = "applications";
    private static final String SPEC_VALUE_START_MENU = "startMenu";
    private static final String SPEC_VALUE_NO_SHOW = "noShow";
    private static final String SPEC_VALUE_NORMAL = "normal";
    private static final String SPEC_VALUE_MAXIMIZED = "maximized";
    private static final String SPEC_VALUE_MINIMIZED = "minimized";
    private static final String AUTO_KEY_PROGRAM_GROUP = "programGroup";
    private static final String AUTO_KEY_SHORTCUT = "shortcut";
    private static final String AUTO_ATTRIBUTE_NAME = "name";
    private static final String AUTO_ATTRIBUTE_GROUP = "group";
    private static final String AUTO_ATTRIBUTE_TYPE = "type";
    private static final String AUTO_ATTRIBUTE_COMMAND = "commandLine";
    private static final String AUTO_ATTRIBUTE_DESCRIPTION = "description";
    private static final String AUTO_ATTRIBUTE_ICON = "icon";
    private static final String AUTO_ATTRIBUTE_ICON_INDEX = "iconIndex";
    private static final String AUTO_ATTRIBUTE_INITIAL_STATE = "initialState";
    private static final String AUTO_ATTRIBUTE_TARGET = "target";
    private static final String AUTO_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    private JLabel listLabel;
    private JList groupList;
    private JList targetList;
    private JTextField programGroup;
    private JButton defaultButton;
    private JButton createButton;
    private JButton saveButton;
    private JCheckBox allowDesktopShortcut;
    private JRadioButton currentUser;
    private JRadioButton allUsers;
    private GridBagLayout layout;
    private GridBagConstraints constraints;
    private String suggestedProgramGroup;
    private String groupName;
    private int groupLocation;
    private XMLElement spec;
    private boolean hasDesktopShortcuts = false;
    private Shortcut shortcut;
    private Vector shortcuts = new Vector();
    private Vector files = new Vector();
    private boolean shortcutsToCreate = false;
    private boolean haveShortcutSpec = false;
    private boolean simulteNotSupported = false;
    private boolean firstTime = true;

    public ShortcutPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        try {
            this.readShortcutSpec();
        }
        catch (Throwable throwable) {
            System.out.println("could not read shortcut spec!");
            throwable.printStackTrace();
        }
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        try {
            this.shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            this.shortcut.initialize(1, "-");
        }
        catch (Throwable throwable) {
            System.out.println("could not create shortcut instance");
            throwable.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.currentUser)) {
            this.groupList.setListData(this.shortcut.getProgramGroups(1));
            this.programGroup.setText(this.suggestedProgramGroup);
            this.shortcut.setUserType(1);
        } else if (object.equals(this.allUsers)) {
            this.groupList.setListData(this.shortcut.getProgramGroups(2));
            this.programGroup.setText(this.suggestedProgramGroup);
            this.shortcut.setUserType(2);
        } else if (object.equals(this.createButton)) {
            try {
                this.groupName = this.programGroup.getText();
            }
            catch (Throwable throwable) {
                this.groupName = "";
            }
            this.createShortcuts();
            this.addToUninstaller();
            this.parent.unlockNextButton();
            this.parent.lockPrevButton();
        } else if (object.equals(this.defaultButton)) {
            this.groupList.getSelectionModel().clearSelection();
            this.programGroup.setText(this.suggestedProgramGroup);
        } else if (object.equals(this.saveButton)) {
            this.saveToFile();
            this.addToUninstaller();
        }
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        if (!this.firstTime) {
            return;
        }
        this.firstTime = false;
        this.analyzeShortcutSpec();
        if (this.shortcutsToCreate) {
            if (this.shortcut.supported() && !this.simulteNotSupported) {
                this.parent.lockPrevButton();
                this.parent.lockNextButton();
                this.buildUI(this.shortcut.getProgramGroups(0), true);
            } else {
                this.buildAlternateUI();
                this.parent.unlockNextButton();
                this.parent.lockPrevButton();
            }
        } else {
            this.parent.skipPanel();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.programGroup == null) {
            return;
        }
        String string = "";
        try {
            string = (String)this.groupList.getSelectedValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (string == null) {
            string = "";
        }
        this.programGroup.setText(string);
    }

    private void readShortcutSpec() throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = this.parent.getResource(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            this.haveShortcutSpec = false;
            return;
        }
        if (inputStream == null) {
            this.haveShortcutSpec = false;
            return;
        }
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setValidator(new NonValidator());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        this.spec = (XMLElement)stdXMLParser.parse();
        inputStream.close();
        this.haveShortcutSpec = true;
    }

    private void analyzeShortcutSpec() {
        if (!this.haveShortcutSpec) {
            this.shortcutsToCreate = false;
            return;
        }
        XMLElement xMLElement = this.spec.getFirstChildNamed(SPEC_KEY_NOT_SUPPORTED);
        if (xMLElement != null) {
            this.simulteNotSupported = true;
        }
        XMLElement xMLElement2 = this.spec.getFirstChildNamed("programGroup");
        String string = null;
        this.hasDesktopShortcuts = false;
        if (xMLElement2 != null) {
            this.suggestedProgramGroup = xMLElement2.getAttribute(SPEC_ATTRIBUTE_DEFAULT_GROUP, "");
            string = xMLElement2.getAttribute(SPEC_ATTRIBUTE_LOCATION, "applications");
        } else {
            this.suggestedProgramGroup = "";
            string = "applications";
        }
        if (string.equals("applications")) {
            this.groupLocation = 1;
        } else if (string.equals("startMenu")) {
            this.groupLocation = 2;
        }
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariableValueMap());
        Vector vector = this.spec.getChildrenNamed("shortcut");
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2;
            XMLElement xMLElement3 = (XMLElement)vector.elementAt(i);
            ShortcutData shortcutData = new ShortcutData();
            shortcutData.name = xMLElement3.getAttribute("name");
            shortcutData.subgroup = xMLElement3.getAttribute(SPEC_ATTRIBUTE_SUBGROUP);
            shortcutData.description = xMLElement3.getAttribute("description", "");
            String string2 = this.fixSeparatorChar(xMLElement3.getAttribute("target", ""));
            shortcutData.target = variableSubstitutor.substitute(string2, null);
            string2 = xMLElement3.getAttribute("commandLine", "");
            shortcutData.commandLine = variableSubstitutor.substitute(string2, null);
            string2 = this.fixSeparatorChar(xMLElement3.getAttribute(SPEC_ATTRIBUTE_ICON, ""));
            shortcutData.iconFile = variableSubstitutor.substitute(string2, null);
            shortcutData.iconIndex = Integer.parseInt(xMLElement3.getAttribute("iconIndex", "0"));
            string2 = this.fixSeparatorChar(xMLElement3.getAttribute("workingDirectory", ""));
            shortcutData.workingDirectory = variableSubstitutor.substitute(string2, null);
            String string3 = xMLElement3.getAttribute("initialState", "");
            shortcutData.initialState = string3.equals(SPEC_VALUE_NO_SHOW) ? 0 : (string3.equals(SPEC_VALUE_NORMAL) ? 1 : (string3.equals(SPEC_VALUE_MAXIMIZED) ? 3 : (string3.equals(SPEC_VALUE_MINIMIZED) ? 2 : 1)));
            if (shortcutData.name == null || shortcutData.target == null || !this.shortcutRequiredFor(vector2 = xMLElement3.getChildrenNamed(SPEC_KEY_PACKS))) continue;
            if (this.attributeIsTrue(xMLElement3, SPEC_ATTRIBUTE_DESKTOP)) {
                this.hasDesktopShortcuts = true;
                shortcutData.addToGroup = false;
                shortcutData.type = 3;
                this.shortcuts.add(shortcutData.clone());
            }
            if (this.attributeIsTrue(xMLElement3, "applications")) {
                shortcutData.addToGroup = false;
                shortcutData.type = 1;
                this.shortcuts.add(shortcutData.clone());
            }
            if (this.attributeIsTrue(xMLElement3, "startMenu")) {
                shortcutData.addToGroup = false;
                shortcutData.type = 2;
                this.shortcuts.add(shortcutData.clone());
            }
            if (this.attributeIsTrue(xMLElement3, SPEC_ATTRIBUTE_STARTUP)) {
                shortcutData.addToGroup = false;
                shortcutData.type = 4;
                this.shortcuts.add(shortcutData.clone());
            }
            if (!this.attributeIsTrue(xMLElement3, "programGroup")) continue;
            shortcutData.addToGroup = true;
            shortcutData.type = 1;
            this.shortcuts.add(shortcutData.clone());
        }
        if (this.shortcuts.size() > 0) {
            this.shortcutsToCreate = true;
        }
    }

    private void createShortcuts() {
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            ShortcutData shortcutData = (ShortcutData)this.shortcuts.elementAt(i);
            try {
                this.groupName = this.groupName + shortcutData.subgroup;
                this.shortcut.setLinkName(shortcutData.name);
                this.shortcut.setLinkType(shortcutData.type);
                this.shortcut.setArguments(shortcutData.commandLine);
                this.shortcut.setDescription(shortcutData.description);
                this.shortcut.setIconLocation(shortcutData.iconFile, shortcutData.iconIndex);
                this.shortcut.setShowCommand(shortcutData.initialState);
                this.shortcut.setTargetPath(shortcutData.target);
                this.shortcut.setWorkingDirectory(shortcutData.workingDirectory);
                if (shortcutData.addToGroup) {
                    this.shortcut.setProgramGroup(this.groupName);
                } else {
                    this.shortcut.setProgramGroup("");
                }
                try {
                    if (shortcutData.type == 3 && (shortcutData.type != 3 || !this.allowDesktopShortcut.isSelected())) continue;
                    this.shortcut.save();
                    String string = this.shortcut.getFileName();
                    String string2 = this.shortcut.getDirectoryCreated();
                    this.files.add(string);
                    if (string2 == null) continue;
                    this.files.add(string2);
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.parent.unlockNextButton();
    }

    private boolean shortcutRequiredFor(Vector vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = ((XMLElement)vector.elementAt(j)).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean attributeIsTrue(XMLElement xMLElement, String string) {
        String string2 = xMLElement.getAttribute(string, "").toUpperCase();
        if (string2.equals("YES")) {
            return true;
        }
        if (string2.equals("TRUE")) {
            return true;
        }
        if (string2.equals("ON")) {
            return true;
        }
        return string2.equals("1");
    }

    private String fixSeparatorChar(String string) {
        String string2 = string.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        return string2;
    }

    private void buildUI(Vector vector, boolean bl) {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.listLabel = new JLabel(this.parent.langpack.getString("ShortcutPanel.regular.list"), 10);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.layout.addLayoutComponent(this.listLabel, this.constraints);
        this.add(this.listLabel);
        this.groupList = new JList(vector);
        this.groupList.setSelectionMode(0);
        this.groupList.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.groupList);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 1;
        this.layout.addLayoutComponent(jScrollPane, this.constraints);
        this.add(jScrollPane);
        if (this.shortcut.multipleUsers()) {
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.currentUser = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.currentUser"), bl);
            this.currentUser.addActionListener(this);
            buttonGroup.add(this.currentUser);
            jPanel.add(this.currentUser);
            this.allUsers = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.allUsers"), !bl);
            this.allUsers.addActionListener(this);
            buttonGroup.add(this.allUsers);
            jPanel.add(this.allUsers);
            TitledBorder titledBorder = new TitledBorder(new EmptyBorder(2, 2, 2, 2), this.parent.langpack.getString("ShortcutPanel.regular.userIntro"));
            jPanel.setBorder(titledBorder);
            this.constraints.gridx = 1;
            this.constraints.gridy = 1;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.fill = 0;
            this.layout.addLayoutComponent(jPanel, this.constraints);
            this.add(jPanel);
        }
        this.programGroup = new JTextField(this.suggestedProgramGroup, 40);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.programGroup, this.constraints);
        this.add(this.programGroup);
        this.defaultButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.regular.default"), this.idata.buttonsHColor);
        this.defaultButton.addActionListener(this);
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.layout.addLayoutComponent(this.defaultButton, this.constraints);
        this.add(this.defaultButton);
        this.allowDesktopShortcut = new JCheckBox(this.parent.langpack.getString("ShortcutPanel.regular.desktop"), true);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        if (this.hasDesktopShortcuts) {
            this.layout.addLayoutComponent(this.allowDesktopShortcut, this.constraints);
            this.add(this.allowDesktopShortcut);
        }
        this.createButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.regular.create"), this.idata.buttonsHColor);
        this.createButton.addActionListener(this);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.layout.addLayoutComponent(this.createButton, this.constraints);
        this.add(this.createButton);
    }

    private void buildAlternateUI() {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        MultiLineLabel multiLineLabel = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.apology"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.layout.addLayoutComponent(multiLineLabel, this.constraints);
        this.add(multiLineLabel);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.targetsLabel"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.layout.addLayoutComponent(multiLineLabel2, this.constraints);
        this.add(multiLineLabel2);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            vector.add(((ShortcutData)this.shortcuts.elementAt((int)i)).target);
        }
        this.targetList = new JList(vector);
        JScrollPane jScrollPane = new JScrollPane(this.targetList);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.layout.addLayoutComponent(jScrollPane, this.constraints);
        this.add(jScrollPane);
        MultiLineLabel multiLineLabel3 = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.textFileExplanation"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(multiLineLabel3, this.constraints);
        this.add(multiLineLabel3);
        this.saveButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.alternate.saveButton"), this.idata.buttonsHColor);
        this.saveButton.addActionListener(this);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.layout.addLayoutComponent(this.saveButton, this.constraints);
        this.add(this.saveButton);
    }

    public Dimension getSize() {
        Dimension dimension = this.getParent().getSize();
        Insets insets = this.getInsets();
        Border border = this.getBorder();
        Insets insets2 = new Insets(0, 0, 0, 0);
        if (border != null) {
            insets2 = border.getBorderInsets(this);
        }
        dimension.height = dimension.height - insets.top - insets.bottom - insets2.top - insets2.bottom - 50;
        dimension.width = dimension.width - insets.left - insets.right - insets2.left - insets2.right - 50;
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(this.idata.getInstallPath());
        jFileChooser.setSelectedFile(new File(TEXT_FILE_NAME));
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        FileWriter fileWriter = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.parent.langpack.getString("ShortcutPanel.textFile.header");
        String string2 = System.getProperty("line.separator", "\n");
        try {
            fileWriter = new FileWriter(file);
        }
        catch (Throwable throwable) {
            return;
        }
        int n = 0;
        int n2 = 0;
        do {
            if ((n = string.indexOf("\\n", n2)) > -1) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append(string2);
                n2 = n + 2;
                continue;
            }
            stringBuffer.append(string.substring(n2, string.length()));
            stringBuffer.append(string2);
        } while (n > -1);
        stringBuffer.append(SEPARATOR_LINE);
        stringBuffer.append(string2);
        stringBuffer.append(string2);
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            ShortcutData shortcutData = (ShortcutData)this.shortcuts.elementAt(i);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.name"));
            stringBuffer.append(shortcutData.name);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.location"));
            switch (shortcutData.type) {
                case 3: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.desktop"));
                    break;
                }
                case 1: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.applications"));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.startMenu"));
                    break;
                }
                case 4: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.startup"));
                }
            }
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.description"));
            stringBuffer.append(shortcutData.description);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.target"));
            stringBuffer.append(shortcutData.target);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.command"));
            stringBuffer.append(shortcutData.commandLine);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconName"));
            stringBuffer.append(shortcutData.iconFile);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconIndex"));
            stringBuffer.append(shortcutData.iconIndex);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.work"));
            stringBuffer.append(shortcutData.workingDirectory);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(SEPARATOR_LINE);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
        }
        try {
            fileWriter.write(stringBuffer.toString());
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                fileWriter.flush();
                fileWriter.close();
                this.files.add(file.getPath());
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void addToUninstaller() {
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i = 0; i < this.files.size(); ++i) {
            uninstallData.addFile((String)this.files.elementAt(i));
        }
    }

    public void makeXMLData(XMLElement xMLElement) {
        if (!this.shortcutsToCreate || !this.shortcut.supported() || this.simulteNotSupported) {
            return;
        }
        XMLElement xMLElement2 = new XMLElement("programGroup");
        xMLElement2.setAttribute("name", this.groupName);
        xMLElement.addChild(xMLElement2);
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            ShortcutData shortcutData = (ShortcutData)this.shortcuts.elementAt(i);
            xMLElement2 = new XMLElement("shortcut");
            xMLElement2.setAttribute("name", shortcutData.name);
            xMLElement2.setAttribute(AUTO_ATTRIBUTE_GROUP, new Boolean(shortcutData.addToGroup).toString());
            xMLElement2.setAttribute(AUTO_ATTRIBUTE_TYPE, Integer.toString(shortcutData.type));
            xMLElement2.setAttribute("commandLine", shortcutData.commandLine);
            xMLElement2.setAttribute("description", shortcutData.description);
            xMLElement2.setAttribute(AUTO_ATTRIBUTE_ICON, shortcutData.iconFile);
            xMLElement2.setAttribute("iconIndex", Integer.toString(shortcutData.iconIndex));
            xMLElement2.setAttribute("initialState", Integer.toString(shortcutData.initialState));
            xMLElement2.setAttribute("target", shortcutData.target);
            xMLElement2.setAttribute("workingDirectory", shortcutData.workingDirectory);
            if (shortcutData.type == 3 && (shortcutData.type != 3 || !this.allowDesktopShortcut.isSelected())) continue;
            xMLElement.addChild(xMLElement2);
        }
    }

    public void runAutomated(XMLElement xMLElement) {
        if (!this.shortcut.supported()) {
            return;
        }
        this.shortcuts = new Vector();
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("programGroup");
        this.groupName = xMLElement2.getAttribute("name");
        if (this.groupName == null) {
            this.groupName = "";
        }
        Vector vector = xMLElement.getChildrenNamed("shortcut");
        for (int i = 0; i < vector.size(); ++i) {
            ShortcutData shortcutData = new ShortcutData();
            xMLElement2 = (XMLElement)vector.elementAt(i);
            shortcutData.name = xMLElement2.getAttribute("name");
            shortcutData.addToGroup = Boolean.valueOf(xMLElement2.getAttribute(AUTO_ATTRIBUTE_GROUP));
            shortcutData.type = Integer.valueOf(xMLElement2.getAttribute(AUTO_ATTRIBUTE_TYPE));
            shortcutData.commandLine = xMLElement2.getAttribute("commandLine");
            shortcutData.description = xMLElement2.getAttribute("description");
            shortcutData.iconFile = xMLElement2.getAttribute(AUTO_ATTRIBUTE_ICON);
            shortcutData.iconIndex = Integer.valueOf(xMLElement2.getAttribute("iconIndex"));
            shortcutData.initialState = Integer.valueOf(xMLElement2.getAttribute("initialState"));
            shortcutData.target = xMLElement2.getAttribute("target");
            shortcutData.workingDirectory = xMLElement2.getAttribute("workingDirectory");
            this.shortcuts.add(shortcutData);
        }
        this.createShortcuts();
    }
}

