/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include "Other.moc"

#define Inherited OtherData

Other::Other(QWidget* parent,const char* name, bool img, bool zbuf)
   : Inherited( parent, name )
{
   setCaption( "Other Parameters" );
   if (img || zbuf)
   {
      edit_resx->setEnabled(FALSE);
      edit_resy->setEnabled(FALSE);
      edit_resz->setEnabled(FALSE);
      edit_antialiasing->setEnabled(FALSE);
      button_res1->setEnabled(FALSE);
      button_res2->setEnabled(FALSE);
      button_res3->setEnabled(FALSE);
      button_res4->setEnabled(FALSE);
      button_res5->setEnabled(FALSE);
   }
   if (img)
   {
      edit_ambient->setEnabled(FALSE);
      edit_phongmax->setEnabled(FALSE);
      edit_phongsharp->setEnabled(FALSE);
   }
}


Other::~Other()
{
}

void Other::SetData(int ResX, int ResY, int ResZ, 
      double PhongMax, double PhongSharp,
      double Ambient, int Antialiasing, long time)
{
   QString s;

   s.setNum(ResX);
   edit_resx->setText((const char *)s);
   s.setNum(ResY);
   edit_resy->setText((const char *)s);
   s.setNum(ResZ);
   edit_resz->setText((const char *)s);
   s.setNum(PhongMax, 'g', 12);
   edit_phongmax->setText((const char*)s);
   s.setNum(PhongSharp, 'g', 12);
   edit_phongsharp->setText((const char*)s);
   s.setNum(Ambient, 'g', 12);
   edit_ambient->setText((const char*)s);
   s.setNum(Antialiasing);
   edit_antialiasing->setText((const char *)s);
   s.setNum(time);
   label_time->setText((const char *)s);
}

void Other::GetData(int *ResX, int *ResY, int *ResZ,
      double *PhongMax, double *PhongSharp,
      double *Ambient, int *Antialiasing)
{
   QString s;
   
   s = edit_resx->text();
   *ResX = s.toInt(NULL);
   s = edit_resy->text();
   *ResY = s.toInt(NULL);
   s = edit_resz->text();
   *ResZ = s.toInt(NULL);
   s = edit_phongmax->text();
   *PhongMax = s.toDouble(NULL);
   s = edit_phongsharp->text();
   *PhongSharp = s.toDouble(NULL);
   s = edit_ambient->text();
   *Ambient = s.toDouble(NULL);
   s = edit_antialiasing->text();
   *Antialiasing = s.toInt(NULL);
}

void Other::setRes1()
{
   edit_resx->setText("80");
   edit_resy->setText("60");
   edit_resz->setText("60");
}

void Other::setRes2()
{
   edit_resx->setText("80");
   edit_resy->setText("60");
   edit_resz->setText("120");
}

void Other::setRes3()
{
   edit_resx->setText("160");
   edit_resy->setText("120");
   edit_resz->setText("120");
}

void Other::setRes4()
{
   edit_resx->setText("320");
   edit_resy->setText("240");
   edit_resz->setText("240");
}

void Other::setRes5()
{
   edit_resx->setText("640");
   edit_resy->setText("480");
   edit_resz->setText("480");
}

