// Ver25.cpp : implementation file
//

#include "stdafx.h"
#include "TestAxGCom.h"
#include "Ver25.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVer25 dialog


CVer25::CVer25(CWnd* pParent /*=NULL*/)
	: CDialog(CVer25::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVer25)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CVer25::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVer25)
	DDX_Control(pDX, IDC_AXGC1, m_gcom);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CVer25, CDialog)
	//{{AFX_MSG_MAP(CVer25)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CHANGEVAL, OnChange)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_POP, OnPop)
	ON_BN_CLICKED(IDC_PUSH, OnPush)
	ON_BN_CLICKED(IDC_SETBOX, OnSetbox)
	ON_BN_CLICKED(IDC_MOSAIK, OnMosaik)
	ON_BN_CLICKED(IDC_CLEARALL, OnClearall)
	ON_BN_CLICKED(IDC_SHOWLABELS, OnShowlabels)
	ON_BN_CLICKED(IDC_EVENTS, OnEvents)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVer25 message handlers

BOOL CVer25::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CVer25::OnTimer(UINT nIDEvent) 
{
	int n = m_gcom.GetCountSeries();
	double x1,y1,x2,y2;
	int np,i;
	double rx,ry,dx,dy;
    
	if(!n)return;

	switch( m_cs )
	{
     
	case 1:
	{
		np = m_gcom.NPoints(0);
		for(i=0;i<np;i++)
		{
			m_gcom.GetPoint(0,i,&x1,&y1);
			
			rx = 1.0 - (2.0*(double)(rand()&255)/255.0);
			ry = 1.0 - (2.0*(rand()&255))/255.0;

			dx = x1+rx/10.0;
			dy = y1+ry/1000.0;
			m_gcom.ChangeValue(0,i,dx, dy);
			
		}

		m_gcom.SetBox(0,-0.05,1000,.1);
	}
		break;

	case 2:
	{
		m_gcom.Pop(0);
		m_gcom.PopBack(0);
		m_gcom.SetBox(0,-1.2,10,2.4);
		break;
    }

	case 3:
	{
		x1 = 0; y1 = 0;
		m_gcom.GetPoint(0,0,&x1,&y1);
		x1-=0.1;
		m_gcom.PushToBegin(0,x1,sin(x1));


		np = m_gcom.NPoints(1);
		x2 = 0;
		m_gcom.GetPoint(1,np-1,&x2,&y2);
		x2+=0.1;
		m_gcom.AddPointToSeries(1,x2,x2*sin(x2/3));

		if(np>100)
		{
			m_gcom.RemoveData(0);
			m_gcom.RemoveData(1);
			
		}


		break;
    }
	case 4:
	{
		b_x += 0.05;
		b_y += 0.005;
		b_w -= 0.1;
		b_h -= 0.01;

		if(b_w<0.1)
		{
			b_x = 0;
			b_y = -1;
			b_w = 10;
			b_h = 2;
		}
		m_gcom.SetBox(b_x,b_y,b_w,b_h);
		break;
	}
  

	case 0:
		break;




	default:
		break;
	}
	
	CDialog::OnTimer(nIDEvent);
}

void CVer25::OnChange() 
{
	ClearData();
	int n = m_gcom.GetCountSeries();
	if(!n)
	{
		m_gcom.CreateSeries();
	}else
	{
		m_gcom.RemoveData(0);	
	}

	for(int i=0;i<1000;i++)m_gcom.AddPointToSeries(0,((double)i),0);
	m_gcom.SetPropertySeries(0,50, RGB(0,0,255));
	m_gcom.Points(30,5);
    if(n==2)m_gcom.RemoveData(1); // if series 1 is exist we must remove data from series_1 	
	m_cs = 1;

}

BOOL CVer25::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_cs = 0;

	m_uTimerID = (UINT)(SetTimer(0x451,50,0));

    ((CButton*)GetDlgItem(IDC_SHOWLABELS))->SetCheck(1);

	m_gcom.LicensingKey(123456789); //  You mast set your own licensing key!


	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CVer25::OnDestroy() 
{
	CDialog::OnDestroy();
    KillTimer(m_uTimerID);	
}



void CVer25::OnPop() 
{
	ClearData();
    int n = m_gcom.GetCountSeries();
	if(!n)
	{
		m_gcom.CreateSeries();

	}else
	{
		m_gcom.RemoveData(0);

	}

	double x;
	for(int i=0;i<1000;i++)
	{	
		x = ((double)i)/100.0;
		m_gcom.AddPointToSeries(0,x,sin(x));
	}

	m_gcom.SetPropertySeries(0,10, RGB(0,100,100));
	m_gcom.Points(30,5);
	
	m_cs = 2;

	m_gcom.SetBox(0,-1.2,10,2.4);

	m_gcom.RemoveData(1); // if series 1 is exist we must remove data from series_1 
}

void CVer25::OnPush() 
{
	ClearData();
	int n = m_gcom.GetCountSeries();
	if(!n)
	{
		m_gcom.CreateSeries();
		m_gcom.CreateSeries();

	}else
	{
		if(n==1)m_gcom.CreateSeries();
	}

	m_gcom.RemoveData(0);
	m_gcom.RemoveData(1);

	m_cs = 3;

	m_gcom.SetPropertySeries(0,50, RGB(0,0,255));
	m_gcom.SetPropertySeries(1,50, RGB(0,100,0));
	m_gcom.Points(30,5);
	
	
}

void CVer25::OnSetbox() 
{
	ClearData();
	int n = m_gcom.GetCountSeries();
	if(!n)
	{
		m_gcom.CreateSeries();
	}

	// if series 1 and 2 is exist we must remove data from series_1 and series_2
	 
	if(n==1)m_gcom.RemoveData(0);
	if(n==2)m_gcom.RemoveData(1);

	m_cs = 4;

	b_x = 0;
    b_y = -1;
	b_w = 10;
	b_h = 2;

	double x;
	if(m_gcom.NPoints(0)<1000)
	{
		for(int i=0;i<10000;i++)
		{	
			x = ((double)i)/100.0;
			m_gcom.AddPointToSeries(0,x,sin(x*x));
		}
	}
	m_gcom.SetPropertySeries(0,255, RGB(0,0,100));
	

}

void CVer25::OnMosaik() 
{
	m_cs = 5;

	int n = m_gcom.GetCountMatrix();

	if(n<8)
	{
		for(int k=0;k<8-n;k++)
		{
			m_gcom.CreateMatrix();
		}
	}
	
	m_gcom.SetMatrixSize(0,5,5);
	m_gcom.SetMatrixSize(1,50,50);
	m_gcom.SetMatrixSize(2,10,10);
	m_gcom.SetMatrixSize(3,1,1);
	m_gcom.SetMatrixSize(4,10,12);
	
	m_gcom.SetMatrixSize(5,5,5);
	m_gcom.SetMatrixSize(6,4,4);
	m_gcom.SetMatrixSize(7,7,7);
	
	long mask = RGB(255,255,255);

	for(int i=0;i<50;i++) 
	{             

		for(int j=0;j<50;j++)
		{
		    int v = rand()&15; 
			
			if(!(v%5))
			{
		
				
				m_gcom.SetCell(0,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),255,1,1);
				
				m_gcom.SetCell(1,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),200,1,1);
			
				m_gcom.SetCell(2,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),100,0,1);
			
				m_gcom.SetCell(4,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),50,0,1);
			
				m_gcom.SetCell(5,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),30,0,1);
			
				m_gcom.SetCell(6,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),30,0,1);
			
				m_gcom.SetCell(7,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),30,0,1);
			
			}

			m_gcom.SetCell(3,i,j,RGB(rand()&255,rand()&255,rand()&255),RGB(rand()&255,rand()&255,rand()&255),100,1,1);
		}
	              
	}
	
	
	m_gcom.SetBackColor(RGB(0,0,100));
	
	m_gcom.SquarteCells(1);//  <- SquarteCells(0) 'stretching' cells
	


}

void CVer25::ClearData()
{

	int n = m_gcom.GetCountMatrix();
	for(int k=0;k<n;k++)
	{
		m_gcom.SetMatrixSize(0,0,0);
	}

	m_gcom.SetBackColor(RGB(255,255,255));


}

void CVer25::OnClearall() 
{
	m_gcom.RemoveAll();	
}

void CVer25::OnShowlabels() 
{
	int l = ((CButton*)GetDlgItem(IDC_SHOWLABELS))->GetCheck();
	m_gcom.SetShowAxisLabel(l);
}

void CVer25::OnEvents() 
{
	int l,i;
	double x;
	l = ((CButton*)GetDlgItem(IDC_EVENTS))->GetCheck();

	for(i=IDC_CHANGEVAL;i<IDC_EVENTS;i++)
	{
		GetDlgItem(i)->EnableWindow(!l);
	}

	m_cs = 0;
	color = RGB(255,255,255);
	m_gcom.RemoveAll();
	m_gcom.CreateSeries();
	for(i=0;i<1000;i++)
	{
		x = ((double)i)/100.0;
		m_gcom.AddPointToSeries(0,x, sin(x));
	}
	

	
}

BEGIN_EVENTSINK_MAP(CVer25, CDialog)
    //{{AFX_EVENTSINK_MAP(CVer25)
	ON_EVENT(CVer25, IDC_AXGC1, 3 /* leftbuttonup */, OnleftbuttonupAxgc1, VTS_NONE)
	ON_EVENT(CVer25, IDC_AXGC1, 2 /* leftbuttondown */, OnleftbuttondownAxgc1, VTS_NONE)
	ON_EVENT(CVer25, IDC_AXGC1, 6 /* keypress */, OnkeypressAxgc1, VTS_NONE)
	ON_EVENT(CVer25, IDC_AXGC1, 7 /* keydown */, OnkeydownAxgc1, VTS_NONE)
	ON_EVENT(CVer25, IDC_AXGC1, 4 /* rightbuttondown */, OnrightbuttondownAxgc1, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CVer25::OnleftbuttonupAxgc1() 
{
	int l;
	l = ((CButton*)GetDlgItem(IDC_EVENTS))->GetCheck();
	if(l)m_gcom.SetPropertySeries(0,255,RGB(0,0,255));

}

void CVer25::OnleftbuttondownAxgc1() 
{
	int l;
	l = ((CButton*)GetDlgItem(IDC_EVENTS))->GetCheck();
	if(l)m_gcom.SetPropertySeries(0,255,RGB(255,0,0));
}

void CVer25::OnkeypressAxgc1() 
{
	int r,g,b;
	r = GetRValue(color);
	g = GetGValue(color);
	b = GetBValue(color);

	
	if(m_gcom.GetLastPressedKey()  == '+') 
	{
		r+=1;
		if(r>255) r = 0;
		m_gcom.SetBackColor(RGB(r,g,b));
	}

	if(m_gcom.GetLastPressedKey() == '-') 
	{
		r-=1;
		if(!r) r = 255;
		m_gcom.SetBackColor(RGB(r,g,b));
	}
}

void CVer25::OnkeydownAxgc1() 
{
	
	int r,g,b;
	r = GetRValue(color);
	g = GetGValue(color);
	b = GetBValue(color);

	char c = m_gcom.GetLastPressedKey();

	if(c  == 'z' || c  == 'Z') 
	{
		r+=2;
		g+=2;
		if(r>255) r = 0;
		color = RGB(r,g,b);
		m_gcom.SetBackColor(color);
	}

	if(c == 'x' || c == 'X') 
	{
		r-=2;
		g-=2;
		if(!r) r = 255;
		color = RGB(r,g,b);
		m_gcom.SetBackColor(color);
	}

	if(c == 'c' || c == 'C') 
	{
		double x,y;
		for(int i=0;i<1000;i++)
		{
			m_gcom.GetPoint(0,i,&x,&y);
			x+=(1.0 - (2.0*(double)(rand()&255)/255.0))/100.0;
			y+=(1.0 - (2.0*(double)(rand()&255)/255.0))/100.0;
			m_gcom.ChangeValue(0,i,x,y);
		}
	}
}

void CVer25::OnrightbuttondownAxgc1() 
{

	double x,y;
	for(int i=0;i<1000;i++)
	{
		m_gcom.GetPoint(0,i,&x,&y);
		x+=(1.0 - (2.0*(double)(rand()&255)/255.0))/100.0;
		y+=(1.0 - (2.0*(double)(rand()&255)/255.0))/100.0;
		m_gcom.ChangeValue(0,i,x,y);
	}
}
