#if !defined(AFX_DLTEDITPLOTPARMS_H__0B6CD1A1_8BEC_11D3_B5BA_812844EBE31B__INCLUDED_)
#define AFX_DLTEDITPLOTPARMS_H__0B6CD1A1_8BEC_11D3_B5BA_812844EBE31B__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// DlgEditPlotZ.h : header file
//

#include "..\common\PlotCalc.h"

#define	DEFAULT_SURFACE		"SineWave"
#define	SURFACE_HIVE_SUBDIR	"Surfaces"

/////////////////////////////////////////////////////////////////////////////
// DlgEditPlotZ dialog

class DlgEditPlotZ : public CDialog
{
// Construction
public:
	DlgEditPlotZ(CWnd* pParent = NULL);   // standard constructor
	void SetDefaults(void);
	void SaveToRegistry(void);
	int  GetFromRegistry(void);
	void UpdateDialogState(void);
	void AttachCalculator(PlotCalc* pPlotCalc);
	int  SetSurfaceName(CString name="");
	CString GetSurfaceName(void);
	CString GetPlotRegPath(void);
	CString GetSurfaceRegPath(void);

	// data
	int  m_is_equation_ok;
	COLORREF	m_line_color;
	COLORREF	m_background_color;
	CString		m_surface_name;

// Dialog Data
	//{{AFX_DATA(DlgEditPlotZ)
	enum { IDD = IDD_EDIT_PLOTZ_PARMS };
	CComboBox	m_list_surfaces;
	CComboBox	m_ViewProgram;
	double	m_xmin;
	double	m_xmax;
	double	m_ymin;
	double	m_ymax;
	double	m_zmin;
	double	m_zmax;
	double	m_zrotate;
	double	m_xytilt;
	BOOL	m_is_color;
	BOOL	m_remove_hidden_lines;
	BOOL	m_show_xlines;
	BOOL	m_show_ylines;
	BOOL	m_slow_draw;
	long	m_slow_draw_rate;
	UINT	m_nxlines;
	UINT	m_nylines;
	double	m_scale;
	BOOL	m_show_axis;
	CString	m_sPlotEquation;
	CString	m_sEquationStatus;
	CString	m_sC1;
	CString	m_sC2;
	CString	m_sC3;
	CString	m_sC4;
	CString	m_sC5;
	CString	m_sC6;
	CString	m_sC7;
	CString	m_sC8;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(DlgEditPlotZ)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	PlotCalc* m_pPlotCalc;	// equation calculator (we don't own this memory)

	// Generated message map functions
	//{{AFX_MSG(DlgEditPlotZ)
	afx_msg void OnHelpParm();
	afx_msg void OnButtonSyntax();
	afx_msg void OnButtonTest();
	virtual void OnOK();
	afx_msg void OnDropdownComboViewProgram();
	afx_msg void OnButtonDefaults();
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonLineColor();
	afx_msg void OnButtonBackgroundColor();
	afx_msg void OnPaint();
	afx_msg void OnButtonDelete();
	afx_msg void OnButtonNew();
	afx_msg void OnSelchangeComboListSurface();
	afx_msg void OnCancel();
	afx_msg void OnButtonSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DLTEDITPLOTPARMS_H__0B6CD1A1_8BEC_11D3_B5BA_812844EBE31B__INCLUDED_)
