/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JViewport;

public class AutoscrollViewport
extends JViewport {
    Point scrollTo = new Point();
    Point last = new Point();
    boolean manualDragUnderWay = false;
    final int increment;

    public AutoscrollViewport(Component component, int n) {
        this.increment = n;
        this.setView(component);
        this.setAutoscrolls(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AutoscrollViewport.this.last.x = mouseEvent.getPoint().x;
                AutoscrollViewport.this.last.y = mouseEvent.getPoint().y;
                AutoscrollViewport.this.manualDragUnderWay = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                Point point2 = AutoscrollViewport.this.getViewPosition();
                Point point3 = new Point(point.x - AutoscrollViewport.this.last.x, point.y - AutoscrollViewport.this.last.y);
                AutoscrollViewport.this.last.x = point.x;
                AutoscrollViewport.this.last.y = point.y;
                if (AutoscrollViewport.this.contains(point) && AutoscrollViewport.this.manualDragUnderWay) {
                    AutoscrollViewport.this.scrollTo.x = point2.x - point3.x;
                    AutoscrollViewport.this.scrollTo.y = point2.y - point3.y;
                    AutoscrollViewport.this.setViewPosition(AutoscrollViewport.this.scrollTo);
                }
            }
        });
    }
}

