unit GLE2000D;
{Display Unit Version GLE2000H2  12th May 2000
 Procedures for graphics display.}
interface

uses
  Windows, Messages, SysUtils,WinTypes,WinProcs, Graphics, Controls, Forms,
  Dialogs, Tabs, StdCtrls, ExtCtrls, GLE2000E, Classes, GLE2000W, GLE2000T,
  Menus, Buttons, ClipBrd, Printers;

const crZoom= 1;
      MaxTransforms= 25;

type
  TDisplayForm = class(TForm)
    DisplayPanel: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    TextEdit: TEdit;
    CopyButton: TButton;
    PrintButton: TButton;
    PasteButton: TButton;
    SaveButton: TButton;
    Image1: TImage;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Line1: TMenuItem;
    Brush1: TMenuItem;
    Colour1: TMenuItem;
    Load1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    Style1: TMenuItem;
    Colour2: TMenuItem;
    Width1: TMenuItem;
    Font1: TMenuItem;
    Size1: TMenuItem;
    Colour4: TMenuItem;
    EditButton: TBitBtn;
    xPanel: TPanel;
    yPanel: TPanel;
    xLabel: TLabel;
    yLabel: TLabel;
    ClearBitBtn: TBitBtn;
    PosnLabel: TLabel;
    PrintDialog1: TPrintDialog;
    Help1: TMenuItem;
    HelpContents1: TMenuItem;
    ReDrawBitBtn1: TBitBtn;
    Help2: TMenuItem;
    ErrorMessages1: TMenuItem;
    Conversions1: TMenuItem;
    FontName1: TMenuItem;
    N1: TMenuItem;
    Clear1: TMenuItem;
    Solid1: TMenuItem;
    Dash1: TMenuItem;
    Dot1: TMenuItem;
    DashDot1: TMenuItem;
    DashDotdot1: TMenuItem;
    Insideframe1: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Window1: TMenuItem;
    Printer1: TMenuItem;
    PageSettings1: TMenuItem;
    Print1: TMenuItem;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    ModeButton: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn10: TBitBtn;
    Reset1: TMenuItem;
    SetDefaults1: TMenuItem;
    ZoomBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CopyButtonClick(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
    procedure PasteButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Image1DblClick(Sender: TObject);
    procedure EditButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ClearBitBtnClick(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure HelpContents1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ReDrawBitBtn1Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure ErrorMessages1Click(Sender: TObject);
    procedure Conversions1Click(Sender: TObject);
    procedure FontName1Click(Sender: TObject);
    procedure Size1Click(Sender: TObject);
    procedure Colour4Click(Sender: TObject);
    procedure Brush1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure Solid1Click(Sender: TObject);
    procedure Dash1Click(Sender: TObject);
    procedure Dot1Click(Sender: TObject);
    procedure DashDot1Click(Sender: TObject);
    procedure DashDotdot1Click(Sender: TObject);
    procedure Insideframe1Click(Sender: TObject);
    procedure Colour2Click(Sender: TObject);
    procedure Width1Click(Sender: TObject);
    procedure PageSettings1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure ModeButtonClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure BitBtn9Click(Sender: TObject);
    procedure BitBtn10Click(Sender: TObject);
    procedure Reset1Click(Sender: TObject);
    procedure ZoomBtnClick(Sender: TObject);
    procedure SetDefaults1Click(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
   private
    { Private declarations }
   public
  end;
  CTransform = Record {Co-ordinate Transforms}
    XOrigin,
    YOrigin,
    TranC, TranE, TranD, TranF,
    XScale, YScale,
    Rotation:double;
  end;
  SvSettings = Record  {Save & Restore Settings}
    {Dispay Settings}
    SCPnt,SLpnt:RealPoint;
    SXorgn,SYorgn,SXOffst,SYOffst,SZFactor:double;
    BgNum,Llevel,LTlevel:Integer;
    STransform,SITransform:CTransForm;
    STextangle,SArrowSize,SArrowangle:double;
    SAlinecolor,SAfillcolor,SAStyle, SSclmode:integer;
    Sastart,SAend:Boolean;
    SFont:TFont;
    SFcol,SF2col,SFbcol:TColor;
    {Pen and Brush Settings}
    SPStyle:TpenStyle;
    SPmode:TPenMode;
    SPColor:TColor;
    SPwidth:Integer;
    SBstyle:TBrushStyle;
    SBColor:TColor;
    SBitMap:TBitMap;
    SBBSet:Boolean;
  end;

  TDrawingTool = (dtNone, dtLine, dtArc, dtPaste, dtCopy, dtBox, dtSquare, dtBezier,
                  dtCircle, dtEllipse, dtMarker, dtText,dtContinue);
  TMarkerType  = (mtCircle, mtTriangle, mtSquare, mtDiamond,
                  mtDot, mtCross, mtStar, mtSnake, mtDag,
                  mtDdag, mtAsterisk, mtOplus, mtOminus,
                  mtOtimes);

var
  DisplayForm: TDisplayForm;
  BitMap,BitMap1,BrushBitMap:tbitmap;
  CurrentItem,FinalItem,ip,SpotSize,
  GLEHeight,GLEWidth,DisplayHeight,
  MarkerType,MarkerSize,
  CurrentBitBtn,LastBitBtn,gResetLevel,
  Arrowlinecolor,Arrowfillcolor,ArrowStyle, Scalemode:integer;
  PixelsPerCm,DotsPerCm,PScale,
  WindowHeight,WindowWidth,XWinOrigin,YWinOrigin,
  ArrowSize,ArrowAngle,
  XOffset,YOffset,TextAngle:double;
  MouseMode,KeyMode,SetCurve,NewStyle,NewDrawObject,Drawing,
  NewDrawing,StartDraw,Clockwise,BrushBitmapSet,
  ArrowStart,ArrowEnd:Boolean;
  DrawStart,LastStart, DrawEnd,LastEnd,CStart,CEnd,
  ControlPoint1,ControlPoint2,TextAt :TPoint;
  DrawingTool: TDrawingTool;
  DrawingMode, LastDmode, {Controls for complex drawing operations}
  DrawingStyle,
  CTransformNum:integer;   {Level in Coordinate Transform Stack }
  ap1:array[0 .. 100] of tpoint;
  rpt1,rpt2,club,spade,heart,snake:array[0 .. 100] of RealPoint;
  CurrentTransform,CurrentInvTransform,ArrowTransform:CTransform;
  SavedSettings,ReplacedSettings,DefaultSettings:SvSettings;
  Ctrans:array [0 ..  MaxTransforms] of CTransform;
  TextOut:String;
  CurrentFont,DefaultFont,SavedFont,LastFont:TFont;
  MarkerStyle:array[ 0 ..30] of string;
  CurrentPoint,LastPoint:RealPoint;
  Mask1,Mask2:array[0 ..264] of byte;
  {Arrays used to define fill patterns  }
  FColor,F2Color,FbColor:TColor; {colours used in fill patterns.}

  function SetPenStyle(Tpen:integer):TPenStyle;
  {Sets a pen style According to The current style code}

  procedure SetBitMaps(Width,Height:integer);
  {sets size oBitmaps used for drawing }

  procedure SetBrushBitmap(BitMapStyle,NumOfBitmaps:integer;
             Var Bitmap3:TBitmap;Mask1,Mask2:array of Byte;
             FColor,F2Color,FbColor:TColor);
  { Sets up an 8 by 8 pixel bitmap using masks defined by arrays Mask1
    and Mask2 and colours defined by FColor,FColor2 and FbColor. In event
    of error a null bitmap is returned. }

  function SetBrushStyle(BrushType:integer;var BrushBitmap:TBitMap):TBrushStyle;
  {Sets a brush style According to the current style code.
   if a pattern is required the Brush Bitmap is set.}

  function  InverseTransform(CurrentTransform:CTransform):CTransform;
  {Forms the inverse of the current Transform}

  function TransformPoint(CurrentTransForm:CTransform;
                          Inpoint:RealPoint):Realpoint;
{ Converts current co-ordinate values}

  function ScreenPoint(Input:RealPoint):TPoint;
  {Derives screen coordinates for a plot point}

  function ToRealPoint(Input:Tpoint):RealPoint;
  {Derives co-ordiates in cm corresponding to a screen point
   Note, these are absolute coordinates}

  procedure DrawBezier(scale:double;x1,y1,xc1,yc1,xc2,yc2,x2,y2,
          dmode:integer);
    { Constructs a 2-Dimensional Besier spline from x1,y1 to
      x2,y2 using control points xc1,yc1 and xc2,yc2.
      Plots this on the screen using scale factor `scale' and
      mode control `dmode'.
      Set up modes 1 to 3 use narrow black lines
      dmode = 0 does nothing,
      dmode = 1 plots the straight line from start to end,
      dmode = 2 plots control points.
      dmode = 3 plots 1st control vector and curve
      dmode = 4 plots 2nd control vector and curve
      dmode = 5 plots both control vectors and curve in black.
      dmode = 6 plots curve in original style and colour.  }

    procedure DrawArc(x1,y1,xc,yc,xa,ya,dmode:integer;var x2,y2:longint;
                       var Radius,StartAngle,EndAngle:double;Clock:boolean);
   { Constructs an arc from x1,y1 to x2,y2 using control points
     xc,yc and xa,ya. xc,yc is the centre of the arc, the arc ends at
     the intersection with the line from xc,yc to xa,ya.
     The arc is drawn clockwise if Clock is TRUE.
     Plots this on the screen using mode control `dmode' as follows:
     Set up modes 1 to 3 use narrow black lines
     dmode = 0 does nothing,
     dmode = 1 plots the initial straight line from x1,y1 to xc,yc,
     dmode = 2 plots control points at x1,y1,xc,yc and xa,ya.
     dmode = 3 plots arc and 1st control vector in black.
     dmode = 4 plots arc and 2nd control vector in black.
     dmode = 6 plots arc in original style and colour.  }

procedure DrawMarker(mtype,x,y:integer;mscale:double);
{ Draws a marker of type mtype and size mscale at x,y
  Colours and fill style are set in DrawMain before calling this
  procedure }

procedure DrawArrow(Atype:integer;APoint:RealPoint;AAngle,Asize:double);
{ Draws a marker of type mtype and size mscale at x,y
  Colours and fill style are set in DrawMain before calling this
  procedure }

function IntString(I: Longint): string;
{ Converts any integer type to a string }

function RealString(R: real): string;
{ Convert any real type to a string }

procedure DisplayObject(step:integer);
{ This draws an object in final form, then sets it up in
  list of graph objects, and increments item number
  For Bezier and Arc functions Flag SetCurve is reset.  }

procedure Displayat(x,y:double;PictName:String);
{Pastes an imagefile at point x,y}

procedure CopyFrom(x,y,x1,y1:double);
{Copies the specified rectangle to the clipboard}

procedure PasteAt(x,y,x1,y1:double);
{Copies the clipboard to point x,y}

{ ************ Procedures for GLE operations ************** }

  procedure Aline(x,y:double);
  {Draws a line to x,y and makes this the current point}

 procedure Apline(r,a:double);
 {Draws a line in polar coordinates}

  procedure Amove(x,y:double);
  {Moves Current point to x,y}

 procedure Apmove(r,a:double);
 {Moves current point in polar coordinates}

  procedure ArcAt(xradius,yradius,startangle,endangle:double);
  {draws a simple arc centred at current point}

 procedure ArcTo(x1,y1,x2,y2,radius:double);
  {Fits an arc of radius r in the line segment xc,yc - x1,y1
   - x2,y2 where xc,yc is the current point.}

  procedure Bezier(xc1,yc1,xc2,yc2,xend,yend:double);
  {Draws a Bezier curve from the current point to xend,yend
   and moves current point to xend,yend }

  procedure BoxAt(x,y:double);
  {Draws a box from current point to x,y
   without resetting starting point}

  procedure Box(x,y:double);
  {Draws a box from current point to x,y
   and resets starting point}

  procedure DrawStar(Npoints,OuterRad,InnerRad,StartAngle:double);
 {Draws a star with N points, starting with first point at StartAngle.
  The star is centred on the current point with line style, line colour
  and fill style and colour defined by current settings.}

  procedure DrawRNPolygon(NumOfSides,PolyRadius,StartAngle:Double);
 {Draws an N-sided regular polygon with first corner at startangle.
  The polygon is centred on the current point and uses current lne
  and fill settings.}

  procedure SetPolygon(NumOfPoints:Integer;
             RealPolyPoint:array of RealPoint);
         {Draws a polygon in current line style and fills
          it with current fillstyle}

  procedure SetPolyLine(NumOfPoints:Integer;
             RealPolyPoint:array of RealPoint);
         {Draws a polyline in current line style}

  procedure EllipseAt(xradius,yradius:double);
  { Draws an ellipse centred at current point }

  procedure Circle(radius:double);
  {Draws a circle centred onthe current point}

  procedure Fill(Color,Style:integer);
 {Fill an area surrounding the current point using the current fill
  style and colours. Color is the boundary colour or the colour to
  be flled over.}

  procedure Marker(mktype:string;size:double);
  {Draws a marker at the curent point}

  procedure RBezier(xc1,yc1,xc2,yc2,xend,yend:double);
 {Draws a Bezier curve from the current point to xend,yend
  and moves current point to xend,yend where all parameters
  are relative to the current point  }

  procedure Rline(x,y:double);
  {Draws a line to x,y relative to present point}

 procedure RpLine(r,a:double);
 {Relative line in polar coordinates}

  procedure Rmove(x,y:double);
  {Moves Current point to x,y relative to present point}

 procedure RpMove(r,a:double);
 {Relative move in polar coordinates}

  procedure square(xx:double);
  {Draws a box centred on the current point }

  procedure Text(TextString:string;AngleOfText:Double);
  {Displays a simple Text String}

  procedure SaveSettings;
  {Saves current graph settings}

  procedure RestoreSettings;
  {Restores  last saved settings and stores current settings as Last Settings}

  procedure ResetSettings;
  {Restores last settings or default settings.}

implementation

uses GLE2000G, GLE2000F, GLE2000P;

var  TextOn:Boolean;
     FontRecord:TlogFont;

{$R *.DFM}
{$R POINTERS1.RES}

function SetPenStyle(Tpen:integer):TPenStyle;
{Sets a pen style According to The current style code}
begin
  case Tpen of
    0:SetPenStyle:=psClear;
    1:SetPenStyle:=psSolid;
    2:SetPenStyle:=psDash;
    3:SetPenStyle:=psDot;
    4:SetPenStyle:=psDashDot;
    5:SetPenStyle:=psDashDotDot;
    6:SetPenStyle:=psInsideFrame;
   else begin
     if (Messagedlg('D40: Illegal line style parameter. Set solid as default ',
          mtWarning,[mbignore,mbabort],0)= mrAbort) then
       begin
         Disaster:=True;
         Exit;
       end else SetPenStyle:=psSolid;
   end;
  end; {Case Tpen}
end; {SetPenStyle}

procedure SetBitMaps(Width,Height:integer);
{sets size of Bitmaps used for drawing }
begin
    BitMap1.Free;  BitMap.Free;
    Bitmap1 := TBitmap.Create;	{ construct the bitmap object }
    Bitmap1.Width := Width;	{ assign the initial width... }
    Bitmap1.Height :=Height-displayForm.DisplayPanel.Height;	{ ...and the initial height }
    Bitmap := TBitmap.Create;	{ construct the bitmap object }
    Bitmap.Width := Width;	     { assign the initial width and }
    Bitmap.Height := Height-DisplayForm.DisplayPanel.Height; { the initial height }
    DisplayHeight := Displayform.Height-DisplayForm.DisplayPanel.Height-67;
end;



procedure SetBrushBitmap(BitMapStyle,NumOfBitmaps:integer;Var Bitmap3:TBitmap;
         Mask1,Mask2:array of Byte;FColor,F2Color,FbColor:TColor);
{ Sets up an 8 by 8 pixel bitmap using masks defined by arrays Mask1
  and Mask2 and colours defined by FColor,FColor2 and FbColor. In event
  of error a null bitmap is returned. }
  var i,j,k,t1,t2:integer;
  begin
   BitmapStyle:=8*(BitmapStyle-8);
  { Bitmapstyle:= 16;     {Force temporary setting}
   BitMap3.Free;
   Bitmap3:=TBitMap.Create;
   Bitmap3.Height:=8;
   BitMap3.Width:= 8;
   try
    with Bitmap3 do
    begin
     for j:= 0 to 7 do
     begin
      k:=1;
      try
       t1:= Mask1[BitMapstyle+j];
       t2:= Mask2[BitMapstyle+j];
      except
        on E: ERangeError do begin
         MessageDlg(
          'D41: Error in setting fill style, check for use of a fill pattern: '
            + E.Message, mtError, [mbOK], 0);
         Disaster:= True;
         exit;
        end;
      end;
      for i:=0 to 7 do
      begin
      canvas.pixels[i,j]:= FbColor;
       if (k and t1)>0 then canvas.pixels[i,j]:= Fcolor;
       if (k and t2)>0 then canvas.pixels[i,j]:= F2Color;
       k:= k+k;
      end;
     end;
    end; {with Bitmap3}
    finally
    {  on Error
    messagedlg('Error in setting a fill style',mtWarning,[mbOK],0); }
   end;
   BrushBitmapSet:= True;
end; {SetBrushBitMap}

function SetBrushStyle(BrushType:integer;var BrushBitmap:TBitMap):TBrushStyle;
{Sets a brush style According to the current style code.
 if a pattern is required the Brush Bitmap is set.}
begin
  if BrushType in [0 .. 7] then BrushBitmapSet:= False;
  case BrushType of
    0:SetBrushStyle:=bsClear;
    1:SetBrushStyle:=bsSolid;
    2:SetBrushStyle:=bsBDiagonal;
    3:SetBrushStyle:=bsFDiagonal;
    4:SetBrushStyle:=bsCross;
    5:SetBrushStyle:=bsDiagCross;
    6:SetBrushStyle:=bsHorizontal;
    7:SetBrushStyle:=bsVertical;
    8..40:begin
           BrushBitMapSet:= True;
          end;
   end; {case}
end; {SetBrushStyle}

function  InverseTransform(CurrentTransform:CTransform):CTransform;
{Forms the inverse of the current Transform}
var decf:double;
begin
 with CurrentTransform do
 begin
   decf:= TranD*TranE - TranC*TranF;
   if decf=0 then decf:=1.0;
   InverseTransform.Xorigin := (XOrigin*TranF - YOrigin*TranE)/decf;
   InverseTransform.YOrigin := (YOrigin*TranC - Xorigin*TranD)/decf;
   InverseTransForm.TranC:= -TranF/decf;
   InverseTransForm.TranD:=  TranD/decf;
   InverseTransForm.TranE:=  TranE/decf;
   InverseTransForm.TranF:= -TranC/decf;
   InverseTransform.XScale := 1.0/Xscale;;
   InverseTransform.Yscale := 1.0/Yscale;
   InverseTransform.Rotation := -Rotation;
 end;
end; {Inverse Transform }

function TransformPoint(CurrentTransForm:CTransform;
                          Inpoint:RealPoint):Realpoint;
{ Converts current co-ordinate values}
begin
 with CurrentTransform do
 begin
   TransformPoint.x := Xorigin + TranC*Inpoint.x + TranE*Inpoint.y;
   TransformPoint.y := YOrigin + TranD*Inpoint.x + TranF*Inpoint.y;
 end;
end; {TransformPoint}

function ScreenPoint(Input:RealPoint):TPoint;
{Derives screen coordinates for a plot point}
begin
    ScreenPoint.x := Round(Input.x*SpA+SpB);
    ScreenPoint.y := Round(SpC -Input.y*SpA);
end; {Screenpoint}

function ToRealPoint(Input:Tpoint):RealPoint;
{Derives co-ordiates in cm corresponding to a screen point
 Note, these are absolute coordinates}
begin
    ToRealPoint.x := Input.x*SpE + SpF;
    ToRealPoint.y := SpG - Input.y*SpE;
end; {ToRealPoint}


 Procedure SetFillPatterns;
 {Masks for Fill Patterns }
 begin
  {Fine Vertical lines }
  {Pstyle[0]:= 'Fine Vertical Lines'; }
  Mask1[0]:= 17;       Mask2[0]:= 238;
  Mask1[1]:= 17;       Mask2[1]:= 238;
  Mask1[2]:= 17;       Mask2[2]:= 238;
  Mask1[3]:= 17;       Mask2[3]:= 238;
  Mask1[4]:= 17;       Mask2[4]:= 238;
  Mask1[5]:= 17;       Mask2[5]:= 238;
  Mask1[6]:= 17;       Mask2[6]:= 238;
  Mask1[7]:= 17;       Mask2[7]:= 238;
  {Medium Vertical lines }
 { Pstyle[1]:= 'Medium Vertical Lines'; }
  Mask1[8]:=  102;     Mask2[8]:= 153;
  Mask1[9]:=  102;     Mask2[9]:= 153;
  Mask1[10]:= 102;     Mask2[10]:= 153;
  Mask1[11]:= 102;     Mask2[11]:= 153;
  Mask1[12]:= 102;     Mask2[12]:= 153;
  Mask1[13]:= 102;     Mask2[13]:= 153;
  Mask1[14]:= 102;     Mask2[14]:= 153;
  Mask1[15]:= 102;     Mask2[15]:= 153;
  {Thick Vertical lines }
 { PStyle[2]:= 'Thick Vertical Lines'; }
  Mask1[16]:= 56;      Mask2[16]:= 199;
  Mask1[17]:= 56;      Mask2[17]:= 199;
  Mask1[18]:= 56;      Mask2[18]:= 199;
  Mask1[19]:= 56;      Mask2[19]:= 199;
  Mask1[20]:= 56;      Mask2[20]:= 199;
  Mask1[21]:= 56;      Mask2[21]:= 199;
  Mask1[22]:= 56;      Mask2[22]:= 199;
  Mask1[23]:= 56;      Mask2[23]:= 199;
  {Fine Horizontal Lines}
 { PStyle[3]:= 'Fine Horizontal Lines';  }
  Mask1[24]:= 0;       Mask2[24]:= 255;
  Mask1[25]:= 0;       Mask2[25]:= 255;
  Mask1[26]:= 255;     Mask2[26]:= 0;
  Mask1[27]:= 0;       Mask2[27]:= 255;
  Mask1[28]:= 0;       Mask2[28]:= 255;
  Mask1[29]:= 0;       Mask2[29]:= 255;
  Mask1[30]:= 255;     Mask2[30]:= 0;
  Mask1[31]:= 0;       Mask2[31]:= 255;
  {Medium Horizontal Lines}
 { PStyle[4]:= 'Medium Horizontal Lines';  }
  Mask1[32]:= 0;       Mask2[32]:= 255;
  Mask1[33]:= 0;       Mask2[33]:= 255;
  Mask1[34]:= 255;     Mask2[34]:= 0;
  Mask1[35]:= 255;     Mask2[35]:= 0;
  Mask1[36]:= 0;       Mask2[36]:= 255;
  Mask1[37]:= 0;       Mask2[37]:= 255;
  Mask1[38]:= 255;     Mask2[38]:= 0;
  Mask1[39]:= 255;     Mask2[39]:= 0;
  {Thick Horizontal Lines}
 { PStyle[5]:= 'Thick Horizontal Lines';  }
  Mask1[40]:= 0;       Mask2[40]:= 255;
  Mask1[41]:= 0;       Mask2[41]:= 255;
  Mask1[42]:= 0;       Mask2[42]:= 255;
  Mask1[43]:= 255;     Mask2[43]:= 0;
  Mask1[44]:= 255;     Mask2[44]:= 0;
  Mask1[45]:= 255;     Mask2[45]:= 0;
  Mask1[46]:= 0;       Mask2[46]:= 255;
  Mask1[47]:= 0;       Mask2[47]:= 255;
  {Fine Square Net }
 { Pstyle[6]:= 'Fine Square Net';  }
  Mask1[48]:= 17;       Mask2[48]:= 238;
  Mask1[49]:= 17;       Mask2[49]:= 238;
  Mask1[50]:= 255;      Mask2[50]:= 0;
  Mask1[51]:= 17;       Mask2[51]:= 238;
  Mask1[52]:= 17;       Mask2[52]:= 238;
  Mask1[53]:= 17;       Mask2[53]:= 238;
  Mask1[54]:= 255;      Mask2[54]:= 0;
  Mask1[55]:= 17;       Mask2[55]:= 238;
  {Medium Square Net }
 { Pstyle[7]:= 'Medium Square Net';  }
  Mask1[56]:= 102;     Mask2[56]:= 153;
  Mask1[57]:= 255;     Mask2[57]:= 0;
  Mask1[58]:= 255;     Mask2[58]:= 0;
  Mask1[59]:= 102;     Mask2[59]:= 153;
  Mask1[60]:= 102;     Mask2[60]:= 153;
  Mask1[61]:= 255;     Mask2[61]:= 0;
  Mask1[62]:= 255;     Mask2[62]:= 0;
  Mask1[63]:= 102;     Mask2[63]:= 153;
  {Thick Square Net }
 { PStyle[8]:= 'Thick Square Net';  }
  Mask1[64]:= 56;      Mask2[64]:= 199;
  Mask1[65]:= 56;      Mask2[65]:= 199;
  Mask1[66]:= 255;     Mask2[66]:= 0;
  Mask1[67]:= 255;     Mask2[67]:= 0;
  Mask1[68]:= 255;     Mask2[68]:= 0;
  Mask1[69]:= 56;      Mask2[69]:= 199;
  Mask1[70]:= 56;      Mask2[70]:= 199;
  Mask1[71]:= 56;      Mask2[71]:= 199;
  {Hollow Squares }
  {Thin Hollow Squares }
 { PStyle[9]:= 'Thin Hollow Squares'; }
  Mask1[72]:= 0;       Mask2[72]:= 0;
  Mask1[73]:= 126;     Mask2[73]:= 0;
  Mask1[74]:= 66;      Mask2[74]:= 60;
  Mask1[75]:= 66;      Mask2[75]:= 60;
  Mask1[76]:= 66;      Mask2[76]:= 60;
  Mask1[77]:= 66;      Mask2[77]:= 60;
  Mask1[78]:= 126;     Mask2[78]:= 0;
  Mask1[79]:= 0;       Mask2[79]:= 0;
  {Hollow Squares}
 { PStyle[10]:= 'Hollow Squares';  }
  Mask1[80]:= 0;       Mask2[80]:= 0;
  Mask1[81]:= 126;     Mask2[81]:= 0;
  Mask1[82]:= 126;     Mask2[82]:= 0;
  Mask1[83]:= 102;     Mask2[83]:= 24;
  Mask1[84]:= 102;     Mask2[84]:= 24;
  Mask1[85]:= 126;     Mask2[85]:= 0;
  Mask1[86]:= 126;     Mask2[86]:= 0;
  Mask1[87]:= 0;       Mask2[87]:= 0;
  {Small Squares}
 { PStyle[11]:= 'Small Squares';  }
  Mask1[88]:= 51;      Mask2[88]:= 204;
  Mask1[89]:= 51;      Mask2[89]:= 204;
  Mask1[90]:= 204;     Mask2[90]:= 51;
  Mask1[91]:= 204;     Mask2[91]:= 51;
  Mask1[92]:= 51;      Mask2[92]:= 204;
  Mask1[93]:= 51;      Mask2[93]:= 204;
  Mask1[94]:= 204;     Mask2[94]:= 51;
  Mask1[95]:= 204;     Mask2[95]:= 51;
  {Medium Squares}
 { PStyle[12]:= 'Medium Squares';  }
  Mask1[96]:=  15;      Mask2[96]:=  240;
  Mask1[97]:=  15;      Mask2[97]:=  240;
  Mask1[98]:=  15;      Mask2[98]:=  240;
  Mask1[99]:=  15;      Mask2[99]:=  240;
  Mask1[100]:= 240;     Mask2[100]:= 15;
  Mask1[101]:= 240;     Mask2[101]:= 15;
  Mask1[102]:= 240;     Mask2[102]:= 15;
  Mask1[103]:= 240;     Mask2[103]:= 15;
  {circles}
 { PStyle[13]:= 'Circles';  }
  Mask1[104]:= 0;       Mask2[104]:= 255;
  Mask1[105]:= 0;       Mask2[105]:= 255;
  Mask1[106]:= 24;      Mask2[106]:= 231;
  Mask1[107]:= 60;      Mask2[107]:= 195;
  Mask1[108]:= 60;      Mask2[108]:= 195;
  Mask1[109]:= 24;      Mask2[109]:= 231;
  Mask1[110]:= 0;       Mask2[110]:= 255;
  Mask1[111]:= 0;       Mask2[111]:= 255;
  {Hollow Circles}
 { PStyle[14]:= 'Hollow Circles'; }
  Mask1[112]:= 0;       Mask2[112]:= 0;
  Mask1[113]:= 24;      Mask2[113]:= 0;
  Mask1[114]:= 36;      Mask2[114]:= 24;
  Mask1[115]:= 66;      Mask2[115]:= 60;
  Mask1[116]:= 66;      Mask2[116]:= 60;
  Mask1[117]:= 36;      Mask2[117]:= 24;
  Mask1[118]:= 24;      Mask2[118]:= 0;
  Mask1[119]:= 0;       Mask2[119]:= 0;
  {Fine left Diagonal}
 { PStyle[15]:= 'Fine Left Diagonal';  }
  Mask1[120]:= 17;      Mask2[120]:= 238;
  Mask1[121]:= 34;      Mask2[121]:= 221;
  Mask1[122]:= 68;      Mask2[122]:= 187;
  Mask1[123]:= 136;     Mask2[123]:= 119;
  Mask1[124]:= 17;      Mask2[124]:= 238;
  Mask1[125]:= 34;      Mask2[125]:= 221;
  Mask1[126]:= 68;      Mask2[126]:= 187;
  Mask1[127]:= 136;     Mask2[127]:= 119;
  {Medium Left Diagonal}
 { PStyle[16]:= 'Medium Left Diagonal';  }
  Mask1[128]:= 51;      Mask2[128]:= 204;
  Mask1[129]:= 102;     Mask2[129]:= 153;
  Mask1[130]:= 204;     Mask2[130]:= 51;
  Mask1[131]:= 153;     Mask2[131]:= 102;
  Mask1[132]:= 51;      Mask2[132]:= 204;
  Mask1[133]:= 102;     Mask2[133]:= 153;
  Mask1[134]:= 204;     Mask2[134]:= 51;
  Mask1[135]:= 153;     Mask2[135]:= 102;
  {Thick Left Diagonal}
 { PStyle[17]:= 'Thick Left Diagonal';  }
  Mask1[136]:= 7;       Mask2[136]:= 248;
  Mask1[137]:= 14;      Mask2[137]:= 241;
  Mask1[138]:= 28;      Mask2[138]:= 227;
  Mask1[139]:= 56;      Mask2[139]:= 199;
  Mask1[140]:= 112;     Mask2[140]:= 143;
  Mask1[141]:= 224;     Mask2[141]:= 31;
  Mask1[142]:= 193;     Mask2[142]:= 62;
  Mask1[143]:= 131;     Mask2[143]:= 124;
  {Fine Right Diagonal}
 { PStyle[18]:= 'Fine Right Diagonal';  }
  Mask1[151]:= 17;      Mask2[151]:= 238;
  Mask1[150]:= 34;      Mask2[150]:= 221;
  Mask1[149]:= 68;      Mask2[149]:= 187;
  Mask1[148]:= 136;     Mask2[148]:= 119;
  Mask1[147]:= 17;      Mask2[147]:= 238;
  Mask1[146]:= 34;      Mask2[146]:= 221;
  Mask1[145]:= 68;      Mask2[145]:= 187;
  Mask1[144]:= 136;     Mask2[144]:= 119;
  {Medium Right Diagonal}
 { PStyle[19]:= 'Medium Right Diagonal';   }
  Mask1[159]:= 51;      Mask2[159]:= 204;
  Mask1[158]:= 102;     Mask2[158]:= 153;
  Mask1[157]:= 204;     Mask2[157]:= 51;
  Mask1[156]:= 153;     Mask2[156]:= 102;
  Mask1[155]:= 51;      Mask2[155]:= 204;
  Mask1[154]:= 102;     Mask2[154]:= 153;
  Mask1[153]:= 204;     Mask2[153]:= 51;
  Mask1[152]:= 153;     Mask2[152]:= 102;
  {Thick Left Diagonal}
 { PStyle[20]:= 'Thick Right Diagonal';  }
  Mask1[167]:= 7;       Mask2[167]:= 248;
  Mask1[166]:= 14;      Mask2[166]:= 241;
  Mask1[165]:= 28;      Mask2[165]:= 227;
  Mask1[164]:= 56;      Mask2[164]:= 199;
  Mask1[163]:= 112;     Mask2[163]:= 143;
  Mask1[162]:= 224;     Mask2[162]:= 31;
  Mask1[161]:= 193;     Mask2[161]:= 62;
  Mask1[160]:= 131;     Mask2[160]:= 124;
   {Fine Diamond Mesh}
 { PStyle[21]:= 'Fine Diamond Mesh';  }
  Mask1[168]:= 17;      Mask2[168]:= 238;
  Mask1[169]:= 170;     Mask2[169]:=  85;
  Mask1[170]:= 68;      Mask2[170]:= 187;
  Mask1[171]:= 170;     Mask2[171]:=  85;
  Mask1[172]:= 17;      Mask2[172]:= 238;
  Mask1[173]:= 170;     Mask2[173]:=  85;
  Mask1[174]:= 68;      Mask2[174]:= 187;
  Mask1[175]:= 170;     Mask2[175]:=  85;
  {Thick Diamond Mesh}
 { PStyle[22]:= 'Thick Diamond Mesh';  }
  Mask1[176]:= 199;     Mask2[176]:=  56;
  Mask1[177]:= 238;     Mask2[177]:=  17;
  Mask1[178]:= 124;     Mask2[178]:= 131;
  Mask1[179]:=  56;     Mask2[179]:= 199;
  Mask1[180]:= 124;     Mask2[180]:= 131;
  Mask1[181]:= 238;     Mask2[181]:=  17;
  Mask1[182]:= 199;     Mask2[182]:=  56;
  Mask1[183]:= 131;     Mask2[183]:= 124;
  {Medium Filled Diamond}
 { PStyle[23]:= 'Medium Filled Diamond';  }
  Mask1[184]:= 119;     Mask2[184]:=  136;
  Mask1[185]:=  34;     Mask2[185]:=  221;
  Mask1[186]:=   0;     Mask2[186]:=  255;
  Mask1[187]:=  34;     Mask2[187]:=  221;
  Mask1[188]:= 119;     Mask2[188]:=  136;
  Mask1[189]:=  34;     Mask2[189]:=  221;
  Mask1[190]:=   0;     Mask2[190]:=  255;
  Mask1[191]:=  34;     Mask2[191]:=  221;
   {Large Filled Diamond}
 { PStyle[24]:= 'Large Filled Diamond';  }
  Mask1[192]:= 129;     Mask2[192]:= 126;
  Mask1[193]:= 195;     Mask2[193]:=  60;
  Mask1[194]:= 231;     Mask2[194]:=  24;
  Mask1[195]:= 255;     Mask2[195]:=   0;
  Mask1[196]:= 255;     Mask2[196]:=   0;
  Mask1[197]:= 231;     Mask2[197]:=  24;
  Mask1[198]:= 195;     Mask2[198]:=  60;
  Mask1[199]:= 129;     Mask2[199]:= 126;
  {Weave}
 { PStyle[25]:= 'Weave';   }
  Mask1[200]:=   6;     Mask2[200]:= 193;
  Mask1[201]:=  14;     Mask2[201]:= 224;
  Mask1[202]:=  28;     Mask2[202]:=  96;
  Mask1[203]:=  56;     Mask2[203]:=   0;
  Mask1[204]:= 112;     Mask2[204]:=  12;
  Mask1[205]:= 224;     Mask2[205]:=  14;
  Mask1[206]:= 192;     Mask2[206]:=   7;
  Mask1[207]:=   0;     Mask2[207]:= 131;
  {Hollow Diamonds}
 { PStyle[26]:= 'Vertical Weave';  }
  Mask1[208]:= 24;      Mask2[208]:= 231;
  Mask1[209]:= 153;     Mask2[209]:= 0;
  Mask1[210]:= 153;     Mask2[210]:= 0;
  Mask1[211]:= 129;     Mask2[211]:= 126;
  Mask1[212]:= 129;     Mask2[212]:= 126;
  Mask1[213]:= 153;     Mask2[213]:= 0;
  Mask1[214]:= 153;     Mask2[214]:= 0;
  Mask1[215]:= 24;      Mask2[215]:= 231;
   {Undefined}
 { PStyle[27]:= 'Fine ZigZag';  }
  Mask1[216]:= 153;     Mask2[216]:= 102;
  Mask1[217]:= 60;      Mask2[217]:= 195;
  Mask1[218]:= 102;     Mask2[218]:= 153;
  Mask1[219]:= 195;     Mask2[219]:= 60;
  Mask1[220]:= 153;     Mask2[220]:= 102;
  Mask1[221]:= 60;      Mask2[221]:= 195;
  Mask1[222]:= 102;     Mask2[222]:= 153;
  Mask1[223]:= 195;     Mask2[223]:= 60;
  {Undefined}
 { PStyle[28]:= 'Thick ZigZag'; }
  Mask1[224]:= 0;       Mask2[224]:= 255;
  Mask1[225]:= 8;       Mask2[225]:= 247;
  Mask1[226]:= 28;      Mask2[226]:= 227;
  Mask1[227]:= 62;      Mask2[227]:= 193;
  Mask1[228]:= 119;     Mask2[228]:= 136;
  Mask1[229]:= 227;     Mask2[229]:= 28;
  Mask1[230]:= 193;     Mask2[230]:= 62;
  Mask1[231]:= 128;     Mask2[231]:= 127;
  {Undefined}
 { PStyle[29]:= 'Fine Vert ZigZag';   }
  Mask1[232]:= 153;     Mask2[232]:= 102;
  Mask1[233]:= 51;      Mask2[233]:= 204;
  Mask1[234]:= 102;     Mask2[234]:= 153;
  Mask1[235]:= 204;     Mask2[235]:= 51;
  Mask1[236]:= 204;     Mask2[236]:= 51;
  Mask1[237]:= 102;     Mask2[237]:= 153;
  Mask1[238]:= 51;      Mask2[238]:= 204;
  Mask1[239]:= 153;     Mask2[239]:= 102;
  {Undefined}
 { PStyle[29]:= 'Thick Vert ZigZag';   }
  Mask1[240]:= 14;      Mask2[240]:= 241;
  Mask1[241]:= 28;      Mask2[241]:= 227;
  Mask1[242]:= 56;      Mask2[242]:= 199;
  Mask1[243]:= 112;     Mask2[243]:= 143;
  Mask1[244]:= 56;      Mask2[244]:= 199;
  Mask1[245]:= 28;      Mask2[245]:= 227;
  Mask1[246]:= 14;      Mask2[246]:= 241;
  Mask1[247]:= 7;       Mask2[247]:= 248;
    {Undefined}
 { PStyle[29]:= 'Triangles' }
  Mask1[248]:= 8;       Mask2[248]:= 247;
  Mask1[249]:= 28;      Mask2[249]:= 227;
  Mask1[250]:= 62;      Mask2[250]:= 193;
  Mask1[251]:= 127;     Mask2[251]:= 128;
  Mask1[252]:= 128;     Mask2[252]:= 127;
  Mask1[253]:= 193;     Mask2[253]:= 62;
  Mask1[254]:= 227;     Mask2[254]:= 28;
  Mask1[255]:= 247;     Mask2[255]:= 8;
    {Undefined}
 { PStyle[29]:= 'Vertical Triangles' }
  Mask1[256]:= 232;     Mask2[256]:= 23;
  Mask1[257]:= 204;     Mask2[257]:= 51;
  Mask1[258]:= 142;     Mask2[258]:= 113;
  Mask1[259]:= 15;      Mask2[259]:= 240;
  Mask1[260]:= 142;     Mask2[260]:= 113;
  Mask1[261]:= 204;     Mask2[261]:= 51;
  Mask1[262]:= 232;     Mask2[262]:= 23;
  Mask1[263]:= 240;     Mask2[263]:= 15;
 end;  {Set Fill Patterns}

 Procedure SetMarkerPatterns;
  {set up arrays for markers}
 var  i:integer;

 begin
  for  i:= 0 to 100 do
   begin
    club[i].x:=  0.0;   club[i].y:=  0.0;
    spade[i].x:=  0.0;  spade[i].y:=  0.0;
    heart[i].x:=  0.0;  heart[i].y:=  0.0;
    snake[i].x:= 0.0;   snake[i].y:= 0.0;
    rpt2[i].x:= 0.0;    rpt2[i].y:= 0.0;
   end;
   {Data array for club}
   club[0].x:=  -0.191;   club[0].y:=   0.01;
   club[1].x:=  -0.122;   club[1].y:=   0.141;
   club[2].x:=  -0.080;   club[2].y:=   0.270;
   club[3].x:=  -0.062;   club[3].y:=   0.346;
   club[4].x:=  -0.057;   club[4].y:=   0.400;
   club[5].x:=  -0.087;   club[5].y:=   0.327;
   club[6].x:=  -0.121;   club[6].y:=   0.292;
   club[7].x:=  -0.159;   club[7].y:=   0.258;
   club[8].x:=  -0.219;   club[8].y:=   0.235;
   club[9].x:=  -0.302;   club[9].y:=   0.229;
   club[10].x:= -0.391;   club[10].y:=  0.257;
   club[11].x:= -0.458;   club[11].y:=  0.314;
   club[12].x:= -0.492;   club[12].y:=  0.388;
   club[13].x:= -0.502;   club[13].y:=  0.462;
   club[14].x:= -0.481;   club[14].y:=  0.545;
   club[15].x:= -0.441;   club[15].y:=  0.608;
   club[16].x:= -0.378;   club[16].y:=  0.655;
   club[17].x:= -0.304;   club[17].y:=  0.678;
   club[18].x:= -0.243;   club[18].y:=  0.675;
   club[19].x:= -0.191;   club[19].y:=  0.660;
   club[20].x:= -0.216;   club[20].y:=  0.719;
   club[21].x:= -0.227;   club[21].y:=  0.785;
   club[22].x:= -0.213;   club[22].y:=  0.854;
   club[23].x:= -0.181;   club[23].y:=  0.914;
   club[24].x:= -0.132;   club[24].y:=  0.963;
   club[25].x:= -0.077;   club[25].y:=  0.989;
   club[26].x:= -0.010;   club[26].y:=  1.004;
   club[27].x:=  0.039;   club[27].y:=  1.001;
   club[28].x:=  0.100;   club[28].y:=  0.980;
   club[29].x:=  0.160;   club[29].y:=  0.939;
   club[30].x:=  0.199;   club[30].y:=  0.889;
   club[31].x:=  0.222;   club[31].y:=  0.820;
   club[32].x:=  0.224;   club[32].y:=  0.743;
   club[33].x:=  0.210;   club[33].y:=  0.698;
   club[34].x:=  0.193;   club[34].y:=  0.664;
   club[35].x:=  0.233;   club[35].y:=  0.675;
   club[36].x:=  0.302;   club[36].y:=  0.677;
   club[37].x:=  0.363;   club[37].y:=  0.661;
   club[38].x:=  0.419;   club[38].y:=  0.627;
   club[39].x:=  0.462;   club[39].y:=  0.580;
   club[40].x:=  0.489;   club[40].y:=  0.524;
   club[41].x:=  0.502;   club[41].y:=  0.458;
   club[42].x:=  0.499;   club[42].y:=  0.418;
   club[43].x:=  0.481;   club[43].y:=  0.359;
   club[44].x:=  0.455;   club[44].y:=  0.316;
   club[45].x:=  0.421;   club[45].y:=  0.283;
   club[46].x:=  0.372;   club[46].y:=  0.249;
   club[47].x:=  0.310;   club[47].y:=  0.229;
   club[48].x:=  0.230;   club[48].y:=  0.231;
   club[49].x:=  0.172;   club[49].y:=  0.252;
   club[50].x:=  0.120;   club[50].y:=  0.289;
   club[51].x:=  0.081;   club[51].y:=  0.336;
   club[52].x:=  0.054;   club[52].y:=  0.401;
   club[53].x:=  0.073;   club[53].y:=  0.299;
   club[54].x:=  0.095;   club[54].y:=  0.227;
   club[55].x:=  0.123;   club[55].y:=  0.136;
   club[56].x:=  0.156;   club[56].y:=  0.063;
   club[57].x:=  0.191;   club[57].y:= -0.001;
   club[58].x:=  0.01;    club[58].y:=  0.01;

 {Data array for spades}
   spade[0].x:=  -0.055;  spade[0].y:=  -0.111;
   spade[1].x:=  -0.129;  spade[1].y:=  -0.203;
   spade[2].x:=  -0.220;  spade[2].y:=  -0.275;
   spade[3].x:=  -0.349;  spade[3].y:=  -0.354;
   spade[4].x:=  -0.419;  spade[4].y:=  -0.411;
   spade[5].x:=  -0.476;  spade[5].y:=  -0.489;
   spade[6].x:=  -0.499;  spade[6].y:=  -0.570;
   spade[7].x:=  -0.494;  spade[7].y:=  -0.652;
   spade[8].x:=  -0.463;  spade[8].y:=  -0.734;
   spade[9].x:=  -0.407;  spade[9].y:=  -0.795;
   spade[10].x:= -0.350;  spade[10].y:= -0.830;
   spade[11].x:= -0.277;  spade[11].y:= -0.852;
   spade[12].x:= -0.190;  spade[12].y:= -0.844;
   spade[13].x:= -0.119;  spade[13].y:= -0.817;
   spade[14].x:= -0.080;  spade[14].y:= -0.787;
   spade[15].x:= -0.034;  spade[15].y:= -0.728;
   spade[16].x:= -0.037;  spade[16].y:= -0.834;
   spade[17].x:= -0.057;  spade[17].y:= -0.971;
   spade[18].x:= -0.088;  spade[18].y:= -1.081;
   spade[19].x:= -0.135;  spade[19].y:= -1.201;
   spade[20].x:=  0.127;  spade[20].y:= -1.201;
   spade[21].x:=  0.077;  spade[21].y:= -1.054;
   spade[22].x:=  0.077;  spade[22].y:= -1.054;
   spade[23].x:=  0.053;  spade[23].y:= -0.928;
   spade[24].x:=  0.042;  spade[24].y:= -0.821;
   spade[25].x:=  0.040;  spade[25].y:= -0.733;
   spade[26].x:=  0.082;  spade[26].y:= -0.788;
   spade[27].x:=  0.137;  spade[27].y:= -0.823;
   spade[28].x:=  0.137;  spade[28].y:= -0.823;
   spade[29].x:=  0.201;  spade[29].y:= -0.847;
   spade[30].x:=  0.281;  spade[30].y:= -0.851;
   spade[31].x:=  0.328;  spade[31].y:= -0.839;
   spade[32].x:=  0.390;  spade[32].y:= -0.809;
   spade[33].x:=  0.450;  spade[33].y:= -0.752;
   spade[34].x:=  0.489;  spade[34].y:= -0.676;
   spade[35].x:=  0.500;  spade[35].y:= -0.605;
   spade[36].x:=  0.491;  spade[36].y:= -0.534;
   spade[37].x:=  0.464;  spade[37].y:= -0.472;
   spade[38].x:=  0.426;  spade[38].y:= -0.420;
   spade[39].x:=  0.361;  spade[39].y:= -0.365;
   spade[40].x:=  0.275;  spade[40].y:= -0.307;
   spade[41].x:=  0.183;  spade[41].y:= -0.251;
   spade[42].x:=  0.136;  spade[42].y:= -0.210;
   spade[43].x:=  0.074;  spade[43].y:= -0.140;
   spade[44].x:=  0.038;  spade[44].y:= -0.077;
   spade[45].x:=  0.001;  spade[45].y:=  0.000;
  {data for hearts}
   Heart[0].x:= -0.114;   Heart[0].y:=  0.067;
   Heart[1].x:= -0.203;   Heart[1].y:=  0.136;
   Heart[2].x:= -0.281;   Heart[2].y:=  0.215;
   Heart[3].x:= -0.374;   Heart[3].y:=  0.324;
   Heart[4].x:= -0.450;   Heart[4].y:=  0.431;
   Heart[5].x:= -0.487;   Heart[5].y:=  0.505;
   Heart[6].x:= -0.502;   Heart[6].y:=  0.584;
   Heart[7].x:= -0.492;   Heart[7].y:=  0.661;
   Heart[8].x:= -0.465;   Heart[8].y:=  0.724;
   Heart[9].x:= -0.419;   Heart[9].y:=  0.785;
   Heart[10].x:=-0.349;   Heart[10].y:= 0.832;
   Heart[11].x:=-0.291;   Heart[11].y:= 0.851;
   Heart[12].x:=-0.224;   Heart[12].y:= 0.858;
   Heart[13].x:=-0.147;   Heart[13].y:= 0.846;
   Heart[14].x:=-0.073;   Heart[14].y:= 0.812;
   Heart[15].x:=-0.031;   Heart[15].y:= 0.771;
   Heart[16].x:= 0.003;   Heart[16].y:= 0.726;
   Heart[17].x:= 0.035;   Heart[17].y:= 0.775;
   Heart[18].x:= 0.091;   Heart[18].y:= 0.821;
   Heart[19].x:= 0.162;   Heart[19].y:= 0.850;
   Heart[20].x:= 0.239;   Heart[20].y:= 0.860;
   Heart[21].x:= 0.303;   Heart[21].y:= 0.847;
   Heart[22].x:= 0.377;   Heart[22].y:= 0.817;
   Heart[23].x:= 0.443;   Heart[23].y:= 0.758;
   Heart[24].x:= 0.483;   Heart[24].y:= 0.688;
   Heart[25].x:= 0.500;   Heart[25].y:= 0.598;
   Heart[26].x:= 0.494;   Heart[26].y:= 0.520;
   Heart[27].x:= 0.472;   Heart[27].y:= 0.467;
   Heart[28].x:= 0.390;   Heart[28].y:= 0.347;
   Heart[29].x:= 0.306;   Heart[29].y:= 0.244;
   Heart[30].x:= 0.237;   Heart[30].y:= 0.176;
   Heart[31].x:= 0.170;   Heart[31].y:= 0.118;
   Heart[32].x:= 0.091;   Heart[32].y:= 0.060;
   Heart[33].x:= 0.000;   Heart[33].y:= 0.007;
   {data for snake}
      Snake[0].x:=  -0.135;  Snake[0].y:=   0.452;
   Snake[1].x:=  -0.095;  Snake[1].y:=   0.484;
   Snake[2].x:=  -0.039;  Snake[2].y:=   0.497;
   Snake[3].x:=   0.014;  Snake[3].y:=   0.486;
   Snake[4].x:=   0.066;  Snake[4].y:=   0.445;
   Snake[5].x:=   0.095;  Snake[5].y:=   0.369;
   Snake[6].x:=   0.084;  Snake[6].y:=   0.318;
   Snake[7].x:=   0.061;  Snake[7].y:=   0.279;
   Snake[8].x:=   0.151;  Snake[8].y:=   0.203;
   Snake[9].x:=   0.197;  Snake[9].y:=   0.127;
   Snake[10].x:=  0.221;  Snake[10].y:=  0.041;
   Snake[11].x:=  0.207;  Snake[11].y:= -0.105;
   Snake[12].x:=  0.142;  Snake[12].y:= -0.211;
   Snake[13].x:=  0.071;  Snake[13].y:= -0.269;
   Snake[14].x:= -0.003;  Snake[14].y:= -0.306;
   Snake[15].x:= -0.033;  Snake[15].y:= -0.343;
   Snake[16].x:= -0.035;  Snake[16].y:= -0.392;
   Snake[17].x:= -0.015;  Snake[17].y:= -0.438;
   Snake[18].x:=  0.023;  Snake[18].y:= -0.460;
   Snake[19].x:=  0.077;  Snake[19].y:= -0.464;
   Snake[20].x:=  0.123;  Snake[20].y:= -0.435;
   Snake[21].x:=  0.145;  Snake[21].y:= -0.469;
   Snake[22].x:=  0.091;  Snake[22].y:= -0.502;
   Snake[23].x:=  0.034;  Snake[23].y:= -0.507;
   Snake[24].x:= -0.023;  Snake[24].y:= -0.483;
   Snake[25].x:= -0.063;  Snake[25].y:= -0.450;
   Snake[26].x:= -0.083;  Snake[26].y:= -0.399;
   Snake[27].x:= -0.087;  Snake[27].y:= -0.355;
   Snake[28].x:= -0.073;  Snake[28].y:= -0.324;
   Snake[29].x:= -0.050;  Snake[29].y:= -0.283;
   Snake[30].x:= -0.003;  Snake[30].y:= -0.250;
   Snake[31].x:=  0.061;  Snake[31].y:= -0.215;
   Snake[32].x:=  0.119;  Snake[32].y:= -0.157;
   Snake[33].x:=  0.161;  Snake[33].y:= -0.073;
   Snake[34].x:=  0.174;  Snake[34].y:=  0.017;
   Snake[35].x:=  0.156;  Snake[35].y:=  0.098;
   Snake[36].x:=  0.116;  Snake[36].y:=  0.167;
   Snake[37].x:=  0.059;  Snake[37].y:=  0.222;
   Snake[38].x:=  0.009;  Snake[38].y:=  0.247;
   Snake[39].x:= -0.067;  Snake[39].y:=  0.198;
   Snake[40].x:= -0.135;  Snake[40].y:=  0.102;
   Snake[41].x:= -0.160;  Snake[41].y:= -0.006;
   Snake[42].x:= -0.146;  Snake[42].y:= -0.086;
   Snake[43].x:= -0.111;  Snake[43].y:= -0.162;
   Snake[44].x:= -0.055;  Snake[44].y:= -0.215;
   Snake[45].x:= -0.005;  Snake[45].y:= -0.251;
   Snake[46].x:= -0.054;  Snake[46].y:= -0.286;
   Snake[47].x:= -0.114;  Snake[47].y:= -0.238;
   Snake[48].x:= -0.169;  Snake[48].y:= -0.156;
   Snake[49].x:= -0.210;  Snake[49].y:= -0.058;
   Snake[50].x:= -0.199;  Snake[50].y:=  0.080;
   Snake[51].x:= -0.164;  Snake[51].y:=  0.167;
   Snake[52].x:= -0.111;  Snake[52].y:=  0.233;
   Snake[53].x:= -0.054;  Snake[53].y:=  0.273;
   Snake[54].x:=  0.004;  Snake[54].y:=  0.300;
   Snake[55].x:=  0.034;  Snake[55].y:=  0.346;
   Snake[56].x:=  0.030;  Snake[56].y:=  0.399;
   Snake[57].x:= -0.001;  Snake[57].y:=  0.430;
   Snake[58].x:= -0.042;  Snake[58].y:=  0.445;
   Snake[59].x:= -0.076;  Snake[59].y:=  0.436;
   Snake[60].x:= -0.103;  Snake[60].y:=  0.416;

end;   {setMarkerPatterns}


procedure TDisplayForm.FormCreate(Sender: TObject);

var Theta, Xcentre,YCentre,Radian:double; {Temp variables for testing rotations}
    i:integer;
begin
    {Set default window size - to fit a VGA display.}
    ScaleMode:= 0;
    Top:=  40;
    Left:= 30;
    Height := 400;
    Width := 600;
    WindowHeight:= 10.0; WindowWidth:= 12.5;
    XWinOrigin:= 0; YWinOrigin:= 0;
    PixelsPerCm := 50.0;
    DotsperCm   := 118.11; {Set for 300 d.p.i. printer}
    GLEHeight := Round(30*PixelsPerCm);
    GlEWidth  := Round(20*PixelsPerCm);
    TextAngle:= 0.0;   {Angle of text relative to rest of diagram}
    CTransFormNum:=0;  {Sets start of Transform Stack}
    BeginNum:=0;       {Sets start of Begin Stack}
    BeginValue:=100;   {Sets initial count for unnamed Begins}
    XOffset:=0.0;
    YOffset:=0.0;
    MarkerType:=2;
    MarkerSize:=Round(0.08*PixelsPerCm);
    MarkerStyle[0] := 'circle';
    MarkerStyle[1] := 'triangle';
    MarkerStyle[2] := 'square';
    MarkerStyle[3] := 'diamond';
    MarkerStyle[4] := 'fcircle';
    MarkerStyle[5] := 'ftriangle';
    MarkerStyle[6] := 'fsquare';
    MarkerStyle[7] := 'fdiamond';
    MarkerStyle[8] := 'dot';
    MarkerStyle[9] := 'cross';
    MarkerStyle[10] := 'club';
    MarkerStyle[11] := 'heart';
    with Ctrans[0] do
    begin;        {Base of Transform stack}
      XOrigin:= 0;
      Yorigin := 0;
      Xscale := 1.0;
      Yscale := 1.0;
      TranC:= 1.0; TranD:= 0;
      TranF:= 1.0; TranE:= 0;
      Rotation:= 0;
      Radian:= 1.745327778e-02;
    end;
    ArrowStart:=False; ArrowEnd:=False;
    ArrowStyle:= 9; Arrowlinecolor:= Black; ArrowSize:=0.01*PixelsPerCm;
    CurrentTransform:=Ctrans[0];
    CurrentInvTransform:=InverseTransform(CurrentTransform);
    CurrentPoint.x:=0.0;Currentpoint.y:=0.0;
    DrawStart := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
    DrawEnd:=DrawStart; LastEnd:=DrawStart;LastStart:=DrawStart;
    DefaultFont:=Tfont.create;
    DefaultFont.name:='Times New Roman';
    DefaultFont.Style:=[ ];
    DefaultFont.Size:=Round(0.2*PixelsperCm);
    DefaultFont.Color:=clBlack;
    LastFont:=Tfont.create;
    LastFont.assign(defaultfont);
    CurrentFont:= Tfont.Create;
    CurrentFont.assign(DefaultFont);
    BrushBitmap:= TBitmap.Create;
    BrushBitmap.Height:= 8;
    BrushBitmap.Width:= 8;
    Image1.Picture.Graphic := Bitmap;{Assign the bitmap to the image component}
    TextOn:=False;
    DrawingTool:= dtNone;
    MouseMode:= True;
    with Image1 do
    begin
     Canvas.Pen.Style:=psSolid;
     Canvas.Pen.Width :=1;
     Canvas.Pen.Color:=clBlack;
     Canvas.Brush.Style:=bsClear;
    end;
    Screen.Cursors[crZoom] := LoadCursor(HInstance, 'ZCursor');
    Image1.Cursor:= crZoom;
    SpotSize:=5;
    BrushBitmapSet:= False;
    gResetlevel:= 0;
    SaveSettings;
    DefaultSettings:= SavedSettings;
    SetFillPatterns;
    SetMarkerPatterns;
end;  {FormCreate}

procedure BasicArc(var Arcpoint:array of RealPoint;XCentre,YCentre,
                   XRadius,YRadius,StartAngle,EndAngle:double);
{Sets up an array of points defining an elliptical arc,
 centre at Xcentre,YCentre, radii Xradius,YRadius,
 running from StartAngle to EndAngle. All co-ordinates in cms
 and angles in degrees. Note that because basic pixel y coordinates start
 at top of screen this draws a clockwise arc. After first applying
 coordinate transforms arc will conform to conventional practice.}

 const  Pi = 3.14159265358979;
         radian = Pi/180.0;

 var  i:integer;
      StepAngle,Cos1,CosStep,Sin1,SinStep,c,s,x,y:double;

 begin
 { First put StartAngle within range 0 to 360 degrees.}
   if StartAngle>0 then
        while StartAngle>360.0 do StartAngle:= StartAngle-360.0
   else while StartAngle<0.0   do StartAngle:= StartAngle+360.0;
  { Now set EndAngle to be no more than 360 deg > StartAngle }
   while EndAngle>StartAngle do EndAngle:= EndAngle-360.0;
   while EndAngle<StartAngle do EndAngle:= EndAngle+360.0;
   {convert to radians and work out increment}
   StartAngle:= StartAngle*radian;
   EndAngle:= EndAngle*radian;
   StepAngle:= (EndAngle-StartAngle)/50; {N.B. This will be positive}
   {Set up starting point}
   Cos1:=cos(StartAngle);Sin1:=sin(StartAngle);
   CosStep:=cos(StepAngle);SinStep:=sin(StepAngle);
   x:= Xcentre + Cos1*Xradius; y:= Ycentre + Sin1*Yradius;
   Arcpoint[0].x:= x;
   ArcPoint[0].y:= y;
   for i:= 1 to 49 do
   begin
     c:= Cos1*CosStep - Sin1*SinStep;
     s:= Cos1*SinStep + Sin1*CosStep;
     Cos1:=c; Sin1:=s;
     x:= Xcentre + Cos1*Xradius;
     y:= Ycentre + Sin1*Yradius;
     Arcpoint[i].x:= x;
     ArcPoint[i].y:= y;
   end;
 {To avoid accumulated errors use actual EndAngle for final point}
     Cos1 := cos(EndAngle); Sin1 := sin(EndAngle);
     x:= Xcentre + Cos1*Xradius; y:= Ycentre + Sin1*Yradius;
     Arcpoint[50].x:= x;
     ArcPoint[50].y:= y;
 end; {BasicArc}


 procedure DrawBezier(scale:double;x1,y1,xc1,yc1,xc2,yc2,x2,y2,
          dmode:integer);
{ Constructs a 2-Dimensional Besier spline from x1,y1 to
  x2,y2 using control points xc1,yc1 and xc2,yc2.
  Plots this on the screen using scale factor `scale' and
  mode control `dmode'.
  Set up modes 1 to 3 use narrow black lines
  dmode + 0 does nothing,
  dmode = 1 plots the straight line from start to end,
  dmode = 2 adds control points.
  dmode = 3 plots curve, control points and 1st control vector in black.
  dmode = 4 plots curve, control points and 2nd control vector in black.
  dmode = 5 plots both control vectors and curve in black
  dmode = 6 plots curve in original style and colour, then resets
  dmode = 7 plots curve in orignal style and colour without reset.}

var  i,i1,LastWidth: integer;
     t,t1,t2,t3,nc1,nc2,nc3,nc4: real;
     x,y: array[0 .. 21] of integer;
     LastColor: TColor;   { Delphi pen parameters }
     LastStyle: TPenStyle;

begin
with DisplayForm.Image1 do
begin
 if dmode>0 then
 begin
  LastWidth := Canvas.pen.Width;    {Save current line parameters }
  LastColor := Canvas.Pen.Color;
  LastStyle := Canvas.Pen.Style;
  Canvas.Pen.Color := clBlack;     { Reset as narrow black lines }
  Canvas.Pen.Style := psSolid;
  Canvas.Pen.Width := 1;
  if  dmode <3 then {Draw straight line from start to end }
  begin
    Setcurve := False;
    Canvas.Moveto(x1,y1);
    Canvas.LineTo(x2,y2);
  end;
  if   (dmode > 1) and (dmode < 6)  then { add control points }
  begin
    Canvas.Ellipse(x1+4,y1+4,x1-4,y1-4);
    Canvas.Ellipse(xc1+4,yc1+4,xc1-4,yc1-4);
    Canvas.Ellipse(xc2+4,yc2+4,xc2-4,yc2-4);
    Canvas.Ellipse(x2+4,y2+4,x2-4,y2-4);
  end;  { add control points }
  if dmode = 3 then    { Add 1st control vector }
  begin
    Canvas.MoveTo(xc1,yc1);
    Canvas.Lineto(x1,y1);
  end;
  if dmode = 4 then    { Adds 2nd control vector }
  begin
    Canvas.Moveto(x2,y2);
    Canvas.LineTo(xc2,yc2);
  end;
  if dmode = 5 then    {Add both control vectors }
  begin
    Canvas.MoveTo(xc1,yc1);
    Canvas.Lineto(x1,y1);
    Canvas.Moveto(x2,y2);
    Canvas.LineTo(xc2,yc2);
  end; { Add Control vectors }
  if dmode > 2 then  { evaluate Bezier curve }
  begin
    t:= -0.05;
    i1 := 1;
    for i := 0 to 20 do
    begin
     t := (0.05+t);
     t2 := sqr(t);
     t3 := t2*t;
     nc1 := 1 - 3*t + 3*t2 - t3;
     nc2 := 3*t3 - 6*t2 + 3*t;
     nc3 := 3*t2 - 3*t3;
     nc4 := t3;
     x[i1] := trunc(scale*(nc1*x1 + nc2*xc1 + nc3*xc2 + nc4*x2));
     y[i1] := trunc(scale*(nc1*y1 + nc2*yc1 + nc3*yc2 + nc4*y2));
     i1 := succ(i1);
    end; {For }
    i1:=pred(i1);
    x[i1] := x2; {Set final points to exact end values - Point 21}
    y[i1] := y2;
  end; {dmode>2}
  if (dmode>2) and (dmode < 6) then  {Draw Bezier curve as a narrow black line}
  begin
    Canvas.Moveto(x1,y1);
    For i := 1 to 21 do Canvas.LineTo(x[i],y[i]);
  end; { Draw Curve }
  Canvas.Pen.Width := LastWidth;    { Reset pen parameters }
  Canvas.Pen.Style := LastStyle;
  Canvas.Pen.Color := LastColor;
  if dmode = 6 then  { Draw in original style and colour }
  begin
    Canvas.Moveto(x1,y1);
    For i := 1 to 21 do Canvas.LineTo(x[i],y[i]);
  end; { Draw Curve }
 end; { dmode>0 }
end; { with DisplayForm ..}
end; {DrawBezier}


 procedure DrawArc(x1,y1,xc,yc,xa,ya,dmode:integer;var x2,y2:longint;
                    var Radius,StartAngle,EndAngle:double;Clock:boolean);
{ Constructs an arc from x1,y1 to x2,y2 using control points
  xc,yc and xa,ya. xc,yc is the centre of the arc, the arc ends at
  the intersection with the line from xc,yc to xa,ya.
  The arc is drawn clockwise if Clock is TRUE.
  Plots this on the screen using mode control `dmode' as follows:
  Set up modes 1 to 3 use narrow black lines
  dmode = 0 does nothing,
  dmode = 1 plots the initial straight line from x1,y1 to xc,yc,
  dmode = 2 plots control points at x1,y1,xc,yc and xa,ya.
  dmode = 3 plots arc and 1st control vector in black.
  dmode = 4 plots arc and 2nd control vector in black.
  dmode = 6 plots curve in original style and colour, then resets.
  dmode = 7 plots arc in original style and colour without resetting.
  the final end point x2, y2 is returned.}

const  Pi = 3.14159265358979;
       deg = -180.0/Pi;

 var  i,i1,LastWidth,
     r1,r2: integer;
     Radx,Rady: real;
     p0:Tpoint;
     Rp1,Rp2,Rp3,Rp4:RealPoint;
     LastColor: TColor;   { Delphi pen parameters }
     LastStyle: TPenStyle;

begin
 if dmode>0 then
 begin
  with DisplayForm.Image1 do
  begin
   LastWidth := Canvas.pen.Width;    {Save current line parameters }
   LastColor := Canvas.Pen.Color;
   LastStyle := Canvas.Pen.Style;
   Canvas.Pen.Color := clBlack;     { Reset as narrow black lines }
   Canvas.Pen.Style := psSolid;
   Canvas.Pen.Width := 1;
   if dmode < 2 then  { Initial settings of x2,y2 and xa,ya }
   begin
     SetCurve := False;  {Resets register flag}
     x2 := x1; y2 := y1;
     xa := (2*x1 + xc)div 3; ya := (2*y1 + yc)div 3;
   end;
   if  dmode <6 then {Draw straight line from start to centre }
   begin
     Canvas.Moveto(x1,y1);
     Canvas.LineTo(xc,yc);
   end;
   if (dmode > 1) and (dmode < 6)  then { add control points }
   begin
     Canvas.Ellipse(x1+4,y1+4,x1-4,y1-4);
     Canvas.Ellipse(xc+4,yc+4,xc-4,yc-4);
     Canvas.Ellipse(xa+4,ya+4,xa-4,ya-4);
   end;  { add control points }
   if (dmode >2) and  (dmode < 6) then    { Set control vector }
   begin
     Canvas.MoveTo(xc,yc);
     Canvas.Lineto(xa,ya);
   end;
   if (dmode > 3) and (dmode <7) then    { Adds arc}
   begin
     if dmode=6 then
     begin
      Canvas.Pen.Width := LastWidth;    { Reset pen parameters }
      Canvas.Pen.Style := LastStyle;
      Canvas.Pen.Color := LastColor;
     end;
     Rp1:= TransformPoint(CurrentInvTransform,ToRealpoint(Point(x1,y1)));
     Rp3:= TransformPoint(CurrentInvTransform,ToRealPoint(Point(xc,yc)));
     Rp4:= TransformPoint(CurrentInvTransform,ToRealPoint(Point(xa,ya)));
     Radx:=sqrt(sqr(Rp3.x-Rp1.x)+Sqr(Rp3.y-Rp1.y));
     Rady:=Radx;Radius:=Radx;
     StartAngle:=deg*Atan2((Rp1.x-Rp3.x+0.01),(Rp1.y-Rp3.y));
     Endangle:=deg*Atan2((Rp4.x-Rp3.x+0.01),(Rp4.y-Rp3.y));
     amove(Rp3.x,Rp3.y);             { Move to centre of arc }
     if clock then  ArcAt(radx,-rady,startangle,endangle)
           else ArcAt(radx,-rady,endangle,startangle);
     Rp2.x:= Rp3.x+Radius*cos(Endangle/Deg);
     Rp2.y:= Rp3.y+Radius*sin(EndAngle/Deg);
     p0:= ScreenPoint(TransformPoint(CurrentTransform,Rp2));
     x2:= p0.x; y2:= p0.y;
     amove(Rp2.x,Rp2.y);  { Move to end of arc }
   end;
   Canvas.Pen.Width := LastWidth;    { Reset pen parameters }
   Canvas.Pen.Style := LastStyle;
   Canvas.Pen.Color := LastColor;
  end; {with DisplayForm }
 end; { dmode>0 }
end; {DrawArc}

 procedure DrawMarker(mtype,x,y:integer;mscale:double);
{ Draws a marker of type mtype and size msz at x,y
  Colours and fill style are set in DrawMain before calling this
  procedure }
var   LastLnColor,LastLnstyle,LastLnWidth,  {These used for saving and }
      LastBmStyle,                     {restoring pen & brush settings.}
      LastFcol1,LastFCol2,LastFColbk,  {& Fill colours}
      i,msz,msz2,msz3:integer;
      msc:double;
   {   Bmset:Boolean;  }
      OldPenColor,OldBrushColor:TColor;
      OldPenStyle:TPenStyle;
      OldPenWidth:Integer;
      OldBrushStyle:TBrushStyle;
begin
 msc:= mscale/pixelspercm;  {Scaling factor for reals}
 msz:=round(mscale*ZoomFactor);  {Set scale factor}
 if msz<1 then msz:=1;
 msz2:=round(mscale*0.4*ZoomFactor);
 if msz2<1 then msz2:=1;
 msz3:=round(msz*1.25);
 if msz3<1 then msz2:=1;
 with DisplayForm.Image1 do
 begin
 {First save former styles and colours}
      OldPenColor:= Canvas.Pen.Color;
      OldPenStyle:= Canvas.Pen.Style;
      OldPenWidth:= Canvas.Pen.Width;
      OldBrushColor:= Canvas.Brush.Color;
      OldBrushStyle:= Canvas.Brush.Style;

   case mtype of
         0:  begin {Circle}
               Canvas.Brush.Style:= bsclear;
               Canvas.Ellipse(x+msz, y+msz, x-msz, y-msz);
             end;
         1:  begin  {Triangle}
               Canvas.Brush.Style:= bsclear;
               Canvas.polygon([Point(x,y-msz),Point(x-msz,y+msz),
                    Point(x+msz,y+msz)]);
             end;
         2:  begin {Square}
               Canvas.Brush.Style:= bsclear;
               Canvas.rectangle(x+msz,y+msz,x-msz,y-msz);
             end;
         3:  begin {Diamond}
               Canvas.Brush.Style:= bsclear;
                Canvas.polygon([Point(x-msz,y),Point(x,y+msz3),
                     Point(x+msz,y),Point(x,y-msz3)]);
             end;
         4:  begin {Pentagon}
               DrawRNPolygon(5,1.3*msc,90);
             end;
         5:  begin {Hexagon}
               DrawRNPolygon(6,1.3*msc,90);
             end;
         6:  begin {Octagon}
               DrawRNPolygon(8,1.3*msc,22.5);
             end;
         7:  begin  {star}
               Canvas.brush.style:= bsClear;
               DrawStar(5,2.0*msc,0.7*msc,90);
             end;
         8:  Canvas.Ellipse(x+msz, y+msz, x-msz, y-msz);  { Filled Circle}
         9:  Canvas.polygon([Point(x,y-msz),Point(x-msz,y+msz),
                    Point(x+msz,y+msz)]);  {Filled Triangle}
        10:  canvas.rectangle(x+msz,y+msz,x-msz,y-msz);  { Filed Square}
        11:  Canvas.polygon([Point(x-msz,y),Point(x,y+msz3), {Filled Diamond}
                     Point(x+msz,y),Point(x,y-msz3)]);
        12:  DrawRNPolygon(5,1.3*msc,90);  {Filled Pentagon}
        13:  DrawRNPolygon(6,1.3*msc,90);  {Filled Hexagon}
        14:  DrawRNPolygon(8,1.3*msc,22.5);  {Filled Octagon}
        15:  begin  {filled star}
               DrawStar(5,2.0*msc,0.7*msc,90);
            end;
        16: begin {club}
               for i:= 0 to 58 do
               begin
                 rpt2[i].x:= club[i].x*2.5*msc;
                 rpt2[i].y:= club[i].y*2.5*msc;
               end;
               rmove(0,-msc);
               SetPolygon(59,rpt2);
              end;
         17:  begin {spade}
                  for i:= 0 to 45 do
                  begin
                    rpt2[i].x:= spade[i].x*2.5*msc;
                    rpt2[i].y:= spade[i].y*2.5*msc;
                  end;
                  rmove(0,1.5*msc);
                  SetPolygon(46,rpt2);
              end;
         18:  begin {heart}
                  for i:= 0 to 33 do
                  begin
                    rpt2[i].x:= heart[i].x*2.5*msc;
                    rpt2[i].y:= heart[i].y*2.5*msc;
                  end;
                  rmove(0,-msc);
                  SetPolygon(34,rpt2);
              end;

         19:  Canvas.Ellipse(x+msz, y+msz, x-msz, y-msz);  {dot}
         20:  begin  {Diagonal cross}
               canvas.pen.width:= msz2;
               canvas.moveto(x+msz,y+msz);
               canvas.lineto(x-msz,y-msz);
               canvas.moveto(x-msz,y+msz);
               canvas.lineto(x+msz,y-msz);
             end;
         21: begin  {snake}
                  for i:= 0 to 60 do
                  begin
                    rpt2[i].x:= snake[i].x*0.05*mscale;
                    rpt2[i].y:= snake[i].y*0.05*mscale;
                  end;
                  SetPolygon(61,rpt2);
            end;
         22: begin {dag}
              canvas.pen.width:= msz2;
              canvas.moveto(x,y-msz);
              canvas.lineto(x,y+2*msz);
              canvas.moveto(x-msz,y);
              canvas.lineto(x+msz,y);
            end;
         23: begin  {ddag}
              canvas.pen.width:= msz2;
              canvas.moveto(x,y-2*msz);
              canvas.lineto(x,y+2*msz);
              canvas.moveto(x-msz,y-msz);
              canvas.lineto(x+msz,y-msz);
              canvas.moveto(x-msz,y+msz);
              canvas.lineto(x+msz,y+msz);
           end;
       24: begin {asterisk}
               Canvas.brush.color:= canvas.pen.color;
               Canvas.brush.style:= bsSolid;
               DrawStar(8,2.0*msc,0.5*msc,90);
      {        canvas.moveto(x+msz,y+msz);
               canvas.lineto(x-msz,y-msz);
               canvas.moveto(x-msz,y+msz);
               canvas.lineto(x+msz,y-msz);
               canvas.moveto(x,y+msz+1);
               canvas.lineto(x,y-msz-1);
               canvas.moveto(x-msz-1,y);
               canvas.lineto(x+msz+1,y); }
           end;
       25: begin   {OPlus}
              canvas.ellipse(x+2*msz,y+2*msz,x-2*msz,y-2*msz);
               canvas.moveto(x,y+msz);
               canvas.pen.width:= msz2;
               canvas.lineto(x,y-msz);
               canvas.moveto(x-msz,y);
               canvas.lineto(x+msz,y);
           end;
       26: begin   {Ominus}
              canvas.ellipse(x+2*msz,y+2*msz,x-2*msz,y-2*msz);
              canvas.moveto(x-msz,y);
              canvas.pen.width:= msz2;
              canvas.lineto(x+msz,y);
           end;
       27:begin  {Otimes}
              canvas.ellipse(x+2*msz,y+2*msz,x-2*msz,y-2*msz);
              canvas.moveto(x+msz,y+msz);
              canvas.pen.width:= msz2;
              canvas.lineto(x-msz,y-msz);
              canvas.moveto(x-msz,y+msz);
              canvas.lineto(x+msz,y-msz);
          end;
       28:begin  {Odot}
              Canvas.Ellipse(x+msz, y+msz, x-msz, y-msz);
              canvas.pen.width:= msz2;
              Canvas.Ellipse(x+1, y+1, x-1, y-1);
          end;
       29:  Canvas.polygon([Point(x,y-msz),Point(x-msz,y+msz),
                    Point(x+msz,y+msz)]);  {TriangleZ}
       30:  canvas.rectangle(x+msz,y+msz,x-msz,y-msz);  {SquareZ}
       31:  Canvas.polygon([Point(x-msz,y),Point(x,y+msz3), {DiamondZ}
                     Point(x+msz,y),Point(x,y-msz3)]);
       32:  begin {wcircle}
              Canvas.brush.color:= clwhite;
              Canvas.Ellipse(x+msz, y+msz, x-msz, y-msz);
            end;
       33:  begin {Wtriangle}
              Canvas.brush.color:= clwhite;
              Canvas.polygon([Point(x,y-msz),Point(x-msz,y+msz),
                    Point(x+msz,y+msz)]);
            end;
       34:  begin {wsquare}
              Canvas.brush.color:= clwhite;
              Canvas.rectangle(x+msz,y+msz,x-msz,y-msz);
            end;
       35:  begin {Wdiamond}
              Canvas.brush.color:= clwhite;
              Canvas.polygon([Point(x-msz,y),Point(x,y+msz3),
                    Point(x+msz,y),Point(x,y-msz3)]);
            end;
       36:  begin {WPentagon}
               Canvas.brush.color:= clwhite;
               DrawRNPolygon(5,1.3*msc,90);
             end;
       37:  begin {WHexagon}
               Canvas.brush.color:= clwhite;
               DrawRNPolygon(6,1.3*msc,90);
             end;
       38:  begin {WOctagon}
               Canvas.brush.color:= clwhite;
               DrawRNPolygon(8,1.3*msc,22.5);
             end;
       39:  begin  {wstar}
              Canvas.brush.color:= clwhite;
              DrawStar(5,2.0*msc,0.7*msc,90);
       {       msz :=(msz div 3)+1;
              canvas.polygon([Point(x,y-4*msz),Point(x-msz,y-2*msz),
              Point(x-3*msz,y-2*msz),Point(x-2*msz,y),Point(x-3*msz,y+2*msz),
              Point(x-msz,y+2*msz),Point(x,y+4*msz),Point(x+msz,y+2*msz),
              Point(x+3*msz,y+2*msz),Point(x+2*msz,y),Point(x+3*msz,y-2*msz),
              Point(x+msz,y-2*msz)]);  }
            end;
       40:begin
            canvas.rectangle(x+msz,y+msz,x-msz,y-msz);  {SquareDot}
            canvas.pen.width:= msz2;
            Canvas.Ellipse(x+1, y+1, x-1, y-1);
          end;
       41:begin
            Canvas.polygon([Point(x-msz,y),Point(x,y+msz3), {DiamondDot}
                     Point(x+msz,y),Point(x,y-msz3)]);
            Canvas.pen.width:= msz2;
            Canvas.Ellipse(x+1, y+1, x-1, y-1);
            end;
       42:begin {Plus}
               canvas.pen.width:= msz2;
               canvas.moveto(x+msz,y);
               canvas.lineto(x-msz,y);
               canvas.moveto(x,y+msz);
               canvas.lineto(x,y-msz);
          end;
      end;  {Case}
   {Reset pen and brush}
      canvas.moveto(x,y);
      Canvas.Pen.Color:= OldPenColor;;
      Canvas.Pen.Style:= OldPenStyle;
      Canvas.Pen.Width:= OldPenWidth;
      Canvas.Brush.Color:= OldBrushColor;
      Canvas.Brush.Style:= OldBrushStyle;
      if BrushBitmapSet then Canvas.Brush.Bitmap:= BrushBitmap;
 end; {with Image1}
end;         {DrawMarker}

procedure DrawArrow(Atype:integer;APoint:RealPoint;AAngle,Asize:double);
{ Draws an arrow of type Atype and size Asize, at angle  Aangle and point
  Apoint. Line and fill colours are set before calling this procedure }
var   p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15:TPoint;
      ap0,ap1:RealPoint;
      OldPenColor,OldBrushColor:TColor;
      OldPenStyle:TPenStyle;
      OldPenWidth:Integer;
      OldBrushStyle:TBrushStyle;
begin
 ArrowTransform:=CurrentTransform;
 with ArrowTransform do
 begin
 {Reset Origin}
        ap1:=TransformPoint(CurrentTransform,Apoint);
        Xorigin:=ap1.x;
        YOrigin:=ap1.y;
 {Reset Rotation - assumes Aangle in radians.}
          Rotation:= Rotation + AAngle;   {Changed 24/10/98}
          MatMult(cos(AAngle),-sin(AAngle),sin(AAngle),cos(AAngle),
                  TranC,TranE,TranD,TranF);
 {Reset ScaleFactor  }
          Xscale:= Xscale*Asize;
          Yscale:= Yscale*Asize;
          MatMult(Asize,0,0,Asize,TranC,TranE,TranD,TranF);
   end;
 with DisplayForm.Image1 do
 begin
 {First save former styles and reset pen style and colour}
      OldPenColor:= Canvas.Pen.Color;
      OldPenStyle:= Canvas.Pen.Style;
      OldPenWidth:= Canvas.Pen.Width;
      OldBrushColor:= Canvas.Brush.Color;
      OldBrushStyle:= Canvas.Brush.Style;
      Canvas.Pen.Style:= psSolid;
      Canvas.Pen.Color:= Arrowlinecolor;
      Canvas.Pen.Width := 0;
   case Atype of
     0,3,6,9:begin
            Canvas.Brush.Style:= bsClear;
           end;
     1,4,7,10:begin
            Canvas.Brush.Style:= bsSolid;
            Canvas.Brush.Color:= Arrowfillcolor;
           end;
     2,5,8,11:begin
            Canvas.Brush.Style:= bsSolid;
            Canvas.Brush.Color:= White
           end;
   end; {case}
   case Atype of
   0,1,2:begin { Norman Arrow}
      p0 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0,0)));
      p1 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.0,0.3)));
      p2 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.9,0.0)));
      p3 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.0,-0.3)));
      canvas.polygon([p0,p1,p2,p3]);
     end;
   3,4,5:begin {Roman Arrow}
      p0 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0,0)));
      p1 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.0,0.3)));
      p2 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.0,-0.3)));
      canvas.polygon([p0,p1,p2]);
     end;
   6,7,8:begin {Greek Arrow}
      p0 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0,0)));
      p1 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.276,0.027)));
      p2 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.541,0.108)));
      p3 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.786,0.238)));
      p4 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.000, 0.414)));
      p5 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.927, 0.325)));
      p6 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.873, 0.224)));
      p7 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.840, 0.114)));
      p8 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.818, 0.000)));
      p9 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.840,-0.114)));
      p10:= ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.873,-0.224)));
      p11:= ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.927,-0.325)));
      p12:= ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.000,-0.414)));
      p13:= ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.786,-0.238)));
      p14:= ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.541,-0.108)));
      p15:= ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.276,-0.027)));
      canvas.polygon([p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15]);
     end;
   9,10,11:begin {Saxon Arrow}
      p0 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0,0)));
      p1 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.0,0.3)));
      p2 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(0.3,0.0)));
      p3 := ScreenPoint(TransformPoint(ArrowTransform,Rpoint(1.0,-0.3)));
      canvas.polygon([p0,p1,p2,p3]);
     end;
  end; {case}
  {Reset pen and brush}
      Canvas.Pen.Color:= OldPenColor;;
      Canvas.Pen.Style:= OldPenStyle;
      Canvas.Pen.Width:= OldPenWidth;
      Canvas.Brush.Color:= OldBrushColor;
      Canvas.Brush.Style:= OldBrushStyle;
      if BrushBitmapSet then Canvas.Brush.Bitmap:= BrushBitmap;
 end; {with Displayform}
end;  {Draw Arrow}

procedure DrawText(x,y:integer;Scale,Rotate:double;TextItem:String);
{ Draws a text string or a maths symbol }
var k1,k2:integer;

begin
 With DisplayForm.Image1.canvas do
 begin
 Font.Name:= CurrentFont.Name;
  GetObject(Font.Handle,SizeOf(FontRecord),Addr(FontRecord));
  FontRecord.lfEscapement:=Round(Rotate*10);
  FontRecord.lfHeight:=Round(2*CurrentFont.size*CurrentTransform.YScale);
  FontRecord.lfWidth:=Round(WidthOfText*CurrentFont.size*CurrentTransform.Xscale);
  Font.Handle:=CreateFontIndirect(FontRecord);
  Textout(x,y,TextItem);
 end; {With Image1}
end;  {DrawText}

function IntString(I: Longint): string;
{ Converts any integer type to a string }
var
  S: string;
begin
  Str(I:SigFigs, S);
  IntString:= S;
end;

function RealString(R: real): string;
{ Convert any real type to a string }
var
  S: string;
begin
  Str(R:Sigfigs:DecFigs, S);
  RealString:= S;
end;

procedure DisplayObject(Step:Integer);
{ This draws an object in final form, then sets it up in
  list of graph objects, and increments item number
  For Bezier and Arc functions Flag SetCurve is reset.  }
 { *** If the Command dictionaries are altered corresponding changes
   must be made to the listing entries generated in this procedure. *** }
const  Pi = 3.14159265358979;
       deg = 180.0/Pi;

var i,j,k,Lastwidth:integer;
    msz,xytemp:double;
    Radx,Rady,StartAngle,EndAngle:double;
    Rp1,Rp2,Rp3,Rp4:RealPoint;
    Sx,Sy:String;
    LastColor:Tcolor;
    LastStyle:TpenStyle;

begin
  with DisplayForm.Image1 do
  begin
    if BrushBitmapSet then Canvas.Brush.BitMap:= BrushBitMap;
    CurrentInvTransform:= InverseTransform(CurrentTransform);
    case DrawingTool of
        dtline:begin
                Canvas.MoveTo(DrawStart.x,DrawStart.y);
                Canvas.LineTo(DrawEnd.x, DrawEnd.y);
                if Step=10 then
                begin
                 Rp1:=TransformPoint(CurrentInvTransform,
                                       ToRealpoint(DrawStart));
                 Rp2:=TransformPoint(CurrentInvTransform,
                                       ToRealPoint(DrawEnd));
                 If (DrawStart.x<>LastEnd.x) or (DrawStart.y<>LastEnd.y)
                  then EditForm.EditMemo.Lines.Add(' Amove   '
                  + RealString(Rp1.x) +' '+Realstring(Rp1.y));
                 EditForm.EditMemo.Lines.Add(' ALine   '+RealString(Rp2.x)
                   +' '+Realstring(Rp2.y));
                 CurrentPoint:=Rp2;
                end;
               end; {dtLine}
           dtbox:begin
                { Boxes use a corner as starting point, circles, ellipses
                 and squares all use the centre }
                  Rp1:=TransformPoint(CurrentInvTransform,ToRealpoint(DrawStart));
                  Rp2:=TransformPoint(CurrentInvTransform,ToRealPoint(DrawEnd));
                  CurrentPoint:=Rp1;
                  BoxAt(Rp2.x-Rp1.x,Rp2.y-Rp1.y);
                  if Step=10 then
                   begin
                    If (DrawStart.x<>LastEnd.x) or (DrawStart.y<>LastEnd.y)
                    then EditForm.EditMemo.Lines.Add(' Amove   '
                      + RealString(Rp1.x) +' '+Realstring(Rp1.y));
                    EditForm.EditMemo.Lines.Add(' box     '
                          + RealString(Rp2.x-Rp1.x) + ' '
                          + Realstring(Rp2.y-Rp1.y));
                    CurrentPoint:=Rp2;
                   end;
                 end; {dtbox }
 dtPaste,dtCopy: begin
                { Boxes use a corner as starting point, circles, ellipses
                 and squares all use the centre }
                 canvas.pen.mode:=pmNotXor;
                 LastColor:=canvas.pen.color;
                 canvas.pen.color:= clblack;
                 Laststyle:= canvas.pen.style;
                 canvas.pen.style:=psdash;
                 lastwidth:= canvas.pen.width;
                 canvas.pen.width:= 1;
                 Rp1:=TransformPoint(CurrentInvTransform,ToRealpoint(DrawStart));
                 Rp2:=TransformPoint(CurrentInvTransform,ToRealPoint(DrawEnd));
                 CurrentPoint:=Rp1;
                 BoxAt(Rp2.x-Rp1.x,Rp2.y-Rp1.y);
                 if Step=10 then
                 begin
                  if drawingtool=dtPaste then
                  begin
                   drawingtool:= dtnone;
                   PasteAt(Rp1.x,Rp1.y,Rp2.X,Rp2.y);
                   EditForm.EditMemo.Lines.Add(' PasteAt   '
                    + RealString(Rp1.x) + ' ' + Realstring(Rp1.y)
                    + ' ' +  RealString(Rp2.x) + ' ' + Realstring(Rp2.y));
                  end else if drawingtool= dtcopy then
                  begin
                   drawingtool:= dtnone;
                 { The following if statements ensure that the copy rectangle
                   starts at bottom left and ends at  top right. This is
                   needed to avoid a system resources error.}
                   if  Rp1.x>Rp2.x then
                   begin
                       xytemp:= Rp1.x; Rp1.x:= Rp2.x; Rp2.x:= xytemp;
                   end;
                   if  Rp1.y>Rp2.y then
                   begin
                       xytemp:= Rp1.y; Rp1.y:= Rp2.y; Rp2.y:= xytemp;
                   end;
                   Copyfrom(Rp1.x,Rp1.y,Rp2.x,Rp2.y);
                   EditForm.EditMemo.Lines.Add(' Copyfrom   '
                    + RealString(Rp1.x) + ' ' + Realstring(Rp1.y)
                    + ' ' +  RealString(Rp2.x) + ' ' + Realstring(Rp2.y));
                   DrawStart:= LastStart;  DrawEnd:= LastEnd;
                  end;
                 end; {If step=10}
                 canvas.pen.width:= lastwidth;
                 canvas.pen.color:= LastColor;
                 canvas.pen.style:= Laststyle;
                 end; {dtPaste, dtCopy }
        dtSquare :begin
                 Rp1:=TransformPoint(CurrentInvTransform,
                                       ToRealpoint(DrawStart));
                 Rp2:=TransformPoint(CurrentInvTransform,
                                        ToRealPoint(DrawEnd));
                 Radx:= Abs(Rp2.x-Rp1.x);
                 Rady:= Abs(Rp2.y-Rp1.y);
                 if Radx>Rady then Rady:=Radx else Radx:=Rady;
                 CurrentPoint:=Rp1;
                 square(Radx);
                 if Step=10 then
                 begin
                  If (DrawStart.x<>LastStart.x) or (DrawStart.y<>LastStart.y)
                   then EditForm.EditMemo.Lines.Add(' Amove   '
                   + RealString(Rp1.x) +' '+Realstring(Rp1.y));
                  EditForm.EditMemo.Lines.Add(' square  '+RealString(Radx));
                 end;
                  end;
        dtCircle: begin
                   Rp1:=TransformPoint(CurrentInvTransform,
                        ToRealpoint(DrawStart));
                   Rp2:=TransformPoint(CurrentInvTransform,
                        ToRealPoint(DrawEnd));
                   Radx:= Sqrt(Sqr(Rp1.x-Rp2.x) + Sqr(Rp1.y-Rp2.y));
                   CurrentPoint:=Rp1;
                   Circle(Radx);
                   if Step=10 then
                   begin
                    If (DrawStart.x<>LastStart.x) or (DrawStart.y<>LastStart.y)
                     then EditForm.EditMemo.Lines.Add(' Amove   '
                      + RealString(Rp1.x) +' '+Realstring(Rp1.y));
                    EditForm.EditMemo.Lines.Add(' Circle  '+ RealString(Radx));
                   end;
                  end;
        dtEllipse:begin
                 Rp3:=TransformPoint(CurrentInvTransform,
                                      ToRealpoint(DrawStart));
                 Rp4:=TransformPoint(CurrentInvTransform,
                                         ToRealPoint(DrawEnd));
                 Radx:= Abs(Rp4.x-Rp3.x); +
                 Rady:= Abs(Rp4.y-Rp3.y);
                 CurrentPoint:=Rp3;
                 EllipseAt(Radx,Rady);
                 if Step=10 then
                   begin
                    Rp3:=TransformPoint(CurrentInvTransform,
                                         ToRealpoint(DrawStart));
                    Rp4:=TransformPoint(CurrentInvTransform,
                                         ToRealPoint(DrawEnd));
                    If (DrawStart.x<>LastStart.x) or (DrawStart.y<>LastStart.y)
                     then EditForm.EditMemo.Lines.Add(' Amove   '
                     + RealString(Rp3.x) +' '+Realstring(Rp3.y));
                    EditForm.EditMemo.Lines.Add(' Ellipse '
                    + RealString(Abs(Rp3.x-Rp4.x)) +' '
                    + Realstring(Abs(Rp3.y - Rp4.y)));
                   end;
                 end;
        dtMarker:begin
                  DrawMarker(MarkerType,DrawEnd.x,DrawEnd.y,
                     MarkerSize*CurrentTransform.XScale);
                  if Step=10 then
                  begin
                    Rp3:=TransformPoint(CurrentInvTransform,
                                         ToRealpoint(DrawEnd));
                    Rp4:= Rp3;  {TransformPoint(CurrentInvTransform,
                                 Mod. 19/11/98   ToRealPoint(DrawEnd)); }
                    If (DrawStart.x<>LastEnd.x) or (DrawStart.y<>LastEnd.y)
                     then EditForm.EditMemo.Lines.Add(' Amove   '
                     + RealString(Rp3.x) +' '+Realstring(Rp3.y));
                     msz:= (MarkerSize-1)*2.01/PixelsPerCm;
                     EditForm.EditMemo.Lines.Add(' Marker  '
                     + MarkerStyle[MarkerType] +' '
                     + Realstring(msz));
                   end;
                  end;
         dtText:  begin
                    DrawText(DrawEnd.x,DrawEnd.y,30,
                       CurrentTransform.Rotation*AngleMeasure+
                       TextAngle,DisplayForm.TextEdit.Text); {Changed 24/10/98}
                    if Step=10 then
                    begin
                     Rp3:=TransformPoint(CurrentInvTransform,
                                         ToRealpoint(DrawEnd));
                     Rp4:=TransformPoint(CurrentInvTransform,
                                         ToRealPoint(DrawEnd));
                    EditForm.EditMemo.Lines.Add(' Amove   '
                     + RealString(Rp3.x) +' '+Realstring(Rp3.y));
                    EditForm.EditMemo.Lines.Add(' Text    '
                    + DisplayForm.textEdit.Text);
                   end;
                  end;
        dtBezier:begin
                  DrawBezier(1.0,CStart.x,CStart.y,ControlPoint1.x,
                   ControlPoint1.y,ControlPoint2.x,
                        ControlPoint2.y,Cend.x,Cend.y,DrawingStyle);
                   if Step =10 then begin
                    SetCurve := False;
                    Rp1:= TransformPoint(CurrentInvTransform,
                            ToRealpoint(CStart));
                    Rp2:= TransformPoint(CurrentInvTransform,
                             ToRealPoint(CEnd));
                    Rp3:= TransformPoint(CurrentInvTransform,
                               ToRealPoint(ControlPoint1));
                    Rp4:= TransformPoint(CurrentInvTransform,
                               ToRealPoint(ControlPoint2));
                    If (CStart.x<>LastEnd.x) or (CStart.y<>LastEnd.y)
                     then EditForm.EditMemo.Lines.Add(' Amove   '
                      + RealString(Rp1.x) +' '+Realstring(Rp1.y));
                     EditForm.EditMemo.Lines.Add(' Bezier  '
                    + RealString(Rp3.x) + ' ' + Realstring(Rp3.y) + ' '
                    + RealString(Rp4.x) + ' ' + Realstring(Rp4.y) + ' '
                    + RealString(Rp2.x) + ' ' + Realstring(Rp2.y));
                   end;
                  end;
            dtArc: begin
                      DrawArc(CStart.x,CStart.y,ControlPoint1.x,
                      ControlPoint1.y,ControlPoint2.x,ControlPoint2.y,
                      DrawingStyle,CEnd.x,CEnd.y,
                      Radx,StartAngle,EndAngle,Clockwise);
                      if step=10 then
                      begin
                       SetCurve := False;
                       Rp1:= TransformPoint(CurrentInvTransform,
                            ToRealpoint(CStart));
                       Rp2:= TransformPoint(CurrentInvTransform,
                             ToRealPoint(CEnd));
                       Rp3:= TransformPoint(CurrentInvTransform,
                               ToRealPoint(ControlPoint1));
                       Rp4:= TransformPoint(CurrentInvTransform,
                               ToRealPoint(ControlPoint2));
                       EditForm.EditMemo.Lines.Add(' Amove   '
                        + RealString(Rp3.x) +' '+Realstring(Rp3.y));
                       if Clockwise then Sx := ' Narc    '
                       else Sx:= ' Arc     ';
                       EditForm.EditMemo.Lines.Add(Sx + RealString(Radx)
                        + ' ' + Realstring(-Startangle) + ' '
                       + RealString(-EndAngle));
                       EditForm.EditMemo.Lines.Add(' Amove   '
                      + RealString(Rp2.x) +' '+Realstring(Rp2.y));
                      end;
                   end;
    end; {Case}
   if Step=10 then
    begin
    if (DrawingTool in [dtLine,dtBox,dtBezier,dtArc]) then
    begin
      Lastend:=DrawEnd; LastStart:= DrawStart;
      DrawStart:=DrawEnd;
    end;
    if (DrawingTool in [dtCircle, dtSquare,dtEllipse]) then
    begin
      DrawEnd:= DrawStart; LastStart:= DrawStart; LastEnd:= DrawStart;
    end;
    end; {step=10}
  end; {with DisplayForm .}
end;     {Display Object}

procedure TDisplayForm.Image1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

{ This is the primary routine for initiating drawing of an object.
  It uses the flags NewObject, NewStyle, StartDrawing and Drawing
  to determine the exact set of operations needed.
  If MouseMode is not set all mouse controlled operations are inhibited }

var x1,y1,x2,y2,xinc,yinc,signxy: Integer;
    xf,yf:double;
    Realpt:Realpoint;

begin
 with DisplayForm.Image1 do
 begin
 if CurrentItem <=0 then
 begin       { Actions at start of program only }
   NewStyle :=True;
   CurrentItem := 1;
 end; {else begin  { CurrentItem <= 0 }
 if MouseMode then   { If in KeyMode all mouse operations suppressed }
 begin
 if (Button = mbRight) and not ( (drawingtool in [ dtBezier, dtArc])
     and (DrawingStyle>0))then
{ Reset for a completely new line }
  begin
    StartDraw := True;
    Drawing := False;
  end; {Right Mouse Button }
{ if Diagnostics then Writeln('In FMDown NewStyle = ',NewStyle);   }
 if NewStyle then
 { If new styles requested set them up.
   Do this for either mouse button }
  begin
      Canvas.font.assign(CurrentFont);
      Canvas.Pen.Color := clBlack;         { SetLineStyles.LSLineColor; }
      Canvas.Pen.Style := psSolid;         {  SetLineStyles.LSPenStyle; }
      Canvas.Pen.Width := 1;               { SetLineStyles.LineWidth;   }
      Canvas.Brush.Color :=  clBlue;       { SetLineStyles.LSFillColor; }
      Canvas.Brush.Style :=  bsClear;      { SetLineStyles.LSFillStyle; }
  {  end;   }
    NewStyle := False;
 end; {NewStyle}

 {Operations specific to drawing  - valid for both mouse buttons}
 Canvas.Pen.Mode := pmNotXor;
 begin
  if NewDrawObject then NewDrawObject := False;
  if StartDraw then
  begin
   { If a set of new lines set x,y as starting point }
   DrawStart.x := x;
   DrawStart.y := y;
   Cstart:=DrawStart;
   StartDraw := False;
  end;
  DrawEnd.x := x;    { Set DrawEnd to current point - which will be }
  DrawEnd.y := y;    { DrawStart for a new object }
  { Now Draw the initial line which is cancelled in MoveMouse procedure }
  case DrawingTool of
   dtNone:   begin
               RealPt:= ToRealPoint(Point(x,y));
               if (Button = mbright) then
               begin
                ZoomFactor:= ZoomFactor*1.414213562373;
                if (ZoomFactor>8.0) then ZoomFactor:= 8.0;
               XOffset:= -Realpt.x+WindowWidth/(2*zoomfactor);
               YOffset:= -Realpt.y+WindowHeight/(2*ZoomFactor);
               end else
               if (Button = mbleft) then
               begin
                ZoomFactor:= ZoomFactor*0.7071067811865;
                If (zoomFactor<0.03125) then ZoomFactor:= 0.03125;
               XOffset:= -Realpt.x+WindowWidth/(2*zoomfactor);
               YOffset:= -Realpt.y+WindowHeight/(2*ZoomFactor);
               end;
               ClearBitBtnClick(Sender);
               DrawDiagram(FirstLine);
             end;
   dtText:   begin
                 DisplayObject(1);
             end;
   dtBezier: if DrawingMode = 0  then
             begin
               DrawingMode := 1;
               DrawingStyle := 2;
               CStart := DrawStart;
               CEnd := DrawEnd;
               x1 := (x - CStart.x) Div 3;
               y1 := (y - CStart.y) Div 3;
               ControlPoint1 := Point( Cstart.x + x1, CStart.y + y1);
               ControlPoint2 := Point( CEnd.x -x1, CEnd.y - y1);
               DisplayObject(0)
             end;
   dtArc:   if DrawingMode = 0 then
            begin
             DrawingMode := 1;
             DrawingStyle := 2;
             CStart := DrawStart;
             CEnd := DrawStart;
             ControlPoint1 := DrawEnd;
             ControlPoint2.x := (2*Cstart.x+ControlPoint1.x) div 3;
             ControlPoint2.y := (2*Cstart.y+ControlPoint1.y) div 3;
             DisplayObject(0);
            end;
         else displayobject(1);
   end; {Case}
 end; { not Moving or Sizing }
   Drawing := True;
 end;  {MouseMode}
 end; {with Image1}
end;

procedure TDisplayForm.Image1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);

var {dmode,} x1,y1,xinc,yinc,x2inc,y2inc,signxy:Integer;
     xf,yf,Rpx,Rpy:double;
     Lastcolor: TColor;
     RealPt,RP2:Realpoint;
     sp:string;
begin
 with DisplayForm.Image1 do
 begin
  if Drawing then
  begin
     { First delete last item }
       case DrawingTool of
  dtText:  begin
               LastColor := Canvas.Font.Color;
               Canvas.Font.Color := clWindow; { Needed to delete text }
               DisplayObject(1);
               Canvas.Font.Color := LastColor;
            end;
   dtBezier: begin
             if (DrawingMode>0) and (DrawingMode <7)
               then   displayObject(0)
             end;
    dtArc: begin
              if (DrawingMode>0) then   displayObject(0);
            end;
         else displayobject(1);
   end; {Case}
     DrawEnd := Point(x,y);
  case DrawingTool of
     dtText: begin
                 Canvas.Font.Color := CurrentFont.Color;
                 DisplayObject(1);
             end;
     dtBezier: begin
                Case DrawingMode of
                 1:begin
                    x1 := (x - CStart.x) Div 3;
                    y1 := (y - CStart.y) Div 3;
                    ControlPoint1 := Point( Cstart.x + x1,
                          CStart.y + y1);
                    ControlPoint2 := Point( CEnd.x - x1,
                          CEnd.y - y1);
                    CEnd := Point(x,y);
                   end;
                2: begin
                     if (abs(ControlPoint1.x - x) +
                         abs(ControlPoint1.y - y)) < SpotSize
                      then begin
                         DrawingMode := 3;
                         DrawingStyle := 3;
                      end;
                     if (abs(ControlPoint2.x - x) +
                         abs(ControlPoint2.y - y)) < SpotSize
                      then begin
                         DrawingMode := 4;
                         DrawingStyle := 4;
                      end;
                     if (abs(CEnd.x - x) +  abs(CEnd.y - y))
                       < SpotSize then
                       if (SetCurve)  then
                       begin
                         DrawingMode := 6;
                         DrawingStyle := 6;
                         SetCurve := FALSE;
                       end else begin
                         DrawingMode := 5;
                         DrawingStyle := 4;
                       end;
                   End;
                3: begin
                    DrawingStyle := 3;
                    ControlPoint1 := Point(x,y);
                   end;
                4: begin
                    DrawingStyle := 4;
                    ControlPoint2 := Point(x,y);
                   end;
                5: begin
                    DrawingStyle := 4;
                    CEnd := Point(x,y);
                   end;
                6: begin
                     DrawingMode := 6;
                   end;
               end; {Case DrawingMode}
              displayobject(0);
              if Drawingmode=6 then drawingstyle:=0;
             end; {dtBezier}
      dtArc: begin
                Case DrawingMode of
                 1:begin
                    ControlPoint2.x := (2*CStart.x+x) Div 3;
                    ControlPoint2.y := (2*CStart.y+y) Div 3;
                    ControlPoint1 := Point( x,y);
                   end;
                2: begin
                     if (abs(ControlPoint1.x - x) +
                         abs(ControlPoint1.y - y)) < SpotSize
                      then begin
                         DrawingMode := 3;
                         DrawingStyle := 4;
                      end;
                     if (abs(ControlPoint2.x - x) +
                         abs(ControlPoint2.y - y)) < SpotSize
                      then begin
                         DrawingMode := 4;
                         DrawingStyle := 4;
                      end;
                     if (abs(CStart.x - x) +  abs(CStart.y - y))
                       < SpotSize then
                       if (SetCurve)  then
                       begin
                         DrawingMode := 6;
                         DrawingStyle := 6;
                         SetCurve := FALSE;
                       end else begin
                         DrawingMode := 5;
                         DrawingStyle := 4;
                       end;
                   end;
                3: begin
                    DrawingStyle := 4;
                    ControlPoint1 := Point(x,y);
                   end;
                4: begin
                    DrawingStyle := 4;
                    ControlPoint2 := Point(x,y);
                   end;
                5: begin
                    DrawingStyle := 4;
                    CStart := Point(x,y);
                   end;
                6: begin
                     DrawingMode := 6;
                   end;
               end; {Case DrawingMode}
               displayobject(0);
               if DrawingMode = 6 then DrawingStyle := 0;
             end; {dtArc}
        else displayobject(1);
          end; {Case}
  end;
   RealPt:= ToRealPoint(Point(x,y));
   RP2:= RealPt;
   case ScaleMode of
   0: begin
       Realpt.x:= Realpt.x+Xoffset;
       Realpt.y:= Realpt.y+YOffset;
      end;
   1: begin
       Realpt.x:= Realpt.x+Xwinorigin;
       Realpt.y:= Realpt.y+YwinOrigin;
      end;
   2: begin
       RealPt:= TransformPoint(CurrentInvTransform,RealPt);
       Realpt.x:= Realpt.x;
       Realpt.y:= Realpt.y;
      end;
   3: begin
         RP2:= TransformPoint(CurrentInvTransform,RealPt);
         RealPt.x:= Sqrt(Sqr(RP2.x) + Sqr(RP2.y));
         RealPt.y:= atan2(Rp2.x,RP2.y)*AngleMeasure;
      end;
   4: begin
         RealPt.x:= CurrentTransform.XScale;
         RealPt.y:= CurrentTransform.YScale;
      end;
   5: begin
         RealPt.x:= XWinOrigin;
         Realpt.y:= YWinOrigin;
      end;
   6: begin
        Realpt.x:= Zoomfactor;
        Realpt.y:= 0.0;
      end;
   end;
   Str(Realpt.x:8:3,sp); {adds preset offset}
   Xlabel.Caption:= ' ' + sp;
   Str(realPt.y:8:3,sp);
   Ylabel.caption:= ' ' + sp;
  end; {with Image1}
end; {mouse Move}

procedure TDisplayForm.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
with DisplayForm.Image1 do
begin
 if MouseMode then
 begin
 if Drawing then
 begin
  { Select operation according to status }
      case DrawingMode of
       0: begin
           Drawing := False;
           Canvas.Pen.Mode:= pmCopy;
           DisplayObject(10);
           Canvas.pen.mode:= pmNotXor;
          end;
      1: begin
          DrawingMode := 2;
         end;
  3,4,5: DrawingMode := 2;
      6: begin
          DrawingStyle := 6;
          DrawingMode := 6;
          Canvas.pen.mode:= pmCopy;
          DisplayObject(10);
          Canvas.pen.mode:= pmNotXor;
          SetCurve := False;
          DrawingMode := 0;
          DrawingStyle := 0;
          Cstart := Cend;
        end;
      end; { Case DrawingMode }
  end;   {if Drawing}
  Drawing := False;
  { Set size of item list }
  If FinalItem <CurrentItem then FinalItem := CurrentItem;
 end; { MouseMode }
end; {Mouse Up}
end;

procedure TDisplayForm.CopyButtonClick(Sender: TObject);
begin
    DrawingTool:= dtCopy;
    DrawingMode:= 0;
{   Clipboard.Assign(Image1.Picture); }
end;

procedure TDisplayForm.PrintButtonClick(Sender: TObject);
{ Prints a graphic.  Version 2.  11/3/99}

  procedure DrawImage(Canvas:TCanvas; DestRect:TRect; ABitmap:TBitMap);

  var Header,Bits:pointer;
      HeaderSize:integer;
      BitsSize:integer;

  begin
      DrawingMode:= 0;
      GetDIBSizes(ABitmap.Handle, HeaderSize, BitsSize);
      Header:= MemAlloc(HeaderSize);
      Bits:=   MemAlloc(BitsSize);
      try
        GetDIB(ABitmap.Handle, ABitmap.Palette, Header^, Bits^);
        StretchDIBits(Canvas.Handle, DestRect.Left, DestRect.Top,
                      DestRect.Right, DestRect.Bottom,
                      0, 0, ABitmap.Width, ABitmap.Height, Bits,
                      TBitmapInfo(Header^), DIB_RGB_COLORS, SRCCOPY);
        {N.B. StretchDIBits is a Windows API function which uses a
              different definition of TRect from Delphi.
                DestRect.Right is now the WIDTH of the rectangle.
                DestRect.Bottom is now the HEIGHT of the rectangle.}
      finally
        FreeMem(Header, HeaderSize);
        FreeMem(Bits, BitsSize);
      end;
  end; {DrawImage}

var  relwidth,relheight,relleft,reltop:integer;
     ScaleFactor,Margin:double;
     ErrorCode:Boolean;

begin
  if PrintDialog1.Execute then
  begin
   Printer.Begindoc;
   ScaleFactor:= ImageScale*DotsPerCm/PixelsPerCm; {Sets printer image size}
   Margin:= 2.0;   {Margin currently set at 2cms.}
   ErrorCode:= False;
   try
    if PrintFullPage then
    begin {Full size page image}
     if (Image1.Picture.Width/Image1.Picture.Height) >
             (printer.pagewidth/printer.pageheight) then
     begin
      relwidth:= printer.pagewidth;
      relheight:= Round(MulDiv(Image1.Picture.Height,
                        printer.pagewidth, Image1.Picture.Width));
      ScaleFactor:= (1.0 - 2*Margin*DotsPerCm/printer.pagewidth);
     end else begin
      relwidth:= Round(MulDiv(Image1.Picture.Width,
                       printer.pageheight, Image1.Picture.Height));
      relheight:= printer.pageheight;
      ScaleFactor:= (1.0 - 2*Margin*DotsPerCm/printer.pageheight);
     end;
     {Now set up page borders}
     relleft:= Round(0.5*(printer.pagewidth-ScaleFactor*relwidth));
     reltop:=  Round(0.5*(printer.pageheight-ScaleFactor*relheight));
     relwidth:= Round(ScaleFactor*relwidth);
     relheight:= Round(ScaleFactor*relheight);
    end else begin  {User set size and position}
     ScaleFactor:= ImageScale*DotsperCm/pixelsPerCm;
     relleft:= round(LeftMargin*DotsPerCm);
     reltop:=  round(TopMargin*DotsPerCm);
     relwidth:= round(ScaleFactor*Image1.Picture.Width);
     relheight:= round(ScaleFactor*Image1.Picture.Height);
     if ((relleft+relwidth) > printer.pagewidth)
      or ((reltop+relHeight) > printer.pageheight) then
     begin
        Messagedlg('D42: Image is too big for paper. Rescale and try again',
        mtWarning, [mbOK],0);
        errorCode:=True;
     end;
    end; {if PrintFullPage}
    if not errorcode then
     DrawImage(Printer.Canvas, Rect(relleft, reltop, relwidth, relheight),
              Image1.Picture.bitmap);
   finally
    Printer.EndDoc;
   end; {try}
  end; {If PrintDialog1 ..}
end;  {PrintButton}

procedure Displayat(x,y:double;PictName:string);
{Pastes an imagefile at point x,y}

var Bmp2:TBitMap;
    R1:Trect;

begin
   CurrentPoint.x:=x;CurrentPoint.y:=y;
   LastStart:=DrawStart;LastEnd:=DrawEnd;   {Saves previous settings }
   DrawStart := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
   Bmp2:= TBitMap.Create;
    try
     Bmp2.LoadfromFile(PictName);
     R1.Left:= DrawStart.x;
     R1.top:= DrawStart.y-Round(Bmp2.Height*ZoomFactor*CurrentTransform.Yscale);
     R1.right:= R1.Left+Round(Bmp2.Width*ZoomFactor*CurrentTransform.Xscale);
     R1.bottom:= DrawStart.y;
     DisplayForm.Image1.Canvas.StretchDraw(R1,Bmp2);
    finally
     Bmp2.free;
    end;
end; {Displayat}

procedure CopyFrom(x,y,x1,y1:double);
{Copies the specified rectangle to the clipboard}

var
  NewPoint:realPoint;
  PasteRect,DestRect:Trect;
  pastebitmap:tbitmap;

begin
 pastebitmap:= tbitmap.create;
 CurrentPoint.x:=x;CurrentPoint.y:=y;
 Newpoint:= RPoint(x1,y1);
 LastStart:=DrawStart;LastEnd:=DrawEnd;   {Saves previous settings }
 DrawStart := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
 DrawEnd:= ScreenPoint(TransformPoint(CurrentTransform,NewPoint));
 PasteRect.left:= DrawStart.x;
 PasteRect.top:= DrawEnd.y;
 PasteRect.right:= DrawEnd.x;
 PasteRect.bottom:= DrawStart.y;
 pastebitmap.Width:= (DrawEnd.x-DrawStart.x);
 pastebitmap.Height:= (DrawStart.y-DrawEnd.y);
 DestRect.Top:= 0;
 DestRect.Left:= 0;
 DestRect.Bottom:= pastebitmap.height;
 Destrect.right:= pastebitmap.width;
 try
  with pastebitmap.canvas do
   copyrect(DestRect,DisplayForm.Image1.canvas,PasteRect);
   clipboard.assign(Pastebitmap);
 finally
  PasteBitmap.free;
 end;
end; {Copyfrom}

procedure PasteAt(x,y,x1,y1:double);
{Copies the clipboard to point x,y}
var Bmp2:TBitMap;
    Newpoint:RealPoint;
    R1:Trect;

begin
   CurrentPoint.x:=x;CurrentPoint.y:=y;
   Newpoint:= RPoint(x1,y1);
   LastStart:=DrawStart;LastEnd:=DrawEnd;   {Saves previous settings }
   DrawStart := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
   DrawEnd:= ScreenPoint(TransformPoint(CurrentTransform,NewPoint));
   if ClipBoard.HasFormat(CF_BITMAP) then
   begin
     Bmp2:= TBitMap.Create;
    try
     Bmp2.Assign(ClipBoard);
     R1.Left:= DrawStart.x;
     R1.top:= DrawEnd.y;
     R1.right:= DrawEnd.x;
     R1.bottom:= DrawStart.y;
     DisplayForm.Image1.Canvas.StretchDraw(R1,Bmp2);
    finally
     Bmp2.free;
    end;
   end else begin
     if Messagedlg('D44: No picture on the Clipboard.', mtInformation,
        [mbOK,mbAbort],0) = mrAbort then Disaster:= True;
   end; {if ClipBoard}
end; {PasteAt}

procedure TDisplayForm.PasteButtonClick(Sender: TObject);

begin
  Mousemode:= True; NewDrawing:= True; NewStyle:= True;
  DrawingTool:= dtPaste; DrawingMode:= 0;
end;

procedure TDisplayForm.SaveButtonClick(Sender: TObject);
begin
 DrawingMode:= 0;
 SaveDialog1.DefaultExt:= 'bmp';
 if SaveDialog1.Execute then
   Image1.Picture.SaveToFile(SaveDialog1.FileName);
end;

procedure TDisplayForm.RadioButton1Click(Sender: TObject);
begin
  MouseMode:=True;KeyMode:=False;
end;

procedure TDisplayForm.RadioButton2Click(Sender: TObject);
begin
  KeyMode:=True; MouseMode:=False;
end;

procedure TDisplayForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key= VK_Insert then SetCurve:=True;
end;

procedure TDisplayForm.Image1DblClick(Sender: TObject);
var Rp1,Rp2,Rp3,Rp4,Rp5,Rp6:realpoint;
    CP1:array[0 .. 25] of realpoint;
    iii:integer;
begin
  with Image1 do
  begin
   {test 3 Axis test}
   canvas.pen.color:=clblack;
   DrawAxis(x1Axis);
   with y1axis do
   begin
      tickangle:=-140;
      xend:=13.0;yend:=8.5;
   end;
   DrawAxis(y1Axis);
   with x2Axis do
   begin
      tickangle:=175;
      xend:=6.0;yend:=10.0;
   end;
   DrawAxis(x2Axis);
 end; {with Image1}
end;

procedure TDisplayForm.EditButtonClick(Sender: TObject);
begin
   EditForm.Show;
end;

{ ************  Procedures for GLE Operations   ***********  }

 procedure Aline(x,y:double);
 {Draws a line to x,y}
 var LineAngle:double;
 begin
   LastPoint:= CurrentPoint;
   CurrentPoint.x:=x;CurrentPoint.y:=y;
   DrawEnd := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
   DisplayForm.Image1.Canvas.LineTo(DrawEnd.x,DrawEnd.y);
   LineAngle:= atan2((x-LastPoint.x)*currentTransForm.XScale,
                     (y-LastPoint.y)*CurrentTransform.yscale);
   if ArrowStart then DrawArrow(ArrowStyle,LastPoint,Lineangle,Arrowsize);
   if ArrowEnd then DrawArrow(ArrowStyle,Currentpoint,LineAngle+Pi,Arrowsize);
   LastStart:=DrawStart;LastEnd:=DrawEnd;DrawStart:=DrawEnd;
 end;

 procedure Apline(r,a:double);
 {Draws a line in polar coordinates}
  begin
    Aline(r*cos(a/anglemeasure),r*sin(a/anglemeasure));
  end;

 procedure Amove(x,y:double);
 {Moves Current point to x,y}
 begin
   CurrentPoint.x:=x;CurrentPoint.y:=y;
   LastStart:=DrawStart;LastEnd:=DrawEnd;   {Saves previous settings }
   DrawEnd := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
   DisplayForm.Image1.Canvas.MoveTo(DrawEnd.x,DrawEnd.y);
   LastStart:=DrawStart;DrawStart:=DrawEnd;
   LastEnd:=DrawEnd;   {Moves to current point }
 end;  {Amove}

 procedure Apmove(r,a:double);
 {Moves current point in polar coordinates}
 begin
    Amove(r*cos(a/anglemeasure),r*sin(a/anglemeasure));
  end;


 procedure ArcAt(xradius,yradius,startangle,endangle:double);
  {draws a simple arc}

 var APoint:array[ 0 .. 50] of TPoint;
     RlPoint:array[ 0 .. 50] of RealPoint;
     Xc,Yc:double;
     i:integer;
 begin
     Xc:=CurrentPoint.x;Yc:=CurrentPoint.y;
     BasicArc(Rlpoint,Xc,Yc,XRadius,YRadius,StartAngle,EndAngle);
     for i:=0 to 50 do
         Apoint[i] := ScreenPoint(TransformPoint({CurrentTransform}
                            Ctrans[CTransFormNum],RlPoint[i]));
         DisplayForm.Image1.canvas.polyline(Apoint);
 end;    {ArcAt}

 procedure ArcTo(x1,y1,x2,y2,radius:double);
  {Fits an arc of radius r in the line segment xc,yc - x1,y1
   - x2,y2 where xc,yc is the initial current point.}

 var APoint:array[ 0 .. 52] of TPoint;
     RlPoint:array[ 0 .. 50] of RealPoint;
     x,y,xi,yi,xs,ys,xe,ye,Xc,Yc,dn,
     ma,pa,mb,pb,mn,pn,mbs,pbs,
     LengthA,LengthB,angleA,angleB,angleAB,
     StartAngle,Endangle,Phi:double;
     i:integer;
 begin
     Xc:=CurrentPoint.x;Yc:=CurrentPoint.y;
     LengthA:= sqrt(sqr(x1-xc)+sqr(y1-yc));
     LengthB:= sqrt(sqr(x2-x1)+sqr(y2-y1));
     angleA := atan2(x1-xc,y1-yc);
     angleB := atan2(x2-x1,y2-y1);
     { Calculate interior angle between lines a and b.
       This will be +ve for an anticlockwise arc and -ve
       for a clockwise arc. }
     angleAB := Pi - angleB + angleA;
     { Set bisector angle for AngleAB. note that the sign
       is automatically derived corectly from previous values}
     while (angleAB < -Pi) do  angleAB:= angleAB + TwoPi;
     while (angleAb > Pi)  do  angleAB:= angleAB - TwoPi;
     Phi:= angleB + 0.5*angleAB;
     { Set  equations for lines A and B}
     if (x1 = xc) then
     begin
       ma:= 1.0E+10;
       pa:= -1.0E+10*x1;
     end else begin
       ma:= (y1-yc)/(x1-xc);
       pa:= y1 - ma*x1;
     end; {if x1=xc}
     if (x2 = x1) then
     begin
       mb:= 1.0E+10;
       pb:= -1.0E+10*x2;
     end else begin
       mb:= (y2-y1)/(x2-x1);
       pb:= y2 - mb*x2;
     end; {if x2=x1}
     {Set equation for bisector of angleAB}
     if abs(Phi)<>0.5*Pi then mbs:= sin(Phi)/cos(Phi) else mbs:= 1.0E+10;
     pbs:= y1-mbs*x1;
     { Now get normals to A and B though the end points
       xc,yc and x2,y2}
     if (lengthA<lengthB) then
     begin
       x:= xc; y:= yc;
       if ma<>0 then mn:= -1.0/ma else mn:= -1.0E+10;
       pn:= yc - mn*xc;
     end else begin
       x:= x2; y:= y2;
       if mb<>0 then mn:= -1.0/mb else mn:= -1.0E+10;
       pn:= y2 - mn*x2;
     end;
     {Evaluate intersection point}
     if abs(mn) = abs(mbs) then
     begin
        Messagedlg('D43: Error in evaluating ArcTo. Check for parallel lines. ',
        mtError, [mbAbort],0);
        Disaster:= True;
        Exit;
     end else begin
       xi:= (pbs-pn)/(mn - mbs);
       yi:= (mn*pbs - mbs*pn)/(mn - mbs);
     end;
     { Get length of normal to A or B through end points.}
     dn:= sqrt(sqr(x-xi)+sqr(y-yi));
     {and scale as required.}
     if radius>dn then   radius:= dn
     else begin
       dn:= radius/dn;
       xi:= x1-(x1-xi)*dn;
       yi:= y1-(y1-yi)*dn;
     end;
     { Reuse AnglA and AngleB for angles of respective normals.
       These are modified according to direction of  angleAB. }
     AngleA:= AngleA - 0.5*Pi*Sign(AngleAB);
     AngleB:= AngleB - 0.5*Pi*Sign(AngleAB);
     {Set end points for straight line portions}
     LastPoint:= CurrentPoint;
     Apoint[0] := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
     CurrentPoint.x:=x2;CurrentPoint.y:=y2;
     Apoint[52] := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
     {Swap ends according to direction of rotation.}
     if Sign(angleAb)<0 then begin
        x:= AngleA; AngleA:= AngleB; AngleB:= x;
        Apoint[1]:= Apoint[0]; Apoint[0]:= Apoint[52]; Apoint[52]:=Apoint[1];
     end;
     {BasicArc requires angles in degrees.}
     x:= 20.0*sign(AngleAB);
     BasicArc(Rlpoint,xi,yi,Radius,Radius,AngleA*Degree,AngleB*Degree);
     {Set up curved part of ArcTo.}
     for i:=0 to 50 do
         Apoint[i+1] := ScreenPoint(TransformPoint({CurrentTransform}
                            Ctrans[CTransFormNum],RlPoint[i]));
     DisplayForm.Image1.canvas.polyline(Apoint);
     {Reset current point to the end point.}
     CurrentPoint.x:=x2;CurrentPoint.y:=y2;
 end; {ArcTo}


 procedure Bezier(xc1,yc1,xc2,yc2,xend,yend:double);
 {Draws a Bezier curve from the current point to xend,yend
  and moves current point to xend,yend }
  var bp1,bc1,bc2,bp2:realpoint;
       p1,pc1,pc2,p2:Tpoint;
  begin
     bp1:= CurrentPoint;
     bc1.x:=xc1;bc1.y:=yc1;
     bc2.x := xc2; bc2.y := yc2;
     bp2.x := xend; bp2.y:= yend;
     p1 := ScreenPoint(TransformPoint(CurrentTransform,bp1));
     pc1 := ScreenPoint(TransformPoint(CurrentTransform,bc1));
     pc2 := ScreenPoint(TransformPoint(CurrentTransform,bc2));
     p2 := ScreenPoint(TransformPoint(CurrentTransform,bp2));
     DrawBezier(1.0,p1.x,p1.y,pc1.x,pc1.y,pc2.x,pc2.y,
         p2.x,p2.y,6);
     DrawStart:=p2;
     CurrentPoint:= bp2;
  end; {Bezier}

 procedure EllipseAt(xradius,yradius:double);
  { Draws an ellipse centred at xc,yc }
 var APoint:array[ 0 .. 50] of TPoint;
     RlPoint:array[ 0 .. 50] of RealPoint;
     i:integer;
 begin
     BasicArc(Rlpoint,CurrentPoint.x,CurrentPoint.y,XRadius,YRadius,0.0,353.0);
     for i:=0 to 50 do
         Apoint[i] := ScreenPoint(TransformPoint(Ctrans[CTransFormNum],
                                  RlPoint[i]));
     DisplayForm.Image1.canvas.polygon(Apoint);
 end;    {EllipseAt}

 procedure BoxAt(x,y:double);
  {Draws a box without resetting starting point}
 var bp1,bp2,bp3,bp4:RealPoint;
     p2,p4:Tpoint;
 begin
     bp1:= CurrentPoint;
     bp3.x:=bp1.x+x;bp3.y:=bp1.y+y;
     bp2.y := bp1.y; bp2.x := bp3.x;
     bp4.x := bp1.x; bp4.y:= bp3.y;
     DrawStart := ScreenPoint(TransformPoint(CurrentTransform,bp1));
     p2 := ScreenPoint(TransformPoint(CurrentTransform,bp2));
     DrawEnd := ScreenPoint(TransformPoint(CurrentTransform,bp3));
     p4 := ScreenPoint(TransformPoint(CurrentTransform,bp4));
     DisplayForm.Image1.canvas.polygon([DrawStart,p2,DrawEnd,p4]);
     CurrentPoint:=bp3;
 end;    {boxat}

 procedure Box(x,y:double);
 {Draws a box and resets starting point}
 begin
   BoxAt(x,y);
   DisplayForm.Image1.Canvas.MoveTo(DrawEnd.x,DrawEnd.y);
 end;

procedure DrawStar(Npoints,OuterRad,InnerRad,StartAngle:double);
 {Draws a star with N points, starting with first point at StartAngle.
  The star is centred on the current point with line style, line colour
  and fill style and colour defined by current settings.}
var  n,i,j:integer;
     x,y,step,stepangle:real;
     RPoint:RealPoint;
     PolyPoint:array[0 .. 40] of Tpoint;
begin
  n:= round(Npoints);
  if n<3 then n:=3;
  if n>20 then n:= 20;
  StartAngle:= StartAngle/AngleMeasure;
  stepangle:= Pi/n;
  x:= CurrentPoint.x; y:= Currentpoint.y;
  j:= 0; step:= 0.0;
  for i:=0 to n-1 do
  begin
    RPoint.x:= OuterRad*cos(StartAngle+step) + x;
    Rpoint.y:=  OuterRad*sin(StartAngle+step) + y;
    PolyPoint[j] := ScreenPoint(TransformPoint(Ctrans[CtransformNum],RPoint));
    j:= succ(j); step:= step+stepangle;
    RPoint.x:= InnerRad*cos(StartAngle+step) + x;
    Rpoint.y:=  InnerRad*sin(StartAngle+step) + y;
    PolyPoint[j] := ScreenPoint(TransformPoint(Ctrans[CtransformNum],RPoint));
    j:= succ(j); step:= step+stepangle;
  end;
  DisplayForm.Image1.canvas.polygon(Slice(PolyPoint,2*n));
end; {DrawStar}

procedure DrawRNPolygon(NumOfSides,PolyRadius,StartAngle:Double);
 {Draws an N-sided regular polygon with first corner at startangle.
  The polygon is centred on the current point and uses current lne
  and fill settings.}
var  n,i,j:integer;
     x,y,step,stepangle:real;
     RPoint:RealPoint;
     PolyPoint:array[0 .. 25] of Tpoint;
begin
  n:= round(NumOfSides);
  if n<3 then n:=3;
  if n>25 then n:= 25;
  StartAngle:= StartAngle/AngleMeasure;
  stepangle:= TwoPi/n;
  x:= CurrentPoint.x; y:= Currentpoint.y;
  j:= 0; step:= 0.0;
  for i:=0 to n-1 do
  begin
    RPoint.x:= PolyRadius*cos(StartAngle+step) + x;
    Rpoint.y:=  PolyRadius*sin(StartAngle+step) + y;
    PolyPoint[j] := ScreenPoint(TransformPoint(Ctrans[CtransformNum],RPoint));
    j:= succ(j); step:= step+stepangle;
  end;
  DisplayForm.Image1.canvas.polygon(Slice(PolyPoint,n));

end;  {Draw Regular N-sided polygon}


 Procedure SetPolygon(NumOfPoints:Integer;
             RealPolyPoint:array of RealPoint);
         {Draws a polygon in current line style and fills
          it with current fillstyle. All polygon vertices are
          relative to the current point.}

 var i,j,k:integer;
     x,y:real;
     RPoint:RealPoint;
     PolyPoint:array[0 .. 101] of Tpoint;

 begin
  x:= CurrentPoint.x; y:= Currentpoint.y;
  for i:=0 to Numofpoints do
  begin
    RPoint.x:= RealPolyPoint[i].x + x;
    Rpoint.y:= RealPolyPoint[i].y + y;
    PolyPoint[i] := ScreenPoint(TransformPoint(Ctrans[CtransformNum],RPoint));
  end;
    DisplayForm.Image1.canvas.polygon(Slice(PolyPoint,NumOfPoints));
 end; {SetPolygon}

 Procedure SetPolyLine(NumOfPoints:Integer;
             RealPolyPoint:array of RealPoint);
         {Draws a polygon in current line style. All polyline vertices are
          relative to the current point.}

 var i,j,k:integer;
     x,y:real;
     RPoint:RealPoint;
     PolyPoint:array[0 .. 100] of Tpoint;

 begin
   LastPoint:= CurrentPoint;
   x:= CurrentPoint.x; y:= Currentpoint.y;
  for i:=0 to Numofpoints-1 do
  begin
    RPoint.x:= RealPolyPoint[i].x + x;
    Rpoint.y:= RealPolyPoint[i].y + y;
    PolyPoint[i] := ScreenPoint(TransformPoint(Ctrans[CtransformNum],RPoint));
  end;
    x:= RealpolyPoint[NumofPoints-1].x+x;
    y:= RealpolyPoint[NumofPoints-1].y+y;
    DisplayForm.Image1.canvas.polyline(Slice(PolyPoint,NumOfPoints));
    Amove(x,y);
 end; {SetPolyLine}

 procedure Circle(radius:double);
  {Draws a circle}
 var Apoint:array[ 0 .. 50] of TPoint;
     Rlpoint:array[ 0 .. 50] of RealPoint;
     i:integer;
 begin
     BasicArc(Rlpoint,CurrentPoint.x,CurrentPoint.y,Radius,Radius,0.0,353.0);
     for i:=0 to 50 do
         Apoint[i] := ScreenPoint(TransformPoint(Ctrans[CtransformNum],
                                  RlPoint[i]));
     DisplayForm.Image1.canvas.polygon(Apoint);
 end;    {Circle}

 Procedure Fill(Color,Style:integer);
 {Fill an area surrounding the current point using the current fill
  style and colours. Color is the boundary colour or the colour to
  be flled over.}

 var fstyle:TFillStyle;

 begin
    If Style=1  then fstyle:= fsborder else fstyle:= fssurface;
    DisplayForm.Image1.canvas.Floodfill(DrawStart.x,DrawStart.y,Color,fstyle);
 end; {Fill}

 procedure Marker(mktype:string;size:double);
 {Draws a marker at the curent point}
 var linepos,mtype:integer;
 begin
   LastStart:=DrawStart;LastEnd:=DrawEnd;DrawEnd:=DrawStart;
   DrawStart := ScreenPoint(TransformPoint(CurrentTransform,currentpoint));
   linepos:=-1;mtype:=-1;
   repeat
      linepos:=succ(linepos);
      if Markers[linepos] =mktype then mtype:=linepos;
   until (linepos=NumOfMarkers) or (mtype>=0);
   if mtype>=0 then { a Marker style found }

   DrawMarker(mtype,DrawStart.x,DrawStart.y,size*CurrentTransform.XScale);
 end; {Marker}

 procedure RBezier(xc1,yc1,xc2,yc2,xend,yend:double);
{Draws a Bezier curve from the current point to xend,yend
 and moves current point to xend,yend where all parameters
 are relative to the current point  }

 var bp1,bc1,bc2,bp2:realpoint;
       p1,pc1,pc2,p2:Tpoint;
 begin
   bp1   := CurrentPoint;
   bc1.x := bp1.x+xc1;
   bc1.y := bp1.y+yc1;
   bc2.x := bp1.x+xc2;
   bc2.y := bp1.y+yc2;
   bp2.x := bp1.x+xend;
   bp2.y := bp1.y+yend;
   p1 := ScreenPoint(TransformPoint(CurrentTransform,bp1));
   pc1 := ScreenPoint(TransformPoint(CurrentTransform,bc1));
   pc2 := ScreenPoint(TransformPoint(CurrentTransform,bc2));
   p2 := ScreenPoint(TransformPoint(CurrentTransform,bp2));
   DrawBezier(1.0,p1.x,p1.y,pc1.x,pc1.y,pc2.x,pc2.y,
         p2.x,p2.y,6);
   DrawStart:=p2;
   CurrentPoint:= bp2;
 end; {RBezier}

 procedure Rline(x,y:double);
 {Draws a line to x,y relative to present point}
 var  LineAngle:double;
 begin
   LastPoint:= CurrentPoint;
   CurrentPoint.x:=CurrentPoint.x+x;
   CurrentPoint.y:=CurrentPoint.y+y;
   DrawEnd := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
   DisplayForm.Image1.Canvas.LineTo(DrawEnd.x,DrawEnd.y);
   LineAngle:= atan2((CurrentPoint.x-LastPoint.x)*currentTransForm.XScale,
                     (CurrentPoint.y-LastPoint.y)*CurrentTransform.yscale);
   if ArrowStart then DrawArrow(ArrowStyle,LastPoint,Lineangle,Arrowsize);
   if ArrowEnd then DrawArrow(ArrowStyle,Currentpoint,LineAngle+Pi,Arrowsize);
   LastStart:=DrawStart;LastEnd:=DrawEnd;DrawStart:=DrawEnd;
 end; {Rline}

 procedure RpLine(r,a:double);
 {Relative line in polar coordinates}
 begin
    rline(r*cos(a/anglemeasure),r*sin(a/anglemeasure));
 end;

 procedure Rmove(x,y:double);
 {Moves Current point to x,y relative to present point}
 begin
   CurrentPoint.x:=CurrentPoint.x+x;
   CurrentPoint.y:=CurrentPoint.y+y;
   LastStart:=DrawStart;LastEnd:=DrawEnd;   {Saves previous settings }
   DrawEnd := ScreenPoint(TransformPoint(CurrentTransform,CurrentPoint));
   DisplayForm.Image1.Canvas.MoveTo(DrawEnd.x,DrawEnd.y);
   LastStart:=DrawStart;DrawStart:=DrawEnd;
   LastEnd:=DrawEnd;   {Moves to current point }
 end;  {Rmove}

 procedure Rpmove(r,a:double);
 {Relative move in polar coordinates}
 begin
    rmove(r*cos(a/anglemeasure),r*sin(a/anglemeasure));
 end;

 procedure square(xx:double);
  {Draws a square centred on the current point }
 var bp1,bp2,bp3,bp4:RealPoint;
     p1,p2,p3,p4:Tpoint;
 begin
     bp1.x:= CurrentPoint.x-xx;bp1.y:=CurrentPoint.y-xx;
     bp2.x:= CurrentPoint.x+xx;bp2.y:=CurrentPoint.y-xx;
     bp3.x:= CurrentPoint.x+xx;bp3.y:=CurrentPoint.y+xx;
     bp4.x:= CurrentPoint.x-xx;bp4.y:=CurrentPoint.y+xx;
     p1:= ScreenPoint(TransformPoint(CurrentTransform,bp1));
     p2:= ScreenPoint(TransformPoint(CurrentTransform,bp2));
     p3:= ScreenPoint(TransformPoint(CurrentTransform,bp3));
     p4:= ScreenPoint(TransformPoint(CurrentTransform,bp4));
     DisplayForm.Image1.canvas.polygon([p1,p2,p3,p4]);
 end;    {square}

 procedure Text(TextString:String;AngleOfText:double);
 {Draws a text string at the current point using current rotation and scale
  factor.  AngleOfText is in radians.}
 var Cfont:TFont;

  begin
   With DisplayForm.Image1.canvas do
   begin
    Font:=TFont.Create;
    Font.Name:=CurrentFont.Name;
    Font.Color:=CurrentFont.Color;
    GetObject(Font.Handle,SizeOf(FontRecord),Addr(FontRecord));
    FontRecord.lfEscapement:=               { Changed 24/10/98}
            Round((CurrentTransform.Rotation+AngleOfText)*Degree*10.0);
    FontRecord.lfHeight:=Round(2*CurrentFont.size*CurrentTransform.YScale*Zoomfactor);
    FontRecord.lfWidth:=Round(CurrentFont.size
                               *CurrentTransform.Xscale*WidthOfText*ZoomFactor);
    Font.Handle:=CreateFontIndirect(FontRecord);
    Textout(DrawStart.x,DrawStart.y,TextString);
   end; {With Image1}
  end; {Text}

   procedure SaveSettings;
  {Saves current graph settings}
   begin
////////////////////////////////////To be replaced/////////////////////////////
//   gResetlevel:= 3;
//    with Savedsettings do
//    begin
//    {Display Settings}
//     SCPnt:= CurrentPoint;
//     SLpnt:= Lastpoint;
//     SXorgn:= XWinOrigin;
//     SYorgn:= YWinorigin;
//    SXOffst:= XOffset;
//     SYOffst:= YOffset;
//     SZFactor:= ZoomFactor;
//     BgNum:= BeginNum;
//     Llevel:= LocalLevel;
//     LTlevel:= LocalTextLevel;
//     STransform:= CurrentTransForm;
//     SITransform:= CurrentInvTransform;
//     STextangle:= TextAngle;
//     SArrowSize:= ArrowSize;
//     SArrowangle:= ArrowAngle;
//     SAlinecolor:= ArrowLineColor;
//     SAfillcolor:= ArrowFillColor;
//     SAstyle:= ArrowStyle;
//     SSclmode:= ScaleMode;
//     Sastart:= ArrowStart;
//     SAend:= ArrowEnd;
//     SFont:= CurrentFont;
//     SFcol:= Fcolor;
//     SF2col:= F2color;
//     SFbcol:= FBcolor;
//     {Pen and Brush Settings}
//     with DisplayForm.Image1.canvas do
//     begin
//      SPStyle:= Pen.style;
//      SPmode:= Pen.mode;
//      SPColor:= Pen.color;
//      SPwidth:= Pen.width;
//      SBstyle:= Brush.Style;
//      SBColor:= Brush.color;
//      SBitMap:= Brush.BitMap;
//      SBBSet:= BrushBitmapSet;
//     end;
//    end;  {with SavedSettings do}
///////////////////////////////////////////////////////////////////////////////
   end;   {SaveSettings}

   procedure RestoreSettings;
    { If gResetLevel =3 then the current settings are saved as replaced
      values and gresetlevel is set to 2.
      If gresetlevel is 2 the current settings are then replaced by the
      saved settings and gresetlevel is set to 1.
      If gresetklevel is 1 the current settings by the replaced values and
      grestlevel returns to 2. Thus after initial entry the two sets are
      toggled.}
   begin
//////////////////////////////To be replaced///////////////////////////////////
//    if GresetLevel=3 then begin
//    GResetLevel:= 2;
//    with ReplacedSettings do
//    begin
//    {Display Settings}
//     SCPnt:= CurrentPoint;
//     SLpnt:= Lastpoint;
//     SXorgn:= XWinOrigin;
//     SYorgn:= YWinorigin;
//     SXOffst:= XOffset;
//     SYOffst:= YOffset;
//     SZFactor:= ZoomFactor;
//     BgNum:= BeginNum;
//     Llevel:= LocalLevel;
//     LTlevel:= LocalTextLevel;
//     STransform:= CurrentTransForm;
//     SITransform:= CurrentInvTransform;
//     STextangle:= TextAngle;
//     SArrowSize:= ArrowSize;
//     SArrowangle:= ArrowAngle;
//     SAlinecolor:= ArrowLineColor;
//     SAfillcolor:= ArrowFillColor;
//     SAstyle:= ArrowStyle;
//     SSclmode:= ScaleMode;
//     Sastart:= ArrowStart;
//     SAend:= ArrowEnd;
//     SFont:= CurrentFont;
//     SFcol:= Fcolor;
//     SF2col:= F2color;
//     SFbcol:= FBcolor;
//     {Pen and Brush Settings}
//     with DisplayForm.Image1.canvas do
//     begin
//      SPStyle:= Pen.style;
//      SPmode:= Pen.mode;
//      SPColor:= Pen.color;
//      SPwidth:= Pen.width;
//      SBstyle:= Brush.Style;
//      SBColor:= Brush.color;
//      SBitMap:= Brush.BitMap;
//      SBBSet:= BrushBitmapSet;
//     end;
//    end; {With Replaced Settings do}
//    end; {if}
//    if gresetlevel=2 then begin
//    gresetlevel:=1;
//    with SavedSettings do
//    begin
//   {Display Settings}
//     CurrentPoint:= SCpnt;
//     Lastpoint:= SLpnt;
//     XWinOrigin:= SXorgn;
//     YWinorigin:= SYorgn;
//     XOffset:= SXoffst;
//     YOffset:= SYoffst;
//     ZoomFactor:= SZFactor;
//     BeginNum:= BgNum;
//     LocalLevel:= Llevel;
//     LocalTextLevel:= LTlevel;
//     CurrentTransForm:= STransform;
//     CurrentInvTransform:= SITransform;
//     TextAngle:= STextAngle;
//     ArrowSize:= SArrowSize;
//     ArrowAngle:= SArrowAngle;
//     ArrowLineColor:= SAlinecolor;
//     ArrowFillColor:= SAfillcolor;
//     ArrowStyle:= SAStyle;
//     ScaleMode:= SSclmode;
//     ArrowStart:= SAstart;
//     ArrowEnd:= SAend;
//     CurrentFont:= SFont;
//     Fcolor:= SFcol;
//     F2color:= SF2col;
//     FBcolor:= SFbcol;
//     {Pen and Brush Settings}
//     with DisplayForm.Image1.canvas do
//     begin
//      Pen.style:= SPStyle;
//      Pen.mode:= SPmode;
//      Pen.color:= SPcolor;
//      Pen.width:= SPwidth;
//      Brush.Style:= SBstyle;
//      Brush.color:= SBcolor;
//      Brush.BitMap:= SBitMap;
//      BrushBitmapSet:= SBBSet;
//     end;
//    end; {with SavedSettings do}
//    gResetlevel:= 1;
//    end else if gResetLevel=1 then
//    begin
//    gresetLevel:=2;
//    with ReplacedSettings do
//    begin
//    {Display Settings}
//     CurrentPoint:= SCpnt;
//     Lastpoint:= SLpnt;
//     XWinOrigin:= SXorgn;
//     YWinorigin:= SYorgn;
//     XOffset:= SXoffst;
//     YOffset:= SYoffst;
//     ZoomFactor:= SZFactor;
//     BeginNum:= BgNum;
//     LocalLevel:= Llevel;
//     LocalTextLevel:= LTlevel;
//     CurrentTransForm:= STransform;
//     CurrentInvTransform:= SITransform;
//     TextAngle:= STextAngle;
//     ArrowSize:= SArrowSize;
//     ArrowAngle:= SArrowAngle;
//     ArrowLineColor:= SAlinecolor;
//     ArrowFillColor:= SAfillcolor;
//     ArrowStyle:= SAStyle;
//     ScaleMode:= SSclmode;
//     ArrowStart:= SAstart;
//     ArrowEnd:= SAend;
//     CurrentFont:= SFont;
//     Fcolor:= SFcol;
//     F2color:= SF2col;
//     FBcolor:= SFbcol;
//     {Pen and Brush Settings}
//     with DisplayForm.Image1.canvas do
//     begin
//      Pen.style:= SPStyle;
//      Pen.mode:= SPmode;
//      Pen.color:= SPcolor;
//      Pen.width:= SPwidth;
//      Brush.Style:= SBstyle;
//      Brush.color:= SBcolor;
//      Brush.BitMap:= SBitMap;
//      BrushBitmapSet:= SBBSet;
//     end;
//    end; {with Replaced Settings do}
//    end; {if}
///////////////////////////////////////////////////////////////////////////////
   end;  {RestoreSettings}

   procedure ResetSettings;
   {This forces a return to the default settings.}
   begin
////////////////////////////////////to be replaced/////////////////////////////
//   if gResetLevel=1 then
//   begin
//    with ReplacedSettings do
//    begin
//    {Display Settings}
//     CurrentPoint:= SCpnt;
//     Lastpoint:= SLpnt;
//     XWinOrigin:= SXorgn;
//     YWinorigin:= SYorgn;
//     XOffset:= SXoffst;
//     YOffset:= SYoffst;
//     ZoomFactor:= SZFactor;
//     BeginNum:= BgNum;
//     LocalLevel:= Llevel;
//     LocalTextLevel:= LTlevel;
//     CurrentTransForm:= STransform;
//     CurrentInvTransform:= SITransform;
//     TextAngle:= STextAngle;
//     ArrowSize:= SArrowSize;
//     ArrowAngle:= SArrowAngle;
//     ArrowLineColor:= SAlinecolor;
//     ArrowFillColor:= SAfillcolor;
//     ArrowStyle:= SAStyle;
//     ScaleMode:= SSclmode;
//     ArrowStart:= SAstart;
//     ArrowEnd:= SAend;
//     CurrentFont:= SFont;
//     Fcolor:= SFcol;
//     F2color:= SF2col;
//     FBcolor:= SFbcol;
//     {Pen and Brush Settings}
//     with DisplayForm.Image1.canvas do
//     begin
//      Pen.style:= SPStyle;
//      Pen.mode:= SPmode;
//      Pen.color:= SPcolor;
//      Pen.width:= SPwidth;
//      Brush.Style:= SBstyle;
//      Brush.color:= SBcolor;
//      Brush.BitMap:= SBitMap;
//      BrushBitmapSet:= SBBSet;
//     end;
//    end;  {with ReplacedSettings do}
//    gResetlevel:=0;
//   end else begin  {if gResetLevel }
//    with DefaultSettings do
//    begin
//    {Display Settings}
//     CurrentPoint:= SCpnt;
//     Lastpoint:= SLpnt;
//     XWinOrigin:= SXorgn;
//     YWinorigin:= SYorgn;
//     XOffset:= SXoffst;
//     YOffset:= SYoffst;
//     ZoomFactor:= SZFactor;
//     BeginNum:= BgNum;
//     LocalLevel:= Llevel;
//     LocalTextLevel:= LTlevel;
//     CurrentTransForm:= STransform;
//     CurrentInvTransform:= SITransform;
//     TextAngle:= STextAngle;
//     ArrowSize:= SArrowSize;
//     ArrowAngle:= SArrowAngle;
//     ArrowLineColor:= SAlinecolor;
//     ArrowFillColor:= SAfillcolor;
//     ArrowStyle:= SAStyle;
//     ScaleMode:= SSclmode;
//     ArrowStart:= SAstart;
//     ArrowEnd:= SAend;
//     CurrentFont:= SFont;
//     Fcolor:= SFcol;
//     F2color:= SF2col;
//     FBcolor:= SFbcol;
//     {Pen and Brush Settings}
//     with DisplayForm.Image1.canvas do
//     begin
//      Pen.style:= SPStyle;
//      Pen.mode:= SPmode;
//      Pen.color:= SPcolor;
//      Pen.width:= SPwidth;
//      Brush.Style:= SBstyle;
//      Brush.color:= SBcolor;
//      Brush.BitMap:= SBitMap;
//      BrushBitmapSet:= SBBSet;
//     end;
//    end; {with DefaultSettings do}
//    gResetlevel:=0;
//    end; {if gresetlevel}
///////////////////////////////////////////////////////////////////////////////
   end;  {ResetSettings}

procedure TDisplayForm.FormActivate(Sender: TObject);
begin
   Caption := EditForm.Caption;
   DrawingMode:= 0;
end;

procedure TDisplayForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  If EditForm.EditMemo.Modified then
  begin
    EditForm.Show;
  end;
end;

procedure TDisplayForm.ClearBitBtnClick(Sender: TObject);
begin
  with Image1 do
  begin  {Resets defaults prior to redrawing.}
     DrawingMode:= 0;
     Picture.graphic:=Bitmap1;
     Canvas.Pen.Style:=psSolid;
     Canvas.Pen.Width :=1;
     CanVas.Pen.Color:=clBlack;
     Canvas.Brush.Style:=bsClear;
     BrushBitmapSet:= False; {May not be needed here.}
  end;
end;

procedure TDisplayForm.Font1Click(Sender: TObject);
begin
  DrawingMode:= 0;
  EditForm.SetFontClick(Sender);
end;

procedure TDisplayForm.HelpContents1Click(Sender: TObject);
begin
  DrawingMode:= 0;
  Application.HelpFile := 'GLE2000Coms';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TDisplayForm.FormResize(Sender: TObject);
begin
    SetBitMaps(Width,Height);
    ClearBitBtnClick(Sender);
    WindowWidth:= (Width-10)/Pixelspercm;;
    WindowHeight:= (Height-110)/Pixelspercm;
    DrawDiagram(FirstLine);
end;

procedure TDisplayForm.ReDrawBitBtn1Click(Sender: TObject);
begin
  try
    Screen.Cursor:= crHourGlass;
    Image1.Cursor:= crhourGlass;
    ClearBitBtnClick(Sender);
    DrawDiagram(FirstLine);
  finally
    DrawingMode:= 0;
    Image1.Cursor:= crZoom;
    Screen.Cursor:= crDefault;
    ZoomBtnClick(sender);
  end;
end;

procedure TDisplayForm.Help2Click(Sender: TObject);
begin
  Application.HelpFile := 'GLE2000';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TDisplayForm.ErrorMessages1Click(Sender: TObject);
begin
  Application.HelpFile := 'GLE2000Err';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TDisplayForm.Conversions1Click(Sender: TObject);
begin
    Application.HelpFile := 'GLE2000Cnvrt';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TDisplayForm.FontName1Click(Sender: TObject);
begin
   EditForm.Name1Click(Sender);
end;

procedure TDisplayForm.Size1Click(Sender: TObject);
begin
 EditForm.Height1Click(Sender);
end;

procedure TDisplayForm.Colour4Click(Sender: TObject);
begin
  EditForm.Colour1Click(Sender);
end;

procedure TDisplayForm.Brush1Click(Sender: TObject);
begin
 FillsForm.Show; DrawingMode:= 0;
end;

procedure TDisplayForm.Clear1Click(Sender: TObject);
begin
   GLE2000E.SetLineStyle(0); DrawingMode:= 0;
end;

procedure TDisplayForm.Solid1Click(Sender: TObject);
begin
   GLE2000E.SetLineStyle(1); DrawingMode:= 0;
end;

procedure TDisplayForm.Dash1Click(Sender: TObject);
begin
   GLE2000E.SetLineStyle(2); DrawingMode:= 0;
end;

procedure TDisplayForm.Dot1Click(Sender: TObject);
begin
   GLE2000E.SetLineStyle(3); DrawingMode:= 0;
end;

procedure TDisplayForm.DashDot1Click(Sender: TObject);
begin
   GLE2000E.SetLineStyle(4); DrawingMode:= 0;
end;

procedure TDisplayForm.DashDotdot1Click(Sender: TObject);
begin
   GLE2000E.SetLineStyle(5); DrawingMode:= 0;
end;

procedure TDisplayForm.Insideframe1Click(Sender: TObject);
begin
   GLE2000E.SetLineStyle(6); DrawingMode:= 0;
end;

procedure TDisplayForm.Colour2Click(Sender: TObject);
begin
  EditForm.Colour2Click(Sender); DrawingMode:= 0;
end;

procedure TDisplayForm.Width1Click(Sender: TObject);
begin
  EditForm.Width1Click(Sender); DrawingMode:= 0;
end;

procedure TDisplayForm.PageSettings1Click(Sender: TObject);
begin
  PrintForm.Show; DrawingMode:= 0;
end;

procedure TDisplayForm.Print1Click(Sender: TObject);
begin
  PrintButtonClick(Sender);
end;

procedure TDisplayForm.Load1Click(Sender: TObject);
begin
  if OpenDialog1.execute then
  begin
    DrawingMode:= 0;
    Displayat(CurrentPoint.x,CurrentPoint.y,OpenDialog1.FileName);
    EditForm.EditMemo.Lines.Add('Displayat  ' + RealString(Currentpoint.x)
      + ' ' + RealString(CurrentPoint.y) + '  "' + OpenDialog1.FileName +'"');
  end;
end;

procedure TDisplayForm.ModeButtonClick(Sender: TObject);
begin
     ScaleMode:= succ(ScaleMode);
   if Scalemode>6 then ScaleMode:= 0;
   case Scalemode of
    0: begin
         PosnLabel.Caption:= 'Window Position';
         Label1.Caption:= 'x';
         Label2.Caption:= 'y';
         Label4.Caption:= ' cm';
       end;
    1: begin
         PosnLabel.Caption:= 'Abs. Position';
         Label1.Caption:= 'x';
         Label2.Caption:= 'y';
         Label4.Caption:= 'cm';
       end;
    2: begin
         PosnLabel.Caption:= 'Local x,y';
         Label4.Caption:= 'cm';
       end;
    3: begin
         PosnLabel.Caption:= 'Local Polar';
         if Anglemeasure>50.0 then
           Label4.Caption:= 'Deg'
         else Label4.Caption:= 'Rad';
         Label1.Caption:= 'r';
         Label2.Caption:= 'a';
       end;
    4: begin
         PosnLabel.Caption:= 'Scale Factor';
         Label1.Caption:= 'x';
         Label2.Caption:= 'y';
         Label4.Caption:= 'cm';
       end;
    5: begin
         PosnLabel.Caption:= 'Current Origin';
         Label1.Caption:= ' ';
         Label2.Caption:= ' ';
         Label4.Caption:= 'cm';
       end;
    6:begin
         PosnLabel.Caption:= 'Current Zoom';
         Label4.Caption:= ' ';
      end;
   end; {case}

end;

procedure SetBitBtnColor(Bnum,Bcolor:integer);
{sets the caption colors for bit buttons)}
begin
  with DisplayForm do
  case Bnum of
    0:begin
    ZoomBtn.Font.Color:= clAqua;
    ZoomBtn.Caption:= '&D'
      end;
    1:BitBtn1.Font.Color:= Bcolor;
    2:BitBtn2.Font.Color:= Bcolor;
    3:BitBtn3.Font.Color:= Bcolor;
    4:BitBtn4.Font.Color:= Bcolor;
    5:BitBtn5.Font.Color:= Bcolor;
    6:BitBtn6.Font.Color:= Bcolor;
    7:BitBtn7.Font.Color:= Bcolor;
    8:BitBtn8.Font.Color:= Bcolor;
    9:BitBtn9.Font.Color:= Bcolor;
   10:BitBtn10.Font.Color:= Bcolor;
  end;
end; {SetBitbtnColor}

procedure TDisplayForm.BitBtn1Click(Sender: TObject);
begin
   If CurrentBitBtn<>1 then
   begin
      CurrentBitBtn:= 1;
      Image1.Cursor:= crCross;
      SetBitBtnColor(1,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 1;
   end;
   MouseMode:= True; NewDrawing:=True; NewStyle:= True;
   DrawingTool:= dtLine; DrawingMode:= 0;
end;

procedure TDisplayForm.BitBtn2Click(Sender: TObject);
begin
   If CurrentBitBtn<>2 then
   begin
      CurrentBitBtn:= 2;
      Image1.Cursor:= crCross;
      SetBitBtnColor(2,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 2;
   end;
 MouseMode :=True; NewDrawing:=True; NewStyle:=True;
 DrawingTool := dtBox; DrawingMode:= 0;
end;

procedure TDisplayForm.BitBtn3Click(Sender: TObject);
begin
   If CurrentBitBtn<>3 then
   begin
      CurrentBitBtn:= 3;
      Image1.Cursor:= crCross;
      SetBitBtnColor(3,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 3;
   end;
   MouseMode := True;
  DrawIngTool:= dtCircle; DrawingMode:= 0;
end;

procedure TDisplayForm.BitBtn4Click(Sender: TObject);
begin
   If CurrentBitBtn<>4 then
   begin
      CurrentBitBtn:= 4;
      Image1.Cursor:= crCross;
      SetBitBtnColor(4,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 4;
   end;
  MouseMode:=True;
  DrawingTool:=dtArc; DrawingMode:= 0;
  Clockwise:=False;
end;

procedure TDisplayForm.BitBtn5Click(Sender: TObject);
begin
   If CurrentBitBtn<>5 then
   begin
      CurrentBitBtn:= 5;
      Image1.Cursor:= crCross;
      SetBitBtnColor(5,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 5;
   end;
  MouseMode:=True;
  DrawingTool:=dtMarker; DrawingMode:= 0;
end;

procedure TDisplayForm.BitBtn6Click(Sender: TObject);
begin
 If CurrentBitBtn<>6 then
 begin
      CurrentBitBtn:= 6;
      Image1.Cursor:= crCross;
      SetBitBtnColor(6,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 6;
 end;
 MouseMode:=True;
 drawingTool:=dtText; DrawingMode:= 0;
 if not TextOn then
  begin
    Bitbtn1.Hide;
    Bitbtn2.Hide;
    Bitbtn3.Hide;
    Bitbtn4.Hide;
    Bitbtn5.Hide;
    TextEdit.Font.Name:= currentFont.Name;
    TextEdit.Font.height := 15;
    TextEdit.Show;
    TextOn:=True;
  end else begin
    BitBtn1.show;
    BitBtn2.show;
    BitBtn3.show;
    BitBtn4.show;
    BitBtn5.show;
    TextEdit.Hide;
    TextOn:=False;
  end;
  TextOut:=TextEdit.Text;
end;

procedure TDisplayForm.BitBtn7Click(Sender: TObject);
begin
   If CurrentBitBtn<>7 then
   begin
      CurrentBitBtn:= 7;
      Image1.Cursor:= crCross;
      SetBitBtnColor(7,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 7;
   end;
  MouseMode:=True;
  DrawingTool:= dtSquare; DrawingMode:= 0;
end;

procedure TDisplayForm.BitBtn8Click(Sender: TObject);
begin
   If CurrentBitBtn<>8 then
   begin
      CurrentBitBtn:= 8;
      Image1.Cursor:= crCross;
      SetBitBtnColor(8,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 8;
   end;
   MouseMode:= True; NewDrawing:=True; NewStyle:= True;
   DrawingTool:= dtEllipse; DrawingMode:= 0;
end;

procedure TDisplayForm.BitBtn9Click(Sender: TObject);
begin
   If CurrentBitBtn<>9 then
   begin
      CurrentBitBtn:= 9;
      Image1.Cursor:= crCross;
      SetBitBtnColor(9,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 9;
   end;
  MouseMode:=True;
  DrawingTool:=dtArc; DrawingMode:= 0;
  Clockwise:=True;
end;

procedure TDisplayForm.BitBtn10Click(Sender: TObject);
begin
   If CurrentBitBtn<>10 then
   begin
      CurrentBitBtn:= 10;
      Image1.Cursor:= crCross;
      SetBitBtnColor(10,Primrose);
      SetBitBtnColor(LastBitBtn,clNavy);
      LastBitBtn:= 10;
   end;
  MouseMode:=True;
 DrawingTool:= dtBezier; DrawingMode:= 0;
end;

procedure TDisplayForm.Reset1Click(Sender: TObject);
begin
  WindowForm.Show;
  Windowform.FormActivate(Sender);
end;

procedure TDisplayForm.ZoomBtnClick(Sender: TObject);
begin
    Currentbitbtn:= 0;
    Image1.Cursor := crZoom;
    ZoomBtn.Font.Color:= clred;
    Zoombtn.caption:= '&Z';
    DrawingTool:= dtNone; DrawingMode:= 0;
    if LastbitBtn<>0 then SetBitBtnColor(LastBitBtn,clNavy);
    LastBitBtn:= 0;
end;

procedure TDisplayForm.SetDefaults1Click(Sender: TObject);
begin
  DrawingMode:= 0;
  GLE2000W.WindowForm.Button4Click(Sender);
  GLE2000W.WindowForm.Button1Click(Sender);
end;

procedure TDisplayForm.FormDeactivate(Sender: TObject);
begin
 DrawingMode:= 0;
end;

end.
