#include <qwidget.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qpntarry.h>
#include <qpoint.h>
#include "common.h"

class ViewSelector : public QWidget
{
   Q_OBJECT
public:
   ViewSelector(QWidget *parent = 0, const char *name = 0); 
   void SetData(int s_x, int s_y, int s_dx, int s_dy);  
public slots:
   void setView_e(const char *);
   void setView_j(const char *);
   void setView_k(const char *);
   void setUp_e(const char *);
   void setUp_j(const char *);
   void setUp_k(const char *);
   void setMove_x(const char *);
   void setMove_y(const char *);
   void setLxr(const char *);
protected:
   void paintEvent(QPaintEvent *QP);
   void mousePressEvent(QMouseEvent *);
   void mouseMoveEvent(QMouseEvent *);
   void mouseReleaseEvent(QMouseEvent *);
signals:
   void view_e_Changed(const char *);
   void view_j_Changed(const char *);
   void view_k_Changed(const char *);
private:
   void CalcCoo();
   double len_x, len_y;
   struct view_struct v;
   QPixmap *Pixmap;
   int x, y;    // which axis is mapped in x, y directions: 0=e, 1=j, 2=k 
   int dx, dy;  // direction: + or -
   int vx, vy;  // viewpoint in bitmap coordinates
   QPointArray *plane;  // bitmap coordinates of plane points
   int state;   // 0...normal, 1...dragging
};
