/* rgbmap.h - working with rgb maps */

typedef struct {
  int width,height;
  unsigned char *data;
} rgbmap;

int rgbmap_alloc(rgbmap *map,int width,int height);
void rgbmap_free(rgbmap *map);

void rgbmap_swaprgb(rgbmap *map,int r,int g,int b);

int rgbmap_import_ppm(rgbmap *map,FILE *f);
int rgbmap_import_tga(rgbmap *map,FILE *f);
int rgbmap_import_bmp(rgbmap *map,FILE *f);

void rgbmap_dither(rgbmap *map,int pixel_size,unsigned char *pixels,int rbase,int rlevels,int gbase,int glevels,int bbase,int blevels);
void rgbmap_grayscale(rgbmap *map);

void rgbmap_rgb(rgbmap *map,int r,int g,int b);
void rgbmap_rotate(rgbmap *map,int dir);
void rgbmap_mirror(rgbmap *map,int y);

