#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include <windows.h>
#include <winuser.h>
#include "wlookd.h"

#include <string.h>
#include <math.h>

#define VERSION_STRING "0.10"

#include "rgbmap.h"

typedef unsigned char byte;

int grayscale=0;
unsigned char rgb[3]={0,1,2};
int width=640,height=480;
double zoom=1;
double aspect=1;

int depthbit=0,depthbyte=0;
int key_step=10;
double mx=0,my=0,mz=0;
int dirty=1;
byte *backbytes=NULL;
BITMAPINFOHEADER backbih;
byte *bgmem=NULL;
HWND window=NULL;
HINSTANCE hinstance;
HACCEL accel;

int _rgb_r_shift_15=10,_rgb_g_shift_15=5,_rgb_b_shift_15=0;
int _rgb_r_shift_16=10,_rgb_g_shift_16=5,_rgb_b_shift_16=0;
int _rgb_r_shift_24=16,_rgb_g_shift_24=8,_rgb_b_shift_24=0;
int _rgb_r_shift_32=16,_rgb_g_shift_32=8,_rgb_b_shift_32=0;


typedef double vec[3];
typedef vec mat[3];
typedef unsigned char uchar;


typedef struct { uchar r,g,b;} file_pixel;

inline vec *vec_copy(vec *a,vec *b) {                  /* a=b */
  a[0][0]=b[0][0],a[0][1]=b[0][1],a[0][2]=b[0][2];
  return a;
}

inline vec *vec_add(vec *a,vec *b) {                   /* a+=b */
  a[0][0]+=a[0][0];a[0][1]+=b[0][1];a[0][2]+=b[0][2];
  return a;
}

inline vec *vec_sub(vec *a,vec *b) {                    /* a-=b */
  a[0][0]-=b[0][0];a[0][1]-=b[0][1];a[0][2]-=b[0][2];
  return a;
}

inline vec *vec_r(vec *a,double r) {                      /* a*=r */
  a[0][0]*=r,a[0][1]*=r,a[0][2]*=r;
  return a;
}

inline mat *mat_copy(mat *a,mat *b) {
  memcpy(a,b,sizeof(*a));
}

inline mat *mat_mul(mat *c,mat *a,mat *b) {             /* c=a*b */
  int i,j;
  for(i=0;i<3;i++)
    for(j=0;j<3;j++) {
      (*c)[j][i]=(*a)[j][0]*(*b)[0][i]+(*a)[j][1]*(*b)[1][i]+(*a)[j][2]*(*b)[2][i];
    }
};

// rotace jsou ve stupnich
void mat_rotaxis(mat *a,double fi,int axis) {
  mat r={{1,0,0},{0,1,0},{0,0,1}},s;
  int i,j;
  fi=fi*M_PI/180;
  switch(axis) {
   case 0:i=1,j=2;break;
   case 1:i=0,j=2;break;
   case 2:i=0,j=1;break;
   default:return;
  }
  r[i][i]=r[j][j]=cos(fi);
  r[i][j]=-sin(fi);
  r[j][i]=sin(fi);
  mat_copy(&s,a);
  mat_mul(a,&s,&r);
}

mat *mat_rotaxyz(mat *a,double x,double y,double z) {
  mat_rotaxis(a,x,0);
  mat_rotaxis(a,y,1);
  mat_rotaxis(a,z,2);
}


typedef struct {
  int w,h; // width,height,bytes per line
  byte *map;   // data for map
} side;

side map[6];

int side_read(side *s,char *filename,int how) {
  FILE *f;
  char line[80];
  int w,h;
  byte *data;
  byte *bs;
  rgbmap fm;
  char *ext;

  if(!(f=fopen(filename,"rb"))) return 0;
  ext=strrchr(filename,'.');
  if(!ext) {
   defext:
    rgbmap_import_tga(&fm,f);           // default is tga
  } else {
    ext++;
    if(!strcasecmp(ext,"ppm"))  // if there is extension ppm do ppm
      rgbmap_import_ppm(&fm,f);
    else 
    if(!strcasecmp(ext,"bmp"))  // if there is extension bmp do bmp
      rgbmap_import_bmp(&fm,f);
    else
      goto defext;
  }
  fclose(f);
  data=(byte*)fm.data;
  if(!grayscale)
    rgbmap_rgb(&fm,rgb[0],rgb[1],rgb[2]);
  else
    rgbmap_grayscale(&fm);
  switch(how) {
   case 0:rgbmap_rotate(&fm,1);break;
   case 1:rgbmap_mirror(&fm,0);break;
   case 3:rgbmap_rotate(&fm,1);rgbmap_mirror(&fm,0);break;
   case 5:rgbmap_mirror(&fm,1);break;
  };
  /* translation to less depth */
  
  s->w=fm.width,s->h=fm.height;
  s->map=(byte*)malloc(depthbyte*s->w*s->h);
  switch(depthbit) {
   case 15:
      rgbmap_dither(&fm,2,s->map,
      1<<_rgb_r_shift_15,32,1<<_rgb_g_shift_15,32,1<<_rgb_b_shift_15,32);
    break;
   case 16:
      rgbmap_dither(&fm,2,s->map,
      1<<_rgb_r_shift_16,32,1<<_rgb_g_shift_16,32,1<<_rgb_b_shift_16,32);
    break;
   case 24:
      rgbmap_dither(&fm,3,s->map,
      1<<_rgb_r_shift_24,256,1<<_rgb_g_shift_24,256,1<<_rgb_b_shift_24,256);
    break;
   case 32:
      rgbmap_dither(&fm,4,s->map,
      1<<_rgb_r_shift_32,256,1<<_rgb_g_shift_32,256,1<<_rgb_b_shift_32,256);
    break;
  }
  /* done */
  rgbmap_free(&fm);
  return 1;
 r0:
  fclose(f);
  return 0;
}

typedef int myfix;
#define FIX_BITS 16
#define MULT (1<<FIX_BITS)
//#define R2F(X) ((myfix)((X)*MULT))
#define R2F(X) ((myfix)((X)*MULT+.5*((X)<0?-1:1)))

inline void minimum(myfix x,myfix dx,myfix z,myfix dz,int *min) {
  register int d,e;
  if(dz>=0)
    if(dx>=0)   // dz>=0 && dx>=0
      if(dz>=dx) return;
      else d=(z-x)/(dx-dz);
    else        // dz>=0 && dx<0
      if(dz>=-dx) return;
      else d=(z+x)/(dz-dx);
   else
     if(dx>=0) { // dz<0 && dx>=0
       d=(z-x)/(dx-dz);                 // potud ok
       if(dz<-dx) {
         e=(z+x)/(-dx-dz);
         if(e<d) d=e;
       }
     } else  {      // dz<0 && dx<0
       d=(x+z)/(-dx-dz);           // odtud ok
       if(dz<dx) {
         e=(z-x)/(dx-dz);
         if(e<d) d=e;              //  if(e>=1&&e<d) d=e;
       }
     }
  if(d<1) d=1;
  if(*min>d) *min=d;
}


/* interpolace pomoci FDIV

#define FDIV(X,Y) (((X)<<(FIX_BITS/2))/((Y)>>(FIX_BITS-FIX_BITS/2)))

    x2=FDIV(x,z);\
    y2=FDIV(y,z);\
    x2=(x2+MULT+MULT/width/1)*(width-2)/(MULT*2);\
    y2=(y2+MULT+MULT/height/1)*(height-2)/(MULT*2);\
 */

/* interpolace pomoci imuldiv

__inline int imuldiv(int x,int m,int d) {
  __asm__ __volatile__("
    imull %1
    idivl %2"
    : "+a" (x) 
    : "bcSDm" (m),"bcSDm"(d)
    : "edx"
  );
  return x;
} 

    x2=imuldiv(x,(width-1),z);\
    x2=(x2+width)/2;\
    y2=imuldiv(y,(height-1),z);\
    y2=(y2+height)/2;\
 */

// soucasna interpolace pouziva widthm1 (width-1)

__inline int transform(int xy,int whm1,int z) {
  __asm__ __volatile__("
    imull %1
    idivl %2
    addl %1,%%eax
    incl %%eax
    sarl $1,%%eax"
    : "+a" (xy) 
    : "bcSDm" (whm1),"bcSDm"(z)
    : "edx"
  );
  return xy;
}


// depth dependent
// z musi byt vetsi jak 0 a v absolutni hodnote vetsi jak x a y po celou interpolaci

#define DEPTH_PART(ID,TYPE) \
inline void interpolator_ ## ID (\
  myfix x,myfix dx,myfix y,myfix dy,myfix z,myfix dz,int widthm1,int heightm1,\
  TYPE *map,TYPE *buf,int steps) {\
  register myfix x2,y2;\
  while(steps--) {\
    y2=transform(y,heightm1,z);\
    x2=transform(x,widthm1,z);\
    *buf++=map[y2*(widthm1+1)+x2];\
    x+=dx,y+=dy,z+=dz;\
  }\
}\
\
int scanline_ ## ID (myfix x,myfix dx,myfix y,myfix dy,myfix z,myfix dz,byte *buffer) {\
  int len=width,min,m;\
  register myfix x2,y2,z2,dx2,dy2,dz2;\
  TYPE *buf=(TYPE*)buffer;\
  side *mp;\
  while(len) {\
    x2=abs(x),y2=abs(y),z2=abs(z);\
    if(x2>=y2&&x2>=z2) {z2=x,dz2=dx,x2=y,dx2=dy,y2=z,dy2=dz;m=0;}\
    else if(y2>=x2&&y2>=z2) {z2=y,dz2=dy,x2=x,dx2=dx,y2=z,dy2=dz;m=1;}\
    else {z2=z,dz2=dz,x2=x,dx2=dx,y2=y,dy2=dy;m=2;};\
    if(z2<0) m+=3,z2=-z2,dz2=-dz2;\
    min=len;\
    minimum(x2,dx2,z2,dz2,&min);\
    minimum(y2,dy2,z2,dz2,&min);\
    mp=map+m;\
    interpolator_ ## ID (x2,dx2,y2,dy2,z2,dz2,mp->w-1,mp->h-1,(TYPE*)(mp->map),buf,min);\
    x+=min*dx,y+=min*dy,z+=min*dz;\
    buf+=min,len-=min;\
  }\
}

typedef struct { char x[2];} s16;
typedef struct { char x[3];} s24;
typedef struct { char x[4];} s32;


DEPTH_PART(16,s16)
DEPTH_PART(24,s24)
DEPTH_PART(32,s32)

int (*scanline)(myfix x,myfix dx,myfix y,myfix dy,myfix z,myfix dz,byte *buffer);

void recalc() {
  mat ori={{1,0,0},{0,1,0},{0,0,1}},ori2;
  vec vs,vx,vy;
  //double ri,rj;

  mat_copy(&ori2,&ori);
  mat_rotaxyz(&ori2,my,mx,mz);
  vec_r(vec_copy(&vx,ori2),zoom);
  vec_r(vec_copy(&vy,ori2+1),zoom*aspect*height/width);
  vec_copy(&vs,ori2+2);

  // time to go to fixed arithmetic
  vec_r(&vx,2./width);
  vec_r(&vy,2./height);

  { myfix sx=R2F(vs[0]),sy=R2F(vs[1]),sz=R2F(vs[2]);
    myfix xx=R2F(vx[0]),xy=R2F(vx[1]),xz=R2F(vx[2]);
    myfix yx=R2F(vy[0]),yy=R2F(vy[1]),yz=R2F(vy[2]);
    myfix ax,ay,az;
    register int i,j;
    byte *p=bgmem;

    sx-=(width*xx+height*yx)/2; 
    sy-=(width*xy+height*yy)/2;
    sz-=(width*xz+height*yz)/2;

    for(j=height;j;j--) {
      scanline(sx,xx,sy,xy,sz,xz,p);
      p+=width*depthbyte;
      sx+=yx,sy+=yy,sz+=yz;
    }
  }
}

int init(char *filename[6]) {
  int i;
  int pmap_permutation[]={1,5,0,3,4,2};

  depthbit=GetDeviceCaps(GetDC(NULL),BITSPIXEL);
  depthbyte=(depthbit+7)>>3;

  for(i=0;i<6;i++) {
    if(!side_read(map+i,filename[pmap_permutation[i]],i)) return i+1;
    if(!map[i].map) return i+1;
  }
  switch(depthbit) {
    case 15:
    case 16:scanline=scanline_16;break;
    case 24:scanline=scanline_24;break;
    case 32:scanline=scanline_32;break;
  }
  return 0;
};

void repaint() {
  SetDIBitsToDevice(GetDC(window),0,0,width,height,0,0,
      0,height,bgmem,(BITMAPINFO*)&backbih,DIB_RGB_COLORS);
}

void resize_dc() {
  RECT r;
  HBITMAP b;
  GetClientRect(window,&r);
  width=r.right,height=r.bottom;
  if(backbytes)
    free(backbytes);
  backbytes=(byte*)malloc(depthbyte*width*height);
  backbih.biSize=sizeof(backbih);
  backbih.biWidth=width;
  backbih.biHeight=-height;
  backbih.biPlanes=1;
  backbih.biBitCount=depthbit;
  backbih.biCompression=BI_RGB;
  backbih.biSizeImage=0;
  backbih.biXPelsPerMeter=1000;
  backbih.biYPelsPerMeter=1000;
  backbih.biClrUsed=0;
  backbih.biClrImportant=0;
  bgmem=backbytes;
}

long FAR PASCAL main_WndProc (HWND hWnd, UINT iMessage,
    WPARAM wParam, LPARAM lParam);

void create_window() {
  WNDCLASS WndClass;

  accel = LoadAccelerators(hinstance,"accel_main");

  WndClass.cbClsExtra = 0;
  WndClass.cbWndExtra = 0;
  WndClass.hbrBackground = NULL;
  WndClass.hCursor=LoadCursor(NULL, IDC_ARROW);
  WndClass.hIcon=LoadIcon(hinstance,"icon_look");
  WndClass.hInstance = hinstance;
  WndClass.style=CS_OWNDC; // CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc = main_WndProc;
  WndClass.lpszClassName = "main";
  WndClass.lpszMenuName = NULL ; //"menu_main";
  RegisterClass(&WndClass); // main window class

  window=CreateWindow("main","WLook",WS_VISIBLE|WS_TILEDWINDOW,
      0,0,width,height,NULL,NULL,hinstance,NULL);
  resize_dc();
}



long FAR PASCAL main_WndProc (HWND hWnd, UINT iMessage,
    WPARAM wParam, LPARAM lParam) {
  static int lx,ly; // mouse left button press x,y

  LRESULT r=0;

  switch(iMessage)  {
   case WM_PAINT:
    if(bgmem) {
      PAINTSTRUCT PS;
      BeginPaint(hWnd,&PS);
      if(!dirty)
        dirty=1;
      EndPaint(hWnd,&PS);
    } break;
//   case WM_SYSKEYDOWN:
   case WM_KEYDOWN: { 
      MSG m={window,iMessage,wParam,lParam};
      TranslateAccelerator(window,accel,&m);
    } break;
   case WM_COMMAND:
    switch(LOWORD(wParam)) {
     case UM_GoLeft:mx-=key_step*zoom;goto update;
     case UM_GoRight:mx+=key_step*zoom;goto update;
     case UM_GoUp:my-=key_step*zoom;goto update;
     case UM_GoDown:my+=key_step*zoom;goto update;
     case UM_RotateLeft:mz+=key_step*zoom;goto update;
     case UM_RotateRight:mz-=key_step*zoom;goto update;
     case UM_ZoomIn:zoom/=1.1;goto update;
     case UM_ZoomOut:zoom*=1.1;goto update;
     case UM_ViewForward:zoom=1,mx=my=mz=0;goto update;
     case UM_ViewBackward:zoom=1,mx=180,my=mz=0;goto update;
     case UM_ViewLeft:zoom=1,mx=-90,my=mz=0;goto update;
     case UM_ViewRight:zoom=1,mx=90,my=mz=0;goto update;
     case UM_ViewUp:zoom=1,my=-90,mx=mz=0;goto update;
     case UM_ViewDown:zoom=1,my=90,mx=mz=0;goto update;
     case UM_LookBackward:mx+=180;goto update;
     case UM_LookLeft:mx-=90;goto update;
     case UM_LookRight:mx+=90;goto update;
     case UM_LookUp:my-=90;goto update;
     case UM_LookDown:my+=90;goto update;
     default:break;
     update:
      dirty=2;
    } break;
   case WM_SIZE:
    if(window) {
      resize_dc();
      dirty=2;
    }
    break;
   case WM_DESTROY:
    PostQuitMessage(0);
    break;
   case WM_LBUTTONDOWN:
    lx=LOWORD(lParam),ly=HIWORD(lParam);
    break;
   case WM_MOUSEMOVE:
    if(wParam&MK_LBUTTON) {
      int nx=LOWORD(lParam),ny=HIWORD(lParam);
      mx+=zoom*(nx-lx),my+=zoom*(ny-ly);
      lx=nx,ly=ny;
      dirty=2;
    } 
    break;
   default: {
    r=DefWindowProc(hWnd, iMessage, wParam, lParam);
   } break;
  }
  return r;
}

int loop() {
  MSG m;
  static int lx,ly; // mouse left button press x,y

  while(WaitMessage()) {
    while(PeekMessage(&m,NULL,0,0,PM_REMOVE)) {
      if(m.message==WM_QUIT)
        return m.wParam;
      DispatchMessage(&m);
    }
    if(dirty) {
      if(dirty>1) recalc();
      repaint();
      dirty=0;
    }
  }
}
int is_space(char c) {  // misto systemove isspace, protoze
  return 0<c&&c<=' ';               // oddeluje i konce radku
}

int is_nospace(char c) {
  return ' '<c||c<0;
}

char *skip_space(char *str) {   // ukazatel na prvni nemezerovy znak
  while(is_space(*str)) str++;
  return str;
}

char *skip_nospace(char *str) { // ukazatel na prvni mezerovy znak
  while(is_nospace(*str)) str++;
  return str;
}

char *next_word(char *str) {    // ukazatel na zacatek dalsiho slova
  return skip_space(skip_nospace(skip_space(str)));
}

char *str_substr(char *str,int len,char *dest) {
  memcpy(dest,str,len);
  dest[len]=0;
  return str+len;
}

char *str_word(char *str,int plen,char *p) {  // precteni slova z retezce
  char *h;
  str=skip_space(str);
  for(h=str;is_nospace(*h);h++);
  plen--;
  if(h-str<plen) plen=h-str;
  str_substr(str,plen,p);
  return h;
}



char help_str[]=
"wlook v." VERSION_STRING  " compiled "__DATE__" at "__TIME__ " \n"
"\n"
"wlook [-a x/y] [-g] [-h] [-t RGB] [-w XxY] [-z r] file[0-5].{bmp,tga,ppm}\n"
"\n"
"All 6 files can be passed, if only one file is as argument, then other\n"
"files are found with following algorithm, last occurence of digits [0-5] is\n"
"taken as index field in the filename, 6 files with digits 0-5, are opened.\n"
"\n"
"-a x/y	sets aspect of screen to x/y.\n"
"-g	grayscale\n"
"-h 	help\n"
"-t RGB	with this option you can permute RGB colors of picture. For example\n"
"	-t grb ,swaps green and red channel. Option can be useful, in the\n"
"	case of bad detect of color weights.\n"
"-w XxY	set window size\n"
"-z r	sets zoom of picture, 1.0 means 90 grades\n"
"\n"
"Control:\n"
"mouse,arrows	looking around\n"
"Home,End	rotate\n"
"PgUp,PgDn	zoom in/out\n"
"F1-6		sides\n"
;

int print_help() {
  MessageBox(NULL,help_str,"Parametrs",MB_OK);
}

char *parse_args(char *args) {
  char c,*h,buf[256];
  int help=0;

  h=skip_space(args);
  while(*h=='-') {
    h++;
    while(is_nospace(*h)) {
      c=*h++;
      switch(c) {
       case '-':h=skip_space(h);goto parend;
       case 'g':grayscale=1;break;
       case 'z':
        h=str_word(h,sizeof(buf),buf);
        sscanf(buf,"%lf",&zoom);
        zoom=zoom>.01&&zoom<100?1/zoom:1;
        break;
       case 'w':
        h=str_word(h,sizeof(buf),buf);
        sscanf(buf,"%dx%d",&width,&height);
        break;
       case 't':{
          int i;
          char c;
          h=str_word(h,sizeof(buf),buf);
          if(strlen(buf)<3) break;
          for(i=0;i<3;i++) {
            c=tolower(buf[i]);
            switch(c) {
             case 'r':
             case '0':rgb[i]=0;break;
             case 'g':
             case '1':rgb[i]=1;break;
             case 'b':
             case '2':rgb[i]=2;break;
            }
          }
        } break;
       case 'a':{
          int a1,a2;
          h=str_word(h,sizeof(buf),buf);
          sscanf(buf,"%d/%d",&a1,&a2);
          aspect=((double)a2)/a1;
        } break;
       case 'h':
       case '?':
        print_help();
        help=1;
        break;
       default:
        h=next_word(h);
      }
    }
    h=skip_space(h);
  }
 parend:
  if(!*h&&!help)
    print_help();
  return h;
}

char *parse_filenames(char *h,int flen,char *filename[6]) {
  char *g;
  int i;

  for(i=0;i<6;i++) {
    h=str_word(h,flen,filename[i]);
    if(!*filename[i])
      if(i==1) {
        int digit=-1;
        for(i=0;filename[0][i];i++)
            if(filename[0][i]>='0'&&filename[0][i]<='5')
              digit=i;
        if(digit<0)
          return "Unable to find digit 0..6 in filename";
        filename[0][digit]='0';
        for(i=1;i<6;i++) {
          strcpy(filename[i],filename[0]);
          filename[i][digit]='0'+i;
        }
        return NULL;
      } else
        return "Wrong number of filenames";
  }
  return NULL;
}

int PASCAL WinMain(HINSTANCE hCurInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow) {
  char *h;
  char filename[6][FILENAME_MAX];
  char *fn[6];
  int i,r;
  char *e;
  
  hinstance=hCurInstance;
  h=parse_args(lpCmdLine);
  if(!*h)
    return 0;
  for(i=0;i<6;i++) 
    fn[i]=filename[i];
  e=parse_filenames(h,sizeof(*filename),fn);
  if(e) {
    MessageBox(NULL,e,"Error",MB_OK);
    return 1;
  }
  r=init(fn);
  if(r) {
    int m=r>=1&&r<=6;
    MessageBox(NULL,m?filename[r-1]:"Inicialization Failed",m?"Load Error":"Error",MB_OK);
    return 1;
  }
  create_window();
  recalc();
  repaint();
  r=loop();

  return r;
}

