/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import palm.conduit.Log;

class RawRecordInfo {
    byte fileHandle;
    int recId;
    short recIndex;
    byte attribs;
    short catId;
    int conduitId;
    int recSize;
    short totalBytes;
    int reserved;
    private byte[] bytes;

    RawRecordInfo(int n, int n2, int n3) {
        this.fileHandle = (byte)n;
        this.recId = n2;
        this.recIndex = (short)n3;
    }

    RawRecordInfo(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3);
        this.setBytes(byArray);
    }

    RawRecordInfo(int n, int n2, int n3, short s, byte[] byArray) {
        this(n, n2, n3);
        this.catId = s;
        this.setBytes(byArray);
    }

    public String toString() {
        return "fileHandle: " + Integer.toHexString(this.fileHandle) + "\r\n" + "recId: " + Integer.toHexString(this.recId) + "\r\n" + "recIndex: " + Integer.toHexString(this.recIndex) + "\r\n" + "attribs: " + Integer.toHexString(this.attribs) + "\r\n" + "catId: " + Integer.toHexString(this.catId) + "\r\n" + "conduitId: " + Integer.toHexString(this.conduitId) + "\r\n" + "recSize: " + Integer.toHexString(this.recSize) + "\r\n" + "totalBytes: " + Integer.toHexString(this.totalBytes) + "\r\n" + Log.formatBytes(this.getBytes());
    }

    void setBytes(byte[] byArray) {
        this.recSize = byArray.length;
        this.totalBytes = (short)byArray.length;
        this.bytes = byArray;
    }

    byte[] getBytes() {
        if (this.recSize < this.totalBytes) {
            byte[] byArray = new byte[this.recSize];
            System.arraycopy(this.bytes, 0, byArray, 0, this.recSize);
            this.bytes = byArray;
        }
        return this.bytes;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

