/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.SeparatorUI;

public class JSeparator
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "SeparatorUI";
    private int orientation = 0;

    public JSeparator() {
        this(0);
    }

    public JSeparator(int n) {
        this.checkOrientation(n);
        this.orientation = n;
        this.updateUI();
    }

    private void checkOrientation(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
            case 0: 
            case 1: 
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSeparator();
        }
        return this.accessibleContext;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public SeparatorUI getUI() {
        return (SeparatorUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected String paramString() {
        String string = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return String.valueOf(super.paramString()) + ",orientation=" + string;
    }

    public void setOrientation(int n) {
        if (this.orientation == n) {
            return;
        }
        int n2 = this.orientation;
        this.checkOrientation(n);
        this.orientation = n;
        this.firePropertyChange("orientation", n2, n);
        this.revalidate();
        this.repaint();
    }

    public void setUI(SeparatorUI separatorUI) {
        super.setUI(separatorUI);
    }

    public void updateUI() {
        this.setUI((SeparatorUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class AccessibleJSeparator
    extends JComponent.AccessibleJComponent {
        protected AccessibleJSeparator() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SEPARATOR;
        }
    }
}

