/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import jfr.awt.MessageDialog;
import jfr.pagesucker.PageSucker;
import jfr.pagesucker.SuckerFrame;
import jfr.pagesucker.SuckerFrameOwner;
import jfr.util.StringUtils;

public class HTMLFilesSettingsFrame
extends SuckerFrame {
    public Checkbox checkbox_save_html_pages;
    public Checkbox checkbox_parse_html_pages_not_in_hierarchy;
    public Checkbox checkbox_parse_remote_html_pages;
    public Checkbox checkbox_consider_frames_on_same_level_as_page;
    public TextField textfield_max_remote_recursion_depth;
    public TextField textfield_html_types;
    public CheckboxGroup radiogroup_untyped_object;
    public Checkbox radio_untyped_object_directory;
    public Checkbox radio_untyped_object_non_html;
    public Checkbox radio_untyped_object_html;

    public HTMLFilesSettingsFrame(SuckerFrameOwner in_owner) {
        super(in_owner, "Settings: HTML Files");
    }

    protected void setUpFrameContents() {
        int row = 0;
        this.checkbox_save_html_pages = new Checkbox("Save Parsed HTML Pages", null, Main.sucker.editing_settings.save_html_pages);
        this.addToGridBag(this.checkbox_save_html_pages, row, 0, 17);
        this.checkbox_parse_html_pages_not_in_hierarchy = new Checkbox("Parse HTML Pages Not In Hierarchy", null, Main.sucker.editing_settings.parse_html_pages_not_in_hierarchy);
        this.checkbox_parse_html_pages_not_in_hierarchy.addItemListener(this);
        this.addToGridBag(this.checkbox_parse_html_pages_not_in_hierarchy, ++row, 0, 17);
        this.checkbox_parse_remote_html_pages = new Checkbox("Parse HTML Pages On Remote Server, Up To Recursion Depth", null, Main.sucker.editing_settings.parse_remote_html_pages);
        this.checkbox_parse_remote_html_pages.addItemListener(this);
        this.addToGridBag(this.checkbox_parse_remote_html_pages, ++row, 2, 17);
        int v = Main.sucker.editing_settings.max_remote_recursion_depth;
        this.textfield_max_remote_recursion_depth = new TextField(v == -1 ? "INF" : String.valueOf(v), 3);
        this.textfield_max_remote_recursion_depth.setEditable(true);
        ((Component)this.textfield_max_remote_recursion_depth).setBackground(Color.white);
        this.addToGridBag(this.textfield_max_remote_recursion_depth, row, 2, 17);
        this.checkbox_consider_frames_on_same_level_as_page = new Checkbox("Consider Frames To Be On Same Recursion Level As Main Page", null, Main.sucker.editing_settings.consider_frames_on_same_level_as_page);
        this.addToGridBag(this.checkbox_consider_frames_on_same_level_as_page, ++row, 0, 17);
        ++row;
        row = this.addVerticalSpace(row);
        Label label = new Label("File Types To Be Considered HTML: ");
        this.addToGridBag(label, row, 1, 17);
        String html_types_string = StringUtils.arrayToString(Main.sucker.editing_settings.html_types, ", ");
        this.textfield_html_types = new TextField(html_types_string == null ? "" : html_types_string, 30);
        this.textfield_html_types.setEditable(true);
        ((Component)this.textfield_html_types).setBackground(Color.white);
        this.addToGridBag(this.textfield_html_types, row, 0, 17);
        ++row;
        row = this.addVerticalSpace(row);
        label = new Label("Object names without extensions denote:");
        this.addToGridBag(label, row, 0, 17);
        this.radiogroup_untyped_object = new CheckboxGroup();
        this.radio_untyped_object_directory = new Checkbox("directories", this.radiogroup_untyped_object, Main.sucker.editing_settings.untyped_object_mode == 11);
        this.radio_untyped_object_directory.addItemListener(this);
        this.addToGridBag(this.radio_untyped_object_directory, ++row, 0, 17);
        this.radio_untyped_object_non_html = new Checkbox("non HTML files", this.radiogroup_untyped_object, Main.sucker.editing_settings.untyped_object_mode == 12);
        this.radio_untyped_object_non_html.addItemListener(this);
        this.addToGridBag(this.radio_untyped_object_non_html, ++row, 0, 17);
        this.radio_untyped_object_html = new Checkbox("HTML files", this.radiogroup_untyped_object, Main.sucker.editing_settings.untyped_object_mode == 13);
        this.radio_untyped_object_html.addItemListener(this);
        this.addToGridBag(this.radio_untyped_object_html, ++row, 0, 17);
        ++row;
    }

    public boolean saveContentsValues() {
        Main.sucker.editing_settings.save_html_pages = this.checkbox_save_html_pages.getState();
        Main.sucker.editing_settings.parse_html_pages_not_in_hierarchy = this.checkbox_parse_html_pages_not_in_hierarchy.getState();
        Main.sucker.editing_settings.parse_remote_html_pages = this.checkbox_parse_remote_html_pages.getState();
        Main.sucker.editing_settings.consider_frames_on_same_level_as_page = this.checkbox_consider_frames_on_same_level_as_page.getState();
        String s = this.textfield_max_remote_recursion_depth.getText().toUpperCase();
        if (s.equals("INF")) {
            Main.sucker.editing_settings.max_remote_recursion_depth = -1;
        } else {
            try {
                int v = Integer.parseInt(s);
                if (v < 0) {
                    throw new NumberFormatException();
                }
                Main.sucker.editing_settings.max_remote_recursion_depth = v;
            }
            catch (NumberFormatException numberFormatException) {
                Main.sucker.editing_settings.max_remote_recursion_depth = 0;
                ((TextComponent)this.textfield_max_remote_recursion_depth).setText("0");
            }
        }
        Main.sucker.editing_settings.buildHTMLTypesArrayFromString(this.textfield_html_types.getText());
        Checkbox cb = this.radiogroup_untyped_object.getSelectedCheckbox();
        if (cb == this.radio_untyped_object_directory) {
            Main.sucker.editing_settings.untyped_object_mode = 11;
        } else if (cb == this.radio_untyped_object_non_html) {
            Main.sucker.editing_settings.untyped_object_mode = 12;
        } else if (cb == this.radio_untyped_object_html) {
            Main.sucker.editing_settings.untyped_object_mode = 13;
        }
        return true;
    }

    public void updateFromEditingSettings() {
        Checkbox cb;
        this.checkbox_save_html_pages.setState(Main.sucker.editing_settings.save_html_pages);
        this.checkbox_parse_html_pages_not_in_hierarchy.setState(Main.sucker.editing_settings.parse_html_pages_not_in_hierarchy);
        this.checkbox_parse_remote_html_pages.setState(Main.sucker.editing_settings.parse_remote_html_pages);
        this.checkbox_consider_frames_on_same_level_as_page.setState(Main.sucker.editing_settings.consider_frames_on_same_level_as_page);
        int v = Main.sucker.editing_settings.max_remote_recursion_depth;
        ((TextComponent)this.textfield_max_remote_recursion_depth).setText(v < 0 ? "INF" : String.valueOf(v));
        String html_types_string = StringUtils.arrayToString(Main.sucker.editing_settings.html_types, ", ");
        ((TextComponent)this.textfield_html_types).setText(html_types_string);
        switch (Main.sucker.editing_settings.untyped_object_mode) {
            case 11: {
                cb = this.radio_untyped_object_directory;
                break;
            }
            case 12: {
                cb = this.radio_untyped_object_non_html;
                break;
            }
            case 13: {
                cb = this.radio_untyped_object_html;
                break;
            }
            default: {
                cb = null;
            }
        }
        this.radiogroup_untyped_object.setSelectedCheckbox(cb);
    }

    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.checkbox_parse_html_pages_not_in_hierarchy || source == this.checkbox_parse_remote_html_pages) {
            if (PageSucker.registration_checksum1 + 485 != PageSucker.registration_checksum2) {
                new MessageDialog((Frame)this, "Sorry, this option can be enabled in registered copies of PageSucker only. Select \"Register...\" from the \"File\" menu to enter your registration information.", 3).handle();
                ((Checkbox)source).setState(false);
            }
        } else if (source == this.radio_untyped_object_directory || source == this.radio_untyped_object_non_html || source == this.radio_untyped_object_html) {
            boolean state_images = Main.sucker.settings_data.getStateSaveEmbeddedImages();
            boolean state_non_html = Main.sucker.settings_data.getStateSaveNonHTMLObjects();
            boolean state_untyped_non_html = this.radio_untyped_object_non_html.getState();
            if (state_untyped_non_html && (state_images || state_non_html)) {
                Main.sucker.settings_data.enableSaveUntypedNonHTMLObjects();
            } else {
                Main.sucker.settings_data.disableSaveUntypedNonHTMLObjects();
            }
        } else {
            super.itemStateChanged(evt);
        }
    }
}

