/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jfr.awt.FixedSizePanel;
import jfr.pagesucker.PageSucker;
import jfr.util.StringUtils;

public class RegistrationDialog
extends Dialog
implements ActionListener {
    private static final int NAME_FIELD_SIZE = 30;
    private static final int NUMBER_FIELD_SIZE = 30;
    private static final int MAX_TEXT_LENGTH = 64;
    private TextField textfield_name;
    private TextField textfield_number;
    private String selected_button;
    private Frame m_parent_frame;

    public RegistrationDialog(Frame parent, String reg_name, String reg_number) {
        super(parent, true);
        this.m_parent_frame = parent;
        this.initialize(reg_name, reg_number);
        this.addWindowListener(new RegistrationDialogAdapter());
    }

    public void initialize(String reg_name, String reg_number) {
        ((Component)this).setBackground(Color.white);
        this.setResizable(false);
        if (PageSucker.os_type == 1) {
            ((Component)this).setFont(new Font("Geneva", 0, 10));
        }
        String message = reg_name == null ? "This is an unregistered copy. To register, please enter your name and registration code exactly as they appear in the email you received from Kagi when paying the shareware fee. You can also click \"Not Yet\" to test drive the application." : "This copy is already registered to " + reg_name + ". You may change the registration info by entering a correct name and registration number below.";
        String[] lines = StringUtils.stringToLines(message, 64);
        FixedSizePanel panel1 = new FixedSizePanel(-1, lines.length * 14 + 40, true, 0, 0, 0);
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        panel1.setLayout(new GridLayout(0, 1));
        String title = reg_name == null ? "Welcome to PageSucker!" : "PageSucker Registration";
        panel1.add(new Label(title, 1));
        panel1.add(new Label());
        int i = 0;
        while (i < lines.length) {
            Label label = new Label(lines[i], 1);
            panel1.add(label);
            ++i;
        }
        panel1.add(new Label());
        Panel panel2_1 = new Panel();
        panel2_1.setLayout(new BorderLayout());
        panel2_1.add("West", new Label("Name:"));
        this.textfield_name = new TextField(reg_name == null ? "" : reg_name, 30);
        panel2_1.add("East", this.textfield_name);
        Panel panel2_2 = new Panel();
        panel2_2.setLayout(new BorderLayout());
        panel2_2.add("West", new Label("Reg. Number:"));
        this.textfield_number = new TextField(reg_number == null ? "" : reg_number, 30);
        panel2_2.add("East", this.textfield_number);
        panel2.setLayout(new GridLayout(0, 1, 5, 5));
        panel2.add(panel2_1);
        panel2.add(panel2_2);
        panel3.setLayout(new BorderLayout());
        panel3.add("North", new Label());
        String cancel_text = reg_name == null ? "Not Yet" : "Cancel";
        Button button = new Button(cancel_text);
        button.addActionListener(this);
        panel3.add("West", button);
        button = new Button("Register");
        button.addActionListener(this);
        panel3.add("East", button);
        this.add("North", panel1);
        this.add("Center", panel2);
        this.add("South", panel3);
        this.pack();
    }

    public boolean handle(StringBuffer out_name, StringBuffer out_number) {
        Point location = this.m_parent_frame.getLocation();
        Dimension parent_frame_size = this.m_parent_frame.getSize();
        Dimension dialog_size = this.getSize();
        location.translate((parent_frame_size.width - dialog_size.width) / 2, (parent_frame_size.height - dialog_size.height) / 2);
        ((Component)this).setLocation(location);
        ((Component)this).setVisible(true);
        out_name.setLength(0);
        out_number.setLength(0);
        out_name.append(this.textfield_name.getText());
        out_number.append(this.textfield_number.getText());
        boolean result = this.selected_button.equals("Register");
        this.dispose();
        return result;
    }

    public Insets getInsets() {
        Insets r = (Insets)super.getInsets().clone();
        r.top += 15;
        r.bottom += 15;
        r.left += 15;
        r.right += 15;
        return r;
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("Not Yet") || command.equals("Cancel") || command.equals("Register")) {
            this.selected_button = command;
            ((Component)this).setVisible(false);
        }
    }

    static /* synthetic */ String access$0(RegistrationDialog $0) {
        return $0.selected_button;
    }

    class RegistrationDialogAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            RegistrationDialog.this.selected_button = "Cancel";
            ((Component)RegistrationDialog.this).setVisible(false);
        }

        RegistrationDialogAdapter() {
        }
    }
}

